package de.ugoe.cs.swe.memos.tests.database;


import static org.junit.Assert.assertTrue;

import java.util.*;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.swe.memos.database.DBSearcher;
import de.ugoe.cs.swe.memos.database.DBUtility;
import de.ugoe.cs.swe.memos.database.DatabaseException;
import de.ugoe.cs.swe.memos.datamodel.Memo;
import de.ugoe.cs.swe.memos.datamodel.Tag;

public class DBSearcherTest {

	private DBUtility connection;

	@Before
	public void up() {
		this.connection = DBUtility.getInstance();
		
	}
	
	@Test
	public void searchTest1() throws DatabaseException {
		Memo newM = new Memo("SearchTestMemo", true);
		newM.setAuthor("JUnit");
		newM.setContent("Bla");
		ArrayList<Tag> tags = new ArrayList<Tag>();
		tags.add(new Tag("Maik", newM));
		newM.setTags(tags);
		newM.setLock(newM.getAuthor());

		assertTrue(connection.insertMemo(newM));
		
		DBSearcher testsearcher = new DBSearcher("SearchTestMemo");
		
		Vector<Memo> DBs = testsearcher.execute(); 
		
		assertTrue(DBs.size() > 0);
		
		assertTrue(DBs.get(0).getContent().equals("Bla"));
		
		for(Memo m : DBs){
			connection.deleteMemo(m);
		}
		
	}

}
