/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util.preprocessor;

import org.hsqldb.util.preprocessor.PreprocessorException;

final class Tokenizer {
    private final String command;
    private final int commandLength;
    private int tokenType;
    private int startIndex;
    private int currentIndex;

    Tokenizer(String cmd) {
        this.command = cmd + " ";
        this.commandLength = this.command.length();
        this.startIndex = 0;
        this.currentIndex = 0;
        this.tokenType = 0;
    }

    void skipBlanks() {
        String cmd = this.command;
        int len = this.commandLength;
        block3: while (this.currentIndex < len) {
            switch (cmd.charAt(this.currentIndex)) {
                case '\t': 
                case ' ': {
                    ++this.currentIndex;
                    continue block3;
                }
            }
            break;
        }
    }

    int next() throws PreprocessorException {
        this.skipBlanks();
        this.startIndex = this.currentIndex;
        String cmd = this.command;
        int len = this.commandLength;
        if (this.currentIndex >= len) {
            this.tokenType = -1;
            return this.tokenType;
        }
        char ch = cmd.charAt(this.currentIndex);
        if (Character.isJavaIdentifierStart(ch)) {
            this.tokenType = 1;
            ++this.currentIndex;
            while (this.currentIndex < len && Character.isJavaIdentifierPart(cmd.charAt(this.currentIndex))) {
                ++this.currentIndex;
            }
            return this.tokenType;
        }
        if (Character.isDigit(ch)) {
            this.tokenType = 2;
            ++this.currentIndex;
            while (this.currentIndex < len && Character.isDigit(cmd.charAt(this.currentIndex))) {
                ++this.currentIndex;
            }
            if (this.currentIndex < len && cmd.charAt(this.currentIndex) == '.') {
                ++this.currentIndex;
            }
            while (this.currentIndex < len && Character.isDigit(cmd.charAt(this.currentIndex))) {
                ++this.currentIndex;
            }
            return this.tokenType;
        }
        if (ch == '\"') {
            this.tokenType = 3;
            ++this.currentIndex;
            int pos = cmd.indexOf(34, this.currentIndex);
            if (pos == -1) {
                throw new PreprocessorException("Unclosed string literal: " + cmd.substring(this.startIndex));
            }
            this.currentIndex = pos + 1;
            return this.tokenType;
        }
        switch (ch) {
            case '!': 
            case '(': 
            case ')': 
            case '^': {
                ++this.currentIndex;
                char c = ch;
                this.tokenType = c;
                return c;
            }
            case '=': {
                ++this.currentIndex;
                if (this.currentIndex < len && cmd.charAt(this.currentIndex) == '=') {
                    ++this.currentIndex;
                    this.tokenType = 122;
                } else {
                    this.tokenType = 61;
                }
                return this.tokenType;
            }
            case '<': {
                ++this.currentIndex;
                if (this.currentIndex < len && cmd.charAt(this.currentIndex) == '=') {
                    ++this.currentIndex;
                    this.tokenType = 121;
                } else {
                    this.tokenType = 60;
                }
                return this.tokenType;
            }
            case '>': {
                ++this.currentIndex;
                if (this.currentIndex < len && cmd.charAt(this.currentIndex) == '=') {
                    ++this.currentIndex;
                    this.tokenType = 123;
                } else {
                    this.tokenType = 62;
                }
                return this.tokenType;
            }
            case '&': 
            case '|': {
                ++this.currentIndex;
                if (this.currentIndex < len && cmd.charAt(this.currentIndex) == ch) {
                    ++this.currentIndex;
                }
                char c = ch;
                this.tokenType = c;
                return c;
            }
        }
        throw new PreprocessorException("Syntax error: " + cmd.substring(this.currentIndex));
    }

    int getTokenType() {
        return this.tokenType;
    }

    boolean isToken(int type) {
        return this.tokenType == type;
    }

    String getIdent() {
        return this.isToken(-1) ? null : this.command.substring(this.startIndex, this.currentIndex);
    }

    Number getNumber() {
        return this.isToken(-1) ? null : new Double(Double.parseDouble(this.command.substring(this.startIndex, this.currentIndex)));
    }

    String getString() {
        return this.isToken(-1) ? null : this.command.substring(this.startIndex + 1, this.currentIndex - 1);
    }

    int getStartIndex() {
        return this.startIndex;
    }

    int currentIndex() {
        return this.currentIndex;
    }

    String getSource() {
        return this.command;
    }
}

