/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.InputStream;
import java.io.OutputStream;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.types.BlobData;

public class BlobDataID
implements BlobData {
    long id;

    public BlobDataID(long id) {
        this.id = id;
    }

    @Override
    public BlobData duplicate(SessionInterface session) {
        return null;
    }

    @Override
    public void free() {
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session) {
        return null;
    }

    @Override
    public InputStream getBinaryStream(SessionInterface session, long pos, long length) {
        return null;
    }

    @Override
    public byte[] getBytes() {
        return null;
    }

    @Override
    public byte[] getBytes(SessionInterface session, long pos, int length) {
        ResultLob resultOut = ResultLob.newLobGetBytesRequest(this.id, pos, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        return ((ResultLob)resultIn).getByteArray();
    }

    @Override
    public BlobData getBlob(SessionInterface session, long pos, long length) {
        ResultLob resultOut = ResultLob.newLobGetRequest(this.id, pos, length);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw Error.error(resultIn);
        }
        long lobID = ((ResultLob)resultIn).getLobID();
        return new BlobDataID(lobID);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getStreamBlockSize() {
        return 0;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public long length(SessionInterface session) {
        ResultLob resultOut = ResultLob.newLobGetLengthRequest(this.id);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return ((ResultLob)resultIn).getBlockLength();
    }

    @Override
    public long bitLength(SessionInterface session) {
        return 0L;
    }

    @Override
    public boolean isBits() {
        return false;
    }

    @Override
    public long position(SessionInterface session, BlobData pattern, long start) {
        return 0L;
    }

    @Override
    public long position(SessionInterface session, byte[] pattern, long start) {
        ResultLob resultOut = ResultLob.newLobGetBytePatternPositionRequest(this.id, pattern, start);
        ResultLob resultIn = (ResultLob)session.execute(resultOut);
        return resultIn.getOffset();
    }

    @Override
    public long nonZeroLength(SessionInterface session) {
        return 0L;
    }

    @Override
    public OutputStream setBinaryStream(SessionInterface session, long pos) {
        return null;
    }

    @Override
    public int setBytes(SessionInterface session, long pos, byte[] bytes, int offset, int len) {
        ResultLob resultOut = ResultLob.newLobSetBytesRequest(this.id, pos, bytes);
        ResultLob resultIn = (ResultLob)session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
        return bytes.length;
    }

    @Override
    public int setBytes(SessionInterface session, long pos, byte[] bytes) {
        return 0;
    }

    @Override
    public long setBinaryStream(SessionInterface session, long pos, InputStream in) {
        return 0L;
    }

    @Override
    public void setSession(SessionInterface session) {
    }

    @Override
    public void truncate(SessionInterface session, long len) {
        ResultLob resultOut = ResultLob.newLobTruncateRequest(this.id, len);
        Result resultIn = session.execute(resultOut);
        if (resultIn.isError()) {
            throw resultIn.getException();
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }
}

