/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.SimpleDateFormat;
import java.util.regex.Pattern;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.PIFData;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarFileInputStream;
import org.hsqldb.lib.tar.TarHeaderFields;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarReader {
    public static final int LIST_MODE = 0;
    public static final int EXTRACT_MODE = 1;
    public static final int OVERWRITE_MODE = 2;
    protected TarFileInputStream archive;
    protected Pattern[] patterns = null;
    protected int mode;
    protected File extractBaseDir;

    public static void main(String[] sa) throws IOException, TarMalformatException {
        int firstPatInd;
        if (sa.length < 1) {
            System.out.println(RB.singleton.getString(RB.TARREADER_SYNTAX, TarReader.class.getName()));
            System.out.println(RB.singleton.getString(RB.LISTING_FORMAT));
            System.exit(0);
        }
        File exDir = sa.length > 1 && sa[1].startsWith("--directory=") ? new File(sa[1].substring("--directory=".length())) : null;
        int n = firstPatInd = exDir == null ? 2 : 3;
        if (sa.length < firstPatInd || !sa[0].equals("t") && !sa[0].equals("x")) {
            throw new IllegalArgumentException(RB.singleton.getString(RB.TARREADER_SYNTAXERR, TarReader.class.getName()));
        }
        String[] patternStrings = null;
        if (sa.length > firstPatInd) {
            patternStrings = new String[sa.length - firstPatInd];
            for (int i = firstPatInd; i < sa.length; ++i) {
                patternStrings[i - firstPatInd] = sa[i];
            }
        }
        if (sa[0].equals("t") && exDir != null) {
            throw new IllegalArgumentException(RB.singleton.getString(RB.DIR_X_CONFLICT));
        }
        int dirIndex = exDir == null ? 1 : 2;
        int tarReaderMode = sa[0].equals("t") ? 0 : 1;
        new TarReader(new File(sa[dirIndex]), tarReaderMode, patternStrings, null, exDir).read();
    }

    public TarReader(File inFile, int mode, String[] patternStrings, Integer readBufferBlocks, File inDir) throws IOException {
        this.mode = mode;
        File archiveFile = inFile.getAbsoluteFile();
        this.extractBaseDir = inDir == null ? null : inDir.getAbsoluteFile();
        int compression = 0;
        if (archiveFile.getName().endsWith(".tgz") || archiveFile.getName().endsWith(".gz")) {
            compression = 1;
        }
        if (patternStrings != null) {
            this.patterns = new Pattern[patternStrings.length];
            for (int i = 0; i < patternStrings.length; ++i) {
                this.patterns[i] = Pattern.compile(patternStrings[i]);
            }
        }
        this.archive = readBufferBlocks == null ? new TarFileInputStream(archiveFile, compression) : new TarFileInputStream(archiveFile, compression, readBufferBlocks);
    }

    public void read() throws IOException, TarMalformatException {
        boolean anyUnsupporteds = false;
        Long paxSize = null;
        String paxString = null;
        try {
            while (this.archive.readNextHeaderBlock()) {
                TarEntryHeader header = new TarEntryHeader(this.archive.readBuffer);
                char entryType = header.getEntryType();
                if (entryType == 'x') {
                    paxSize = this.getPifData(header).getSize();
                    paxString = header.toString();
                    continue;
                }
                if (paxSize != null) {
                    header.setDataSize(paxSize);
                    paxSize = null;
                }
                if (this.patterns != null) {
                    boolean matched = false;
                    for (int i = 0; i < this.patterns.length; ++i) {
                        if (!this.patterns[i].matcher(header.getPath()).matches()) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        paxString = null;
                        this.skipFileData(header);
                        continue;
                    }
                }
                if (entryType != '\u0000' && entryType != '0' && entryType != 'x') {
                    anyUnsupporteds = true;
                }
                switch (this.mode) {
                    case 0: {
                        if (paxString != null) {
                            System.out.println(paxString);
                        }
                        System.out.println(header.toString());
                        this.skipFileData(header);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (paxString != null) {
                            System.out.println(paxString);
                        }
                        System.out.println(header.toString());
                        if (entryType == '\u0000' || entryType == '0' || entryType == 'x') {
                            this.extractFile(header);
                            break;
                        }
                        this.skipFileData(header);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(RB.singleton.getString(RB.UNSUPPORTED_MODE, this.mode));
                    }
                }
                paxString = null;
            }
            if (anyUnsupporteds) {
                System.out.println(RB.singleton.getString(RB.UNSUPPORTED_ENTRY_PRESENT));
            }
        }
        catch (IOException ioe) {
            this.archive.close();
            throw ioe;
        }
    }

    protected PIFData getPifData(TarEntryHeader header) throws IOException, TarMalformatException {
        long dataSize = header.getDataSize();
        if (dataSize < 1L) {
            throw new TarMalformatException(RB.singleton.getString(RB.PIF_UNKNOWN_DATASIZE));
        }
        if (dataSize > Integer.MAX_VALUE) {
            throw new TarMalformatException(RB.singleton.getString(RB.PIF_DATA_TOOBIG, Long.toString(dataSize), Integer.MAX_VALUE));
        }
        int modulus = (int)(dataSize % 512L);
        PipedOutputStream outPipe = new PipedOutputStream();
        PipedInputStream inPipe = new PipedInputStream(outPipe);
        try {
            int readNow;
            for (int readBlocks = (int)(dataSize / 512L); readBlocks > 0; readBlocks -= readNow) {
                readNow = readBlocks > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : readBlocks;
                this.archive.readBlocks(readNow);
                outPipe.write(this.archive.readBuffer, 0, readNow * 512);
            }
            if (modulus != 0) {
                this.archive.readBlock();
                outPipe.write(this.archive.readBuffer, 0, modulus);
            }
            outPipe.flush();
        }
        catch (IOException ioe) {
            inPipe.close();
            throw ioe;
        }
        finally {
            outPipe.close();
        }
        return new PIFData(inPipe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(TarEntryHeader header) throws IOException, TarMalformatException {
        if (header.getDataSize() < 1L) {
            throw new TarMalformatException(RB.singleton.getString(RB.DATA_SIZE_UNKNOWN));
        }
        int readBlocks = (int)(header.getDataSize() / 512L);
        int modulus = (int)(header.getDataSize() % 512L);
        File newFile = header.generateFile();
        if (!newFile.isAbsolute()) {
            newFile = this.extractBaseDir == null ? newFile.getAbsoluteFile() : new File(this.extractBaseDir, newFile.getPath());
        }
        File parentDir = newFile.getParentFile();
        if (newFile.exists()) {
            if (this.mode != 2) {
                throw new IOException(RB.singleton.getString(RB.EXTRACTION_EXISTS, newFile.getAbsolutePath()));
            }
            if (!newFile.isFile()) {
                throw new IOException(RB.singleton.getString(RB.EXTRACTION_EXISTS_NOTFILE, newFile.getAbsolutePath()));
            }
        }
        if (parentDir.exists()) {
            if (!parentDir.isDirectory()) {
                throw new IOException(RB.singleton.getString(RB.EXTRACTION_PARENT_NOT_DIR, parentDir.getAbsolutePath()));
            }
            if (!parentDir.canWrite()) {
                throw new IOException(RB.singleton.getString(RB.EXTRACTION_PARENT_NOT_WRITABLE, parentDir.getAbsolutePath()));
            }
        } else if (!parentDir.mkdirs()) {
            throw new IOException(RB.singleton.getString(RB.EXTRACTION_PARENT_MKFAIL, parentDir.getAbsolutePath()));
        }
        int fileMode = header.getFileMode();
        FileOutputStream outStream = new FileOutputStream(newFile);
        try {
            newFile.setExecutable(false, false);
            newFile.setReadable(false, false);
            newFile.setWritable(false, false);
            newFile.setExecutable((fileMode & 0x40) != 0, true);
            newFile.setReadable((fileMode & 0x100) != 0, true);
            newFile.setWritable((fileMode & 0x80) != 0, true);
            while (readBlocks > 0) {
                int readNow = readBlocks > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : readBlocks;
                this.archive.readBlocks(readNow);
                readBlocks -= readNow;
                outStream.write(this.archive.readBuffer, 0, readNow * 512);
            }
            if (modulus != 0) {
                this.archive.readBlock();
                outStream.write(this.archive.readBuffer, 0, modulus);
            }
            outStream.flush();
        }
        finally {
            outStream.close();
        }
        newFile.setLastModified(header.getModTime() * 1000L);
        if (newFile.length() != header.getDataSize()) {
            throw new IOException(RB.singleton.getString(RB.WRITE_COUNT_MISMATCH, Long.toString(header.getDataSize()), newFile.getAbsolutePath(), Long.toString(newFile.length())));
        }
    }

    protected void skipFileData(TarEntryHeader header) throws IOException, TarMalformatException {
        int skipNow;
        if (header.getDataSize() == 0L) {
            return;
        }
        if (header.getDataSize() < 0L) {
            throw new TarMalformatException(RB.singleton.getString(RB.DATA_SIZE_UNKNOWN));
        }
        int oddBlocks = header.getDataSize() % 512L == 0L ? 0 : 1;
        for (int skipBlocks = (int)(header.getDataSize() / 512L) + oddBlocks; skipBlocks > 0; skipBlocks -= skipNow) {
            skipNow = skipBlocks > this.archive.getReadBufferBlocks() ? this.archive.getReadBufferBlocks() : skipBlocks;
            this.archive.readBlocks(skipNow);
        }
    }

    protected static class TarEntryHeader {
        protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        protected byte[] rawHeader;
        protected String path;
        protected int fileMode;
        protected long dataSize = -1L;
        protected long modTime;
        protected char entryType;
        protected String ownerName;
        protected boolean ustar;

        public TarEntryHeader(byte[] rawHeader) throws TarMalformatException {
            this.rawHeader = rawHeader;
            Long expectedCheckSum = this.readInteger(7);
            try {
                if (expectedCheckSum == null) {
                    throw new MissingField(7);
                }
                long calculatedCheckSum = this.headerChecksum();
                if (expectedCheckSum != calculatedCheckSum) {
                    throw new TarMalformatException(RB.singleton.getString(RB.CHECKSUM_MISMATCH, expectedCheckSum.toString(), Long.toString(calculatedCheckSum)));
                }
                this.path = this.readString(1);
                if (this.path == null) {
                    throw new MissingField(1);
                }
                Long longObject = this.readInteger(2);
                if (longObject == null) {
                    throw new MissingField(2);
                }
                this.fileMode = (int)longObject.longValue();
                longObject = this.readInteger(5);
                if (longObject != null) {
                    this.dataSize = longObject;
                }
                if ((longObject = this.readInteger(6)) == null) {
                    throw new MissingField(6);
                }
                this.modTime = longObject;
            }
            catch (MissingField mf) {
                throw new TarMalformatException(mf.getMessage());
            }
            this.entryType = this.readChar(8);
            this.ownerName = this.readString(10);
            String pathPrefix = this.readString(12);
            if (pathPrefix != null) {
                this.path = pathPrefix + '/' + this.path;
            }
            this.ustar = this.isUstar();
        }

        public File generateFile() {
            if (this.entryType != '\u0000' && this.entryType != '0') {
                throw new IllegalStateException(RB.singleton.getString(RB.CREATE_ONLY_NORMAL));
            }
            return new File(this.path);
        }

        public char getEntryType() {
            return this.entryType;
        }

        public String getPath() {
            return this.path;
        }

        public void setDataSize(long dataSize) {
            this.dataSize = dataSize;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        public long getModTime() {
            return this.modTime;
        }

        public int getFileMode() {
            return this.fileMode;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(this.sdf.format(new Long(this.modTime * 1000L)) + ' ');
            sb.append(this.entryType == '\u0000' ? (char)' ' : (char)this.entryType);
            sb.append(this.ustar ? (char)'*' : ' ');
            sb.append(" " + StringUtil.toPaddedString(Integer.toOctalString(this.fileMode), 4, ' ', false) + ' ' + StringUtil.toPaddedString(Long.toString(this.dataSize), 11, ' ', false) + "  ");
            sb.append(StringUtil.toPaddedString(this.ownerName == null ? "-" : this.ownerName, 8, ' ', true));
            sb.append("  " + this.path);
            return sb.toString();
        }

        public boolean isUstar() throws TarMalformatException {
            String magicString = this.readString(9);
            return magicString != null && magicString.startsWith("ustar");
        }

        public static int indexOf(byte[] ba, byte val, int from, int to) {
            for (int i = from; i < to; ++i) {
                if (ba[i] != val) continue;
                return i - from;
            }
            return -1;
        }

        protected char readChar(int fieldId) throws TarMalformatException {
            String s = this.readString(fieldId);
            return s == null ? (char)'\u0000' : s.charAt(0);
        }

        protected String readString(int fieldId) throws TarMalformatException {
            int start = TarHeaderFields.getStart(fieldId);
            int stop = TarHeaderFields.getStop(fieldId);
            int termIndex = TarEntryHeader.indexOf(this.rawHeader, (byte)0, start, stop);
            switch (termIndex) {
                case 0: {
                    return null;
                }
                case -1: {
                    termIndex = stop - start;
                }
            }
            try {
                return new String(this.rawHeader, start, termIndex);
            }
            catch (Throwable t) {
                throw new TarMalformatException(RB.singleton.getString(RB.BAD_HEADER_VALUE, TarHeaderFields.toString(fieldId)));
            }
        }

        protected Long readInteger(int fieldId) throws TarMalformatException {
            String s = this.readString(fieldId);
            if (s == null) {
                return null;
            }
            try {
                return Long.valueOf(s, 8);
            }
            catch (NumberFormatException nfe) {
                throw new TarMalformatException(RB.singleton.getString(RB.BAD_NUMERIC_HEADER_VALUE, TarHeaderFields.toString(fieldId), nfe.getMessage()));
            }
        }

        protected long headerChecksum() {
            long sum = 0L;
            for (int i = 0; i < 512; ++i) {
                boolean isInRange = i >= TarHeaderFields.getStart(7) && i < TarHeaderFields.getStop(7);
                sum += isInRange ? 32L : (long)(0xFF & this.rawHeader[i]);
            }
            return sum;
        }

        protected static class MissingField
        extends Exception {
            private int field;

            public MissingField(int field) {
                this.field = field;
            }

            @Override
            public String getMessage() {
                return RB.singleton.getString(RB.HEADER_FIELD_MISSING, TarHeaderFields.toString(this.field));
            }
        }
    }
}

