/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.BaseConnectionWrapper;
import org.hsqldb.jdbc.pool.ConnectionDefaults;
import org.hsqldb.jdbc.pool.JDBCPooledConnection;

public class LifeTimeConnectionWrapper
extends BaseConnectionWrapper {
    protected JDBCConnection connection = null;
    protected PooledConnection pooledConnection = null;
    protected Set connectionListeners = new HashSet();
    protected ConnectionDefaults connectionDefaults = null;

    public LifeTimeConnectionWrapper(JDBCConnection connection, ConnectionDefaults connectionDefaults) throws SQLException {
        this.connection = connection;
        if (connectionDefaults != null) {
            this.connectionDefaults = connectionDefaults;
            this.connectionDefaults.setDefaults(connection);
        } else {
            this.connectionDefaults = new ConnectionDefaults(connection);
        }
    }

    public LifeTimeConnectionWrapper(JDBCConnection connection) throws SQLException {
        this(connection, null);
    }

    public void setPooledConnection(JDBCPooledConnection pooledConnection) {
        this.pooledConnection = pooledConnection;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connectionListeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connectionListeners.remove(listener);
    }

    protected void finalize() throws Throwable {
        this.closePhysically();
    }

    @Override
    protected Connection getConnection() {
        return this.connection;
    }

    @Override
    public void close() throws SQLException {
        this.validate();
        try {
            this.connection.rollback();
            this.connection.clearWarnings();
            this.connectionDefaults.setDefaults(this.connection);
            this.connection.reset();
            this.fireCloseEvent();
        }
        catch (SQLException e) {
            this.fireSqlExceptionEvent(e);
            throw e;
        }
    }

    public void closePhysically() throws SQLException {
        SQLException exception = null;
        if (!this.isClosed && this.connection != null && !this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                exception = e;
            }
        }
        this.isClosed = true;
        this.pooledConnection = null;
        this.connection = null;
        this.connectionDefaults = null;
        this.connectionListeners.clear();
        this.connectionListeners = null;
        if (exception != null) {
            throw exception;
        }
    }

    protected void fireSqlExceptionEvent(SQLException e) {
        ConnectionEvent event = new ConnectionEvent(this.pooledConnection, e);
        for (ConnectionEventListener connectionEventListener : this.connectionListeners) {
            connectionEventListener.connectionErrorOccurred(event);
        }
    }

    protected void fireCloseEvent() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this.pooledConnection);
        for (ConnectionEventListener connectionListener : this.connectionListeners) {
            connectionListener.connectionClosed(connectionEvent);
        }
    }
}

