/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.java.JavaSystem;

public final class ClobInputStream
extends Reader {
    final JDBCClobClient clob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    char[] buffer;
    boolean isClosed;
    int streamBlockSize;

    public ClobInputStream(JDBCClobClient clob, long offset, long length, int blockSize) throws SQLException {
        if (!JDBCClobClient.isInLimits(clob.length(), offset, length)) {
            throw Util.outOfRangeArgument();
        }
        this.clob = clob;
        this.availableLength = offset + length;
        this.currentPosition = offset;
        this.streamBlockSize = blockSize;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.readIntoBuffer();
            }
            catch (SQLException e) {
                throw JavaSystem.toIOException(e);
            }
        }
        int val = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return val;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        this.checkClosed();
        if (this.currentPosition + (long)len >= this.availableLength) {
            return -1;
        }
        for (int i = off; i < len; ++i) {
            cbuf[i] = (char)this.read();
        }
        return len;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        if (n <= 0L) {
            return 0L;
        }
        if (this.currentPosition + n > this.availableLength) {
            n = this.availableLength - this.currentPosition;
        }
        this.currentPosition += n;
        return n;
    }

    public int available() throws IOException {
        return (int)(this.bufferOffset + (long)this.buffer.length - this.currentPosition);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed || this.clob.isClosed()) {
            throw new IOException(Error.getMessage(3475));
        }
    }

    private void readIntoBuffer() throws SQLException {
        long readLength = this.availableLength - this.currentPosition;
        if (readLength <= 0L) {
            // empty if block
        }
        if (readLength > (long)this.streamBlockSize) {
            readLength = this.streamBlockSize;
        }
        this.buffer = this.clob.getChars(this.currentPosition, (int)readLength);
        this.bufferOffset = this.currentPosition;
    }
}

