/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.java.JavaSystem;

public class BlobInputStream
extends InputStream {
    final JDBCBlobClient blob;
    final long availableLength;
    long bufferOffset;
    long currentPosition;
    byte[] buffer;
    boolean isClosed;
    int streamBlockSize;

    public BlobInputStream(JDBCBlobClient blob, long offset, long length, int blockSize) throws SQLException {
        if (!JDBCBlobClient.isInLimits(blob.length(), offset, length)) {
            throw Util.outOfRangeArgument();
        }
        this.blob = blob;
        this.availableLength = offset + length;
        this.currentPosition = offset;
        this.streamBlockSize = blockSize;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.currentPosition >= this.availableLength) {
            return -1;
        }
        if (this.buffer == null || this.currentPosition >= this.bufferOffset + (long)this.buffer.length) {
            try {
                this.readIntoBuffer();
            }
            catch (SQLException e) {
                throw JavaSystem.toIOException(e);
            }
        }
        int val = this.buffer[(int)(this.currentPosition - this.bufferOffset)] & 0xFF;
        ++this.currentPosition;
        return val;
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkClosed();
        if (n <= 0L) {
            return 0L;
        }
        if (this.currentPosition + n > this.availableLength) {
            n = this.availableLength - this.currentPosition;
        }
        this.currentPosition += n;
        return n;
    }

    @Override
    public int available() throws IOException {
        this.checkClosed();
        return (int)(this.bufferOffset + (long)this.buffer.length - this.currentPosition);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed || this.blob.isClosed()) {
            throw new IOException(Error.getMessage(3475));
        }
    }

    private void readIntoBuffer() throws SQLException {
        long readLength = this.availableLength - this.currentPosition;
        if (readLength <= 0L) {
            // empty if block
        }
        if (readLength > (long)this.streamBlockSize) {
            readLength = this.streamBlockSize;
        }
        this.buffer = this.blob.getBytes(this.currentPosition + 1L, (int)readLength);
        this.bufferOffset = this.currentPosition;
    }
}

