/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;

public final class SortAndSlice {
    static final SortAndSlice noSort = new SortAndSlice();
    public int[] sortOrder;
    public boolean[] sortDescending;
    public boolean[] sortNullsLast;
    boolean sortUnion;
    HsqlArrayList exprList = new HsqlArrayList();
    Expression limitCondition;
    public Index index;

    SortAndSlice() {
    }

    public boolean hasOrder() {
        return this.exprList.size() != 0;
    }

    public boolean hasLimit() {
        return this.limitCondition != null;
    }

    public int getOrderLength() {
        return this.exprList.size();
    }

    public void addOrderExpression(Expression e) {
        this.exprList.add(e);
    }

    public void addLimitCondition(Expression expression) {
        this.limitCondition = expression;
    }

    public void prepare(QuerySpecification select) {
        int orderByColumnCount = this.exprList.size();
        if (orderByColumnCount == 0) {
            return;
        }
        this.sortOrder = new int[orderByColumnCount];
        this.sortDescending = new boolean[orderByColumnCount];
        this.sortNullsLast = new boolean[orderByColumnCount];
        for (int i = 0; i < orderByColumnCount; ++i) {
            ExpressionOrderBy sort = (ExpressionOrderBy)this.exprList.get(i);
            this.sortOrder[i] = sort.getLeftNode().queryTableColumnIndex == -1 ? select.indexStartOrderBy + i : sort.getLeftNode().queryTableColumnIndex;
            this.sortDescending[i] = sort.isDescending();
            this.sortNullsLast[i] = sort.isNullsLast();
        }
    }

    public int getLimitStart(Session session) {
        Integer limit;
        if (this.limitCondition != null && (limit = (Integer)this.limitCondition.getLeftNode().getValue(session)) != null) {
            return limit;
        }
        return 0;
    }

    public int getLimitCount(Session session, int rowCount) {
        Integer limit;
        int limitCount = 0;
        if (this.limitCondition != null && (limit = (Integer)this.limitCondition.getRightNode().getValue(session)) != null) {
            limitCount = limit;
        }
        if (rowCount != 0 && (limitCount == 0 || rowCount < limitCount)) {
            limitCount = rowCount;
        }
        return limitCount;
    }

    public void setIndex(TableBase table) {
        try {
            this.index = table.createAndAddIndexStructure(null, this.sortOrder, this.sortDescending, this.sortNullsLast, false, false, false);
        }
        catch (Throwable t) {
            throw Error.runtimeError(401, "SortAndSlice");
        }
    }
}

