/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.SchemaObject;
import org.hsqldb.SchemaObjectSet;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.WrapperIterator;
import org.hsqldb.rights.Grantee;

public final class Schema
implements SchemaObject {
    HsqlNameManager.HsqlName name;
    SchemaObjectSet triggerLookup;
    SchemaObjectSet constraintLookup;
    SchemaObjectSet indexLookup;
    SchemaObjectSet tableLookup;
    SchemaObjectSet sequenceLookup;
    SchemaObjectSet typeLookup;
    SchemaObjectSet charsetLookup;
    SchemaObjectSet collationLookup;
    SchemaObjectSet procedureLookup;
    SchemaObjectSet functionLookup;
    SchemaObjectSet specificRoutineLookup;
    SchemaObjectSet assertionLookup;
    HashMappedList tableList;
    HashMappedList sequenceList;
    Grantee owner;

    Schema(HsqlNameManager.HsqlName name, Grantee owner) {
        this.name = name;
        this.triggerLookup = new SchemaObjectSet(8);
        this.indexLookup = new SchemaObjectSet(20);
        this.constraintLookup = new SchemaObjectSet(5);
        this.tableLookup = new SchemaObjectSet(3);
        this.sequenceLookup = new SchemaObjectSet(7);
        this.typeLookup = new SchemaObjectSet(12);
        this.charsetLookup = new SchemaObjectSet(14);
        this.collationLookup = new SchemaObjectSet(15);
        this.procedureLookup = new SchemaObjectSet(17);
        this.functionLookup = new SchemaObjectSet(16);
        this.specificRoutineLookup = new SchemaObjectSet(24);
        this.assertionLookup = new SchemaObjectSet(6);
        this.tableList = (HashMappedList)this.tableLookup.map;
        this.sequenceList = (HashMappedList)this.sequenceLookup.map;
        this.owner = owner;
        name.owner = owner;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return null;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return null;
    }

    @Override
    public Grantee getOwner() {
        return this.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject parentObject) {
    }

    @Override
    public String getSQL() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.name.statementName).append(' ');
        sb.append("AUTHORIZATION").append(' ');
        sb.append(this.owner.getStatementName());
        return sb.toString();
    }

    public String[] getSQLArray(OrderedHashSet resolved, OrderedHashSet unresolved) {
        HsqlArrayList list = new HsqlArrayList();
        StringBuffer sb = new StringBuffer(128);
        sb.append("CREATE").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.name.statementName).append(' ');
        sb.append("AUTHORIZATION").append(' ');
        sb.append(this.owner.getStatementName());
        list.add(sb.toString());
        sb.setLength(0);
        sb.append("SET").append(' ');
        sb.append("SCHEMA").append(' ');
        sb.append(this.name.statementName);
        list.add(sb.toString());
        Object[] subList = this.charsetLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.collationLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.typeLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.sequenceLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.tableLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.functionLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.procedureLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        subList = this.assertionLookup.getSQL(resolved, unresolved);
        list.addAll(subList);
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getSequenceRestartSQL() {
        HsqlArrayList list = new HsqlArrayList();
        Iterator it = this.sequenceLookup.map.values().iterator();
        while (it.hasNext()) {
            NumberSequence sequence = (NumberSequence)it.next();
            String ddl = sequence.getRestartSQL();
            list.add(ddl);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public String[] getTriggerSQL() {
        HsqlArrayList list = new HsqlArrayList();
        Iterator it = this.tableLookup.map.values().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            Object[] ddl = table.getTriggerSQL();
            list.addAll(ddl);
        }
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    boolean isEmpty() {
        return this.sequenceList.isEmpty() && this.tableList.isEmpty();
    }

    Iterator schemaObjectIterator(int type) {
        switch (type) {
            case 7: {
                return this.sequenceLookup.map.values().iterator();
            }
            case 3: 
            case 4: {
                return this.tableLookup.map.values().iterator();
            }
            case 14: {
                return this.charsetLookup.map.values().iterator();
            }
            case 15: {
                return this.collationLookup.map.values().iterator();
            }
            case 17: {
                return this.procedureLookup.map.values().iterator();
            }
            case 16: {
                return this.functionLookup.map.values().iterator();
            }
            case 18: {
                Iterator functions = this.functionLookup.map.values().iterator();
                return new WrapperIterator(functions, this.procedureLookup.map.values().iterator());
            }
            case 12: 
            case 13: {
                return this.typeLookup.map.values().iterator();
            }
            case 6: {
                return this.assertionLookup.map.values().iterator();
            }
            case 8: {
                return this.triggerLookup.map.values().iterator();
            }
            case 20: {
                return this.indexLookup.map.values().iterator();
            }
            case 5: {
                return this.constraintLookup.map.values().iterator();
            }
        }
        throw Error.runtimeError(401, "Schema");
    }

    void clearStructures() {
        this.tableList.clear();
        this.sequenceList.clear();
        this.triggerLookup = null;
        this.indexLookup = null;
        this.constraintLookup = null;
        this.procedureLookup = null;
        this.functionLookup = null;
        this.sequenceLookup = null;
        this.tableLookup = null;
        this.typeLookup = null;
    }
}

