/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementDMQL;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSet;
import org.hsqldb.Table;
import org.hsqldb.TableUtil;
import org.hsqldb.TableWorks;
import org.hsqldb.Token;
import org.hsqldb.TriggerDef;
import org.hsqldb.TriggerDefSQL;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{54, 120};
    static final short[] endStatementTokens = new short[]{54, 120, 4, 87};
    static final short[] endStatementTokensSchema = new short[]{54, 120};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    void reset(String sql) {
        super.reset(sql);
    }

    StatementSchema compileCreate() {
        int tableType = 3;
        boolean isTable = false;
        this.read();
        switch (this.token.tokenType) {
            case 119: {
                this.read();
                this.readThis(521);
                this.readIfThis(582);
                this.readThis(276);
                isTable = true;
                tableType = 2;
                break;
            }
            case 595: {
                this.read();
                this.readThis(276);
                isTable = true;
                tableType = 2;
                break;
            }
            case 521: {
                this.read();
                this.readThis(276);
                isTable = true;
                tableType = 2;
                break;
            }
            case 582: {
                this.read();
                this.readThis(276);
                isTable = true;
                break;
            }
            case 557: {
                this.read();
                this.readThis(276);
                isTable = true;
                tableType = 4;
                break;
            }
            case 596: {
                this.read();
                this.readThis(276);
                isTable = true;
                tableType = 6;
                break;
            }
            case 276: {
                this.read();
                isTable = true;
                tableType = this.database.schemaManager.getDefaultTableType();
                break;
            }
        }
        if (isTable) {
            return this.compileCreateTable(tableType);
        }
        switch (this.token.tokenType) {
            case 551: {
                return this.compileCreateAlias();
            }
            case 504: {
                return this.compileCreateSequence();
            }
            case 496: {
                return this.compileCreateSchema();
            }
            case 289: {
                return this.compileCreateTrigger();
            }
            case 303: {
                return this.compileCreateUser();
            }
            case 489: {
                return this.compileCreateRole();
            }
            case 543: {
                return this.compileCreateView();
            }
            case 393: {
                return this.compileCreateDomain();
            }
            case 533: {
                return this.compileCreateType();
            }
            case 34: {
                return this.compileCreateCharacterSet();
            }
            case 297: {
                this.read();
                this.checkIsThis(576);
                return this.compileCreateIndex(true);
            }
            case 576: {
                return this.compileCreateIndex(false);
            }
            case 116: 
            case 213: {
                return this.compileCreateProcedureOrFunction();
            }
        }
        throw this.unexpectedToken();
    }

    void processAlter() {
        this.session.setScripting(true);
        this.readThis(4);
        switch (this.token.tokenType) {
            case 276: {
                this.read();
                this.processAlterTable();
                break;
            }
            case 393: {
                this.read();
                this.processAlterDomain();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 576: {
                this.read();
                HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(20, true);
                this.readThis(591);
                this.readThis(283);
                return this.compileRenameObject(name, 20);
            }
            case 496: {
                this.read();
                HsqlNameManager.HsqlName name = this.readSchemaName();
                this.readThis(591);
                this.readThis(283);
                return this.compileRenameObject(name, 2);
            }
            case 348: {
                this.read();
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                this.checkValidCatalogName(name);
                this.read();
                this.readThis(591);
                this.readThis(283);
                return this.compileRenameObject(this.database.getCatalogName(), 1);
            }
            case 504: {
                this.read();
                return this.compileAlterSequence();
            }
            case 276: {
                this.read();
                return this.compileAlterTable();
            }
            case 303: {
                this.read();
                return this.compileAlterUser();
            }
            case 393: {
                this.read();
                return this.compileAlterDomain();
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileDrop() {
        int objectType;
        int statementType;
        boolean canCascade = false;
        boolean cascade = false;
        boolean useIfExists = false;
        boolean ifExists = false;
        this.read();
        int objectTokenType = this.token.tokenType;
        switch (objectTokenType) {
            case 576: {
                this.read();
                statementType = 1058;
                objectType = 20;
                useIfExists = true;
                break;
            }
            case 339: {
                this.read();
                statementType = 24;
                objectType = 6;
                canCascade = true;
                break;
            }
            case 257: {
                this.read();
                switch (this.token.tokenType) {
                    case 116: 
                    case 213: 
                    case 490: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                statementType = 30;
                objectType = 24;
                canCascade = true;
                break;
            }
            case 213: {
                this.read();
                statementType = 30;
                objectType = 17;
                canCascade = true;
                break;
            }
            case 116: {
                this.read();
                statementType = 30;
                objectType = 16;
                canCascade = true;
                break;
            }
            case 496: {
                this.read();
                statementType = 31;
                objectType = 2;
                useIfExists = true;
                canCascade = true;
                break;
            }
            case 504: {
                this.read();
                statementType = 135;
                objectType = 7;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 289: {
                this.read();
                statementType = 34;
                objectType = 8;
                canCascade = false;
                break;
            }
            case 303: {
                this.read();
                statementType = 1062;
                objectType = 11;
                canCascade = true;
                break;
            }
            case 489: {
                this.read();
                statementType = 29;
                objectType = 11;
                canCascade = true;
                break;
            }
            case 393: {
                this.read();
                statementType = 27;
                objectType = 13;
                canCascade = true;
                break;
            }
            case 533: {
                this.read();
                statementType = 35;
                objectType = 12;
                canCascade = true;
                break;
            }
            case 34: {
                this.read();
                this.readThis(252);
                statementType = 25;
                objectType = 14;
                canCascade = false;
                break;
            }
            case 543: {
                this.read();
                statementType = 36;
                objectType = 4;
                canCascade = true;
                useIfExists = true;
                break;
            }
            case 276: {
                this.read();
                statementType = 32;
                objectType = 3;
                canCascade = true;
                useIfExists = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (useIfExists && this.token.tokenType == 412) {
            int position = this.getPosition();
            this.read();
            if (this.token.tokenType == 100) {
                this.read();
                ifExists = true;
            } else {
                this.rewind(position);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName name = null;
        switch (objectTokenType) {
            case 303: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                User grantee = this.database.getUserManager().get(this.token.tokenString);
                name = grantee.getName();
                this.read();
                break;
            }
            case 489: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                Grantee role = this.database.getGranteeManager().getRole(this.token.tokenString);
                name = role.getName();
                this.read();
                break;
            }
            case 496: {
                name = this.readNewSchemaName();
                break;
            }
            default: {
                name = this.readNewSchemaObjectName(objectType, false);
            }
        }
        if (!ifExists && useIfExists && this.token.tokenType == 412) {
            this.read();
            this.readThis(100);
            ifExists = true;
        }
        if (canCascade) {
            if (this.token.tokenType == 347) {
                cascade = true;
                this.read();
            } else if (this.token.tokenType == 484) {
                this.read();
            }
        }
        Object[] args = new Object[]{name, new Integer(objectType), cascade, ifExists};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, statementType, args, null, null);
        switch (objectTokenType) {
            default: 
        }
        return cs;
    }

    private void processAlterTable() {
        String tableName = this.token.tokenString;
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(schema);
        Table t = this.database.schemaManager.getUserTable(this.session, tableName, schema.name);
        if (t.isView()) {
            throw Error.error(5501, tableName);
        }
        this.read();
        switch (this.token.tokenType) {
            case 591: {
                this.read();
                this.readThis(283);
                this.processAlterTableRename(t);
                return;
            }
            case 334: {
                this.read();
                HsqlNameManager.HsqlName cname = null;
                if (this.token.tokenType == 47) {
                    this.read();
                    cname = this.readNewDependentSchemaObjectName(t.getName(), 5);
                    this.database.schemaManager.checkSchemaObjectNotExists(cname);
                }
                switch (this.token.tokenType) {
                    case 112: {
                        this.read();
                        this.readThis(427);
                        this.processAlterTableAddForeignKeyConstraint(t, cname);
                        return;
                    }
                    case 297: {
                        this.read();
                        this.processAlterTableAddUniqueConstraint(t, cname);
                        return;
                    }
                    case 36: {
                        this.read();
                        this.processAlterTableAddCheckConstraint(t, cname);
                        return;
                    }
                    case 212: {
                        this.read();
                        this.readThis(427);
                        this.processAlterTableAddPrimaryKey(t, cname);
                        return;
                    }
                    case 42: {
                        if (cname != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        this.processAlterTableAddColumn(t);
                        return;
                    }
                }
                if (cname != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                this.processAlterTableAddColumn(t);
                return;
            }
            case 87: {
                this.read();
                switch (this.token.tokenType) {
                    case 212: {
                        boolean cascade = false;
                        this.read();
                        this.readThis(427);
                        if (this.token.tokenType == 347) {
                            this.read();
                            cascade = true;
                        }
                        if (!t.hasPrimaryKey()) {
                            throw Error.error(5501);
                        }
                        this.processAlterTableDropConstraint(t, t.getPrimaryConstraint().getName().name, cascade);
                        return;
                    }
                    case 47: {
                        boolean cascade = false;
                        this.read();
                        SchemaObject object = this.readSchemaObjectName(t.getName(), 5);
                        if (this.token.tokenType == 484) {
                            this.read();
                        } else if (this.token.tokenType == 347) {
                            this.read();
                            cascade = true;
                        }
                        this.processAlterTableDropConstraint(t, object.getName().name, cascade);
                        return;
                    }
                    case 42: {
                        this.read();
                    }
                }
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                boolean cascade = false;
                this.read();
                if (this.token.tokenType == 484) {
                    this.read();
                } else if (this.token.tokenType == 347) {
                    this.read();
                    cascade = true;
                }
                this.processAlterTableDropColumn(t, name, cascade);
                return;
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 42) {
                    this.read();
                }
                int columnIndex = t.getColumnIndex(this.token.tokenString);
                ColumnSchema column = t.getColumn(columnIndex);
                this.read();
                this.processAlterColumn(t, column, columnIndex);
                return;
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterTable() {
        String tableName = this.token.tokenString;
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        Table t = this.database.schemaManager.getUserTable(this.session, tableName, schema.name);
        if (t.isView()) {
            throw Error.error(5501, tableName);
        }
        this.read();
        switch (this.token.tokenType) {
            case 591: {
                this.read();
                this.readThis(283);
                return this.compileRenameObject(t.getName(), 3);
            }
            case 334: {
                this.read();
                HsqlNameManager.HsqlName cname = null;
                if (this.token.tokenType == 47) {
                    this.read();
                    cname = this.readNewDependentSchemaObjectName(t.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 112: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddForeignKeyConstraint(t, cname);
                    }
                    case 297: {
                        this.read();
                        return this.compileAlterTableAddUniqueConstraint(t, cname);
                    }
                    case 36: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(t, cname);
                    }
                    case 212: {
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableAddPrimaryKey(t, cname);
                    }
                    case 42: {
                        if (cname != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(t);
                    }
                }
                if (cname != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(t);
            }
            case 87: {
                this.read();
                switch (this.token.tokenType) {
                    case 212: {
                        boolean cascade = false;
                        this.read();
                        this.readThis(427);
                        return this.compileAlterTableDropPrimaryKey(t);
                    }
                    case 47: {
                        this.read();
                        return this.compileAlterTableDropConstraint(t);
                    }
                    case 42: {
                        this.read();
                    }
                }
                this.checkIsSimpleName();
                String name = this.token.tokenString;
                boolean cascade = false;
                this.read();
                if (this.token.tokenType == 484) {
                    this.read();
                } else if (this.token.tokenType == 347) {
                    this.read();
                    cascade = true;
                }
                return this.compileAlterTableDropColumn(t, name, cascade);
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 42) {
                    this.read();
                }
                int columnIndex = t.getColumnIndex(this.token.tokenString);
                ColumnSchema column = t.getColumn(columnIndex);
                this.read();
                return this.compileAlterColumn(t, column, columnIndex);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table t) {
        boolean cascade = false;
        SchemaObject object = this.readSchemaObjectName(t.getSchemaName(), 5);
        if (this.token.tokenType == 484) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            cascade = true;
        }
        Object[] args = new Object[]{object.getName(), 5, cascade, false};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 1059, args, null, null);
        cs.writeTableNames = this.getReferenceArray(t.getName(), cascade);
        return cs;
    }

    private Statement compileAlterTableDropPrimaryKey(Table t) {
        boolean cascade = false;
        if (this.token.tokenType == 484) {
            this.read();
        } else if (this.token.tokenType == 347) {
            this.read();
            cascade = true;
        }
        if (!t.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        Constraint object = t.getPrimaryConstraint();
        Object[] args = new Object[]{object.getName(), 5, cascade, false};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, 1059, args, null, null);
        cs.writeTableNames = this.getReferenceArray(t.getName(), cascade);
        return cs;
    }

    HsqlNameManager.HsqlName[] getReferenceArray(HsqlNameManager.HsqlName objectName, boolean cascade) {
        if (cascade) {
            OrderedHashSet names = new OrderedHashSet();
            this.database.schemaManager.getCascadingReferences(objectName, names);
            Iterator it = names.iterator();
            while (it.hasNext()) {
                HsqlNameManager.HsqlName name = (HsqlNameManager.HsqlName)it.next();
                if (name.type == 3) continue;
                it.remove();
            }
            names.add(objectName);
            Object[] array = new HsqlNameManager.HsqlName[names.size()];
            names.toArray(array);
            return array;
        }
        return new HsqlNameManager.HsqlName[]{objectName};
    }

    StatementSchema compileCreateTable(int type) {
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, false);
        HsqlArrayList tempConstraints = new HsqlArrayList();
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        Table table = TableUtil.newTable(this.database, type, name);
        if (this.token.tokenType == 9) {
            return this.readTableAsSubqueryDefinition(table);
        }
        int position = this.getPosition();
        this.readThis(695);
        Constraint c = new Constraint(null, null, 5);
        tempConstraints.add(c);
        boolean start = true;
        boolean startPart = true;
        boolean end = false;
        block6: while (!end) {
            switch (this.token.tokenType) {
                case 152: {
                    ColumnSchema[] likeColumns = this.readLikeTable(table);
                    for (int i = 0; i < likeColumns.length; ++i) {
                        table.addColumn(likeColumns[i]);
                    }
                    start = false;
                    startPart = false;
                    continue block6;
                }
                case 36: 
                case 47: 
                case 112: 
                case 212: 
                case 297: {
                    if (!startPart) {
                        throw this.unexpectedToken();
                    }
                    this.readConstraint(table, tempConstraints);
                    start = false;
                    startPart = false;
                    continue block6;
                }
                case 684: {
                    if (startPart) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    startPart = true;
                    continue block6;
                }
                case 682: {
                    this.read();
                    end = true;
                    continue block6;
                }
            }
            if (!startPart) {
                throw this.unexpectedToken();
            }
            this.checkIsSchemaObjectName();
            HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(name, this.token.tokenString, this.isDelimitedIdentifier());
            this.read();
            ColumnSchema newcolumn = this.readColumnDefinitionOrNull(table, hsqlName, tempConstraints);
            if (newcolumn == null) {
                if (start) {
                    this.rewind(position);
                    return this.readTableAsSubqueryDefinition(table);
                }
                throw Error.error(5000);
            }
            table.addColumn(newcolumn);
            start = false;
            startPart = false;
        }
        if (this.token.tokenType == 192) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(43);
            if (this.token.tokenType != 78 && this.token.tokenType == 475) {
                table.persistenceScope = 13;
            }
            this.read();
            this.readThis(243);
        }
        Object[] args = new Object[]{table, tempConstraints, null};
        String sql = this.getLastPart();
        return new StatementSchema(sql, 77, args, null, null);
    }

    private ColumnSchema[] readLikeTable(Table table) {
        this.read();
        boolean generated = false;
        boolean identity = false;
        boolean defaults = false;
        Table likeTable = this.readTableName();
        OrderedIntHashSet set = new OrderedIntHashSet();
        while (true) {
            boolean including;
            boolean bl = including = this.token.tokenType == 416;
            if (!including && this.token.tokenType != 399) break;
            this.read();
            switch (this.token.tokenType) {
                case 407: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    generated = including;
                    break;
                }
                case 127: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    identity = including;
                    break;
                }
                case 381: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    defaults = including;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        ColumnSchema[] columnList = new ColumnSchema[likeTable.getColumnCount()];
        for (int i = 0; i < columnList.length; ++i) {
            ColumnSchema column = likeTable.getColumn(i).duplicate();
            HsqlNameManager.HsqlName name = this.database.nameManager.newColumnSchemaHsqlName(table.getName(), column.getName());
            column.setName(name);
            if (identity) {
                if (column.isIdentity()) {
                    column.setIdentity(column.getIdentitySequence().duplicate());
                }
            } else {
                column.setIdentity(null);
            }
            if (!defaults) {
                column.setDefaultExpression(null);
            }
            if (!generated) {
                column.setGeneratingExpression(null);
            }
            columnList[i] = column;
        }
        return columnList;
    }

    StatementSchema readTableAsSubqueryDefinition(Table table) {
        Object readName = null;
        boolean withData = true;
        HsqlNameManager.HsqlName[] columnNames = null;
        StatementQuery statement = null;
        if (this.token.tokenType == 695) {
            columnNames = this.readColumnNames(table.getName());
        }
        this.readThis(9);
        this.readThis(695);
        QueryExpression queryExpression = this.XreadQueryExpression();
        queryExpression.setAsTopLevel();
        queryExpression.resolve(this.session);
        this.readThis(682);
        this.readThis(317);
        if (this.token.tokenType == 178) {
            this.read();
            withData = false;
        } else if (table.getTableType() == 6) {
            throw this.unexpectedTokenRequire("NO");
        }
        this.readThis(378);
        if (this.token.tokenType == 192) {
            if (!table.isTemp()) {
                throw this.unexpectedToken();
            }
            this.read();
            this.readThis(43);
            if (this.token.tokenType != 78 && this.token.tokenType == 475) {
                table.persistenceScope = 13;
            }
            this.read();
            this.readThis(243);
        }
        TableUtil.setColumnsInSchemaTable(table, queryExpression.getResultColumnNames(), queryExpression.getColumnTypes());
        if (columnNames != null) {
            if (columnNames.length != queryExpression.getColumnCount()) {
                throw Error.error(5593);
            }
            for (int i = 0; i < columnNames.length; ++i) {
                table.getColumn(i).getName().rename(columnNames[i]);
            }
        }
        table.createPrimaryKey();
        if (withData) {
            statement = new StatementQuery(this.session, queryExpression, this.compileContext);
        }
        Object[] args = new Object[]{table, null, statement};
        String sql = this.getLastPart();
        StatementSchema st = new StatementSchema(sql, 77, args, null, null);
        if (statement != null) {
            st.readTableNames = statement.getTableNamesForRead();
        }
        return st;
    }

    static Table addTableConstraintDefinitions(Session session, Table table, HsqlArrayList tempConstraints, HsqlArrayList constraintList) {
        Constraint c = (Constraint)tempConstraints.get(0);
        String namePart = c.getName() == null ? null : c.getName().name;
        HsqlNameManager.HsqlName indexName = session.database.nameManager.newAutoName("IDX", namePart, table.getSchemaName(), table.getName(), 20);
        if (c.mainColSet != null) {
            c.core.mainCols = table.getColumnIndexes(c.mainColSet);
        }
        table.createPrimaryKey(indexName, c.core.mainCols, true);
        if (c.core.mainCols != null) {
            Constraint newconstraint = new Constraint(c.getName(), table, table.getPrimaryIndex(), 4);
            table.addConstraint(newconstraint);
            session.database.schemaManager.addSchemaObject(newconstraint);
        }
        block5: for (int i = 1; i < tempConstraints.size(); ++i) {
            c = (Constraint)tempConstraints.get(i);
            switch (c.constType) {
                case 2: {
                    c.setColumnsIndexes(table);
                    if (table.getUniqueConstraintForColumns(c.core.mainCols) != null) {
                        throw Error.error(5522);
                    }
                    indexName = session.database.nameManager.newAutoName("IDX", c.getName().name, table.getSchemaName(), table.getName(), 20);
                    Index index = table.createAndAddIndexStructure(indexName, c.core.mainCols, null, null, true, true, false);
                    Constraint newconstraint = new Constraint(c.getName(), table, index, 2);
                    table.addConstraint(newconstraint);
                    session.database.schemaManager.addSchemaObject(newconstraint);
                    continue block5;
                }
                case 0: {
                    ParserDDL.addForeignKey(session, table, c, constraintList);
                    continue block5;
                }
                case 3: {
                    c.prepareCheckConstraint(session, table, false);
                    table.addConstraint(c);
                    if (c.isNotNull()) {
                        ColumnSchema column = table.getColumn(c.notNullColumnIndex);
                        column.setNullable(false);
                        table.setColumnTypeVars(c.notNullColumnIndex);
                    }
                    session.database.schemaManager.addSchemaObject(c);
                }
            }
        }
        return table;
    }

    static void addForeignKey(Session session, Table table, Constraint c, HsqlArrayList constraintList) {
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        if (mainTableName == table.getName()) {
            c.core.mainTable = table;
        } else {
            Table mainTable = session.database.schemaManager.findUserTable(session, mainTableName.name, mainTableName.schema.name);
            if (mainTable == null) {
                if (constraintList == null) {
                    throw Error.error(5501, mainTableName.name);
                }
                constraintList.add(c);
                return;
            }
            c.core.mainTable = mainTable;
        }
        c.setColumnsIndexes(table);
        Constraint uniqueConstraint = c.core.mainTable.getUniqueConstraintForColumns(c.core.mainCols, c.core.refCols);
        if (uniqueConstraint == null) {
            throw Error.error(5523);
        }
        Index mainIndex = uniqueConstraint.getMainIndex();
        TableWorks tableWorks = new TableWorks(session, table);
        tableWorks.checkCreateForeignKey(c);
        boolean isForward = c.core.mainTable.getSchemaName() != table.getSchemaName();
        int offset = session.database.schemaManager.getTableIndex(table);
        if (offset != -1 && offset < session.database.schemaManager.getTableIndex(c.core.mainTable)) {
            isForward = true;
        }
        HsqlNameManager.HsqlName refIndexName = session.database.nameManager.newAutoName("IDX", table.getSchemaName(), table.getName(), 20);
        Index index = table.createAndAddIndexStructure(refIndexName, c.core.refCols, null, null, false, true, isForward);
        HsqlNameManager.HsqlName mainName = session.database.nameManager.newAutoName("REF", c.getName().name, table.getSchemaName(), table.getName(), 20);
        c.core.uniqueName = uniqueConstraint.getName();
        c.core.mainName = mainName;
        c.core.mainIndex = mainIndex;
        c.core.refTable = table;
        c.core.refName = c.getName();
        c.core.refIndex = index;
        c.isForward = isForward;
        table.addConstraint(c);
        c.core.mainTable.addConstraint(new Constraint(mainName, c));
        session.database.schemaManager.addSchemaObject(c);
    }

    private Constraint readFKReferences(Table refTable, HsqlNameManager.HsqlName constraintName, OrderedHashSet refColSet) {
        HsqlNameManager.HsqlName mainTableName;
        OrderedHashSet mainColSet = null;
        this.readThis(220);
        HsqlNameManager.HsqlName schema = this.token.namePrefix == null ? refTable.getSchemaName() : this.database.schemaManager.getSchemaHsqlName(this.token.namePrefix);
        if (refTable.getSchemaName() == schema && refTable.getName().name.equals(this.token.tokenString)) {
            mainTableName = refTable.getName();
            this.read();
        } else {
            mainTableName = this.readFKTableName(schema);
        }
        if (this.token.tokenType == 695) {
            mainColSet = this.readColumnNames(false);
        } else if (mainTableName == refTable.getName()) {
            // empty if block
        }
        int matchType = 59;
        if (this.token.tokenType == 160) {
            this.read();
            switch (this.token.tokenType) {
                case 509: {
                    this.read();
                    break;
                }
                case 469: {
                    throw super.unsupportedFeature();
                }
                case 115: {
                    this.read();
                    matchType = 61;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        }
        int deleteAction = 3;
        int updateAction = 3;
        OrderedIntHashSet set = new OrderedIntHashSet();
        block13: while (this.token.tokenType == 192) {
            this.read();
            if (!set.add(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            if (this.token.tokenType == 78) {
                this.read();
                if (this.token.tokenType == 252) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 77: {
                            this.read();
                            deleteAction = 4;
                            continue block13;
                        }
                        case 184: {
                            this.read();
                            deleteAction = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    deleteAction = 0;
                    continue;
                }
                if (this.token.tokenType == 484) {
                    this.read();
                    continue;
                }
                this.readThis(178);
                this.readThis(332);
                continue;
            }
            if (this.token.tokenType == 301) {
                this.read();
                if (this.token.tokenType == 252) {
                    this.read();
                    switch (this.token.tokenType) {
                        case 77: {
                            this.read();
                            deleteAction = 4;
                            continue block13;
                        }
                        case 184: {
                            this.read();
                            deleteAction = 2;
                            continue block13;
                        }
                    }
                    throw this.unexpectedToken();
                }
                if (this.token.tokenType == 347) {
                    this.read();
                    updateAction = 0;
                    continue;
                }
                if (this.token.tokenType == 484) {
                    this.read();
                    continue;
                }
                this.readThis(178);
                this.readThis(332);
                continue;
            }
            throw this.unexpectedToken();
        }
        if (constraintName == null) {
            constraintName = this.database.nameManager.newAutoName("FK", refTable.getSchemaName(), refTable.getName(), 5);
        }
        return new Constraint(constraintName, refTable.getName(), refColSet, mainTableName, mainColSet, 0, deleteAction, updateAction, matchType);
    }

    private HsqlNameManager.HsqlName readFKTableName(HsqlNameManager.HsqlName schema) {
        this.checkIsSchemaObjectName();
        Table table = this.database.schemaManager.findUserTable(this.session, this.token.tokenString, schema.name);
        HsqlNameManager.HsqlName name = table == null ? this.database.nameManager.newHsqlName(schema, this.token.tokenString, this.isDelimitedIdentifier(), 3) : table.getName();
        this.read();
        return name;
    }

    void processCreateView() {
        StatementSchema cs = this.compileCreateView();
        View view = (View)cs.arguments[0];
        this.checkSchemaUpdateAuthorisation(view.getSchemaName());
        this.database.schemaManager.checkSchemaObjectNotExists(view.getName());
        this.database.schemaManager.addSchemaObject(view);
    }

    StatementSchema compileCreateView() {
        String statementSQL;
        QueryExpression queryExpression;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(4, true);
        name.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        HsqlNameManager.HsqlName[] colList = null;
        if (this.token.tokenType == 695) {
            colList = this.readColumnNames(name);
        }
        this.readThis(9);
        this.startRecording();
        int position = this.getPosition();
        try {
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException e) {
            queryExpression = this.XreadJoinedTable();
        }
        Token[] statement = this.getRecordedStatement();
        String sql = this.getLastPart(position);
        int check = 0;
        if (this.token.tokenType == 317) {
            this.read();
            check = 2;
            if (this.readIfThis(155)) {
                check = 1;
            } else {
                this.readIfThis(27);
            }
            this.readThis(36);
            this.readThis(454);
        }
        View view = new View(this.session, this.database, name, colList, sql, check);
        queryExpression.setAsTopLevel();
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        view.compile(this.session, null);
        this.checkSchemaUpdateAuthorisation(name.schema);
        this.database.schemaManager.checkSchemaObjectNotExists(name);
        view.statement = statementSQL = Token.getSQL(statement);
        String fullSQL = this.getLastPart();
        Object[] args = new Object[]{view};
        StatementSchema cs = new StatementSchema(fullSQL, 84, args, null, null);
        OrderedHashSet set = new OrderedHashSet();
        queryExpression.getBaseTableNames(set);
        Object[] names = new HsqlNameManager.HsqlName[set.size()];
        set.toArray(names);
        cs.readTableNames = names;
        return cs;
    }

    StatementSchema compileCreateSequence() {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(7, false);
        NumberSequence sequence = new NumberSequence(name, Type.SQL_INTEGER);
        this.readSequenceOptions(sequence, true, false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{sequence};
        return new StatementSchema(sql, 133, args, null, null);
    }

    StatementSchema compileCreateDomain() {
        boolean end;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(13, false);
        this.readIfThis(9);
        Type type = this.readTypeDefinition(false).duplicate();
        Expression defaultClause = null;
        if (this.readIfThis(77)) {
            defaultClause = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(name, 13, type);
        userTypeModifier.setDefaultClause(defaultClause);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList tempConstraints = new HsqlArrayList();
        this.compileContext.currentDomain = type;
        do {
            end = false;
            switch (this.token.tokenType) {
                case 36: 
                case 47: {
                    this.readConstraint(type, tempConstraints);
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        this.compileContext.currentDomain = null;
        for (int i = 0; i < tempConstraints.size(); ++i) {
            Constraint c = (Constraint)tempConstraints.get(i);
            c.prepareCheckConstraint(this.session, null, false);
            userTypeModifier.addConstraint(c);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{type};
        return new StatementSchema(sql, 23, args, null, null);
    }

    StatementSchema compileCreateType() {
        UserTypeModifier userTypeModifier;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(12, false);
        this.readThis(9);
        Type type = this.readTypeDefinition(false).duplicate();
        this.readIfThis(400);
        type.userTypeModifier = userTypeModifier = new UserTypeModifier(name, 12, type);
        String sql = this.getLastPart();
        Object[] args = new Object[]{type};
        return new StatementSchema(sql, 83, args, null, null);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(252);
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(14, false);
        this.readIfThis(9);
        this.readThis(118);
        String schema = this.session.getSchemaName(this.token.namePrefix);
        Charset source = (Charset)this.database.schemaManager.getSchemaObject(this.token.tokenString, schema, 14);
        this.read();
        if (this.token.tokenType == 358) {
            this.read();
            this.readThis(114);
            this.readThis(77);
        }
        Charset charset = new Charset(name);
        charset.base = source.getName();
        String sql = this.getLastPart();
        Object[] args = new Object[]{charset};
        return new StatementSchema(sql, 8, args, null, null);
    }

    StatementSchema compileCreateAlias() {
        String alias;
        HsqlNameManager.HsqlName name = null;
        Routine[] routines = null;
        String methodFQN = null;
        if (!this.session.isProcessingScript()) {
            throw super.unsupportedFeature();
        }
        this.read();
        try {
            alias = this.token.tokenString;
            this.read();
            this.readThis(111);
            methodFQN = this.token.tokenString;
            this.read();
        }
        catch (HsqlException e) {
            alias = null;
        }
        if (alias != null) {
            HsqlNameManager.HsqlName schema = this.database.schemaManager.getDefaultSchemaHsqlName();
            name = this.database.nameManager.newHsqlName(schema, alias, 16);
            Method[] methods = Routine.getMethods(methodFQN);
            routines = Routine.newRoutines(methods);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, routines};
        return new StatementSchema(sql, 1051, args, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    StatementSchema compileCreateTrigger() {
        int operationType;
        String operation;
        int beforeOrAfterType;
        String beforeOrAfter;
        boolean isForEachRow = false;
        boolean isNowait = false;
        boolean hasQueueSize = false;
        int queueSize = 0;
        HsqlNameManager.HsqlName otherName = null;
        OrderedHashSet columns = null;
        int[] updateColumnIndexes = null;
        this.read();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(8, true);
        switch (this.token.tokenType) {
            case 422: {
                beforeOrAfter = this.token.tokenString;
                beforeOrAfterType = this.token.tokenType;
                this.read();
                this.readThis(189);
                break;
            }
            case 336: 
            case 343: {
                beforeOrAfter = this.token.tokenString;
                beforeOrAfterType = this.token.tokenType;
                this.read();
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        switch (this.token.tokenType) {
            case 78: 
            case 133: {
                operation = this.token.tokenString;
                operationType = this.token.tokenType;
                this.read();
                break;
            }
            case 301: {
                operation = this.token.tokenString;
                operationType = this.token.tokenType;
                this.read();
                if (this.token.tokenType != 189 || beforeOrAfterType == 422) break;
                this.read();
                columns = this.readColumnNameList(null, false);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.readThis(192);
        Table table = this.readTableName();
        if (this.token.tokenType == 343) {
            this.read();
            this.checkIsSimpleName();
            otherName = this.readNewSchemaObjectName(8, true);
        }
        name.setSchemaIfNull(table.getSchemaName());
        this.checkSchemaUpdateAuthorisation(name.schema);
        if (beforeOrAfterType == 422 ? !table.isView() || ((View)table).getCheckOption() == 2 : table.isView()) {
            throw Error.error(5538, name.schema.name);
        }
        if (name.schema != table.getSchemaName()) {
            throw Error.error(5505, name.schema.name);
        }
        name.parent = table.getName();
        this.database.schemaManager.checkSchemaObjectNotExists(name);
        if (columns != null) {
            updateColumnIndexes = table.getColumnIndexes(columns);
            for (int i = 0; i < updateColumnIndexes.length; ++i) {
                if (updateColumnIndexes[i] != -1) continue;
                throw Error.error(5544, (String)columns.get(i));
            }
        }
        Expression condition = null;
        String oldTableName = null;
        String newTableName = null;
        String oldRowName = null;
        String newRowName = null;
        Table[] transitions = new Table[4];
        RangeVariable[] rangeVars = new RangeVariable[4];
        HsqlArrayList compiledStatements = new HsqlArrayList();
        String conditionSQL = null;
        String procedureSQL = null;
        if (this.token.tokenType == 221) {
            this.read();
            if (this.token.tokenType != 191 && this.token.tokenType != 177) {
                throw this.unexpectedToken();
            }
            while (true) {
                RangeVariable range;
                Table transition;
                HsqlNameManager.HsqlName hsqlName;
                String n;
                if (this.token.tokenType == 191) {
                    if (operationType == 133) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 276) {
                        if (oldTableName != null || beforeOrAfterType == 343) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(9);
                        this.checkIsSimpleName();
                        n = oldTableName = this.token.tokenString;
                        if (n.equals(newTableName) || n.equals(oldRowName) || n.equals(newRowName)) {
                            throw this.unexpectedToken();
                        }
                        hsqlName = this.database.nameManager.newHsqlName(table.getSchemaName(), n, this.isDelimitedIdentifier(), 10);
                        transition = new Table(table, hsqlName);
                        range = new RangeVariable(transition, null, null, null, this.compileContext);
                        transitions[2] = transition;
                        rangeVars[2] = range;
                    } else {
                        if (this.token.tokenType != 241) throw this.unexpectedToken();
                        if (oldRowName != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(9);
                        this.checkIsSimpleName();
                        n = oldRowName = this.token.tokenString;
                        if (n.equals(newTableName) || n.equals(oldTableName) || n.equals(newRowName)) {
                            throw this.unexpectedToken();
                        }
                        isForEachRow = true;
                        hsqlName = this.database.nameManager.newHsqlName(table.getSchemaName(), n, this.isDelimitedIdentifier(), 10);
                        transition = new Table(table, hsqlName);
                        range = new RangeVariable(transition, null, null, null, this.compileContext);
                        transitions[0] = transition;
                        rangeVars[0] = range;
                    }
                } else {
                    if (this.token.tokenType != 177) break;
                    if (operationType == 78) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.token.tokenType == 276) {
                        if (newTableName != null || beforeOrAfterType == 343) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(9);
                        this.checkIsSimpleName();
                        n = newTableName = this.token.tokenString;
                        if (n.equals(oldTableName) || n.equals(oldRowName) || n.equals(newRowName)) {
                            throw this.unexpectedToken();
                        }
                        hsqlName = this.database.nameManager.newHsqlName(table.getSchemaName(), n, this.isDelimitedIdentifier(), 10);
                        transition = new Table(table, hsqlName);
                        range = new RangeVariable(transition, null, null, null, this.compileContext);
                        transitions[3] = transition;
                        rangeVars[3] = range;
                    } else {
                        if (this.token.tokenType != 241) throw this.unexpectedToken();
                        if (newRowName != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readIfThis(9);
                        this.checkIsSimpleName();
                        newRowName = this.token.tokenString;
                        isForEachRow = true;
                        n = newRowName;
                        if (n.equals(oldTableName) || n.equals(newTableName) || n.equals(oldRowName)) {
                            throw this.unexpectedToken();
                        }
                        hsqlName = this.database.nameManager.newHsqlName(table.getSchemaName(), n, this.isDelimitedIdentifier(), 10);
                        transition = new Table(table, hsqlName);
                        range = new RangeVariable(transition, null, null, null, this.compileContext);
                        transitions[1] = transition;
                        rangeVars[1] = range;
                    }
                }
                this.read();
            }
        }
        if (isForEachRow && this.token.tokenType != 111) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 111) {
            this.read();
            this.readThis(89);
            if (this.token.tokenType == 241) {
                isForEachRow = true;
            } else {
                if (this.token.tokenType != 515) throw this.unexpectedToken();
                if (isForEachRow || beforeOrAfterType == 343) {
                    throw this.unexpectedToken();
                }
            }
            this.read();
        }
        if (rangeVars[2] != null) {
            // empty if block
        }
        if (rangeVars[3] != null) {
            // empty if block
        }
        if ("QUEUE".equals(this.token.tokenString)) {
            this.read();
            queueSize = this.readInteger();
            hasQueueSize = true;
        }
        if ("NOWAIT".equals(this.token.tokenString)) {
            this.read();
            isNowait = true;
        }
        if (this.token.tokenType == 312 && beforeOrAfterType != 422) {
            this.read();
            this.readThis(695);
            int position = this.getPosition();
            this.isCheckOrTriggerCondition = true;
            condition = this.XreadBooleanValueExpression();
            conditionSQL = this.getLastPart(position);
            this.isCheckOrTriggerCondition = false;
            this.readThis(682);
            HsqlList unresolved = condition.resolveColumnReferences(rangeVars, null);
            ExpressionColumn.checkColumnsResolved(unresolved);
            condition.resolveTypes(this.session, null);
            if (condition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.token.tokenType == 24) {
            this.read();
            this.checkIsSimpleName();
            this.checkIsDelimitedIdentifier();
            String className = this.token.tokenString;
            this.read();
            TriggerDef td = new TriggerDef(name, beforeOrAfter, operation, isForEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumnIndexes, className, isNowait, queueSize);
            String sql = this.getLastPart();
            Object[] args = new Object[]{td, otherName};
            return new StatementSchema(sql, 80, args, null, table.getName());
        }
        if (hasQueueSize) {
            throw this.unexpectedToken("QUEUE");
        }
        if (isNowait) {
            throw this.unexpectedToken("NOWAIT");
        }
        boolean isBlock = false;
        if (this.readIfThis(16)) {
            this.readThis(13);
            isBlock = true;
        }
        int position = this.getPosition();
        block18: do {
            StatementDMQL cs = null;
            this.compileContext.reset();
            switch (this.token.tokenType) {
                case 133: {
                    if (beforeOrAfterType == 343) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileInsertStatement(rangeVars);
                    compiledStatements.add(cs);
                    if (!isBlock) continue block18;
                    this.readThis(699);
                    break;
                }
                case 301: {
                    if (beforeOrAfterType == 343) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileUpdateStatement(rangeVars);
                    compiledStatements.add(cs);
                    if (!isBlock) continue block18;
                    this.readThis(699);
                    break;
                }
                case 78: {
                    if (beforeOrAfterType == 343) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileDeleteStatement(rangeVars);
                    compiledStatements.add(cs);
                    if (!isBlock) continue block18;
                    this.readThis(699);
                    break;
                }
                case 164: {
                    if (beforeOrAfterType == 343) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileMergeStatement(rangeVars);
                    compiledStatements.add(cs);
                    if (!isBlock) continue block18;
                    this.readThis(699);
                    break;
                }
                case 252: {
                    if (beforeOrAfterType != 343 || operationType == 78) {
                        throw this.unexpectedToken();
                    }
                    cs = this.compileTriggerSetStatement(table, rangeVars);
                    compiledStatements.add(cs);
                    if (!isBlock) continue block18;
                    this.readThis(699);
                    break;
                }
                case 93: {
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
        } while (isBlock && this.token.tokenType != 93);
        procedureSQL = this.getLastPart(position);
        if (isBlock) {
            this.readThis(93);
        }
        StatementDMQL[] csArray = new StatementDMQL[compiledStatements.size()];
        compiledStatements.toArray(csArray);
        OrderedHashSet references = this.compileContext.getSchemaObjectNames();
        for (int i = 0; i < csArray.length; ++i) {
            Table targetTable = csArray[i].targetTable;
            boolean[] check = csArray[i].getInsertOrUpdateColumnCheckList();
            if (check == null) continue;
            targetTable.getColumnNames(check, references);
        }
        references.remove(table.getName());
        TriggerDefSQL td = new TriggerDefSQL(name, beforeOrAfter, operation, isForEachRow, table, transitions, rangeVars, condition, conditionSQL, updateColumnIndexes, csArray, procedureSQL, references);
        String sql = this.getLastPart();
        Object[] args = new Object[]{td, otherName};
        return new StatementSchema(sql, 80, args, null, table.getName());
    }

    StatementDMQL compileTriggerSetStatement(Table table, RangeVariable[] rangeVars) {
        this.read();
        OrderedHashSet colNames = new OrderedHashSet();
        HsqlArrayList exprList = new HsqlArrayList();
        RangeVariable[] targetRangeVars = new RangeVariable[]{rangeVars[1]};
        this.readSetClauseList(targetRangeVars, colNames, exprList);
        int[] columnMap = table.getColumnIndexes(colNames);
        Expression[] updateExpressions = new Expression[exprList.size()];
        exprList.toArray(updateExpressions);
        this.resolveUpdateExpressions(table, rangeVars, columnMap, updateExpressions, RangeVariable.emptyArray);
        StatementSet cs = new StatementSet(this.session, table, rangeVars, columnMap, updateExpressions, this.compileContext);
        return cs;
    }

    ColumnSchema readColumnDefinitionOrNull(Table table, HsqlNameManager.HsqlName hsqlName, HsqlArrayList constraintList) {
        Type typeObject;
        boolean isIdentity = false;
        boolean isPKIdentity = false;
        boolean generatedAlways = false;
        Expression generateExpr = null;
        boolean isNullable = true;
        Expression defaultExpr = null;
        NumberSequence sequence = null;
        if (this.token.tokenType == 127) {
            this.read();
            isIdentity = true;
            isPKIdentity = true;
            typeObject = Type.SQL_INTEGER;
            sequence = new NumberSequence(null, 0L, 1L, typeObject);
        } else {
            if (this.token.tokenType == 684) {
                return null;
            }
            typeObject = this.readTypeDefinition(true);
        }
        if (!isIdentity) {
            if (this.token.tokenType == 77) {
                this.read();
                defaultExpr = this.readDefaultClause(typeObject);
            } else if (this.token.tokenType == 407 && !isIdentity) {
                this.read();
                if (this.token.tokenType == 23) {
                    this.read();
                    this.readThis(77);
                } else {
                    this.readThis(337);
                    generatedAlways = true;
                }
                this.readThis(9);
                if (this.token.tokenType == 127) {
                    this.read();
                    sequence = new NumberSequence(null, typeObject);
                    sequence.setAlways(generatedAlways);
                    if (this.token.tokenType == 695) {
                        this.read();
                        this.readSequenceOptions(sequence, false, false);
                        this.readThis(682);
                    }
                    isIdentity = true;
                } else if (this.token.tokenType == 695) {
                    if (!generatedAlways) {
                        throw super.unexpectedTokenRequire("ALWAYS");
                    }
                    this.read();
                    generateExpr = this.XreadValueExpression();
                    this.readThis(682);
                }
            } else if (this.token.tokenType == 127 && !isIdentity) {
                this.read();
                isIdentity = true;
                isPKIdentity = true;
                sequence = new NumberSequence(null, 0L, 1L, typeObject);
            }
        }
        ColumnSchema column = new ColumnSchema(hsqlName, typeObject, isNullable, false, defaultExpr);
        column.setGeneratingExpression(generateExpr);
        this.readColumnConstraints(table, column, constraintList);
        if (this.token.tokenType == 127 && !isIdentity) {
            this.read();
            isIdentity = true;
            isPKIdentity = true;
            sequence = new NumberSequence(null, 0L, 1L, typeObject);
        }
        if (isIdentity) {
            column.setIdentity(sequence);
        }
        if (isPKIdentity && !column.isPrimaryKey()) {
            OrderedHashSet set = new OrderedHashSet();
            set.add(column.getName().name);
            HsqlNameManager.HsqlName constName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
            Constraint c = new Constraint(constName, set, 4);
            constraintList.set(0, c);
            column.setPrimaryKey(true);
        }
        return column;
    }

    private void readSequenceOptions(NumberSequence sequence, boolean withType, boolean isAlter) {
        boolean end;
        OrderedIntHashSet set = new OrderedIntHashSet();
        do {
            end = false;
            if (set.contains(this.token.tokenType)) {
                throw this.unexpectedToken();
            }
            switch (this.token.tokenType) {
                case 9: {
                    if (withType) {
                        this.read();
                        Type type = this.readTypeDefinition(true);
                        sequence.setDefaults(sequence.name, type);
                        break;
                    }
                    throw this.unexpectedToken();
                }
                case 265: {
                    set.add(this.token.tokenType);
                    this.read();
                    this.readThis(317);
                    long value = this.readBigint();
                    sequence.setStartValueNoCheck(value);
                    break;
                }
                case 483: {
                    if (!isAlter) {
                        end = true;
                        break;
                    }
                    set.add(this.token.tokenType);
                    this.read();
                    if (this.readIfThis(317)) {
                        long value = this.readBigint();
                        sequence.setCurrentValueNoCheck(value);
                        break;
                    }
                    sequence.setStartValueDefault();
                    break;
                }
                case 417: {
                    set.add(this.token.tokenType);
                    this.read();
                    this.readThis(23);
                    long value = this.readBigint();
                    sequence.setIncrement(value);
                    break;
                }
                case 178: {
                    this.read();
                    if (this.token.tokenType == 437) {
                        sequence.setDefaultMaxValue();
                    } else if (this.token.tokenType == 441) {
                        sequence.setDefaultMinValue();
                    } else if (this.token.tokenType == 70) {
                        sequence.setCycle(false);
                    } else {
                        throw this.unexpectedToken();
                    }
                    set.add(this.token.tokenType);
                    this.read();
                    break;
                }
                case 437: {
                    set.add(this.token.tokenType);
                    this.read();
                    long value = this.readBigint();
                    sequence.setMaxValueNoCheck(value);
                    break;
                }
                case 441: {
                    set.add(this.token.tokenType);
                    this.read();
                    long value = this.readBigint();
                    sequence.setMinValueNoCheck(value);
                    break;
                }
                case 70: {
                    set.add(this.token.tokenType);
                    this.read();
                    sequence.setCycle(true);
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        sequence.checkValues();
    }

    private void readConstraint(SchemaObject schemaObject, HsqlArrayList constraintList) {
        HsqlNameManager.HsqlName constName = null;
        if (this.token.tokenType == 47) {
            this.read();
            constName = this.readNewDependentSchemaObjectName(schemaObject.getName(), 5);
        }
        switch (this.token.tokenType) {
            case 212: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                Constraint mainConst = (Constraint)constraintList.get(0);
                if (mainConst.constType == 4) {
                    throw Error.error(5532);
                }
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("PK", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                OrderedHashSet set = this.readColumnNames(false);
                Constraint c = new Constraint(constName, set, 4);
                constraintList.set(0, c);
                break;
            }
            case 297: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                OrderedHashSet set = this.readColumnNames(false);
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint c = new Constraint(constName, set, 2);
                constraintList.add(c);
                break;
            }
            case 112: {
                if (schemaObject.getName().type != 3) {
                    throw this.unexpectedTokenRequire("CHECK");
                }
                this.read();
                this.readThis(427);
                OrderedHashSet set = this.readColumnNames(false);
                Constraint c = this.readFKReferences((Table)schemaObject, constName, set);
                constraintList.add(c);
                break;
            }
            case 36: {
                this.read();
                if (constName == null) {
                    constName = this.database.nameManager.newAutoName("CT", schemaObject.getSchemaName(), schemaObject.getName(), 5);
                }
                Constraint c = new Constraint(constName, null, 3);
                this.readCheckConstraintCondition(c);
                constraintList.add(c);
                break;
            }
            default: {
                if (constName == null) break;
                throw Error.error(5581);
            }
        }
    }

    void readColumnConstraints(Table table, ColumnSchema column, HsqlArrayList constraintList) {
        boolean end = false;
        do {
            HsqlNameManager.HsqlName constName = null;
            if (this.token.tokenType == 47) {
                this.read();
                constName = this.readNewDependentSchemaObjectName(table.getName(), 5);
            }
            switch (this.token.tokenType) {
                case 212: {
                    this.read();
                    this.readThis(427);
                    Constraint existingConst = (Constraint)constraintList.get(0);
                    if (existingConst.constType == 4) {
                        throw Error.error(5532);
                    }
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, set, 4);
                    constraintList.set(0, c);
                    column.setPrimaryKey(true);
                    break;
                }
                case 297: {
                    this.read();
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, set, 2);
                    constraintList.add(c);
                    break;
                }
                case 112: {
                    this.read();
                    this.readThis(427);
                }
                case 220: {
                    OrderedHashSet set = new OrderedHashSet();
                    set.add(column.getName().name);
                    Constraint c = this.readFKReferences(table, constName, set);
                    constraintList.add(c);
                    break;
                }
                case 36: {
                    this.read();
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, null, 3);
                    this.readCheckConstraintCondition(c);
                    OrderedHashSet set = c.getCheckColumnExpressions();
                    for (int i = 0; i < set.size(); ++i) {
                        ExpressionColumn e = (ExpressionColumn)set.get(i);
                        if (column.getName().name.equals(e.getColumnName())) {
                            if (e.getSchemaName() == null || e.getSchemaName() == table.getSchemaName().name) continue;
                            throw Error.error(5505);
                        }
                        throw Error.error(5501);
                    }
                    constraintList.add(c);
                    break;
                }
                case 181: {
                    this.read();
                    this.readThis(184);
                    if (constName == null) {
                        constName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
                    }
                    Constraint c = new Constraint(constName, null, 3);
                    c.check = new ExpressionLogical(column);
                    constraintList.add(c);
                    break;
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
    }

    void readCheckConstraintCondition(Constraint c) {
        this.readThis(695);
        this.startRecording();
        this.isCheckOrTriggerCondition = true;
        Expression condition = this.XreadBooleanValueExpression();
        this.isCheckOrTriggerCondition = false;
        Token[] tokens = this.getRecordedStatement();
        this.readThis(682);
        c.check = condition;
        c.checkStatement = Token.getSQL(tokens);
    }

    private int[] readColumnList(Table table, boolean ascOrDesc) {
        OrderedHashSet set = this.readColumnNames(ascOrDesc);
        return table.getColumnIndexes(set);
    }

    StatementSchema compileCreateIndex(boolean unique) {
        this.read();
        HsqlNameManager.HsqlName indexHsqlName = this.readNewSchemaObjectName(20, true);
        this.readThis(192);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName tableSchema = table.getSchemaName();
        indexHsqlName.setSchemaIfNull(tableSchema);
        indexHsqlName.parent = table.getName();
        if (indexHsqlName.schema != tableSchema) {
            throw Error.error(5505);
        }
        indexHsqlName.schema = table.getSchemaName();
        int[] indexColumns = this.readColumnList(table, true);
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, indexColumns, indexHsqlName, unique};
        return new StatementSchema(sql, 1052, args, null, table.getName());
    }

    StatementSchema compileCreateSchema() {
        boolean swapped;
        Grantee owner;
        HsqlNameManager.HsqlName schemaName = null;
        String authorisation = null;
        this.read();
        if (this.token.tokenType != 14) {
            schemaName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 14) {
            this.read();
            this.checkIsSimpleName();
            authorisation = this.token.tokenString;
            this.read();
            if (schemaName == null) {
                owner = this.database.getGranteeManager().get(authorisation);
                if (owner == null) {
                    throw Error.error(4001, authorisation);
                }
                schemaName = this.database.nameManager.newHsqlName(owner.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(authorisation)) {
            throw Error.error(4002, authorisation);
        }
        Grantee grantee = owner = authorisation == null ? this.session.getGrantee() : this.database.getGranteeManager().get(authorisation);
        if (owner == null) {
            throw Error.error(4001, authorisation);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2000, this.session.getGrantee().getNameString());
        }
        if (this.database.schemaManager.schemaExists(schemaName.name)) {
            throw Error.error(5504, schemaName.name);
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{schemaName, owner};
        HsqlArrayList list = new HsqlArrayList();
        StatementSchema cs = new StatementSchema(sql, 64, args, null, null);
        cs.setSchemaHsqlName(schemaName);
        list.add(cs);
        this.getCompiledStatementBody(list);
        StatementSchema[] array = new StatementSchema[list.size()];
        list.toArray(array);
        do {
            swapped = false;
            for (int i = 0; i < array.length - 1; ++i) {
                if (array[i].order <= array[i + 1].order) continue;
                StatementSchema temp = array[i + 1];
                array[i + 1] = array[i];
                array[i] = temp;
                swapped = true;
            }
        } while (swapped);
        return new StatementSchemaDefinition(array);
    }

    void getCompiledStatementBody(HsqlList list) {
        boolean end = false;
        while (!end) {
            StatementSchema cs = null;
            int position = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 54: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 297: 
                        case 303: 
                        case 496: {
                            throw this.unexpectedToken();
                        }
                        case 576: {
                            int statementType = 1052;
                            String sql = this.getStatement(position, endStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType, null, null, null);
                            break block0;
                        }
                        case 504: {
                            cs = this.compileCreateSequence();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 489: {
                            cs = this.compileCreateRole();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 393: {
                            int statementType = 23;
                            String sql = this.getStatement(position, endStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType, null, null, null);
                            break block0;
                        }
                        case 533: {
                            cs = this.compileCreateType();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 34: {
                            cs = this.compileCreateCharacterSet();
                            cs.sql = this.getLastPart(position);
                            break block0;
                        }
                        case 339: {
                            throw this.unexpectedToken();
                        }
                        case 119: 
                        case 276: 
                        case 521: 
                        case 557: 
                        case 582: 
                        case 595: 
                        case 596: {
                            int statementType = 77;
                            String sql = this.getStatement(position, endStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType, null, null, null);
                            break block0;
                        }
                        case 289: {
                            int statementType = 80;
                            String sql = this.getStatement(position, endStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType, null, null, null);
                            break block0;
                        }
                        case 543: {
                            int statementType = 84;
                            String sql = this.getStatement(position, endStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType, null, null, null);
                            break block0;
                        }
                        case 116: {
                            int statementType = 14;
                            String sql = this.getStatement(position, endStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType, null, null, null);
                            break block0;
                        }
                        case 213: {
                            int statementType = 14;
                            String sql = this.getStatement(position, endStatementTokensSchema);
                            cs = new StatementSchema(sql, statementType, null, null, null);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 120: {
                    cs = this.compileGrantOrRevoke();
                    cs.sql = this.getLastPart(position);
                    break;
                }
                case 699: {
                    this.read();
                    end = true;
                    break;
                }
                case 748: {
                    end = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (cs == null) continue;
            cs.isSchemaDefinition = true;
            list.add(cs);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName name = this.readNewUserIdentifier();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name};
        return new StatementSchema(sql, 61, args, null, null);
    }

    StatementSchema compileCreateUser() {
        boolean admin = false;
        Grantee grantor = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName name = this.readNewUserIdentifier();
        this.readThis(586);
        String password = this.readPassword();
        if (this.token.tokenType == 335) {
            this.read();
            admin = true;
        }
        this.checkDatabaseUpdateAuthorisation();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, password, grantor, admin};
        return new StatementSchema(sql, 1053, args, null, null);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String tokenS = this.token.tokenString;
        boolean isQuoted = this.isDelimitedIdentifier();
        if (tokenS.equalsIgnoreCase("SA")) {
            tokenS = "SA";
            isQuoted = false;
        }
        HsqlNameManager.HsqlName name = this.database.nameManager.newHsqlName(tokenS, isQuoted, 11);
        this.read();
        return name;
    }

    String readPassword() {
        String tokenS = this.token.tokenString;
        this.read();
        return tokenS;
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName name, int objectType) {
        HsqlNameManager.HsqlName newName = this.readNewSchemaObjectName(objectType, true);
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, newName};
        return new StatementSchema(sql, 1064, args, null, null);
    }

    void processAlterTableRename(Table table) {
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(3, true);
        name.setSchemaIfNull(table.getSchemaName());
        if (table.getSchemaName() != name.schema) {
            throw Error.error(5505);
        }
        this.database.schemaManager.renameSchemaObject(table.getName(), name);
    }

    void processAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] cols = this.readColumnList(table, false);
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addUniqueConstraint(cols, name);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] cols = this.readColumnList(table, false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{cols, name};
        return new StatementSchema(sql, 4, args, null, table.getName());
    }

    void processAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet set = this.readColumnNames(false);
        Constraint c = this.readFKReferences(table, name, set);
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        c.core.mainTable = this.database.schemaManager.getTable(this.session, mainTableName.name, mainTableName.schema.name);
        c.setColumnsIndexes(table);
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addForeignKey(c);
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet set = this.readColumnNames(false);
        Constraint c = this.readFKReferences(table, name, set);
        HsqlNameManager.HsqlName mainTableName = c.getMainTableName();
        c.core.mainTable = this.database.schemaManager.getTable(this.session, mainTableName.name, mainTableName.schema.name);
        c.setColumnsIndexes(table);
        String sql = this.getLastPart();
        Object[] args = new Object[]{c};
        return new StatementSchema(sql, 4, args, c.core.mainTableName, table.getName());
    }

    void processAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint check = new Constraint(name, null, 3);
        this.readCheckConstraintCondition(check);
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addCheckConstraint(check);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint check = new Constraint(name, null, 3);
        this.readCheckConstraintCondition(check);
        String sql = this.getLastPart();
        Object[] args = new Object[]{check};
        return new StatementSchema(sql, 4, args, null, table.getName());
    }

    void processAlterTableAddColumn(Table table) {
        int colIndex = table.getColumnCount();
        HsqlArrayList list = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        list.add(constraint);
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema column = this.readColumnDefinitionOrNull(table, hsqlName, list);
        if (column == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 343) {
            this.read();
            colIndex = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        TableWorks tableWorks = new TableWorks(this.session, table);
        this.session.commit(false);
        tableWorks.addColumn(column, colIndex, list);
    }

    Statement compileAlterTableAddColumn(Table table) {
        int colIndex = table.getColumnCount();
        HsqlArrayList list = new HsqlArrayList();
        Constraint constraint = new Constraint(null, null, 5);
        list.add(constraint);
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema column = this.readColumnDefinitionOrNull(table, hsqlName, list);
        if (column == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 343) {
            this.read();
            colIndex = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String sql = this.getLastPart();
        Object[] args = new Object[]{column, new Integer(colIndex), list};
        return new StatementSchema(sql, 4, args, null, table.getName());
    }

    void processAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        int[] cols = this.readColumnList(table, false);
        Constraint constraint = new Constraint(name, null, 4);
        constraint.core.mainCols = cols;
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.addPrimaryKey(constraint, name);
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName name) {
        if (name == null) {
            name = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        int[] cols = this.readColumnList(table, false);
        Constraint constraint = new Constraint(name, null, 4);
        constraint.core.mainCols = cols;
        String sql = this.getLastPart();
        Object[] args = new Object[]{constraint};
        return new StatementSchema(sql, 4, args, null, table.getName());
    }

    void processAlterTableDropColumn(Table table, String colName, boolean cascade) {
        int colindex = table.getColumnIndex(colName);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.dropColumn(colindex, cascade);
    }

    Statement compileAlterTableDropColumn(Table table, String colName, boolean cascade) {
        HsqlNameManager.HsqlName writeName = null;
        int colindex = table.getColumnIndex(colName);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        Object[] args = new Object[]{table.getColumn(colindex).getName(), 5, cascade, false};
        if (!table.isTemp()) {
            writeName = table.getName();
        }
        return new StatementSchema(null, 1057, args, null, writeName);
    }

    void processAlterTableDropConstraint(Table table, String name, boolean cascade) {
        this.session.commit(false);
        TableWorks tableWorks = new TableWorks(this.session, table);
        tableWorks.dropConstraint(name, cascade);
    }

    void processAlterColumn(Table table, ColumnSchema column, int columnIndex) {
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 591: {
                this.read();
                this.readThis(283);
                this.processAlterColumnRename(table, column);
                return;
            }
            case 87: {
                this.read();
                if (this.token.tokenType == 77) {
                    this.read();
                    TableWorks tw = new TableWorks(this.session, table);
                    tw.setColDefaultExpression(columnIndex, null);
                    return;
                }
                if (this.token.tokenType == 407) {
                    this.read();
                    column.setIdentity(null);
                    table.setColumnTypeVars(columnIndex);
                    return;
                }
                throw this.unexpectedToken();
            }
            case 252: {
                this.read();
                switch (this.token.tokenType) {
                    case 378: {
                        this.read();
                        this.readThis(533);
                        this.processAlterColumnDataType(table, column);
                        return;
                    }
                    case 77: {
                        this.read();
                        TableWorks tw = new TableWorks(this.session, table);
                        Type type = column.getDataType();
                        Expression expr = this.readDefaultClause(type);
                        tw.setColDefaultExpression(columnIndex, expr);
                        return;
                    }
                    case 181: {
                        this.read();
                        this.readThis(184);
                        this.session.commit(false);
                        TableWorks tw = new TableWorks(this.session, table);
                        tw.setColNullability(column, false);
                        return;
                    }
                    case 184: {
                        this.read();
                        this.session.commit(false);
                        TableWorks tw = new TableWorks(this.session, table);
                        tw.setColNullability(column, true);
                        return;
                    }
                }
                this.rewind(position);
                this.read();
            }
        }
        if (this.token.tokenType == 252 || this.token.tokenType == 483) {
            if (!column.isIdentity()) {
                throw Error.error(5535);
            }
            this.processAlterColumnSequenceOptions(column);
            return;
        }
        this.processAlterColumnType(table, column, true);
    }

    Statement compileAlterColumn(Table table, ColumnSchema column, int columnIndex) {
        int position = this.getPosition();
        switch (this.token.tokenType) {
            case 591: {
                this.read();
                this.readThis(283);
                return this.compileAlterColumnRename(table, column);
            }
            case 87: {
                this.read();
                if (this.token.tokenType == 77) {
                    this.read();
                    return this.compileAlterColumnDropDefault(table, column, columnIndex);
                }
                if (this.token.tokenType == 407) {
                    this.read();
                    return this.compileAlterColumnDropGenerated(table, column, columnIndex);
                }
                throw this.unexpectedToken();
            }
            case 252: {
                this.read();
                switch (this.token.tokenType) {
                    case 378: {
                        this.read();
                        this.readThis(533);
                        return this.compileAlterColumnDataType(table, column);
                    }
                    case 77: {
                        this.read();
                        Type type = column.getDataType();
                        Expression expr = this.readDefaultClause(type);
                        return this.compileAlterColumnSetDefault(table, column, expr);
                    }
                    case 181: {
                        this.read();
                        this.readThis(184);
                        return this.compileAlterColumnSetNullability(table, column, false);
                    }
                    case 184: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, column, true);
                    }
                }
                this.rewind(position);
                this.read();
            }
        }
        if (this.token.tokenType == 252 || this.token.tokenType == 483) {
            if (!column.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, column);
        }
        return this.compileAlterColumnType(table, column);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema column) {
        Object writeName = null;
        Type typeObject = this.readTypeDefinition(false);
        String sql = this.getLastPart();
        Object[] args = new Object[]{table, column, typeObject};
        return new StatementSchema(sql, 4, null, null, table.getName());
    }

    private Statement compileAlterColumnType(Table table, ColumnSchema column) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 4, null, table.getName());
    }

    private Statement compileAlterColumnSequenceOptions(Table table, ColumnSchema column) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 4, table.getName(), null);
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema column, boolean b) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 4, table.getName(), null);
    }

    private Statement compileAlterColumnSetDefault(Table table, ColumnSchema column, Expression expr) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 4, table.getName(), null);
    }

    private Statement compileAlterColumnDropGenerated(Table table, ColumnSchema column, int columnIndex) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 4, table.getName(), null);
    }

    private Statement compileAlterColumnDropDefault(Table table, ColumnSchema column, int columnIndex) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 4, table.getName(), null);
    }

    Statement compileAlterSequence() {
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence sequence = this.database.schemaManager.getSequence(this.token.tokenString, schema.name, true);
        this.read();
        if (this.token.tokenType == 591) {
            this.read();
            this.readThis(283);
            return this.compileRenameObject(sequence.getName(), 7);
        }
        NumberSequence copy = sequence.duplicate();
        this.readSequenceOptions(copy, false, true);
        String sql = this.getLastPart();
        Object[] args = new Object[]{sequence, copy};
        return new StatementSchema(sql, 134, args, null, null);
    }

    void processAlterColumnSequenceOptions(ColumnSchema column) {
        boolean end;
        OrderedIntHashSet set = new OrderedIntHashSet();
        NumberSequence sequence = column.getIdentitySequence().duplicate();
        do {
            end = false;
            block0 : switch (this.token.tokenType) {
                case 483: {
                    if (!set.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    this.readThis(317);
                    long value = this.readBigint();
                    sequence.setStartValue(value);
                    break;
                }
                case 252: {
                    long value;
                    this.read();
                    switch (this.token.tokenType) {
                        case 417: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(23);
                            value = this.readBigint();
                            sequence.setIncrement(value);
                            break block0;
                        }
                        case 178: {
                            this.read();
                            if (this.token.tokenType == 437) {
                                sequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 441) {
                                sequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 70) {
                                sequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 437: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            value = this.readBigint();
                            sequence.setMaxValueNoCheck(value);
                            break block0;
                        }
                        case 441: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            value = this.readBigint();
                            sequence.setMinValueNoCheck(value);
                            break block0;
                        }
                        case 70: {
                            if (!set.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            sequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw Error.error(5581, this.token.tokenString);
                }
                default: {
                    end = true;
                }
            }
        } while (!end);
        sequence.checkValues();
        column.getIdentitySequence().reset(sequence);
    }

    private void processAlterColumnDataType(Table table, ColumnSchema oldCol) {
        this.processAlterColumnType(table, oldCol, false);
    }

    private void processAlterColumnType(Table table, ColumnSchema oldCol, boolean fullDefinition) {
        ColumnSchema newCol;
        if (oldCol.isGenerated()) {
            throw Error.error(5561);
        }
        if (fullDefinition) {
            HsqlArrayList list = new HsqlArrayList();
            Constraint c = table.getPrimaryConstraint();
            if (c == null) {
                c = new Constraint(null, null, 5);
            }
            list.add(c);
            newCol = this.readColumnDefinitionOrNull(table, oldCol.getName(), list);
            if (newCol == null) {
                throw Error.error(5000);
            }
            if (oldCol.isIdentity() && newCol.isIdentity()) {
                throw Error.error(5525);
            }
            if (list.size() > 1) {
                throw Error.error(5524);
            }
        } else {
            Type type = this.readTypeDefinition(true);
            if (oldCol.isIdentity() && !type.isIntegralType()) {
                throw Error.error(5561);
            }
            newCol = oldCol.duplicate();
            newCol.setType(type);
        }
        TableWorks tw = new TableWorks(this.session, table);
        tw.retypeColumn(oldCol, newCol);
    }

    private void processAlterColumnRename(Table table, ColumnSchema column) {
        this.checkIsSimpleName();
        if (table.findColumn(this.token.tokenString) > -1) {
            throw Error.error(5504, this.token.tokenString);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), column.getName());
        this.session.commit(false);
        table.renameColumn(column, this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema column) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName name = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(name.name) > -1) {
            throw Error.error(5504, name.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), column.getName());
        String sql = this.getLastPart();
        Object[] args = new Object[]{column.getName(), name};
        return new StatementSchema(sql, 1064, args, null, null);
    }

    Statement compileAlterSchemaRename() {
        HsqlNameManager.HsqlName name = this.readSchemaName();
        this.checkSchemaUpdateAuthorisation(name);
        this.readThis(591);
        this.readThis(283);
        HsqlNameManager.HsqlName newName = this.readNewSchemaName();
        String sql = this.getLastPart();
        Object[] args = new Object[]{name, newName};
        return new StatementSchema(sql, 1064, args, null, null);
    }

    Statement compileAlterUser() {
        HsqlNameManager.HsqlName userName = this.readNewUserIdentifier();
        User userObject = this.database.getUserManager().get(userName.name);
        if (userName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        this.readThis(252);
        if (this.token.tokenType == 586) {
            this.read();
            String password = this.readPassword();
            Object[] args = new Object[]{userObject, password};
            return new StatementCommand(1043, args, null, null);
        }
        if (this.token.tokenType == 577) {
            this.read();
            this.readThis(496);
            HsqlNameManager.HsqlName schemaName = this.token.tokenType == 77 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
            this.read();
            Object[] args = new Object[]{userObject, schemaName};
            return new StatementCommand(1042, args, null, null);
        }
        throw this.unexpectedToken();
    }

    void processAlterDomain() {
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(schema);
        Type domain = this.database.schemaManager.getDomain(this.token.tokenString, schema.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 591: {
                this.read();
                this.readThis(283);
                HsqlNameManager.HsqlName newName = this.readNewSchemaObjectName(13, true);
                newName.setSchemaIfNull(schema);
                if (domain.getSchemaName() != newName.schema) {
                    throw Error.error(5505, newName.schema.name);
                }
                this.checkSchemaUpdateAuthorisation(schema);
                this.database.schemaManager.renameSchemaObject(domain.getName(), newName);
                return;
            }
            case 87: {
                this.read();
                if (this.token.tokenType == 77) {
                    this.read();
                    domain.userTypeModifier.removeDefaultClause();
                    return;
                }
                if (this.token.tokenType == 47) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName name = this.database.schemaManager.getSchemaObjectName(domain.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    this.database.schemaManager.removeSchemaObject(name);
                    return;
                }
                throw this.unexpectedToken();
            }
            case 252: {
                this.read();
                this.readThis(77);
                Expression e = this.readDefaultClause(domain);
                domain.userTypeModifier.setDefaultClause(e);
                return;
            }
            case 334: {
                this.read();
                if (this.token.tokenType != 47 && this.token.tokenType != 36) break;
                HsqlArrayList tempConstraints = new HsqlArrayList();
                this.readConstraint(domain, tempConstraints);
                Constraint c = (Constraint)tempConstraints.get(0);
                domain.userTypeModifier.addConstraint(c);
                this.database.schemaManager.addSchemaObject(c);
                return;
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        HsqlNameManager.HsqlName schema = this.session.getSchemaHsqlName(this.token.namePrefix);
        Type domain = this.database.schemaManager.getDomain(this.token.tokenString, schema.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 591: {
                this.read();
                this.readThis(283);
                return this.compileRenameObject(domain.getName(), 13);
            }
            case 87: {
                this.read();
                if (this.token.tokenType == 77) {
                    this.read();
                    return this.compileAlterDomainDropDefault(domain);
                }
                if (this.token.tokenType == 47) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName name = this.database.schemaManager.getSchemaObjectName(domain.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    return this.compileAlterDomainDropConstraint(domain, name);
                }
                throw this.unexpectedToken();
            }
            case 252: {
                this.read();
                this.readThis(77);
                Expression e = this.readDefaultClause(domain);
                return this.compileAlterDomainSetDefault(domain, e);
            }
            case 334: {
                this.read();
                if (this.token.tokenType != 47 && this.token.tokenType != 36) break;
                HsqlArrayList tempConstraints = new HsqlArrayList();
                this.readConstraint(domain, tempConstraints);
                Constraint c = (Constraint)tempConstraints.get(0);
                return this.compileAlterDomainAddConstraint(domain, c);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterDomainAddConstraint(Type domain, Constraint c) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 3, null, null);
    }

    private Statement compileAlterDomainSetDefault(Type domain, Expression e) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 3, null, null);
    }

    private Statement compileAlterDomainDropConstraint(Type domain, HsqlNameManager.HsqlName name) {
        String sql = super.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 3, null, null);
    }

    private Statement compileAlterDomainDropDefault(Type domain) {
        String sql = this.getStatement(this.getParsePosition(), endStatementTokens);
        return new StatementSchema(sql, 3, null, null);
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 2: 
            case 78: 
            case 99: 
            case 133: 
            case 220: 
            case 249: 
            case 301: 
            case 538: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean grant = this.token.tokenType == 120;
        this.read();
        if (this.isGrantToken() || !grant && (this.token.tokenType == 120 || this.token.tokenType == 411)) {
            return this.compileRightGrantOrRevoke(grant);
        }
        return this.compileRoleGrantOrRevoke(grant);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean grant) {
        OrderedHashSet granteeList = new OrderedHashSet();
        Grantee grantor = null;
        Right right = null;
        HsqlNameManager.HsqlName objectName = null;
        boolean isTable = false;
        boolean isUsage = false;
        boolean isExec = false;
        boolean isAll = false;
        boolean isGrantOption = false;
        boolean cascade = false;
        if (!grant) {
            if (this.token.tokenType == 120) {
                this.read();
                this.readThis(454);
                this.readThis(111);
                isGrantOption = true;
            } else if (this.token.tokenType == 411) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 2) {
            this.read();
            if (this.token.tokenType == 477) {
                this.read();
            }
            right = Right.fullRights;
            isAll = true;
        } else {
            right = new Right();
            boolean loop = true;
            block20: while (loop) {
                this.checkIsNotQuoted();
                int rightType = GranteeManager.getCheckSingleRight(this.token.tokenString);
                int grantType = this.token.tokenType;
                OrderedHashSet columnSet = null;
                this.read();
                switch (grantType) {
                    case 133: 
                    case 220: 
                    case 249: 
                    case 301: {
                        if (this.token.tokenType == 695) {
                            columnSet = this.readColumnNames(false);
                        }
                    }
                    case 78: 
                    case 289: {
                        if (right == null) {
                            right = new Right();
                        }
                        right.set(rightType, columnSet);
                        isTable = true;
                        break;
                    }
                    case 538: {
                        if (isTable) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        isUsage = true;
                        loop = false;
                        continue block20;
                    }
                    case 99: {
                        if (isTable) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        isExec = true;
                        loop = false;
                        continue block20;
                    }
                }
                if (this.token.tokenType != 684) break;
                this.read();
            }
        }
        this.readThis(192);
        int objectType = 0;
        switch (this.token.tokenType) {
            case 560: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                objectType = 16;
                objectName = this.readNewSchemaObjectName(16, false);
                break;
            }
            case 257: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 116: 
                    case 213: 
                    case 490: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                objectType = 24;
                break;
            }
            case 116: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 16;
                break;
            }
            case 213: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 17;
                break;
            }
            case 490: {
                if (!isExec && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 18;
                break;
            }
            case 533: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 12;
                break;
            }
            case 393: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 13;
                break;
            }
            case 504: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                objectType = 7;
                break;
            }
            case 34: {
                if (!isUsage && !isAll) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(252);
                objectType = 14;
                break;
            }
            default: {
                if (!isTable && !isAll) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(276);
                objectType = 3;
            }
        }
        objectName = this.readNewSchemaObjectName(objectType, false);
        if (grant) {
            this.readThis(283);
        } else {
            this.readThis(114);
        }
        while (true) {
            this.checkIsSimpleName();
            granteeList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 684) break;
            this.read();
        }
        if (grant) {
            if (this.token.tokenType == 317) {
                this.read();
                this.readThis(120);
                this.readThis(454);
                isGrantOption = true;
            }
            if (this.token.tokenType == 410) {
                this.read();
                this.readThis(23);
                if (this.token.tokenType == 68) {
                    this.read();
                } else {
                    this.readThis(63);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantor = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 347) {
            cascade = true;
            this.read();
        } else {
            this.readThis(484);
        }
        int typee = grant ? 48 : 59;
        Object[] args = new Object[]{granteeList, objectName, right, grantor, cascade, isGrantOption};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, typee, args, null, null);
        return cs;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean grant) {
        Grantee grantor = this.session.getGrantee();
        OrderedHashSet roleList = new OrderedHashSet();
        OrderedHashSet granteeList = new OrderedHashSet();
        boolean cascade = false;
        if (!grant && this.token.tokenType == 335) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            roleList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 684) break;
            this.read();
        }
        if (grant) {
            this.readThis(283);
        } else {
            this.readThis(114);
        }
        while (true) {
            this.checkIsSimpleName();
            granteeList.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 684) break;
            this.read();
        }
        if (grant && this.token.tokenType == 317) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 410) {
            this.read();
            this.readThis(23);
            if (this.token.tokenType == 68) {
                this.read();
            } else {
                this.readThis(63);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantor = this.session.getRole();
            }
        }
        if (!grant) {
            if (this.token.tokenType == 347) {
                cascade = true;
                this.read();
            } else {
                this.readThis(484);
            }
        }
        int type = grant ? 49 : 129;
        Object[] args = new Object[]{granteeList, roleList, grantor, cascade};
        String sql = this.getLastPart();
        StatementSchema cs = new StatementSchema(sql, type, args, null, null);
        return cs;
    }

    void checkSchemaUpdateAuthorisation(HsqlNameManager.HsqlName schema) {
        if (this.session.isProcessingLog) {
            return;
        }
        SqlInvariants.checkSchemaNameNotSystem(schema.name);
        if (this.isSchemaDefinition) {
            if (schema != this.session.getCurrentSchemaHsqlName()) {
                throw Error.error(5505);
            }
        } else {
            this.session.getGrantee().checkSchemaUpdateOrGrantRights(schema.name);
        }
        this.session.checkDDLWrite();
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }
}

