/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.ISimpleRichTextModel;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.ILineAttributeModel;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.PartitionStorage;
import java.util.List;

public class WorldChange
extends Change {
    protected List<BasePartition> newPartitions;
    protected int[] aligns;
    protected Object[] bullets;

    public WorldChange(List<BasePartition> clonePartitions, int[] aligns, Object[] bullets) {
        this.newPartitions = clonePartitions;
        this.aligns = aligns;
        this.bullets = bullets;
    }

    public WorldChange(List<BasePartition> clonePartitions, List<Integer> oldAligns, List<Object> oldBullets) {
        this.newPartitions = clonePartitions;
        this.aligns = new int[oldAligns.size()];
        int a = 0;
        while (a < this.aligns.length) {
            this.aligns[a] = oldAligns.get(a);
            ++a;
        }
        this.bullets = oldBullets.toArray();
    }

    public WorldChange(ISimpleRichTextModel model) {
        this.newPartitions = model.getPartitions();
        this.aligns = new int[model.getLineCount()];
        this.bullets = new Object[model.getLineCount()];
        int a = 0;
        while (a < this.aligns.length) {
            this.aligns[a] = model.getAlign(a);
            this.bullets[a] = model.getBullet(a);
            ++a;
        }
    }

    @Override
    protected void apply(PartitionDelta delta) {
        PartitionStorage storage = delta.getStorage();
        List<BasePartition> clonePartitions = storage.clonePartitions();
        ILineAttributeModel lineAttributeModel = delta.getStorage().getLineAttributeModel();
        int lineCount = lineAttributeModel.lineCount();
        int[] aligns = new int[lineCount];
        Object[] bullets = new Object[lineCount];
        int a = 0;
        while (a < lineCount) {
            aligns[a] = lineAttributeModel.getLineAlign(a);
            bullets[a] = lineAttributeModel.getBullet(a);
            ++a;
        }
        storage.setPartitions(this.newPartitions);
        a = 0;
        while (a < this.aligns.length) {
            lineAttributeModel.setLineAlign(a, 0, this.aligns[a]);
            Object bullet = this.bullets[a];
            if (bullet != null) {
                lineAttributeModel.setLineBullet(a, 0, bullet);
            }
            ++a;
        }
        delta.getUndoChange().add(new WorldChange(clonePartitions, aligns, bullets));
    }
}

