/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.partitions.AbstractPartitionChange;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;

public class PartitionStyleChange
extends AbstractPartitionChange {
    private FontStyle style;
    private boolean add;
    private boolean set;

    public boolean isSet() {
        return this.set;
    }

    public void setSet(boolean set) {
        this.set = set;
    }

    public PartitionStyleChange(BasePartition partition, FontStyle style, boolean add) {
        super(partition);
        this.style = style;
        this.add = add;
    }

    @Override
    protected void apply(PartitionDelta delta) {
        this.partition.getBgColorRGB();
        final FontStyle oldStyle = new FontStyle(this.partition);
        if (this.set) {
            this.style.setStyle(this.partition);
        } else if (this.add) {
            this.style.applyStyle(this.partition);
        } else {
            this.style.removeStyle(this.partition);
        }
        AbstractPartitionChange abstractPartitionChange = new AbstractPartitionChange(this.partition){

            @Override
            protected void apply(PartitionDelta partitionStorage) {
                oldStyle.setStyle(this.partition);
                partitionStorage.getUndoChange().add(PartitionStyleChange.this);
            }
        };
        delta.changed(this.partition);
        delta.getUndoChange().add(abstractPartitionChange);
    }

    public String toString() {
        String s = this.add ? "Apply style " : "Remove style ";
        return String.valueOf(s) + this.style + " " + this.partition;
    }
}

