/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.FontStyle;
import com.onpositive.richtexteditor.model.IPartition;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.Change;
import com.onpositive.richtexteditor.model.partitions.CompositeChange;
import com.onpositive.richtexteditor.model.partitions.LinkPartition;
import com.onpositive.richtexteditor.model.partitions.ObjectPartition;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.PartitionStorage;
import com.onpositive.richtexteditor.model.partitions.PartitionStyleChange;
import java.util.List;

public class ExpandPartitionAtOffsetChange
extends Change {
    private int offset;
    private int amount;
    private BasePartition current;
    private BasePartition psToCreate;

    public ExpandPartitionAtOffsetChange(int offset, int amount, BasePartition currentFontPartition) {
        this.amount = amount;
        this.offset = offset;
        this.current = currentFontPartition;
    }

    @Override
    protected void apply(PartitionDelta delta) {
        int i;
        BasePartition original;
        BasePartition partitionAtOffset;
        BasePartition initial;
        PartitionStorage storage;
        PartitionStorage partitionStorage = storage = delta.getStorage();
        BasePartition partitionAtPosition = partitionStorage.getPartitionAtOffset(Math.max(this.offset - 1, 0));
        BasePartition basePartition = initial = this.current != null ? null : partitionAtPosition;
        if (initial instanceof LinkPartition || initial instanceof ObjectPartition) {
            if (this.offset == 0) {
                initial = null;
            } else if (initial.getOffset() == this.offset || initial.getOffset() + initial.getLength() == this.offset) {
                this.expandOtherPartition(delta, initial);
                return;
            }
        }
        BasePartition basePartition2 = partitionAtOffset = (original = initial) != null ? original : this.createPartition(partitionStorage);
        if (original == null) {
            IPartition pa = null;
            if ((pa = this.getPartitionToInsertIn(storage, pa)) == null) {
                int pos = this.determineInsertionOffset(partitionStorage);
                partitionStorage.insertPartition(pos, partitionAtOffset);
                delta.added(partitionAtOffset);
            } else {
                CompositeChange cq = new CompositeChange(storage);
                BasePartition fp = (BasePartition)pa;
                cq.setLength(fp, pa.getLength() + this.amount);
                cq.shiftOffsets(fp.getPosition() + 1, this.amount);
                cq.apply(delta);
                cq = new CompositeChange(storage);
                List<IPartition> extractChangedRegion = cq.extractChangedRegion(this.offset, this.amount);
                FontStyle fs = new FontStyle(this.current);
                for (IPartition p : extractChangedRegion) {
                    PartitionStyleChange change = new PartitionStyleChange((BasePartition)p, fs, false);
                    change.setSet(true);
                    cq.add(change);
                }
                cq.apply(delta);
                return;
            }
        }
        partitionAtOffset.setLength(partitionAtOffset.getLength() + this.amount);
        delta.changed(partitionAtOffset);
        int a = i = partitionAtOffset.getPosition() + 1;
        while (a < partitionStorage.size()) {
            BasePartition basePartition3 = partitionStorage.get(a);
            basePartition3.setOffset(basePartition3.getOffset() + this.amount);
            ++a;
        }
        Change change = new Change(){

            @Override
            protected void apply(PartitionDelta delta) {
                PartitionStorage partitionStorage = delta.getStorage();
                if (original == null) {
                    partitionStorage.removePartition(partitionAtOffset);
                }
                if (partitionAtOffset != null) {
                    partitionAtOffset.setLength(partitionAtOffset.getLength() - ExpandPartitionAtOffsetChange.this.amount);
                }
                int a = original != null ? i : i - 1;
                while (a < partitionStorage.size()) {
                    BasePartition basePartition = partitionStorage.get(a);
                    basePartition.setOffset(basePartition.getOffset() - ExpandPartitionAtOffsetChange.this.amount);
                    ++a;
                }
                delta.getUndoChange().add(ExpandPartitionAtOffsetChange.this);
            }
        };
        delta.getUndoChange().add(change);
    }

    private IPartition getPartitionToInsertIn(PartitionStorage storage, IPartition pa) {
        for (IPartition iPartition : storage.getPartitions()) {
            boolean b;
            boolean bl = b = iPartition.getOffset() < this.offset;
            if (!b) break;
            if (iPartition.getOffset() + iPartition.getLength() <= this.offset) continue;
            pa = iPartition;
            break;
        }
        return pa;
    }

    private int determineInsertionOffset(PartitionStorage partitionStorage) {
        int pos = partitionStorage.size();
        int a = 0;
        while (a < partitionStorage.size()) {
            BasePartition pa = partitionStorage.get(a);
            if (pa.getOffset() >= this.offset) {
                pos = a;
                break;
            }
            ++a;
        }
        return pos;
    }

    private BasePartition createPartition(PartitionStorage partitionStorage) {
        BasePartition internalCreatePartition;
        if (this.psToCreate != null) {
            return this.psToCreate;
        }
        this.psToCreate = internalCreatePartition = this.internalCreatePartition(partitionStorage);
        return internalCreatePartition;
    }

    private BasePartition internalCreatePartition(PartitionStorage partitionStorage) {
        if (this.current != null) {
            return partitionStorage.newPartition(this.offset, 0, this.current);
        }
        return partitionStorage.newPartition();
    }

    private void expandOtherPartition(PartitionDelta delta, BasePartition ps) {
        int i;
        PartitionStorage partitionStorage = delta.getStorage();
        final BasePartition original = this.getNextUsualPartition(partitionStorage);
        final BasePartition partitionAtOffset = original != null ? partitionStorage.newPartition(this.offset, this.amount, original) : this.createPartition(partitionStorage);
        partitionStorage.insertPartition(ps.getPosition() + 1, partitionAtOffset);
        partitionAtOffset.setOffset(this.offset);
        partitionAtOffset.setLength(this.amount);
        delta.added(partitionAtOffset);
        int a = i = partitionAtOffset.getPosition() + 1;
        while (a < partitionStorage.size()) {
            BasePartition basePartition = partitionStorage.get(a);
            basePartition.setOffset(basePartition.getOffset() + this.amount);
            ++a;
        }
        Change change = new Change(){

            @Override
            protected void apply(PartitionDelta delta) {
                PartitionStorage partitionStorage = delta.getStorage();
                if (original == null) {
                    partitionStorage.removePartition(partitionAtOffset);
                } else if (partitionAtOffset != null) {
                    partitionAtOffset.setOffset(partitionAtOffset.getOffset() + ExpandPartitionAtOffsetChange.this.amount);
                }
                int a = i;
                while (a < partitionStorage.size()) {
                    BasePartition basePartition = partitionStorage.get(a);
                    basePartition.setOffset(basePartition.getOffset() + ExpandPartitionAtOffsetChange.this.amount);
                    ++a;
                }
                delta.getUndoChange().add(ExpandPartitionAtOffsetChange.this);
            }
        };
        delta.getUndoChange().add(change);
    }

    private BasePartition getNextUsualPartition(PartitionStorage partitionStorage) {
        BasePartition partitionAtOffset;
        int pos = this.offset + 1;
        while ((partitionAtOffset = partitionStorage.getPartitionAtOffset(pos)) instanceof LinkPartition || partitionAtOffset instanceof ObjectPartition) {
            pos = partitionAtOffset.getOffset() + partitionAtOffset.getLength();
        }
        return partitionAtOffset;
    }

    public String toString() {
        return "Expand " + this.current + " at " + this.offset + " amount: " + this.amount;
    }
}

