/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.partitions.AbstractPartitionChange;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;

public class AdjustPartitionChange
extends AbstractPartitionChange {
    private int offset;
    private int length;

    public AdjustPartitionChange(BasePartition partition, int offset, int length) {
        super(partition);
        this.offset = offset;
        this.length = length;
    }

    @Override
    protected void apply(PartitionDelta delta) {
        int oldOffset = this.partition.getOffset();
        int oldLength = this.partition.getLength();
        this.partition.offset = this.offset;
        this.partition.length = this.length;
        delta.changed(this.partition);
        delta.getUndoChange().add(new AdjustPartitionChange(this.partition, oldOffset, oldLength));
    }

    public String toString() {
        return "Adjust " + this.partition + " to offset " + this.offset + " ,length " + this.length;
    }
}

