/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.model.partitions;

import com.onpositive.richtexteditor.model.partitions.AbstractPartitionChange;
import com.onpositive.richtexteditor.model.partitions.BasePartition;
import com.onpositive.richtexteditor.model.partitions.PartitionDelta;
import com.onpositive.richtexteditor.model.partitions.PartitionStorage;
import com.onpositive.richtexteditor.model.partitions.RegionPartition;

public class AddRemovePartitionChange
extends AbstractPartitionChange {
    boolean add;
    int index;

    public AddRemovePartitionChange(int index, BasePartition partition, boolean add) {
        super(partition);
        if (!add && partition.index == -1) {
            throw new IllegalArgumentException();
        }
        this.index = index;
        this.add = add;
    }

    @Override
    protected void apply(PartitionDelta delta) {
        PartitionStorage storage = delta.getStorage();
        if (this.add) {
            storage.insertPartition(this.index, this.partition);
            delta.added(this.partition);
        } else if (this.partition.index == -1) {
            BasePartition removePartition = storage.removePartition(this.index);
            if (removePartition instanceof RegionPartition) {
                ((RegionPartition)removePartition).dispose();
            }
            delta.removed(removePartition);
        } else {
            if (this.partition instanceof RegionPartition) {
                ((RegionPartition)this.partition).dispose();
            }
            storage.removePartition(this.partition);
            delta.removed(this.partition);
        }
        delta.getUndoChange().add(new AddRemovePartitionChange(this.index, this.partition, !this.add));
    }

    public String toString() {
        String res = this.add ? "Add " : "Remove ";
        res = String.valueOf(res) + this.partition.toString() + " index " + this.index;
        return res;
    }
}

