/*
 * Decompiled with CFR 0.152.
 */
package com.onpositive.richtexteditor.io.html_scaner;

import com.onpositive.richtexteditor.io.LexEvent;
import com.onpositive.richtexteditor.io.html_scaner.AttrValueLexEvent;
import com.onpositive.richtexteditor.io.html_scaner.EOFEvent;
import com.onpositive.richtexteditor.io.html_scaner.ILexListener;
import com.onpositive.richtexteditor.io.html_scaner.TagEndEvent;
import com.onpositive.richtexteditor.io.html_scaner.TagLexEvent;
import com.onpositive.richtexteditor.model.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;

public class Scanner {
    protected static final int TYPE_END = 0;
    protected static final int TYPE_UNKNOWN = 101;
    protected static final int TYPE_TEXT = 100;
    protected static final int TYPE_HTML = 1;
    protected static final int TYPE_BODY = 2;
    protected static final int TYPE_P = 3;
    protected static final int TYPE_B = 4;
    protected static final int TYPE_I = 5;
    protected static final int TYPE_U = 6;
    protected static final int TYPE_STRIKE = 7;
    protected static final int TYPE_FONT = 8;
    protected static final int TYPE_IMG = 9;
    protected static final int TYPE_SPAN = 10;
    protected static final int TYPE_BR = 11;
    protected static final int TYPE_OL = 12;
    protected static final int TYPE_UL = 13;
    protected static final int TYPE_LI = 14;
    protected static final int TYPE_STYLE = 15;
    protected static final int TYPE_XML = 16;
    protected static final int TYPE_H1 = 17;
    protected static final int TYPE_H2 = 18;
    protected static final int TYPE_H3 = 19;
    protected static final int TYPE_A = 20;
    protected static final int TYPE_SCRIPT = 21;
    protected static final int TYPE_TITLE = 22;
    protected static final int TYPE_DIV = 23;
    protected static final int TYPE_TR = 24;
    protected static final int TYPE_TABLE = 25;
    protected static final int TYPE_TH = 26;
    protected static final int TYPE_HR = 27;
    protected static final int TYPE_CODE = 28;
    protected static final int TYPE_PRE = 29;
    protected static final int ATTR_TYPE_HEIGHT = 50;
    protected static final int ATTR_TYPE_FACE = 51;
    protected static final int ATTR_TYPE_ALIGN = 52;
    protected static final int ATTR_TYPE_COLOR = 53;
    protected static final int ATTR_TYPE_STYLE = 54;
    protected static final int ATTR_TYPE_HREF = 55;
    protected static final int ATTR_TYPE_SRC = 56;
    char[] nonTagNameSymbols = new char[]{'\"', '\'', '<', '>', '/', '\\', '='};
    protected int uk;
    protected char[] t;
    protected HashMap<String, Integer> tagKeywords = new HashMap();
    protected HashMap<String, Integer> attrKeywords = new HashMap();
    protected ArrayList<ILexListener> listeners = new ArrayList();
    protected static Scanner scaner;
    protected boolean textScanned;
    protected boolean clearEnters = true;

    protected boolean checkForIdentBeginning(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    public void addLexListener(ILexListener lexListener) {
        this.listeners.add(lexListener);
    }

    public void removeLexListener(ILexListener lexListener) {
        this.listeners.remove(lexListener);
    }

    public Scanner() {
        this.fillKeywords();
    }

    protected void fillKeywords() {
        this.tagKeywords.put("html", 1);
        this.tagKeywords.put("body", 2);
        this.tagKeywords.put("p", 3);
        this.tagKeywords.put("b", 4);
        this.tagKeywords.put("i", 5);
        this.tagKeywords.put("u", 6);
        this.tagKeywords.put("em", 5);
        this.tagKeywords.put("strike", 7);
        this.tagKeywords.put("font", 8);
        this.tagKeywords.put("img", 9);
        this.tagKeywords.put("span", 10);
        this.tagKeywords.put("br", 11);
        this.tagKeywords.put("ol", 12);
        this.tagKeywords.put("ul", 13);
        this.tagKeywords.put("li", 14);
        this.tagKeywords.put("style", 15);
        this.tagKeywords.put("xml", 16);
        this.tagKeywords.put("h1", 17);
        this.tagKeywords.put("h2", 18);
        this.tagKeywords.put("h3", 19);
        this.tagKeywords.put("hr", 27);
        this.tagKeywords.put("a", 20);
        this.tagKeywords.put("script", 21);
        this.tagKeywords.put("title", 22);
        this.tagKeywords.put("div", 23);
        this.tagKeywords.put("tr", 24);
        this.tagKeywords.put("table", 25);
        this.tagKeywords.put("code", 28);
        this.tagKeywords.put("pre", 29);
        this.attrKeywords.put("height", 50);
        this.attrKeywords.put("face", 51);
        this.attrKeywords.put("align", 52);
        this.attrKeywords.put("color", 53);
        this.attrKeywords.put("style", 54);
        this.attrKeywords.put("href", 55);
        this.attrKeywords.put("src", 56);
    }

    protected boolean checkForTagNameSymbol(char c) {
        return !this.isIn(c, this.nonTagNameSymbols) && !Character.isWhitespace(c);
    }

    protected boolean checkForIndentSymbol(char c) {
        if (this.checkForIdentBeginning(c)) {
            return true;
        }
        return this.t[this.uk] <= '9' && this.t[this.uk] >= '0';
    }

    void PutUK(int i) {
        this.uk = i;
    }

    int GetUK() {
        return this.uk;
    }

    void LogError(FileWriter LogFile, String msg) throws IOException {
        if (LogFile != null) {
            LogFile.write("\u00ce\u00f8\u00e8\u00e1\u00ea\u00e0! " + msg);
        }
    }

    /*
     * Unable to fully structure code
     */
    void scaner() {
        this.uk = 0;
        while (true) {
            lxm = new LexEvent();
            if (this.uk >= this.t.length) {
                return;
            }
            if (this.t[this.uk] != '<') ** GOTO lbl11
            ++this.uk;
            this.scanForTag();
            continue;
lbl-1000:
            // 1 sources

            {
                lxm.l = String.valueOf(lxm.l) + this.t[this.uk++];
lbl11:
                // 2 sources

                ** while (this.uk < this.t.length && this.t[this.uk] != '<')
            }
lbl12:
            // 1 sources

            if (this.clearEnters) {
                lxm.l = this.clearFromEnters(lxm.l);
            }
            this.handleLexEvent(lxm);
        }
    }

    protected void scanForTag() {
        this.pass();
        boolean open = true;
        if (this.t[this.uk] == '/') {
            open = false;
            ++this.uk;
        }
        if (this.t[this.uk] == '!' && this.uk < this.t.length - 2 && this.t[this.uk + 1] == '-' && this.t[this.uk + 2] == '-') {
            while (this.uk < this.t.length && (this.t[this.uk] != '>' || this.t[this.uk - 1] != '-' || this.t[this.uk - 2] != '-')) {
                ++this.uk;
            }
            ++this.uk;
            return;
        }
        String ident = this.scanForTagName().toLowerCase();
        int tagType = this.getTagKeywordType(ident);
        this.handleLexEvent(new TagLexEvent(ident, tagType, open));
        ++this.uk;
        this.pass();
        while (this.uk < this.t.length && this.t[this.uk] != '>') {
            this.scanForAttribute();
            this.pass();
        }
        if (this.t[this.uk] == '>') {
            ++this.uk;
        }
        this.handleLexEvent(new TagEndEvent(tagType, open));
    }

    protected void scanForAttribute() {
        if (!this.checkForIdentBeginning(this.t[this.uk])) {
            this.neutrilzeUpTo('>');
            return;
        }
        String str = "" + this.t[this.uk];
        ++this.uk;
        while (this.checkForTagNameSymbol(this.t[this.uk])) {
            str = String.valueOf(str) + this.t[this.uk++];
        }
        this.pass();
        if (this.t[this.uk] != '=') {
            this.neutrilzeUpTo('>');
            return;
        }
        ++this.uk;
        this.pass();
        String value = this.getDequotedValueString();
        this.handleLexEvent(new AttrValueLexEvent(value, this.getAttrKeywordType(str.toLowerCase())));
    }

    protected String scanForTagName() {
        if (!this.checkForIdentBeginning(this.t[this.uk])) {
            this.neutrilzeUpTo('>');
            return "";
        }
        String str = "" + this.t[this.uk];
        ++this.uk;
        while (this.checkForTagNameSymbol(this.t[this.uk])) {
            str = String.valueOf(str) + this.t[this.uk++];
        }
        --this.uk;
        return str;
    }

    /*
     * Unable to fully structure code
     */
    protected String getDequotedValueString() {
        block4: {
            quote = '\u0000';
            str = "";
            if (this.t[this.uk] == '\"' || this.t[this.uk] == '\'') {
                quote = this.t[this.uk];
                ++this.uk;
            }
            if (quote != '\u0000') ** GOTO lbl12
            while (this.uk < this.t.length && this.t[this.uk] != '>' && !Character.isWhitespace(this.t[this.uk])) {
                str = String.valueOf(str) + this.t[this.uk++];
            }
            break block4;
lbl-1000:
            // 1 sources

            {
                str = String.valueOf(str) + this.t[this.uk++];
lbl12:
                // 2 sources

                ** while (this.uk < this.t.length && this.t[this.uk] != quote)
            }
        }
        if (this.t[this.uk] == '\"' || this.t[this.uk] == '\'') {
            ++this.uk;
        }
        return str.trim();
    }

    protected void neutrilzeUpTo(char symbol) {
        while (this.uk < this.t.length && this.t[this.uk] != symbol) {
            if (symbol != '\"' && this.t[this.uk] == '\"' || symbol != '\'' && this.t[this.uk] == '\'') {
                this.passStr(this.t[this.uk]);
            }
            ++this.uk;
        }
    }

    protected void passStr(char c) {
        while (this.uk < this.t.length && this.t[this.uk] != c) {
            if (this.t[this.uk] == '\\' && this.t[this.uk + 1] == c) {
                ++this.uk;
            }
            ++this.uk;
        }
    }

    protected void neutrilzeUpTo(char[] symbols) {
        do {
            if (!this.isIn('\"', symbols) && this.t[this.uk] == '\"' || !this.isIn('\'', symbols) && this.t[this.uk] == '\'') {
                this.passStr(this.t[this.uk]);
            }
            if (this.isIn(this.t[this.uk], symbols)) {
                return;
            }
            ++this.uk;
        } while (this.uk < this.t.length);
    }

    boolean isIn(char symbol, char[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == symbol) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int getTagKeywordType(String keyword) {
        Integer num = this.tagKeywords.get(keyword);
        if (num == null) {
            return 101;
        }
        return num;
    }

    protected int getAttrKeywordType(String keyword) {
        Integer num = this.attrKeywords.get(keyword);
        if (num == null) {
            return 101;
        }
        return num;
    }

    protected void pass() {
        while (this.uk < this.t.length && (this.t[this.uk] == ' ' || this.t[this.uk] == '\n' || this.t[this.uk] == '\r' || this.t[this.uk] == '\t')) {
            ++this.uk;
        }
    }

    public void process(File input) {
        FileReader fr = null;
        long k = input.length();
        this.t = new char[(int)k];
        try {
            fr = new FileReader(input);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.log("Co\u00cd\u00e5 \u00ec\u00ee\u00e3\u00f3 \u00ee\u00f2\u00ea\u00f0\u00fb\u00f2\u00fc \u00f4\u00e0\u00e9\u00eb - " + input.getName() + "!");
            System.exit(-1);
        }
        try {
            this.process(fr, k);
        }
        catch (IOException iOException) {
            Logger.log("Error reading file - " + input.getName() + "!");
            return;
        }
    }

    public void process(Reader reader, long charCount) throws IOException {
        this.t = new char[(int)charCount];
        reader.read(this.t, 0, (int)charCount);
        this.scaner();
        this.handleLexEvent(new EOFEvent());
        this.textScanned = true;
    }

    protected void process(String fileName) throws IOException {
        File input = new File(fileName);
        this.process(input);
    }

    protected void handleLexEvent(LexEvent event) {
        for (ILexListener listener : this.listeners) {
            listener.handleLexEvent(event);
        }
    }

    protected String clearFromEnters(String l) {
        l = l.replace('\r', ' ');
        l = l.replace('\n', ' ');
        return l;
    }

    boolean isScanned() {
        return this.textScanned;
    }

    public boolean isClearEnters() {
        return this.clearEnters;
    }

    public void setClearEnters(boolean clearEnters) {
        this.clearEnters = clearEnters;
    }
}

