package de.ugoe.cs.swe.exercises.misc;

import java.util.Iterator;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;

import de.ugoe.cs.swe.exercises.misc.CKeyword;
import de.ugoe.cs.swe.exercises.misc.KeywordLabelProvider;

public class KeywordsCompositeExtender {
	Model selected = null;
	TableViewer viewerKeywords;
	Text textKeywords;
	int type;
	Composite parent;

	/**
	 * Create the composite.
	 * 
	 * @param parent
	 * @param style
	 */
	public KeywordsCompositeExtender(final Composite parent, final int type) {
		this.parent = parent;
		this.type = type;
		viewerKeywords = new TableViewer(parent, SWT.MULTI | SWT.V_SCROLL
				| SWT.BORDER);
		viewerKeywords
				.setContentProvider(new KeywordContentProvider(this.type));
		viewerKeywords.setLabelProvider(new KeywordLabelProvider());
		viewerKeywords.setInput(new Object());
		final Table tableKeywords = viewerKeywords.getTable();
		{
			GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true, 1,
					1);
			gridData.minimumHeight = 100;
			tableKeywords.setLayoutData(gridData);
		}
		tableKeywords.setHeaderVisible(true);
		TableColumn columnKeywords = new TableColumn(tableKeywords, SWT.LEFT, 0);
		columnKeywords.setText("Keywords");
		columnKeywords.setWidth(100);
		viewerKeywords.refresh();

		Button btnDeleteKeyword = new Button(parent, SWT.NONE);
		btnDeleteKeyword.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				StructuredSelection sel = ((StructuredSelection) viewerKeywords
						.getSelection());

				if (!(sel.isEmpty()) && sel instanceof IStructuredSelection) {

					MessageBox deleteMessageBox = new MessageBox(parent
							.getShell(), SWT.YES | SWT.NO);
					deleteMessageBox.setText("Delete");
					deleteMessageBox
							.setMessage("Do you really want to delete this Keyword(s)?");

					if (deleteMessageBox.open() == SWT.YES) {
						for (Iterator<?> iterator = sel.iterator(); iterator
								.hasNext();) {
							Object entry = iterator.next();

							if (entry instanceof CKeyword) {
								CKeyword keyword = (CKeyword) entry;
								int keyId = keyword.getKeyId();
								CKeyword.deleteKey(keyId, type);
							}
						}
					}
				}
				viewerKeywords.refresh();
			}
		});
		btnDeleteKeyword.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM,
				false, false, 1, 1));
		btnDeleteKeyword.setText("Delete keyword");

		textKeywords = new Text(parent, SWT.SINGLE | SWT.BORDER);
		textKeywords.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				false, 1, 1));
		textKeywords
				.setToolTipText("To add a Key, type it in this Box and press 'Return'");

		//
		// EVENT Listeners
		//

		textKeywords.addKeyListener(new KeyAdapter() {
			@Override
			public void keyReleased(KeyEvent key) {
				if (key.keyCode == SWT.LF || key.keyCode == SWT.CR) {
					addKeyword(textKeywords.getText());
				}
			}
		});

		Button btnAddKeyword = new Button(parent, SWT.NONE);
		btnAddKeyword.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				addKeyword(textKeywords.getText());
			}
		});
		btnAddKeyword.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		btnAddKeyword.setText("Add keyword");
	}

	public void load(Model model) {
		this.selected = model;
		viewerKeywords.setContentProvider(new KeywordContentProvider(this.type,
				model));
		viewerKeywords.refresh();
	}

	private void addKeyword(String keyword) {
		CKeyword.insertKey(new CKeyword(0, keyword, selected.getId()),
				this.type);
		textKeywords.setText("");
		textKeywords.setFocus();
		viewerKeywords.refresh();
	}
}
