package de.ugoe.cs.swe.exercises.lecturer;

import java.util.ArrayList;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;

public class ViewLecturer extends ViewPart {
	private Table lecturerTable;
	private Table lectureEventTable;
	private Text lastnameText;
	private Text firstnameText;
	private Text titelText;
	private Text searchText;
	
	private Lecturer selected;
	
	private static String editFirstName;
	private static String editLastName;
	private static String editTitle;
	
	private LecturerFilter filter;
	TableViewer viewerLecturer;

	public static String getEditFirstName() {
		return editFirstName;
	}

	public static String getEditLastName() {
		return editLastName;
	}

	public static String getEditTitle() {
		return editTitle;
	}

	public ViewLecturer() {
	}

	public void createPartControl(Composite parent) {
		
	
		
		parent.setLayout(new GridLayout(3, false));

		Label searchLabel = new Label(parent, SWT.NONE);
		searchLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false,
				false, 1, 1));
		searchLabel.setText("Search:");
		
		searchText = new Text(parent, SWT.BORDER);
		searchText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		searchText.addKeyListener(new KeyAdapter() {
			@Override
			public void keyReleased(KeyEvent ke) {
				filter.setSearchText(searchText.getText());
				viewerLecturer.refresh();
			}
		});
		
		new Label(parent, SWT.NONE); //fill label

		viewerLecturer = new TableViewer(parent, SWT.MULTI | SWT.H_SCROLL
				| SWT.V_SCROLL);
		viewerLecturer.setContentProvider(new LecturerContentProvider());
		viewerLecturer.setLabelProvider(new LecturerLabelProvider());
		viewerLecturer.setInput(new Object());
		lecturerTable = viewerLecturer.getTable();
		filter = new LecturerFilter();
		viewerLecturer.addFilter(filter);
		lecturerTable.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
			selected = (Lecturer)lecturerTable.getSelection()[0].getData();
			refreshData();
			}
		});
		GridData gridData = new GridData(SWT.FILL, SWT.FILL, false, true, 2, 1);
		gridData.minimumWidth = 400;
		gridData.widthHint = 400;
		lecturerTable.setLayoutData(gridData);
		lecturerTable.setHeaderVisible(true);
		lecturerTable.setLinesVisible(true);

		TableColumn titelColumn = new TableColumn(lecturerTable, SWT.NONE);
		titelColumn.setWidth(100);
		titelColumn.setText("Titel");

		TableColumn firstnameColumn = new TableColumn(lecturerTable, SWT.NONE);
		firstnameColumn.setWidth(150);
		firstnameColumn.setText("First name");

		TableColumn lastnameColumn = new TableColumn(lecturerTable, SWT.NONE);
		lastnameColumn.setWidth(150);
		lastnameColumn.setText("Last name");

		refreshLecturerTable();	
		
		if (lecturerTable.getItemCount() > 0) {
			lecturerTable.setSelection(0);
			selected = (Lecturer)lecturerTable.getItem(0).getData();
		}
		
		Group group = new Group(parent, SWT.NONE);
		group.setLayout(new GridLayout(3, false));
		group
				.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1,
						1));
		new Label(group, SWT.NONE);

		Label lastnameLabel = new Label(group, SWT.NONE);
		lastnameLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false,
				false, 1, 1));
		lastnameLabel.setText("last name");

		lastnameText = new Text(group, SWT.BORDER);
		lastnameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
			selected.setLastName(lastnameText.getText());
			}
		});

		GridData gridData2 = new GridData(SWT.FILL, SWT.CENTER, true, false, 1,
				1);
		gridData2.minimumWidth = 100;
		gridData2.widthHint = 100;
		lastnameText.setLayoutData(gridData2);

		new Label(group, SWT.NONE);

		Label firstnameLabel = new Label(group, SWT.NONE);
		firstnameLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false,
				false, 1, 1));
		firstnameLabel.setText("first name");

		firstnameText = new Text(group, SWT.BORDER);
		firstnameText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1,
				1));
		firstnameText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
			selected.setFirstName(firstnameText.getText());
			}
		});

		new Label(group, SWT.NONE);

		Label titelLabel = new Label(group, SWT.NONE);
		titelLabel.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false,
				false, 1, 1));
		titelLabel.setText("titel");

		titelText = new Text(group, SWT.BORDER);
		titelText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false,
				1, 1));
		titelText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
			selected.setTitle(titelText.getText());
			}
		});

		Menu tableMenu = new Menu(parent.getShell(), SWT.POP_UP);
		lecturerTable.setMenu(tableMenu);
		MenuItem add = new MenuItem(tableMenu,SWT.PUSH);
		add.setText("Add lecturer");
		add.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent event) {
				Lecturer lecturer = new Lecturer("first name", "last name", "title");
				lecturer.save();
				refreshLecturerTable();
				lecturerTable.setSelection(lecturerTable.getItemCount() - 1);
				selected = (Lecturer)lecturerTable.getSelection()[0].getData();
				refreshData();
				}
			});
			
		MenuItem delete = new MenuItem(tableMenu,SWT.PUSH);
		delete.setText("Delete lecturer");
		delete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent event) {
				selected.delete();
				refreshLecturerTable();
				lecturerTable.setSelection(0);
				selected = (Lecturer)lecturerTable.getSelection()[0].getData();
				refreshData();
				}
			});
		
		new Label(group, SWT.NONE);
		new Label(group, SWT.NONE);
		
		Button saveButton = new Button(group, SWT.NONE);
		saveButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				selected.save();
				refreshLecturerTable();
			}
		});
		saveButton.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		saveButton.setText("Save changes");

		lectureEventTable = new Table(group, SWT.BORDER | SWT.FULL_SELECTION);
		lectureEventTable.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
				true, 3, 1));
		lectureEventTable.setHeaderVisible(true);
		lectureEventTable.setLinesVisible(true);
		
		TableColumn tblclmnLecture = new TableColumn(lectureEventTable, SWT.NONE);
		tblclmnLecture.setWidth(200);
		tblclmnLecture.setText("Lecture");

		TableColumn lectureEventColumn = new TableColumn(lectureEventTable,
				SWT.NONE);
		lectureEventColumn.setWidth(100);
		lectureEventColumn.setText("Year");
		
		TableColumn tblclmnSemester = new TableColumn(lectureEventTable, SWT.NONE);
		tblclmnSemester.setWidth(100);
		tblclmnSemester.setText("Semester");

		refreshLectureEventTable();
		
		SashForm sashForm = new SashForm(parent, SWT.NONE);
		sashForm.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false,
				2, 1));

		Button deleteLecturerButton = new Button(sashForm, SWT.NONE);
		deleteLecturerButton.setText("Delete Lecturer");		
		deleteLecturerButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				selected.delete();
				refreshLecturerTable();
				lecturerTable.setSelection(0);
				selected = (Lecturer)lecturerTable.getSelection()[0].getData();
				refreshData();
			}
		});


		Button addLecturerButton = new Button(sashForm, SWT.NONE);
		addLecturerButton.setText("Add Lecturer");
		addLecturerButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Lecturer lecturer = new Lecturer("first name", "last name", "title");
				lecturer.save();
				refreshLecturerTable();
				lecturerTable.setSelection(lecturerTable.getItemCount() - 1);
				selected = (Lecturer)lecturerTable.getSelection()[0].getData();
				refreshData();
			}
		});
		sashForm.setWeights(new int[] { 1, 1 });
		new Label(parent, SWT.NONE); //empty label
		refreshData();
	}

	public void refreshLecturerTable() {
		viewerLecturer.refresh();
	}
	
	public void refreshLectureEventTable() {
		lectureEventTable.removeAll();
		if (selected == null)
			return;
		ArrayList<LectureEvent> lectureEventList = selected.getLecturerEvents();
		for(int i=0; i<lectureEventList.size(); i++) {
			TableItem item = new TableItem(lectureEventTable, SWT.NONE);
			item.setText(0, lectureEventList.get(i).getLecture().getName());
			item.setText(1, lectureEventList.get(i).getSemesterString());
			item.setText(2, ""+lectureEventList.get(i).getSemester());
			item.setData(lectureEventList.get(i));
		}
		lectureEventTable.redraw();
	}
	
	public void refreshData() {
		if (selected == null)
			return;
		lastnameText.setText(selected.getLastName());
		firstnameText.setText(selected.getFirstName());
		titelText.setText(selected.getTitle());
		refreshLectureEventTable();
	}
	
	@Override
	public void setFocus() {
	}
}
