package de.ugoe.cs.swe.exercises.lecturer;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LecturerAddDialog extends TitleAreaDialog {

	private Text addTitle;
	private Text addFirstName;
	private Text addLastName;
	private String[] lecturer = new String[4];
	private Shell shell;

	public String[] getLecturer() {
		return lecturer;
	}

	public LecturerAddDialog(Shell parentShell) {
		super(parentShell);
		super.setShellStyle(0);
		this.shell = parentShell;
		shell.setEnabled(false);
	}

	@Override
	protected Control createContents(Composite parent) {
		Control contents = super.createContents(parent);
		setTitle("Add a new lecturer");
		setMessage("Please input all the data for the new lecturer",
				IMessageProvider.INFORMATION);
		return contents;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		parent.getShell().setSize(500, 240);
		int x = shell.getLocation().x + (shell.getSize().x - parent.getShell().getSize().x)/2;
		int y = shell.getLocation().y + (shell.getSize().y - parent.getShell().getSize().y)/2;
		parent.getShell().setLocation(x, y);
		
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		parent.setLayout(layout);
		Label labelTitle = new Label(parent, SWT.NONE);
		labelTitle.setText("Title");
		Text textboxTitle = new Text(parent, SWT.BORDER);
		textboxTitle.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
		addTitle = textboxTitle;
		Label labelFirstName = new Label(parent, SWT.NONE);
		labelFirstName.setText("First name");
		Text textboxFirstName = new Text(parent, SWT.BORDER);
		textboxFirstName.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
		addFirstName = textboxFirstName;
		Label labelLastName = new Label(parent, SWT.NONE);
		labelLastName.setText("Last name");
		Text textboxLastName = new Text(parent, SWT.BORDER);
		textboxLastName.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
		addLastName = textboxLastName;

		GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
		gd.horizontalSpan = 1;

		return parent;

	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		((GridLayout) parent.getLayout()).numColumns = 2;

		GridData buttonlayout = new GridData(SWT.LEFT, SWT.BEGINNING, false,
				false);
		buttonlayout.minimumWidth = 200;
		Button buttonOk = new Button(parent, SWT.PUSH);
		buttonOk.setText("OK");
		buttonOk.setFont(JFaceResources.getDialogFont());
		buttonOk.setLayoutData(buttonlayout);
		buttonOk.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (addTitle.getText().length() != 0
						&& addFirstName.getText().length() != 0
						&& addLastName.getText().length() != 0) {
					lecturer[0] = "1";
					lecturer[1] = addTitle.getText();
					lecturer[2] = addFirstName.getText();
					lecturer[3] = addLastName.getText();
					shell.setEnabled(true);
					close();

				} else {
					setErrorMessage("Please fill out all the data");
				}
			}
		});
		Button buttonCancel = new Button(parent, SWT.PUSH);
		buttonCancel.setText("Cancel");
		buttonCancel.setFont(JFaceResources.getDialogFont());
		buttonCancel.setLayoutData(buttonlayout);
		buttonCancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.setEnabled(true);
				close();
			}
		});
	}
}