package de.ugoe.cs.swe.exercises.lecture;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LectureAddDialog extends TitleAreaDialog {

	private Text text1;
	private String lectureName;
	private Shell shell;

	public String getLecture() {
		return lectureName;
	}

	public LectureAddDialog(Shell parentShell) {
		super(parentShell);
		super.setShellStyle(0);
		this.shell = parentShell;
		shell.setEnabled(false);
	}

	@Override
	protected Control createContents(Composite parent) {
		Control contents = super.createContents(parent);
		setTitle("Add a new lecture");
		setMessage("Please input all the data for the new lecture",
				IMessageProvider.INFORMATION);
		return contents;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		parent.getShell().setSize(500, 170);
		int x = shell.getLocation().x + (shell.getSize().x - parent.getShell().getSize().x)/2;
		int y = shell.getLocation().y + (shell.getSize().y - parent.getShell().getSize().y)/2;
		parent.getShell().setLocation(x, y);
		
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		parent.setLayout(layout);
		Label label1 = new Label(parent, SWT.NONE);
		label1.setText("Lecture Name:");
		Text textbox1 = new Text(parent, SWT.BORDER);
		textbox1.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
		text1 = textbox1;

		GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
		gd.horizontalSpan = 1;

		return parent;

	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		((GridLayout) parent.getLayout()).numColumns = 2;

		GridData buttonlayout = new GridData(SWT.LEFT, SWT.BEGINNING, false,
				false);
		buttonlayout.minimumWidth = 200;
		Button button = new Button(parent, SWT.PUSH);
		button.setText("OK");
		button.setFont(JFaceResources.getDialogFont());
		button.setLayoutData(buttonlayout);
		button.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (text1.getText().length() != 0) {
					lectureName = text1.getText();
					shell.setEnabled(true);
					close();

				} else {
					setErrorMessage("Please fill out all the data");
				}
			}
		});
		Button cancel = new Button(parent, SWT.PUSH);
		cancel.setText("Cancel");
		cancel.setFont(JFaceResources.getDialogFont());
		cancel.setLayoutData(buttonlayout);
		cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.setEnabled(true);
				close();
			}
		});
	}
}