package de.ugoe.cs.swe.exercises.exercise;

import java.util.ArrayList;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.ugoe.cs.swe.exercises.misc.CKeyword;

class ExerciseKeywordContentProvider implements IStructuredContentProvider {

	private int exerciseId;

	public ExerciseKeywordContentProvider(int exerciseId) {
		this.exerciseId = exerciseId;
	}

	public ExerciseKeywordContentProvider() {
		this.exerciseId = -1;
	}

	public void inputChanged(Viewer v, Object oldInput, Object newInput) {
	}

	public void dispose() {
	}

	public Object[] getElements(Object parent) {
		if (this.exerciseId < 0)
			return new ArrayList<Exercise>().toArray();
		return CKeyword.getKeywordsForModel(this.exerciseId, CKeyword.EXERCISE)
				.toArray();
	}
}
