/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetEncoding;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUnpackedRecordFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBaseIndexDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.SqlJetSortingOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetBtreeIndexTable
extends SqlJetBtreeTable
implements ISqlJetBtreeIndexTable {
    private ISqlJetIndexDef indexDef;
    private List<String> columns;

    public SqlJetBtreeIndexTable(ISqlJetSchema schema, String indexName, boolean write) throws SqlJetException {
        super(((SqlJetSchema)schema).getDb(), ((SqlJetSchema)schema).getBtree(), ((SqlJetBaseIndexDef)schema.getIndex(indexName)).getPage(), write, true);
        this.indexDef = schema.getIndex(indexName);
        this.adjustKeyInfo();
    }

    public SqlJetBtreeIndexTable(ISqlJetSchema schema, String indexName, List<String> columns, boolean write) throws SqlJetException {
        super(((SqlJetSchema)schema).getDb(), ((SqlJetSchema)schema).getBtree(), ((SqlJetBaseIndexDef)schema.getIndex(indexName)).getPage(), write, true);
        this.indexDef = schema.getIndex(indexName);
        this.columns = columns;
        this.adjustKeyInfo();
    }

    public ISqlJetIndexDef getIndexDef() {
        return this.indexDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookup(boolean next, Object ... values) throws SqlJetException {
        this.lock();
        try {
            long l = this.lookupSafe(next, false, false, values);
            return l;
        }
        finally {
            this.unlock();
        }
    }

    private long lookupSafe(boolean next, boolean near, boolean last, Object ... values) throws SqlJetException {
        ISqlJetBtreeRecord key = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), values);
        ByteBuffer k = key.getRawRecord();
        if (next) {
            if (!last) {
                this.next();
            } else {
                this.previous();
            }
        } else {
            int moved = this.cursorMoveTo(k, last);
            if (moved != 0) {
                if (!last) {
                    if (moved < 0) {
                        this.next();
                    }
                } else if (moved > 0) {
                    this.previous();
                }
            }
        }
        ISqlJetBtreeRecord record = this.getRecord();
        if (null == record) {
            return 0L;
        }
        if (!near && this.keyCompare(k, record.getRawRecord()) != 0) {
            return 0L;
        }
        return this.getKeyRowId(record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int cursorMoveTo(ByteBuffer pKey, boolean last) throws SqlJetException {
        SqlJetUnpackedRecord pIdxKey;
        this.clearRecordCache();
        int nKey = pKey.remaining();
        if (!last) {
            return this.cursor.moveTo(pKey, nKey, false);
        }
        if (pKey != null) {
            assert ((long)nKey == (long)nKey);
            pIdxKey = this.keyInfo.recordUnpack(nKey, pKey);
            pIdxKey.getFlags().add(SqlJetUnpackedRecordFlags.INCRKEY);
            if (pIdxKey == null) {
                throw new SqlJetException(SqlJetErrorCode.NOMEM);
            }
        } else {
            pIdxKey = null;
        }
        try {
            int n = this.cursor.moveToUnpacked(pIdxKey, nKey, false);
            return n;
        }
        finally {
            if (pKey != null) {
                SqlJetUnpackedRecord.delete(pIdxKey);
            }
        }
    }

    private int keyCompare(ByteBuffer key, ByteBuffer record) throws SqlJetException {
        SqlJetUnpackedRecord unpacked = this.keyInfo.recordUnpack(key.remaining(), key);
        Set<SqlJetUnpackedRecordFlags> flags = unpacked.getFlags();
        flags.add(SqlJetUnpackedRecordFlags.IGNORE_ROWID);
        flags.add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        return unpacked.recordCompare(record.remaining(), record);
    }

    @Override
    public int compareKeys(Object[] firstKey, Object[] lastKey) throws SqlJetException {
        SqlJetEncoding encoding = this.db.getOptions().getEncoding();
        ByteBuffer firstRec = SqlJetBtreeRecord.getRecord(encoding, firstKey).getRawRecord();
        ByteBuffer lastRec = SqlJetBtreeRecord.getRecord(encoding, lastKey).getRawRecord();
        SqlJetUnpackedRecord unpacked = this.keyInfo.recordUnpack(firstRec.remaining(), firstRec);
        unpacked.getFlags().add(SqlJetUnpackedRecordFlags.PREFIX_MATCH);
        return unpacked.recordCompare(lastRec.remaining(), lastRec);
    }

    @Override
    public boolean checkKey(Object ... key) throws SqlJetException {
        if (this.eof()) {
            return false;
        }
        ByteBuffer keyRecord = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), key).getRawRecord();
        return 0 == this.keyCompare(keyRecord, this.getRecord().getRawRecord());
    }

    private void adjustKeyInfo() throws SqlJetException {
        if (null == this.keyInfo) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
        if (null != this.columns) {
            this.keyInfo.setNField(this.columns.size());
        } else if (null != this.indexDef.getColumns()) {
            this.keyInfo.setNField(this.indexDef.getColumns().size());
            int i = 0;
            for (ISqlJetIndexedColumn column : this.indexDef.getColumns()) {
                this.keyInfo.setSortOrder(i++, column.getSortingOrder() == SqlJetSortingOrder.DESC);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insert(long rowId, boolean append, Object ... key) throws SqlJetException {
        this.lock();
        try {
            ByteBuffer zKey = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), SqlJetUtility.addArrays(key, new Object[]{rowId})).getRawRecord();
            this.cursor.insert(zKey, zKey.remaining(), ByteBuffer.allocate(0), 0, 0, append);
            this.clearRecordCache();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delete(long rowId, Object ... key) throws SqlJetException {
        this.lock();
        try {
            ISqlJetBtreeRecord rec = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), key);
            ByteBuffer k = rec.getRawRecord();
            if (this.cursorMoveTo(k, false) < 0) {
                this.next();
            }
            do {
                ISqlJetBtreeRecord record;
                if (null == (record = this.getRecord())) {
                    boolean bl = false;
                    return bl;
                }
                if (this.keyCompare(k, record.getRawRecord()) != 0) {
                    boolean bl = false;
                    return bl;
                }
                if (this.getKeyRowId(record) != rowId) continue;
                this.cursor.delete();
                this.clearRecordCache();
                if (this.cursorMoveTo(k, false) < 0) {
                    this.next();
                }
                boolean bl = true;
                return bl;
            } while (this.next());
            boolean bl = false;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    private long getKeyRowId(ISqlJetBtreeRecord record) {
        if (null == record) {
            return 0L;
        }
        List<ISqlJetVdbeMem> fields = record.getFields();
        if (null == fields || 0 == fields.size()) {
            return 0L;
        }
        return fields.get(fields.size() - 1).intValue();
    }

    @Override
    public long getKeyRowId() throws SqlJetException {
        return this.getKeyRowId(this.getRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reindex(ISqlJetSchema schema) throws SqlJetException {
        this.lock();
        try {
            this.btree.clearTable(this.rootPage, null);
            SqlJetBtreeDataTable dataTable = new SqlJetBtreeDataTable(schema, this.indexDef.getTableName(), false);
            try {
                dataTable.first();
                while (!dataTable.eof()) {
                    Object[] key = dataTable.getKeyForIndex(dataTable.getAsNamedFields(dataTable.getValues()), this.indexDef);
                    this.insert(dataTable.getRowId(), true, key);
                    dataTable.next();
                }
            }
            finally {
                dataTable.close();
            }
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public int compareKey(Object[] key) throws SqlJetException {
        if (this.eof()) {
            return 1;
        }
        ByteBuffer keyRecord = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), key).getRawRecord();
        return this.keyCompare(keyRecord, this.getRecord().getRawRecord());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookupNear(boolean next, Object[] key) throws SqlJetException {
        this.lock();
        try {
            long l = this.lookupSafe(next, true, false, key);
            return l;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long lookupLastNear(Object[] key) throws SqlJetException {
        this.lock();
        try {
            long l = this.lookupSafe(false, true, true, key);
            return l;
        }
        finally {
            this.unlock();
        }
    }
}

