/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.table;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetVdbeMem;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableDef;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeDataTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.ISqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeIndexTable;
import org.tmatesoft.sqljet.core.internal.table.SqlJetBtreeTable;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetBtreeRecord;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDefault;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetIndexedColumn;
import org.tmatesoft.sqljet.core.schema.ISqlJetSchema;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetBtreeDataTable
extends SqlJetBtreeTable
implements ISqlJetBtreeDataTable {
    private static final String[] rowIdNames = new String[]{"ROWID", "_ROWID_", "OID"};
    private SqlJetSchema schema;
    private SqlJetTableDef tableDef;
    private Map<String, ISqlJetIndexDef> indexesDefs;
    private Map<String, ISqlJetBtreeIndexTable> indexesTables;
    private ISqlJetBtreeDataTable sequenceTable;
    private ISqlJetBtreeRecord defaults;

    public SqlJetBtreeDataTable(ISqlJetSchema schema, String tableName, boolean write) throws SqlJetException {
        super(((SqlJetSchema)schema).getDb(), ((SqlJetSchema)schema).getBtree(), ((SqlJetTableDef)schema.getTable(tableName)).getPage(), write, false);
        this.schema = (SqlJetSchema)schema;
        this.tableDef = (SqlJetTableDef)schema.getTable(tableName);
        this.defaults = SqlJetBtreeRecord.getRecord(this.getEncoding(), this.getDefaults());
        this.openIndexes(schema);
    }

    @Override
    public void close() throws SqlJetException {
        if (this.indexesTables != null) {
            for (String key : this.indexesTables.keySet()) {
                ISqlJetBtreeIndexTable table = this.indexesTables.get(key);
                table.close();
            }
        }
        if (null != this.sequenceTable) {
            this.sequenceTable.close();
        }
        super.close();
    }

    private void openIndexes(ISqlJetSchema schema) throws SqlJetException {
        this.indexesDefs = new HashMap<String, ISqlJetIndexDef>();
        this.indexesTables = new HashMap<String, ISqlJetBtreeIndexTable>();
        for (ISqlJetIndexDef indexDef : schema.getIndexes(this.tableDef.getName())) {
            SqlJetBtreeIndexTable indexTable;
            this.indexesDefs.put(indexDef.getName(), indexDef);
            if (indexDef.getColumns().size() > 0) {
                indexTable = new SqlJetBtreeIndexTable(schema, indexDef.getName(), this.write);
            } else {
                ArrayList<String> columns;
                if (this.tableDef.getTableIndexConstraint(indexDef.getName()) != null) {
                    columns = this.tableDef.getTableIndexConstraint(indexDef.getName()).getColumns();
                } else {
                    columns = new ArrayList<String>();
                    columns.add(this.tableDef.getColumnIndexConstraint(indexDef.getName()).getColumn().getName());
                }
                indexTable = new SqlJetBtreeIndexTable(schema, indexDef.getName(), columns, this.write);
            }
            this.indexesTables.put(indexDef.getName(), indexTable);
        }
    }

    @Override
    public ISqlJetTableDef getDefinition() {
        return this.tableDef;
    }

    @Override
    public Map<String, ISqlJetIndexDef> getIndexDefinitions() {
        return Collections.unmodifiableMap(this.indexesDefs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean goToRow(long rowId) throws SqlJetException {
        this.lock();
        try {
            this.clearRecordCache();
            if (this.getRowId() == rowId) {
                boolean bl = true;
                return bl;
            }
            int moveTo = this.cursor.moveTo(null, rowId, false);
            if (moveTo < 0) {
                this.next();
            }
            boolean bl = this.getRowId() == rowId;
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getRowId() throws SqlJetException {
        this.lock();
        try {
            long l = this.cursor.getKeySize();
            return l;
        }
        finally {
            this.unlock();
        }
    }

    @Override
    public long insert(Object ... values) throws SqlJetException {
        return this.insertWithRowId(0L, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertWithRowId(long rowId, Object[] values) throws SqlJetException {
        this.lock();
        try {
            Object[] row = this.getValuesRow(values);
            if (rowId < 1L) {
                rowId = this.getRowIdForRow(row, true);
            }
            this.doInsert(rowId, row);
            long l = rowId;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    private Object[] getValuesRow(Object ... values) throws SqlJetException {
        Object[] row = new Object[this.tableDef.getColumns().size()];
        if (null != values && values.length != 0) {
            if (values.length > row.length) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Values count is more than columns in table");
            }
            Object[] a = SqlJetUtility.adjustNumberTypes(values);
            System.arraycopy(a, 0, row, 0, a.length);
        }
        return row;
    }

    private Object[] getDefaults() throws SqlJetException {
        Object[] row = new Object[this.tableDef.getColumns().size()];
        if (this.db.getOptions().getFileFormat() > 2) {
            for (int i = 0; i < this.tableDef.getColumns().size(); ++i) {
                ISqlJetColumnDef column = this.tableDef.getColumns().get(i);
                for (ISqlJetColumnConstraint constraint : column.getConstraints()) {
                    if (!(constraint instanceof ISqlJetColumnDefault)) continue;
                    ISqlJetColumnDefault d = (ISqlJetColumnDefault)constraint;
                    row[i] = d.getExpression().toString();
                }
            }
        }
        return row;
    }

    private long getRowIdForRow(Object[] row, boolean required) throws SqlJetException {
        if (this.tableDef.isRowIdPrimaryKey()) {
            int primaryKeyColumnNumber = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (primaryKeyColumnNumber == -1 || primaryKeyColumnNumber >= row.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            Object rowIdParam = row[primaryKeyColumnNumber];
            if (null != rowIdParam) {
                if (rowIdParam instanceof Long) {
                    long rowId = (Long)rowIdParam;
                    if (rowId > 0L) {
                        return rowId;
                    }
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "INTEGER PRIMARY KEY column must be more than zero");
                }
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "INTEGER PRIMARY KEY column must have only integer value");
            }
        }
        if (required) {
            return this.newRowId();
        }
        return 0L;
    }

    @Override
    public long newRowId() throws SqlJetException {
        if (!this.tableDef.isAutoincremented()) {
            return super.newRowId();
        }
        if (null == this.sequenceTable) {
            this.sequenceTable = this.schema.openSequenceTable();
            if (null == this.sequenceTable) {
                return super.newRowId();
            }
            return this.locateSequence();
        }
        String s = this.sequenceTable.getString(0);
        if (null == s || !this.tableDef.getName().equalsIgnoreCase(s)) {
            return this.locateSequence();
        }
        return this.updateSequence();
    }

    private long locateSequence() throws SqlJetException {
        this.sequenceTable.first();
        while (!this.sequenceTable.eof()) {
            String s = this.sequenceTable.getString(0);
            if (null != s && this.tableDef.getName().equalsIgnoreCase(s)) {
                return this.updateSequence();
            }
            this.sequenceTable.next();
        }
        long newRowId = super.newRowId();
        this.sequenceTable.insert(this.tableDef.getName(), newRowId);
        return newRowId;
    }

    private long updateSequence() throws SqlJetException {
        long lastRowId = this.sequenceTable.getInteger(1);
        long newRowId = this.newRowId(lastRowId);
        this.sequenceTable.updateCurrent(this.tableDef.getName(), newRowId);
        return newRowId;
    }

    private void doInsert(long rowId, Object[] row) throws SqlJetException {
        ByteBuffer pData;
        if (!this.tableDef.isRowIdPrimaryKey()) {
            pData = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), row).getRawRecord();
        } else {
            int primaryKeyColumnNumber = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (primaryKeyColumnNumber == -1 || primaryKeyColumnNumber >= row.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            row[primaryKeyColumnNumber] = null;
            pData = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), row).getRawRecord();
            row[primaryKeyColumnNumber] = rowId;
        }
        this.doActionWithIndexes(Action.INSERT, rowId, row);
        this.cursor.insert(null, rowId, pData, pData.remaining(), 0, true);
        this.goToRow(rowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(long rowId, Object ... values) throws SqlJetException {
        this.lock();
        try {
            if (rowId <= 0L || !this.goToRow(rowId)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + rowId);
            }
            Object[] row = this.getValuesRow(values);
            if (rowId < 1L) {
                rowId = this.getRowIdForRow(row, false);
            }
            this.doUpdate(rowId, row);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrent(Object ... values) throws SqlJetException {
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            Object[] row = this.getValuesRow(values);
            long rowId = this.getRowIdForRow(row, false);
            this.doUpdate(rowId, row);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateWithRowId(long rowId, long newRowId, Object ... values) throws SqlJetException {
        this.lock();
        try {
            if (rowId <= 0L || !this.goToRow(rowId)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + rowId);
            }
            Object[] row = this.getValuesRow(values);
            if (newRowId < 1L) {
                newRowId = this.getRowIdForRow(row, false);
            }
            this.doUpdate(newRowId > 0L ? newRowId : rowId, row);
            long l = newRowId;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateCurrentWithRowId(long newRowId, Object ... values) throws SqlJetException {
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            Object[] row = this.getValuesRow(values);
            if (newRowId < 1L) {
                newRowId = this.getRowIdForRow(row, false);
            }
            this.doUpdate(newRowId, this.getValuesRow(values));
            long l = newRowId;
            return l;
        }
        finally {
            this.unlock();
        }
    }

    private void doUpdate(long rowId, Object[] row) throws SqlJetException {
        boolean changeRowId;
        ByteBuffer pData;
        long newRowId;
        long currentRowId = this.getRowId();
        Object[] currentRow = this.getValues();
        long l = newRowId = 0L < rowId ? rowId : currentRowId;
        if (newRowId == currentRowId && Arrays.equals(row, currentRow)) {
            return;
        }
        if (!this.tableDef.isRowIdPrimaryKey()) {
            pData = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), row).getRawRecord();
        } else {
            int primaryKeyColumnNumber = this.tableDef.getColumnNumber(this.tableDef.getRowIdPrimaryKeyColumnName());
            if (primaryKeyColumnNumber == -1 || primaryKeyColumnNumber >= row.length) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            row[primaryKeyColumnNumber] = null;
            pData = SqlJetBtreeRecord.getRecord(this.db.getOptions().getEncoding(), row).getRawRecord();
            row[primaryKeyColumnNumber] = newRowId;
        }
        this.doActionWithIndexes(Action.UPDATE, newRowId, row);
        boolean bl = changeRowId = newRowId != currentRowId;
        if (changeRowId) {
            this.cursor.delete();
        }
        this.cursor.insert(null, newRowId, pData, pData.remaining(), 0, changeRowId);
        this.goToRow(newRowId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(long rowId) throws SqlJetException {
        this.lock();
        try {
            if (rowId <= 0L || !this.goToRow(rowId)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Incorrect rowId value: " + rowId);
            }
            this.doDelete();
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() throws SqlJetException {
        this.lock();
        try {
            if (this.eof()) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "No current record");
            }
            this.doDelete();
        }
        finally {
            this.unlock();
        }
    }

    private void doDelete() throws SqlJetException {
        this.doActionWithIndexes(Action.DELETE, 0L, new Object[0]);
        long rowId = this.getRowId();
        this.cursor.delete();
        this.goToRow(rowId);
    }

    private boolean isRowIdExists(long rowId) throws SqlJetException {
        long current = this.getRowId();
        if (rowId == current) {
            return true;
        }
        boolean exists = this.goToRow(rowId);
        if (current > 0L) {
            this.goToRow(current);
        } else {
            this.first();
        }
        return exists;
    }

    private void doActionWithIndexes(Action action, long rowId, Object ... row) throws SqlJetException {
        boolean existsRowId = false;
        long currentRowId = 0L;
        Object[] currentRow = null;
        if (Action.INSERT != action) {
            currentRowId = this.getRowId();
            currentRow = this.getValues();
        }
        if (Action.INSERT == action) {
            existsRowId = this.isRowIdExists(rowId);
        } else if (Action.UPDATE == action && currentRowId != rowId) {
            existsRowId = this.isRowIdExists(rowId);
        }
        if (existsRowId) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Record with given ROWID already exists");
        }
        Map<String, Object> fields = Action.DELETE != action ? this.getAsNamedFields(row) : null;
        class IndexKeys {
            ISqlJetBtreeIndexTable indexTable;
            Object[] currentKey;
            Object[] key;

            public IndexKeys(ISqlJetBtreeIndexTable indexTable, Object[] currentKey, Object[] key) {
                this.indexTable = indexTable;
                this.currentKey = currentKey;
                this.key = key;
            }
        }
        ArrayList<IndexKeys> indexKeys = new ArrayList<IndexKeys>(this.indexesDefs.size());
        for (ISqlJetIndexDef indexDef : this.indexesDefs.values()) {
            long lookup;
            Object[] key;
            Object[] currentKey = Action.INSERT == action ? null : this.getKeyForIndex(this.getAsNamedFields(currentRow), indexDef);
            Object[] objectArray = key = Action.DELETE == action ? null : this.getKeyForIndex(fields, indexDef);
            if (Action.UPDATE == action && currentRowId == rowId && Arrays.deepEquals(currentKey, key)) continue;
            ISqlJetBtreeIndexTable indexTable = this.indexesTables.get(indexDef.getName());
            indexKeys.add(new IndexKeys(indexTable, currentKey, key));
            if (this.hasNull(row) || Action.DELETE == action || !indexDef.isUnique() && this.tableDef.getColumnIndexConstraint(indexDef.getName()) == null && this.tableDef.getTableIndexConstraint(indexDef.getName()) == null || (lookup = indexTable.lookup(false, key)) == 0L) continue;
            if (Action.INSERT == action) {
                throw new SqlJetException(SqlJetErrorCode.CONSTRAINT, "Insert fails: unique index " + indexDef.getName());
            }
            if (Action.UPDATE != action || lookup == currentRowId) continue;
            throw new SqlJetException(SqlJetErrorCode.CONSTRAINT, "Update fails: unique index " + indexDef.getName());
        }
        for (IndexKeys i : indexKeys) {
            if (Action.INSERT != action) {
                i.indexTable.delete(currentRowId, i.currentKey);
            }
            if (Action.DELETE == action) continue;
            i.indexTable.insert(rowId, true, i.key);
        }
    }

    private boolean hasNull(Object[] row) {
        if (row != null && row.length > 0) {
            for (Object value : row) {
                if (null != value) continue;
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAsNamedFields(Object ... values) throws SqlJetException {
        if (values == null) {
            return null;
        }
        int fieldsSize = values.length;
        List<ISqlJetColumnDef> columns = this.tableDef.getColumns();
        int columnsSize = columns.size();
        if (fieldsSize > columnsSize) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Data values count is more than columns in table");
        }
        HashMap<String, Object> namedFields = new HashMap<String, Object>();
        int i = 0;
        for (ISqlJetColumnDef column : columns) {
            if (null != column.getConstraints()) {
                for (ISqlJetColumnConstraint constraint : column.getConstraints()) {
                    if (!(constraint instanceof ISqlJetColumnNotNull) || i < fieldsSize && null != values[i]) continue;
                    throw new SqlJetException(SqlJetErrorCode.MISUSE, "Column " + column.getName() + " is NOT NULL");
                }
            }
            namedFields.put(column.getName(), i < fieldsSize ? values[i] : null);
            ++i;
        }
        return namedFields;
    }

    public Object[] getKeyForIndex(Map<String, Object> fields, ISqlJetIndexDef indexDef) {
        if (null == fields) {
            return null;
        }
        if (this.tableDef.getColumnIndexConstraint(indexDef.getName()) != null) {
            String column = this.tableDef.getColumnIndexConstraint(indexDef.getName()).getColumn().getName();
            return new Object[]{fields.get(column)};
        }
        if (this.tableDef.getTableIndexConstraint(indexDef.getName()) != null) {
            List<String> columns = this.tableDef.getTableIndexConstraint(indexDef.getName()).getColumns();
            int columnsCount = columns.size();
            Object[] key = new Object[columnsCount];
            int i = 0;
            for (String column : columns) {
                key[i++] = fields.get(column);
            }
            return key;
        }
        List<ISqlJetIndexedColumn> indexedColumns = indexDef.getColumns();
        int columnsCount = indexedColumns.size();
        Object[] key = new Object[columnsCount];
        int i = 0;
        for (ISqlJetIndexedColumn column : indexedColumns) {
            key[i++] = fields.get(column.getName());
        }
        return key;
    }

    @Override
    public boolean checkIndex(String indexName, Object[] key) throws SqlJetException {
        if (!this.isIndexExists(indexName)) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE);
        }
        if (null != indexName) {
            return Arrays.equals(key, this.getKeyForIndex(this.getAsNamedFields(this.getValues()), this.indexesDefs.get(indexName)));
        }
        return this.getRowId() == this.getKeyForRowId(key).longValue();
    }

    private Long getKeyForRowId(Object[] key) throws SqlJetException {
        Object[] k;
        if (!this.tableDef.isRowIdPrimaryKey()) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not defined");
        }
        if (key.length == 1 && (k = SqlJetUtility.adjustNumberTypes(key))[0] instanceof Long) {
            return (Long)k[0];
        }
        throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad key");
    }

    @Override
    public String getPrimaryKeyIndex() {
        return this.tableDef.isRowIdPrimaryKey() ? null : this.tableDef.getPrimaryKeyIndexName();
    }

    @Override
    public boolean locate(String indexName, boolean next, Object ... key) throws SqlJetException {
        if (null == key) {
            throw new SqlJetException(SqlJetErrorCode.MISUSE, "Bad key");
        }
        if (null != indexName) {
            if (!this.indexesDefs.containsKey(indexName)) {
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "Index not found: " + indexName);
            }
            ISqlJetBtreeIndexTable indexTable = this.indexesTables.get(indexName);
            long lookup = indexTable.lookup(next, key);
            return lookup != 0L && this.goToRow(lookup);
        }
        if (next) {
            return this.next();
        }
        return this.goToRow(this.getKeyForRowId(key));
    }

    @Override
    public Map<String, ISqlJetBtreeIndexTable> getIndexesTables() {
        return Collections.unmodifiableMap(this.indexesTables);
    }

    @Override
    public long insert(Map<String, Object> values) throws SqlJetException {
        return this.insertWithRowId(SqlJetBtreeDataTable.getRowIdFromValues(values), this.unwrapValues(values));
    }

    @Override
    public void update(long rowId, Map<String, Object> values) throws SqlJetException {
        this.updateWithRowId(rowId, SqlJetBtreeDataTable.getRowIdFromValues(values), this.unwrapValues(values));
    }

    @Override
    public void update(Map<String, Object> values) throws SqlJetException {
        this.updateWithRowId(this.getRowId(), SqlJetBtreeDataTable.getRowIdFromValues(values), this.unwrapValues(values));
    }

    private Object[] unwrapValues(Map<String, Object> values) throws SqlJetException {
        int i = 0;
        Object[] unwrapped = new Object[this.tableDef.getColumns().size()];
        if (null != values) {
            for (ISqlJetColumnDef column : this.tableDef.getColumns()) {
                String columnName = column.getName();
                if (values.containsKey(columnName)) {
                    unwrapped[i] = values.get(columnName);
                }
                ++i;
            }
        }
        return unwrapped;
    }

    @Override
    public long getInteger(int field) throws SqlJetException {
        if (field == this.tableDef.getRowIdPrimaryKeyColumnIndex()) {
            return this.getRowId();
        }
        return super.getInteger(field);
    }

    @Override
    public Object getValue(int field) throws SqlJetException {
        if (field == this.tableDef.getRowIdPrimaryKeyColumnIndex()) {
            return this.getRowId();
        }
        return super.getValue(field);
    }

    @Override
    public boolean isIndexExists(String indexName) {
        return null == indexName || this.getIndexDefinitions().containsKey(indexName);
    }

    public static boolean isFieldNameRowId(String fieldName) {
        if (null == fieldName) {
            return false;
        }
        for (int i = 0; i < rowIdNames.length; ++i) {
            if (!rowIdNames[i].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static long getRowIdFromValues(Map<String, Object> values) throws SqlJetException {
        if (null == values) {
            return 0L;
        }
        for (Map.Entry<String, Object> entry : values.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            for (int i = 0; i < rowIdNames.length; ++i) {
                if (!rowIdNames[i].equalsIgnoreCase(name) || null == value) continue;
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new SqlJetException(SqlJetErrorCode.MISUSE, "ROWID must be integer value");
            }
        }
        return 0L;
    }

    @Override
    public void clear() throws SqlJetException {
        for (ISqlJetBtreeIndexTable index : this.indexesTables.values()) {
            index.clear();
        }
        super.clear();
    }

    @Override
    protected ISqlJetVdbeMem getValueMem(int field) throws SqlJetException {
        ISqlJetVdbeMem valueMem = super.getValueMem(field);
        if (field < this.defaults.getFieldsCount() && (valueMem == null || valueMem.isNull())) {
            return this.defaults.getFields().get(field);
        }
        return valueMem;
    }

    @Override
    public ISqlJetBtreeIndexTable getIndex(String indexName) {
        return this.indexesTables.get(indexName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        INSERT,
        UPDATE,
        DELETE;

    }
}

