/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import java.nio.ByteBuffer;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetBtreeCursor;
import org.tmatesoft.sqljet.core.internal.ISqlJetDbHandle;
import org.tmatesoft.sqljet.core.internal.ISqlJetKeyInfo;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetUnpackedRecord;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetMemPage;
import org.tmatesoft.sqljet.core.internal.vdbe.SqlJetUnpackedRecord;

public class SqlJetBtreeCursor
extends SqlJetCloneable
implements ISqlJetBtreeCursor {
    private static final int NN = 1;
    private static final int NB = 3;
    SqlJetBtree pBtree;
    SqlJetBtreeShared pBt;
    SqlJetBtreeCursor pNext;
    SqlJetBtreeCursor pPrev;
    ISqlJetKeyInfo pKeyInfo;
    int pgnoRoot;
    SqlJetBtreeCellInfo info = new SqlJetBtreeCellInfo();
    boolean wrFlag;
    boolean atLast;
    boolean validNKey;
    CursorState eState;
    ByteBuffer pKey;
    long nKey;
    SqlJetErrorCode error;
    int skip;
    boolean isIncrblobHandle;
    int[] aOverflow;
    boolean pagesShuffled;
    int iPage;
    SqlJetMemPage[] apPage = new SqlJetMemPage[20];
    int[] aiIdx = new int[20];

    public SqlJetBtreeCursor(SqlJetBtree btree, int table, boolean wrFlag, ISqlJetKeyInfo keyInfo) throws SqlJetException {
        SqlJetBtreeShared pBt = btree.pBt;
        assert (btree.holdsMutex());
        if (wrFlag) {
            assert (!pBt.readOnly);
            if (pBt.readOnly) {
                throw new SqlJetException(SqlJetErrorCode.READONLY);
            }
            if (btree.checkReadLocks(table, null, 0L)) {
                throw new SqlJetException(SqlJetErrorCode.LOCKED);
            }
        }
        if (pBt.pPage1 == null) {
            btree.lockWithRetry();
        }
        this.pgnoRoot = table;
        int nPage = pBt.pPager.getPageCount();
        try {
            if (table == 1 && nPage == 0) {
                throw new SqlJetException(SqlJetErrorCode.EMPTY);
            }
            this.apPage[0] = pBt.getAndInitPage(this.pgnoRoot);
            this.pKeyInfo = keyInfo;
            this.pBtree = btree;
            this.pBt = pBt;
            this.wrFlag = wrFlag;
            this.pNext = pBt.pCursor;
            if (this.pNext != null) {
                this.pNext.pPrev = this;
            }
            pBt.pCursor = this;
            this.eState = CursorState.INVALID;
        }
        catch (SqlJetException e) {
            SqlJetMemPage.releasePage(this.apPage[0]);
            pBt.unlockBtreeIfUnused();
            throw e;
        }
    }

    private boolean holdsMutex() {
        return this.pBt.mutex.held();
    }

    private boolean cursorHoldsMutex(SqlJetBtreeCursor cur) {
        return cur.holdsMutex();
    }

    public void clearCursor() {
        assert (this.holdsMutex());
        this.pKey = null;
        this.eState = CursorState.INVALID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursor() throws SqlJetException {
        if (this.pBtree != null) {
            this.pBtree.enter();
            try {
                this.pBt.db = this.pBtree.db;
                this.clearCursor();
                if (this.pPrev != null) {
                    this.pPrev.pNext = this.pNext;
                } else {
                    this.pBt.pCursor = this.pNext;
                }
                if (this.pNext != null) {
                    this.pNext.pPrev = this.pPrev;
                }
                for (int i = 0; i <= this.iPage; ++i) {
                    SqlJetMemPage.releasePage(this.apPage[i]);
                }
                this.pBt.unlockBtreeIfUnused();
                this.invalidateOverflowCache();
            }
            finally {
                this.pBtree.leave();
            }
        }
    }

    private void invalidateOverflowCache() {
        assert (this.holdsMutex());
        this.aOverflow = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveTo(ByteBuffer pKey, long nKey, boolean bias) throws SqlJetException {
        SqlJetUnpackedRecord pIdxKey;
        if (pKey != null) {
            assert (nKey == (long)((int)nKey));
            pIdxKey = this.pKeyInfo.recordUnpack((int)nKey, pKey);
            if (pIdxKey == null) {
                throw new SqlJetException(SqlJetErrorCode.NOMEM);
            }
        } else {
            pIdxKey = null;
        }
        try {
            int n = this.moveToUnpacked(pIdxKey, nKey, bias);
            return n;
        }
        finally {
            if (pKey != null) {
                SqlJetUnpackedRecord.delete(pIdxKey);
            }
        }
    }

    private void moveToRoot() throws SqlJetException {
        assert (this.holdsMutex());
        assert (CursorState.INVALID.compareTo(CursorState.REQUIRESEEK) < 0);
        assert (CursorState.VALID.compareTo(CursorState.REQUIRESEEK) < 0);
        assert (CursorState.FAULT.compareTo(CursorState.REQUIRESEEK) > 0);
        if (this.eState.compareTo(CursorState.REQUIRESEEK) >= 0) {
            if (this.eState == CursorState.FAULT) {
                throw new SqlJetException(this.error);
            }
            this.clearCursor();
        }
        if (this.iPage >= 0) {
            for (int i = 1; i <= this.iPage; ++i) {
                SqlJetMemPage.releasePage(this.apPage[i]);
            }
        } else {
            try {
                this.apPage[0] = this.pBt.getAndInitPage(this.pgnoRoot);
            }
            catch (SqlJetException e) {
                this.eState = CursorState.INVALID;
                throw e;
            }
        }
        SqlJetMemPage pRoot = this.apPage[0];
        assert (pRoot.pgno == this.pgnoRoot);
        this.iPage = 0;
        this.aiIdx[0] = 0;
        this.info.nSize = 0;
        this.atLast = false;
        this.validNKey = false;
        if (pRoot.nCell == 0 && !pRoot.leaf) {
            assert (pRoot.pgno == 1);
            int subpage = SqlJetUtility.get4byte(pRoot.aData, pRoot.hdrOffset + 8);
            assert (subpage > 0);
            this.eState = CursorState.VALID;
            this.moveToChild(subpage);
        } else {
            this.eState = pRoot.nCell > 0 ? CursorState.VALID : CursorState.INVALID;
        }
    }

    private void moveToChild(int newPgno) throws SqlJetException {
        SqlJetMemPage pNewPage;
        int i = this.iPage;
        assert (this.holdsMutex());
        assert (this.eState == CursorState.VALID);
        assert (this.iPage < 20);
        if (this.iPage >= 19) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        this.apPage[i + 1] = pNewPage = this.pBt.getAndInitPage(newPgno);
        this.aiIdx[i + 1] = 0;
        ++this.iPage;
        this.info.nSize = 0;
        this.validNKey = false;
        if (pNewPage.nCell < 1) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private void getCellInfo() {
        if (this.info.nSize == 0) {
            this.info = this.apPage[this.iPage].parseCell(this.aiIdx[this.iPage]);
            this.validNKey = true;
        }
    }

    private ByteBuffer fetchPayload(int[] pAmt, boolean skipKey) {
        int nLocal;
        assert (this.iPage >= 0 && this.apPage[this.iPage] != null);
        assert (this.eState == CursorState.VALID);
        assert (this.holdsMutex());
        SqlJetMemPage pPage = this.apPage[this.iPage];
        assert (this.aiIdx[this.iPage] < pPage.nCell);
        this.getCellInfo();
        ByteBuffer aPayload = this.info.pCell;
        aPayload = SqlJetUtility.slice(aPayload, this.info.nHeader);
        int nKey = pPage.intKey ? 0 : (int)this.info.nKey;
        if (skipKey) {
            aPayload = SqlJetUtility.slice(aPayload, nKey);
            nLocal = this.info.nLocal - nKey;
        } else {
            nLocal = this.info.nLocal;
            if (nLocal > nKey) {
                nLocal = nKey;
            }
        }
        pAmt[0] = nLocal;
        return aPayload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int moveToUnpacked(ISqlJetUnpackedRecord pIdxKey, long intKey, boolean biasRight) throws SqlJetException {
        assert (this.holdsMutex());
        assert (this.pBtree.db.getMutex().held());
        if (this.eState == CursorState.VALID && this.validNKey && this.apPage[0].intKey) {
            if (this.info.nKey == intKey) {
                return 0;
            }
            if (this.atLast && this.info.nKey < intKey) {
                return -1;
            }
        }
        this.moveToRoot();
        assert (this.apPage[this.iPage] != null);
        assert (this.apPage[this.iPage].isInit);
        if (this.eState == CursorState.INVALID) {
            assert (this.apPage[this.iPage].nCell == 0);
            return -1;
        }
        assert (this.apPage[0].intKey || pIdxKey != null);
        while (true) {
            SqlJetMemPage pPage = this.apPage[this.iPage];
            int c = -1;
            int lwr = 0;
            int upr = pPage.nCell - 1;
            if (!pPage.intKey && pIdxKey == null || upr < 0) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.aiIdx[this.iPage] = biasRight ? upr : (upr + lwr) / 2;
            while (true) {
                long[] nCellKey = new long[1];
                int idx = this.aiIdx[this.iPage];
                this.info.nSize = 0;
                this.validNKey = true;
                if (pPage.intKey) {
                    ByteBuffer pCell = SqlJetUtility.slice(pPage.findCell(idx), pPage.childPtrSize);
                    if (pPage.hasData) {
                        int[] dummy = new int[1];
                        pCell = SqlJetUtility.slice(pCell, SqlJetUtility.getVarint32(pCell, dummy));
                    }
                    SqlJetUtility.getVarint(pCell, nCellKey);
                    if (nCellKey[0] == intKey) {
                        c = 0;
                    } else if (nCellKey[0] < intKey) {
                        c = -1;
                    } else {
                        assert (nCellKey[0] > intKey);
                        c = 1;
                    }
                } else {
                    int[] available = new int[1];
                    ByteBuffer pCellKey = this.fetchPayload(available, false);
                    nCellKey[0] = this.info.nKey;
                    if ((long)available[0] >= nCellKey[0]) {
                        c = pIdxKey.recordCompare((int)nCellKey[0], pCellKey);
                    } else {
                        pCellKey = ByteBuffer.allocate((int)nCellKey[0]);
                        try {
                            this.key(0, (int)nCellKey[0], pCellKey);
                        }
                        finally {
                            c = pIdxKey.recordCompare((int)nCellKey[0], pCellKey);
                        }
                    }
                }
                if (c == 0) {
                    this.info.nKey = nCellKey[0];
                    if (pPage.intKey && !pPage.leaf) {
                        lwr = idx;
                        upr = lwr - 1;
                        break;
                    }
                    return 0;
                }
                if (c < 0) {
                    lwr = idx + 1;
                } else {
                    upr = idx - 1;
                }
                if (lwr > upr) {
                    this.info.nKey = nCellKey[0];
                    break;
                }
                this.aiIdx[this.iPage] = (lwr + upr) / 2;
            }
            assert (lwr == upr + 1);
            assert (pPage.isInit);
            int chldPg = pPage.leaf ? 0 : (lwr >= pPage.nCell ? SqlJetUtility.get4byte(pPage.aData, pPage.hdrOffset + 8) : SqlJetUtility.get4byte(pPage.findCell(lwr)));
            if (chldPg == 0) {
                assert (this.aiIdx[this.iPage] < this.apPage[this.iPage].nCell);
                return c;
            }
            this.aiIdx[this.iPage] = lwr;
            this.info.nSize = 0;
            this.validNKey = false;
            this.moveToChild(chldPg);
        }
    }

    private void restoreCursorPosition() throws SqlJetException {
        if (this.eState.compareTo(CursorState.REQUIRESEEK) < 0) {
            return;
        }
        assert (this.holdsMutex());
        if (this.eState == CursorState.FAULT) {
            throw new SqlJetException(this.error);
        }
        this.eState = CursorState.INVALID;
        this.skip = this.moveTo(this.pKey, this.nKey, false);
        this.pKey = null;
        assert (this.eState == CursorState.VALID || this.eState == CursorState.INVALID);
    }

    public boolean cursorHasMoved() {
        try {
            this.restoreCursorPosition();
        }
        catch (SqlJetException e) {
            return true;
        }
        return this.eState != CursorState.VALID || this.skip != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws SqlJetException {
        SqlJetBtreeCursor pCur;
        block21: {
            pCur = this;
            SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
            int pgnoChild = 0;
            SqlJetBtree p = pCur.pBtree;
            SqlJetBtreeShared pBt = p.pBt;
            assert (pCur.holdsMutex());
            assert (pPage.isInit);
            assert (pBt.inTransaction == SqlJetBtree.TransMode.WRITE);
            assert (!pBt.readOnly);
            if (pCur.eState == CursorState.FAULT) {
                throw new SqlJetException(pCur.error);
            }
            if (pCur.aiIdx[pCur.iPage] >= pPage.nCell) {
                throw new SqlJetException(SqlJetErrorCode.ERROR);
            }
            assert (pCur.wrFlag);
            if (pCur.pBtree.checkReadLocks(pCur.pgnoRoot, pCur, pCur.info.nKey)) {
                throw new SqlJetException(SqlJetErrorCode.LOCKED);
            }
            pCur.restoreCursorPosition();
            pBt.saveAllCursors(pCur.pgnoRoot, pCur);
            pPage.pDbPage.write();
            int idx = pCur.aiIdx[pCur.iPage];
            ByteBuffer pCell = pPage.findCell(idx);
            if (!pPage.leaf) {
                pgnoChild = SqlJetUtility.get4byte(pCell);
            }
            pPage.clearCell(pCell);
            if (!pPage.leaf) {
                SqlJetMemPage pLeafPage = null;
                ByteBuffer tempCell = null;
                assert (!pPage.intKey);
                SqlJetBtreeCursor leafCur = pCur.getTempCursor();
                boolean notUsed = leafCur.next();
                assert (leafCur.aiIdx[leafCur.iPage] == 0);
                pLeafPage = leafCur.apPage[leafCur.iPage];
                pLeafPage.pDbPage.write();
                try {
                    boolean leafCursorInvalid = false;
                    SqlJetBtree.TRACE("DELETE: table=%d delete internal from %d replace from leaf %d\n", pCur.pgnoRoot, pPage.pgno, pLeafPage.pgno);
                    pPage.dropCell(idx, pPage.cellSizePtr(pCell));
                    ByteBuffer pNext = pLeafPage.findCell(0);
                    int szNext = pLeafPage.cellSizePtr(pNext);
                    assert (pBt.MX_CELL_SIZE() >= szNext + 4);
                    pBt.allocateTempSpace();
                    tempCell = pBt.pTmpSpace;
                    pPage.insertCell(idx, SqlJetUtility.slice(pNext, -4), szNext + 4, tempCell, (byte)0);
                    if ((pPage.nOverflow > 0 || pPage.nFree > pBt.usableSize * 2 / 3) && pLeafPage.nFree + 2 + szNext > pBt.usableSize * 2 / 3) {
                        leafCursorInvalid = true;
                    }
                    assert (pPage.pDbPage.isWriteable());
                    SqlJetUtility.put4byte(pPage.findOverflowCell(idx), pgnoChild);
                    pCur.balance(false);
                    if (leafCursorInvalid) {
                        leafCur.saveCursorPosition();
                        notUsed = leafCur.next();
                        pLeafPage = leafCur.apPage[leafCur.iPage];
                        assert (leafCur.aiIdx[leafCur.iPage] == 0);
                    }
                    pLeafPage.pDbPage.write();
                    pLeafPage.dropCell(0, szNext);
                    leafCur.balance(false);
                    assert (leafCursorInvalid || !leafCur.pagesShuffled || !pCur.pagesShuffled);
                    break block21;
                }
                finally {
                    leafCur.releaseTempCursor();
                }
            }
            SqlJetBtree.TRACE("DELETE: table=%d delete from leaf %d\n", pCur.pgnoRoot, pPage.pgno);
            pPage.dropCell(idx, pPage.cellSizePtr(pCell));
            pCur.balance(false);
        }
        pCur.moveToRoot();
    }

    private void balance(boolean isInsert) throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        assert (pPage.pBt.mutex.held());
        if (pCur.iPage == 0) {
            pPage.pDbPage.write();
            if (pPage.nOverflow > 0) {
                pCur.balance_deeper();
                assert (pCur.apPage[0] == pPage);
                assert (pPage.nOverflow == 0);
            }
            if (pPage.nCell == 0) {
                pCur.balance_shallower();
                assert (pCur.apPage[0] == pPage);
                assert (pPage.nOverflow == 0);
            }
        } else if (pPage.nOverflow > 0 || !isInsert && pPage.nFree > pPage.pBt.usableSize * 2 / 3) {
            pCur.balance_nonroot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balance_nonroot() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        int nCell = 0;
        int nMaxCells = 0;
        int nOld = 0;
        int nNew = 0;
        int iSpace1 = 0;
        int iSpace2 = 0;
        SqlJetMemPage[] apOld = new SqlJetMemPage[3];
        int[] pgnoOld = new int[3];
        SqlJetMemPage[] apCopy = new SqlJetMemPage[3];
        SqlJetMemPage[] apNew = new SqlJetMemPage[5];
        int[] pgnoNew = new int[5];
        ByteBuffer[] apDiv = new ByteBuffer[3];
        int[] cntNew = new int[5];
        int[] szNew = new int[5];
        ByteBuffer[] apCell = null;
        ByteBuffer[] aCopy = new ByteBuffer[3];
        ByteBuffer aSpace2 = null;
        ByteBuffer aFrom = null;
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        assert (pPage.pBt.mutex.held());
        assert (pCur.iPage > 0);
        assert (pPage.isInit);
        assert (pPage.pDbPage.isWriteable() || pPage.nOverflow == 1);
        SqlJetBtreeShared pBt = pPage.pBt;
        SqlJetMemPage pParent = pCur.apPage[pCur.iPage - 1];
        assert (pParent != null);
        boolean ignore_clean = false;
        try {
            int j;
            pParent.pDbPage.write();
            SqlJetBtree.TRACE("BALANCE: begin page %d child of %d\n", pPage.pgno, pParent.pgno);
            if (pPage.leaf && pPage.intKey && pPage.nOverflow == 1 && pPage.aOvfl[0].idx == pPage.nCell && pParent.pgno != 1 && SqlJetUtility.get4byte(pParent.aData, pParent.hdrOffset + 8) == pPage.pgno) {
                assert (pPage.intKey);
                ignore_clean = true;
                pCur.balance_quick();
                return;
            }
            pPage.pDbPage.write();
            int idx = pCur.aiIdx[pCur.iPage - 1];
            pParent.assertParentIndex(idx, pPage.pgno);
            int nxDiv = idx - 1;
            if (nxDiv + 3 > pParent.nCell) {
                nxDiv = pParent.nCell - 3 + 1;
            }
            if (nxDiv < 0) {
                nxDiv = 0;
            }
            int nDiv = 0;
            int i = 0;
            int k = nxDiv;
            while (i < 3) {
                if (k < pParent.nCell) {
                    apDiv[i] = pParent.findCell(k);
                    ++nDiv;
                    assert (!pParent.leaf);
                    pgnoOld[i] = SqlJetUtility.get4byte(apDiv[i]);
                } else {
                    if (k != pParent.nCell) break;
                    pgnoOld[i] = SqlJetUtility.get4byte(pParent.aData, pParent.hdrOffset + 8);
                }
                apOld[i] = pBt.getAndInitPage(pgnoOld[i]);
                apCopy[i] = null;
                assert (i == nOld);
                ++nOld;
                nMaxCells += 1 + apOld[i].nCell + apOld[i].nOverflow;
                ++i;
                ++k;
            }
            apCell = new ByteBuffer[nMaxCells];
            int[] szCell = new int[nMaxCells];
            ByteBuffer aSpace1 = ByteBuffer.allocate(pBt.pageSize);
            if (pBt.autoVacuum) {
                aFrom = ByteBuffer.allocate(nMaxCells);
            }
            aSpace2 = ByteBuffer.allocate(pBt.pageSize);
            for (i = 0; i < nOld; ++i) {
                SqlJetMemPage p = apCopy[i] = SqlJetUtility.memcpy(apOld[i]);
                p.aData = aCopy[i] = ByteBuffer.allocate(pBt.pageSize);
                SqlJetUtility.memcpy(p.aData, apOld[i].aData, pBt.pageSize);
            }
            nCell = 0;
            int leafCorrection = (pPage.leaf ? 1 : 0) * 4;
            boolean leafData = pPage.hasData;
            for (i = 0; i < nOld; ++i) {
                SqlJetMemPage pOld = apCopy[i];
                int limit = pOld.nCell + pOld.nOverflow;
                for (j = 0; j < limit; ++j) {
                    assert (nCell < nMaxCells);
                    apCell[nCell] = pOld.findOverflowCell(j);
                    szCell[nCell] = pOld.cellSizePtr(apCell[nCell]);
                    if (pBt.autoVacuum) {
                        SqlJetUtility.putUnsignedByte(aFrom, nCell, (byte)i);
                        assert (i >= 0 && i < 6);
                        for (int a = 0; a < pOld.nOverflow; ++a) {
                            if (pOld.aOvfl[a].pCell != apCell[nCell]) continue;
                            SqlJetUtility.putUnsignedByte(aFrom, nCell, (short)-1);
                            break;
                        }
                    }
                    ++nCell;
                }
                if (i >= nOld - 1) continue;
                int sz = pParent.cellSizePtr(apDiv[i]);
                if (leafData) {
                    pParent.dropCell(nxDiv, sz);
                    continue;
                }
                assert (nCell < nMaxCells);
                szCell[nCell] = sz;
                ByteBuffer pTemp = SqlJetUtility.slice(aSpace1, iSpace1);
                iSpace1 += sz;
                assert (sz <= pBt.pageSize / 4);
                assert (iSpace1 <= pBt.pageSize);
                SqlJetUtility.memcpy(pTemp, apDiv[i], sz);
                apCell[nCell] = SqlJetUtility.slice(pTemp, leafCorrection);
                if (pBt.autoVacuum) {
                    SqlJetUtility.putUnsignedByte(aFrom, nCell, (short)-1);
                }
                pParent.dropCell(nxDiv, sz);
                assert (leafCorrection == 0 || leafCorrection == 4);
                int n = nCell;
                szCell[n] = szCell[n] - leafCorrection;
                assert (SqlJetUtility.get4byte(pTemp) == pgnoOld[i]);
                if (!pOld.leaf) {
                    assert (leafCorrection == 0);
                    SqlJetUtility.memcpy(apCell[nCell], SqlJetUtility.slice(pOld.aData, pOld.hdrOffset + 8), 4);
                } else {
                    assert (leafCorrection == 4);
                    if (szCell[nCell] < 4) {
                        szCell[nCell] = 4;
                    }
                }
                ++nCell;
            }
            int usableSpace = pBt.usableSize - 12 + leafCorrection;
            k = 0;
            int subtotal = 0;
            for (i = 0; i < nCell; ++i) {
                assert (i < nMaxCells);
                if ((subtotal += szCell[i] + 2) <= usableSpace) continue;
                szNew[k] = subtotal - szCell[i];
                cntNew[k] = i--;
                if (leafData) {
                    // empty if block
                }
                subtotal = 0;
                ++k;
            }
            szNew[k] = subtotal;
            cntNew[k] = nCell;
            for (i = ++k - 1; i > 0; --i) {
                int szRight = szNew[i];
                int szLeft = szNew[i - 1];
                int r = cntNew[i - 1] - 1;
                int d = r + 1 - (leafData ? 1 : 0);
                assert (d < nMaxCells);
                assert (r < nMaxCells);
                while (szRight == 0 || szRight + szCell[d] + 2 <= szLeft - (szCell[r] + 2)) {
                    szRight += szCell[d] + 2;
                    szLeft -= szCell[r] + 2;
                    int n = i - 1;
                    cntNew[n] = cntNew[n] - 1;
                    r = cntNew[i - 1] - 1;
                    d = r + 1 - (leafData ? 1 : 0);
                }
                szNew[i] = szRight;
                szNew[i - 1] = szLeft;
            }
            assert (cntNew[0] > 0 || pParent.pgno == 1 && pParent.nCell == 0);
            assert (pPage.pgno > 1);
            short pageFlags = SqlJetUtility.getUnsignedByte(pPage.aData, 0);
            int[] ipgnoNew = new int[1];
            for (i = 0; i < k; ++i) {
                SqlJetMemPage pNew;
                if (i < nOld) {
                    pNew = apNew[i] = apOld[i];
                    pgnoNew[i] = pgnoOld[i];
                    apOld[i] = null;
                    pNew.pDbPage.write();
                    ++nNew;
                    continue;
                }
                assert (i > 0);
                ipgnoNew[0] = pgnoNew[i];
                pNew = pBt.allocatePage(ipgnoNew, pgnoNew[i - 1], false);
                pgnoNew[i] = ipgnoNew[0];
                apNew[i] = pNew;
                ++nNew;
            }
            while (i < nOld) {
                apOld[i].freePage();
                SqlJetMemPage.releasePage(apOld[i]);
                apOld[i] = null;
                ++i;
            }
            for (i = 0; i < k - 1; ++i) {
                int minV = pgnoNew[i];
                int minI = i;
                for (j = i + 1; j < k; ++j) {
                    if (pgnoNew[j] >= minV) continue;
                    minI = j;
                    minV = pgnoNew[j];
                }
                if (minI <= i) continue;
                int t = pgnoNew[i];
                SqlJetMemPage pT = apNew[i];
                pgnoNew[i] = pgnoNew[minI];
                apNew[i] = apNew[minI];
                pgnoNew[minI] = t;
                apNew[minI] = pT;
            }
            SqlJetBtree.TRACE("BALANCE: old: %d %d %d  new: %d(%d) %d(%d) %d(%d) %d(%d) %d(%d)\n", pgnoOld[0], nOld >= 2 ? pgnoOld[1] : 0, nOld >= 3 ? pgnoOld[2] : 0, pgnoNew[0], szNew[0], nNew >= 2 ? pgnoNew[1] : 0, nNew >= 2 ? szNew[1] : 0, nNew >= 3 ? pgnoNew[2] : 0, nNew >= 3 ? szNew[2] : 0, nNew >= 4 ? pgnoNew[3] : 0, nNew >= 4 ? szNew[3] : 0, nNew >= 5 ? pgnoNew[4] : 0, nNew >= 5 ? szNew[4] : 0);
            j = 0;
            for (i = 0; i < nNew; ++i) {
                SqlJetMemPage pNew = apNew[i];
                assert (j < nMaxCells);
                assert (pNew.pgno == pgnoNew[i]);
                pNew.zeroPage(pageFlags);
                pNew.assemblePage(cntNew[i] - j, apCell, j, szCell, j);
                assert (pNew.nCell > 0 || nNew == 1 && cntNew[0] == 0);
                assert (pNew.nOverflow == 0);
                if (pBt.autoVacuum) {
                    for (k = j; k < cntNew[i]; ++k) {
                        assert (k < nMaxCells);
                        if (SqlJetUtility.getUnsignedByte(aFrom, k) != 255 && apCopy[SqlJetUtility.getUnsignedByte((ByteBuffer)aFrom, (int)k)].pgno == pNew.pgno) continue;
                        pNew.ptrmapPutOvfl(k - j);
                        if (leafCorrection != 0) continue;
                        pBt.ptrmapPut(SqlJetUtility.get4byte(apCell[k]), (short)5, pNew.pgno);
                    }
                }
                j = cntNew[i];
                if (i < nNew - 1 && j < nCell) {
                    assert (j < nMaxCells);
                    ByteBuffer pCell = apCell[j];
                    int sz = szCell[j] + leafCorrection;
                    ByteBuffer pTemp = SqlJetUtility.slice(aSpace2, iSpace2);
                    if (!pNew.leaf) {
                        SqlJetUtility.memcpy(SqlJetUtility.slice(pNew.aData, 8), pCell, 4);
                        if (pBt.autoVacuum && (SqlJetUtility.getUnsignedByte(aFrom, j) == 255 || apCopy[SqlJetUtility.getUnsignedByte((ByteBuffer)aFrom, (int)j)].pgno != pNew.pgno)) {
                            pBt.ptrmapPut(SqlJetUtility.get4byte(pCell), (short)5, pNew.pgno);
                        }
                    } else if (leafData) {
                        SqlJetBtreeCellInfo info = pNew.parseCellPtr(apCell[--j]);
                        pCell = pTemp;
                        sz = pParent.fillInCell(pCell, null, info.nKey, null, 0, 0);
                        pTemp = null;
                    } else {
                        pCell = SqlJetUtility.slice(pCell, -4);
                        if (szCell[j] == 4) {
                            assert (leafCorrection == 4);
                            sz = pParent.cellSizePtr(pCell);
                        }
                    }
                    iSpace2 += sz;
                    assert (sz <= pBt.pageSize / 4);
                    assert (iSpace2 <= pBt.pageSize);
                    pParent.insertCell(nxDiv, pCell, sz, pTemp, (byte)4);
                    assert (pParent.pDbPage.isWriteable());
                    SqlJetUtility.put4byte(pParent.findOverflowCell(nxDiv), pNew.pgno);
                    if (pBt.autoVacuum && !leafData) {
                        pParent.ptrmapPutOvfl(nxDiv);
                    }
                    ++j;
                    ++nxDiv;
                }
                if (!pBt.autoVacuum) continue;
                pBt.ptrmapPut(pNew.pgno, (short)5, pParent.pgno);
            }
            assert (j == nCell);
            assert (nOld > 0);
            assert (nNew > 0);
            if ((pageFlags & 8) == 0) {
                ByteBuffer zChild = SqlJetUtility.slice(apCopy[nOld - 1].aData, 8);
                SqlJetUtility.memcpy(SqlJetUtility.slice(apNew[nNew - 1].aData, 8), zChild, 4);
                if (pBt.autoVacuum) {
                    pBt.ptrmapPut(SqlJetUtility.get4byte(zChild), (short)5, apNew[nNew - 1].pgno);
                }
            }
            assert (pParent.pDbPage.isWriteable());
            if (nxDiv == pParent.nCell + pParent.nOverflow) {
                SqlJetUtility.put4byte(SqlJetUtility.slice(pParent.aData, pParent.hdrOffset + 8), pgnoNew[nNew - 1]);
            } else {
                SqlJetUtility.put4byte(pParent.findOverflowCell(nxDiv), pgnoNew[nNew - 1]);
            }
            assert (pParent.isInit);
            apCell = null;
            SqlJetBtree.TRACE("BALANCE: finished with %d: old=%d new=%d cells=%d\n", pPage.pgno, nOld, nNew, nCell);
            pPage.nOverflow = 0;
            SqlJetMemPage.releasePage(pPage);
            --pCur.iPage;
            pCur.balance(false);
        }
        finally {
            int i;
            if (ignore_clean) {
                return;
            }
            for (i = 0; i < nOld; ++i) {
                SqlJetMemPage.releasePage(apOld[i]);
            }
            for (i = 0; i < nNew; ++i) {
                SqlJetMemPage.releasePage(apNew[i]);
            }
            pCur.apPage[pCur.iPage].nOverflow = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balance_quick() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        SqlJetMemPage pNew = null;
        int[] pgnoNew = new int[1];
        SqlJetBtreeCellInfo info = new SqlJetBtreeCellInfo();
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        SqlJetMemPage pParent = pCur.apPage[pCur.iPage - 1];
        SqlJetBtreeShared pBt = pPage.pBt;
        int parentIdx = pParent.nCell;
        ByteBuffer parentCell = ByteBuffer.allocate(64);
        assert (pPage.pBt.mutex.held());
        try {
            pNew = pBt.allocatePage(pgnoNew, 0, false);
            ByteBuffer pCell = pPage.aOvfl[0].pCell;
            int szCell = pPage.cellSizePtr(pCell);
            assert (pNew.pDbPage.isWriteable());
            pNew.zeroPage(SqlJetUtility.getUnsignedByte(pPage.aData, 0));
            pNew.assemblePage(1, new ByteBuffer[]{pCell}, new int[]{szCell});
            pPage.nOverflow = 0;
            assert (pPage.nCell > 0);
            pCell = pPage.findCell(pPage.nCell - 1);
            info = pPage.parseCellPtr(pCell);
            int parentSize = pParent.fillInCell(parentCell, null, info.nKey, null, 0, 0);
            assert (parentSize < 64);
            assert (pParent.pDbPage.isWriteable());
            pParent.insertCell(parentIdx, parentCell, parentSize, null, (byte)4);
            SqlJetUtility.put4byte(pParent.findOverflowCell(parentIdx), pPage.pgno);
            SqlJetUtility.put4byte(pParent.aData, pParent.hdrOffset + 8, pgnoNew[0]);
            if (pBt.autoVacuum) {
                pBt.ptrmapPut(pgnoNew[0], (short)5, pParent.pgno);
                pNew.ptrmapPutOvfl(0);
            }
            SqlJetMemPage.releasePage(pNew);
        }
        finally {
            pPage.isInit = false;
            pPage.initPage();
            assert (pPage.nOverflow == 0);
        }
        SqlJetMemPage.releasePage(pPage);
        --pCur.iPage;
        pCur.balance(false);
    }

    private void balance_shallower() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (pCur.iPage == 0);
        SqlJetMemPage pPage = pCur.apPage[0];
        assert (pPage.nCell == 0);
        assert (pPage.pBt.mutex.held());
        SqlJetBtreeShared pBt = pPage.pBt;
        int mxCellPerPage = pBt.MX_CELL();
        ByteBuffer[] apCell = new ByteBuffer[mxCellPerPage];
        int[] szCell = new int[mxCellPerPage];
        if (pPage.leaf) {
            SqlJetBtree.TRACE("BALANCE: empty table %d\n", pPage.pgno);
        } else {
            int pgnoChild = SqlJetUtility.get4byte(pPage.aData, pPage.hdrOffset + 8);
            assert (pgnoChild > 0);
            assert (pgnoChild <= pPage.pBt.getPageCount());
            SqlJetMemPage pChild = pPage.pBt.getPage(pgnoChild, false);
            if (pPage.pgno == 1) {
                pChild.initPage();
                assert (pChild.nOverflow == 0);
                if (pChild.nFree >= 100) {
                    pPage.zeroPage(SqlJetUtility.getUnsignedByte(pChild.aData, 0));
                    for (int i = 0; i < pChild.nCell; ++i) {
                        apCell[i] = pChild.findCell(i);
                        szCell[i] = pChild.cellSizePtr(apCell[i]);
                    }
                    pPage.assemblePage(pChild.nCell, apCell, szCell);
                    assert (pPage.pDbPage.isWriteable());
                    SqlJetUtility.put4byte(pPage.aData, pPage.hdrOffset + 8, SqlJetUtility.get4byte(pChild.aData, pChild.hdrOffset + 8));
                    pChild.freePage();
                    SqlJetBtree.TRACE("BALANCE: child %d transfer to page 1\n", pChild.pgno);
                } else {
                    SqlJetBtree.TRACE("BALANCE: child %d will not fit on page 1\n", pChild.pgno);
                }
            } else {
                SqlJetUtility.memcpy(pPage.aData, pChild.aData, pPage.pBt.usableSize);
                pPage.isInit = false;
                pPage.initPage();
                pChild.freePage();
                SqlJetBtree.TRACE("BALANCE: transfer child %d into root %d\n", pChild.pgno, pPage.pgno);
            }
            assert (pPage.nOverflow == 0);
            if (pBt.autoVacuum) {
                pPage.setChildPtrmaps();
            }
            SqlJetMemPage.releasePage(pChild);
        }
    }

    private void balance_deeper() throws SqlJetException {
        SqlJetMemPage pChild;
        SqlJetBtreeCursor pCur;
        block13: {
            pCur = this;
            int[] pgnoChild = new int[1];
            assert (pCur.iPage == 0);
            assert (pCur.apPage[0].nOverflow > 0);
            SqlJetMemPage pPage = pCur.apPage[0];
            SqlJetBtreeShared pBt = pPage.pBt;
            assert (pBt.mutex.held());
            assert (pPage.pDbPage.isWriteable());
            pChild = pBt.allocatePage(pgnoChild, pPage.pgno, false);
            assert (pChild.pDbPage.isWriteable());
            int usableSize = pBt.usableSize;
            ByteBuffer data = pPage.aData;
            byte hdr = pPage.hdrOffset;
            int cbrk = SqlJetUtility.get2byte(data, hdr + 5);
            ByteBuffer cdata = pChild.aData;
            SqlJetUtility.memcpy(cdata, SqlJetUtility.slice(data, hdr), pPage.cellOffset + 2 * pPage.nCell - hdr);
            SqlJetUtility.memcpy(SqlJetUtility.slice(cdata, cbrk), SqlJetUtility.slice(data, cbrk), usableSize - cbrk);
            try {
                assert (!pChild.isInit);
                pChild.initPage();
                int nCopy = pPage.nOverflow;
                SqlJetUtility.memcpy(pChild.aOvfl, pPage.aOvfl, nCopy);
                pChild.nOverflow = pPage.nOverflow;
                if (pChild.nOverflow != 0) {
                    pChild.nFree = 0;
                }
                assert (pChild.nCell == pPage.nCell);
                assert (pPage.pDbPage.isWriteable());
                pPage.zeroPage(SqlJetUtility.getUnsignedByte(pChild.aData, 0) & 0xFFFFFFF7);
                SqlJetUtility.put4byte(pPage.aData, pPage.hdrOffset + 8, pgnoChild[0]);
                SqlJetBtree.TRACE("BALANCE: copy root %d into %d\n", pPage.pgno, pChild.pgno);
                if (!pBt.autoVacuum) break block13;
                pBt.ptrmapPut(pChild.pgno, (short)5, pPage.pgno);
                try {
                    pChild.setChildPtrmaps();
                }
                catch (SqlJetException e) {
                    pChild.nOverflow = 0;
                    throw e;
                }
            }
            catch (SqlJetException e) {
                SqlJetMemPage.releasePage(pChild);
                throw e;
            }
        }
        ++pCur.iPage;
        pCur.apPage[1] = pChild;
        pCur.aiIdx[0] = 0;
        pCur.balance_nonroot();
    }

    private SqlJetBtreeCursor getTempCursor() throws SqlJetException {
        SqlJetBtreeCursor pTempCur;
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        try {
            pTempCur = (SqlJetBtreeCursor)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new SqlJetException(SqlJetErrorCode.INTERNAL);
        }
        pTempCur.pNext = null;
        pTempCur.pPrev = null;
        for (int i = 0; i <= pTempCur.iPage; ++i) {
            pTempCur.apPage[i].pDbPage.ref();
        }
        assert (pTempCur.pKey == null);
        return pTempCur;
    }

    void releaseTempCursor() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        for (int i = 0; i <= pCur.iPage; ++i) {
            pCur.apPage[i].pDbPage.unref();
        }
        pCur.pKey = null;
    }

    public void insert(ByteBuffer pKey, long nKey, ByteBuffer pData, int nData, int zero, boolean bias) throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        SqlJetBtree p = pCur.pBtree;
        SqlJetBtreeShared pBt = p.pBt;
        ByteBuffer newCell = null;
        assert (this.cursorHoldsMutex(pCur));
        assert (pBt.inTransaction == SqlJetBtree.TransMode.WRITE);
        assert (!pBt.readOnly);
        assert (pCur.wrFlag);
        if (pCur.pBtree.checkReadLocks(pCur.pgnoRoot, pCur, nKey)) {
            throw new SqlJetException(SqlJetErrorCode.LOCKED);
        }
        if (pCur.eState == CursorState.FAULT) {
            throw new SqlJetException(pCur.error);
        }
        pCur.clearCursor();
        pBt.saveAllCursors(pCur.pgnoRoot, pCur);
        int loc = pCur.moveTo(pKey, nKey, bias);
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        assert (pPage.intKey || nKey >= 0L);
        assert (pPage.leaf || !pPage.intKey);
        SqlJetBtree.TRACE("INSERT: table=%d nkey=%lld ndata=%d page=%d %s\n", pCur.pgnoRoot, nKey, pData, pPage.pgno, loc == 0 ? "overwrite" : "new entry");
        assert (pPage.isInit);
        pBt.allocateTempSpace();
        newCell = pBt.pTmpSpace;
        int szNew = pPage.fillInCell(newCell, pKey, nKey, pData, nData, zero);
        assert (szNew == pPage.cellSizePtr(newCell));
        assert (szNew <= pBt.MX_CELL_SIZE());
        int idx = pCur.aiIdx[pCur.iPage];
        if (loc == 0 && CursorState.VALID == pCur.eState) {
            assert (idx < pPage.nCell);
            pPage.pDbPage.write();
            ByteBuffer oldCell = pPage.findCell(idx);
            if (!pPage.leaf) {
                SqlJetUtility.memcpy(newCell, oldCell, 4);
            }
            int szOld = pPage.cellSizePtr(oldCell);
            pPage.clearCell(oldCell);
            pPage.dropCell(idx, szOld);
        } else if (loc < 0 && pPage.nCell > 0) {
            assert (pPage.leaf);
            int n = pCur.iPage;
            int n2 = pCur.aiIdx[n] + 1;
            pCur.aiIdx[n] = n2;
            idx = n2;
            pCur.info.nSize = 0;
            pCur.validNKey = false;
        } else assert (pPage.leaf);
        pPage.insertCell(idx, newCell, szNew, null, (byte)0);
        pCur.balance(true);
        pCur.apPage[pCur.iPage].nOverflow = 0;
        pCur.moveToRoot();
    }

    public boolean first() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.pBtree.db.getMutex().held());
        pCur.moveToRoot();
        if (pCur.eState == CursorState.INVALID) {
            assert (pCur.apPage[pCur.iPage].nCell == 0);
            return true;
        }
        assert (pCur.apPage[pCur.iPage].nCell > 0);
        pCur.moveToLeftmost();
        return false;
    }

    private void moveToLeftmost() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.eState == CursorState.VALID);
        while (true) {
            SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
            if (pPage.leaf) break;
            assert (pCur.aiIdx[pCur.iPage] < pPage.nCell);
            int pgno = SqlJetUtility.get4byte(pPage.findCell(pCur.aiIdx[pCur.iPage]));
            pCur.moveToChild(pgno);
        }
    }

    private void moveToRightmost() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        SqlJetMemPage pPage = null;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.eState == CursorState.VALID);
        while (true) {
            pPage = pCur.apPage[pCur.iPage];
            if (pPage.leaf) break;
            int pgno = SqlJetUtility.get4byte(pPage.aData, pPage.hdrOffset + 8);
            pCur.aiIdx[pCur.iPage] = pPage.nCell;
            pCur.moveToChild(pgno);
        }
        pCur.aiIdx[pCur.iPage] = pPage.nCell - 1;
        pCur.info.nSize = 0;
        pCur.validNKey = false;
    }

    public boolean last() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.pBtree.db.getMutex().held());
        pCur.moveToRoot();
        if (CursorState.INVALID == pCur.eState) {
            assert (pCur.apPage[pCur.iPage].nCell == 0);
            return true;
        }
        assert (pCur.eState == CursorState.VALID);
        try {
            pCur.moveToRightmost();
        }
        catch (SqlJetException e) {
            pCur.atLast = false;
            throw e;
        }
        finally {
            pCur.getCellInfo();
        }
        pCur.atLast = true;
        return false;
    }

    public boolean next() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        pCur.restoreCursorPosition();
        if (CursorState.INVALID == pCur.eState) {
            return true;
        }
        if (pCur.skip > 0) {
            pCur.skip = 0;
            return false;
        }
        pCur.skip = 0;
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        int n = pCur.iPage;
        int n2 = pCur.aiIdx[n] + 1;
        pCur.aiIdx[n] = n2;
        int idx = n2;
        assert (pPage.isInit);
        assert (idx <= pPage.nCell);
        pCur.info.nSize = 0;
        pCur.validNKey = false;
        if (idx >= pPage.nCell) {
            if (!pPage.leaf) {
                pCur.moveToChild(SqlJetUtility.get4byte(pPage.aData, pPage.hdrOffset + 8));
                pCur.moveToLeftmost();
                return false;
            }
            do {
                if (pCur.iPage == 0) {
                    pCur.eState = CursorState.INVALID;
                    return true;
                }
                pCur.moveToParent();
                pPage = pCur.apPage[pCur.iPage];
            } while (pCur.aiIdx[pCur.iPage] >= pPage.nCell);
            if (pPage.intKey) {
                return pCur.next();
            }
            return false;
        }
        if (pPage.leaf) {
            return false;
        }
        pCur.moveToLeftmost();
        return false;
    }

    private void moveToParent() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        assert (pCur.eState == CursorState.VALID);
        assert (pCur.iPage > 0);
        assert (pCur.apPage[pCur.iPage] != null);
        pCur.apPage[pCur.iPage - 1].assertParentIndex(pCur.aiIdx[pCur.iPage - 1], pCur.apPage[pCur.iPage].pgno);
        SqlJetMemPage.releasePage(pCur.apPage[pCur.iPage]);
        --pCur.iPage;
        pCur.info.nSize = 0;
        pCur.validNKey = false;
    }

    public boolean previous() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        pCur.restoreCursorPosition();
        pCur.atLast = false;
        if (CursorState.INVALID == pCur.eState) {
            return true;
        }
        if (pCur.skip < 0) {
            pCur.skip = 0;
            return false;
        }
        pCur.skip = 0;
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        assert (pPage.isInit);
        if (!pPage.leaf) {
            int idx = pCur.aiIdx[pCur.iPage];
            pCur.moveToChild(SqlJetUtility.get4byte(pPage.findCell(idx)));
            pCur.moveToRightmost();
        } else {
            while (pCur.aiIdx[pCur.iPage] == 0) {
                if (pCur.iPage == 0) {
                    pCur.eState = CursorState.INVALID;
                    return true;
                }
                pCur.moveToParent();
            }
            pCur.info.nSize = 0;
            pCur.validNKey = false;
            int n = pCur.iPage;
            pCur.aiIdx[n] = pCur.aiIdx[n] - 1;
            pPage = pCur.apPage[pCur.iPage];
            if (pPage.intKey && !pPage.leaf) {
                return pCur.previous();
            }
        }
        return false;
    }

    public boolean eof() {
        SqlJetBtreeCursor pCur = this;
        return CursorState.VALID != pCur.eState;
    }

    public short flags() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        pCur.restoreCursorPosition();
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        assert (this.cursorHoldsMutex(pCur));
        assert (pPage != null);
        assert (pPage.pBt == pCur.pBt);
        return SqlJetUtility.getUnsignedByte(pPage.aData, pPage.hdrOffset);
    }

    public long getKeySize() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        pCur.restoreCursorPosition();
        assert (pCur.eState == CursorState.INVALID || pCur.eState == CursorState.VALID);
        if (pCur.eState == CursorState.INVALID) {
            return 0L;
        }
        pCur.getCellInfo();
        return pCur.info.nKey;
    }

    public void key(int offset, int amt, ByteBuffer buf) throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (this.cursorHoldsMutex(pCur));
        pCur.restoreCursorPosition();
        assert (pCur.eState == CursorState.VALID);
        assert (pCur.iPage >= 0 && pCur.apPage[pCur.iPage] != null);
        if (pCur.apPage[0].intKey) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        assert (pCur.aiIdx[pCur.iPage] < pCur.apPage[pCur.iPage].nCell);
        pCur.accessPayload(offset, amt, buf, 0, false);
    }

    private void accessPayload(int offset, int amt, ByteBuffer pBuf, int skipKey, boolean eOp) throws SqlJetException {
        int nKey;
        SqlJetBtreeCursor pCur = this;
        int iIdx = 0;
        SqlJetMemPage pPage = pCur.apPage[pCur.iPage];
        SqlJetBtreeShared pBt = pCur.pBt;
        assert (pPage != null);
        assert (pCur.eState == CursorState.VALID);
        assert (pCur.aiIdx[pCur.iPage] < pPage.nCell);
        assert (this.cursorHoldsMutex(pCur));
        pCur.getCellInfo();
        ByteBuffer aPayload = SqlJetUtility.slice(pCur.info.pCell, pCur.info.nHeader);
        int n = nKey = pPage.intKey ? 0 : (int)pCur.info.nKey;
        if (skipKey != 0) {
            offset += nKey;
        }
        if (offset + amt > nKey + pCur.info.nData || aPayload.arrayOffset() + pCur.info.nLocal > pPage.aData.arrayOffset() + pBt.usableSize) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        if (offset < pCur.info.nLocal) {
            int a = amt;
            if (a + offset > pCur.info.nLocal) {
                a = pCur.info.nLocal - offset;
            }
            this.copyPayload(SqlJetUtility.slice(aPayload, offset), pBuf, a, eOp, pPage.pDbPage);
            offset = 0;
            pBuf = SqlJetUtility.slice(pBuf, a);
            amt -= a;
        } else {
            offset -= pCur.info.nLocal;
        }
        if (amt > 0) {
            int ovflSize = pBt.usableSize - 4;
            int nextPage = SqlJetUtility.get4byte(SqlJetUtility.slice(aPayload, pCur.info.nLocal));
            if (pCur.isIncrblobHandle && pCur.aOverflow == null) {
                int nOvfl = (pCur.info.nPayload - pCur.info.nLocal + ovflSize - 1) / ovflSize;
                pCur.aOverflow = new int[nOvfl];
            }
            if (pCur.aOverflow != null && pCur.aOverflow[offset / ovflSize] != 0) {
                iIdx = offset / ovflSize;
                nextPage = pCur.aOverflow[iIdx];
                offset %= ovflSize;
            }
            while (amt > 0 && nextPage != 0) {
                if (pCur.aOverflow != null) {
                    assert (pCur.aOverflow[iIdx] == 0 || pCur.aOverflow[iIdx] == nextPage);
                    pCur.aOverflow[iIdx] = nextPage;
                }
                if (offset >= ovflSize) {
                    if (pCur.aOverflow != null && pCur.aOverflow[iIdx + 1] != 0) {
                        nextPage = pCur.aOverflow[iIdx + 1];
                    } else {
                        int[] pNextPage = new int[]{nextPage};
                        pBt.getOverflowPage(nextPage, null, pNextPage);
                        nextPage = pNextPage[0];
                    }
                    offset -= ovflSize;
                } else {
                    int a = amt;
                    ISqlJetPage pDbPage = pBt.pPager.getPage(nextPage);
                    aPayload = pDbPage.getData();
                    nextPage = SqlJetUtility.get4byte(aPayload);
                    if (a + offset > ovflSize) {
                        a = ovflSize - offset;
                    }
                    this.copyPayload(SqlJetUtility.slice(aPayload, offset + 4), pBuf, a, eOp, pDbPage);
                    pDbPage.unref();
                    offset = 0;
                    amt -= a;
                    pBuf = SqlJetUtility.slice(pBuf, a);
                }
                ++iIdx;
            }
        }
        if (amt > 0) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    private void copyPayload(ByteBuffer pPayload, ByteBuffer pBuf, int nByte, boolean eOp, ISqlJetPage pDbPage) throws SqlJetException {
        if (eOp) {
            pDbPage.write();
            SqlJetUtility.memcpy(pPayload, pBuf, nByte);
        } else {
            SqlJetUtility.memcpy(pBuf, pPayload, nByte);
        }
    }

    public ISqlJetDbHandle getCursorDb() {
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        return this.pBtree.db;
    }

    public ByteBuffer keyFetch(int[] amt) {
        assert (this.cursorHoldsMutex(this));
        if (this.eState == CursorState.VALID) {
            return this.fetchPayload(amt, false);
        }
        return null;
    }

    public ByteBuffer dataFetch(int[] amt) {
        assert (this.cursorHoldsMutex(this));
        if (this.eState == CursorState.VALID) {
            return this.fetchPayload(amt, true);
        }
        return null;
    }

    public int getDataSize() throws SqlJetException {
        assert (this.cursorHoldsMutex(this));
        this.restoreCursorPosition();
        assert (this.eState == CursorState.INVALID || this.eState == CursorState.VALID);
        if (this.eState == CursorState.INVALID) {
            return 0;
        }
        this.getCellInfo();
        return this.info.nData;
    }

    public void data(int offset, int amt, ByteBuffer buf) throws SqlJetException {
        if (this.eState == CursorState.INVALID) {
            throw new SqlJetException(SqlJetErrorCode.ABORT);
        }
        assert (this.cursorHoldsMutex(this));
        this.restoreCursorPosition();
        assert (this.eState == CursorState.VALID);
        assert (this.iPage >= 0 && this.apPage[this.iPage] != null);
        assert (this.aiIdx[this.iPage] < this.apPage[this.iPage].nCell);
        this.accessPayload(offset, amt, buf, 1, false);
    }

    public void putData(int offset, int amt, ByteBuffer data) throws SqlJetException {
        assert (this.cursorHoldsMutex(this));
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        assert (this.isIncrblobHandle);
        this.restoreCursorPosition();
        assert (this.eState != CursorState.REQUIRESEEK);
        if (this.eState != CursorState.VALID) {
            throw new SqlJetException(SqlJetErrorCode.ABORT);
        }
        if (!this.wrFlag) {
            throw new SqlJetException(SqlJetErrorCode.READONLY);
        }
        assert (!this.pBt.readOnly && this.pBt.inTransaction == SqlJetBtree.TransMode.WRITE);
        if (this.pBtree.checkReadLocks(this.pgnoRoot, this, 0L)) {
            throw new SqlJetException(SqlJetErrorCode.LOCKED);
        }
        if (this.eState == CursorState.INVALID || !this.apPage[this.iPage].intKey) {
            throw new SqlJetException(SqlJetErrorCode.ERROR);
        }
        this.accessPayload(offset, amt, data, 0, true);
    }

    public void cacheOverflow() {
        assert (this.cursorHoldsMutex(this));
        assert (SqlJetUtility.mutex_held(this.pBtree.db.getMutex()));
        assert (!this.isIncrblobHandle);
        assert (this.aOverflow == null);
        this.isIncrblobHandle = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveCursorPosition() throws SqlJetException {
        SqlJetBtreeCursor pCur = this;
        assert (CursorState.VALID == pCur.eState);
        assert (null == pCur.pKey);
        assert (this.cursorHoldsMutex(pCur));
        try {
            pCur.nKey = pCur.getKeySize();
            if (!pCur.apPage[0].intKey) {
                ByteBuffer pKey = ByteBuffer.allocate((int)pCur.nKey);
                pCur.key(0, (int)pCur.nKey, pKey);
                pCur.pKey = pKey;
            }
            assert (!pCur.apPage[0].intKey || pCur.pKey == null);
            for (int i = 0; i <= pCur.iPage; ++i) {
                SqlJetMemPage.releasePage(pCur.apPage[i]);
                pCur.apPage[i] = null;
            }
            pCur.iPage = -1;
            pCur.eState = CursorState.REQUIRESEEK;
        }
        finally {
            pCur.invalidateOverflowCache();
        }
        return true;
    }

    public void enterCursor() {
        this.pBtree.enter();
    }

    public void leaveCursor() {
        this.pBtree.leave();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CursorState {
        INVALID,
        VALID,
        REQUIRESEEK,
        FAULT;

    }
}

