/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.SVNClient;

public class PropertyData {
    private String name;
    private String value;
    private byte[] data;
    private String path;
    private SVNClient client;
    public static final String MIME_TYPE = "svn:mime-type";
    public static final String IGNORE = "svn:ignore";
    public static final String EOL_STYLE = "svn:eol-style";
    public static final String KEYWORDS = "svn:keywords";
    public static final String EXECUTABLE = "svn:executable";
    public static final String EXECUTABLE_VALUE = "*";
    public static final String EXTERNALS = "svn:externals";
    public static final String REV_AUTHOR = "svn:author";
    public static final String REV_LOG = "svn:log";
    public static final String REV_DATE = "svn:date";
    public static final String REV_ORIGINAL_DATE = "svn:original-date";
    public static final String NEEDS_LOCK = "svn:needs-lock";

    PropertyData(SVNClient cl, String p, String n, String v, byte[] d) {
        this.path = p;
        this.name = n;
        this.value = v;
        this.client = cl;
        this.data = d;
    }

    PropertyData(String p, String n, String v) {
        this.path = p;
        this.name = n;
        this.value = v;
        this.client = null;
        this.data = v.getBytes();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getPath() {
        return this.path;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setValue(String newValue, boolean recurse) throws ClientException {
        this.client.propertySet(this.path, this.name, newValue, recurse);
        this.value = newValue;
        this.data = null;
    }

    public void setValue(byte[] newValue, boolean recurse) throws ClientException {
        this.client.propertySet(this.path, this.name, newValue, recurse);
        this.data = newValue;
        this.value = null;
    }

    public void remove(boolean recurse) throws ClientException {
        this.client.propertyRemove(this.path, this.name, recurse);
    }
}

