package de.ugoe.cs.swe.exercises.tests;

import static org.junit.Assert.*;

import java.util.ArrayList;

import org.junit.Before;
import org.junit.Test;

import de.ugoe.cs.swe.exercises.exercise.Exercise;
import de.ugoe.cs.swe.exercises.exercise.ExerciseSVN;
import de.ugoe.cs.swe.exercises.exercisesheet.SheetGenerator;
import de.ugoe.cs.swe.exercises.lecture.Lecture;
import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;
import de.ugoe.cs.swe.exercises.misc.CKeyword;
import de.ugoe.cs.swe.exercises.misc.Model;

public class SheetGeneratorTest extends BaseTest {

	private SheetGenerator testSheet;
	private ArrayList<CKeyword> testKeywords;
	private Exercise test1;
	private Exercise test2;

	@Before
	public void setUp() throws Exception {
		Model.getConnection(true);
		ExerciseSVN.SVNCheckout();
		Model.flushTables();
		
		testKeywords = new ArrayList<CKeyword>();
		
		Lecture lecture = new Lecture("Vorlesung");
		lecture.save();
		
		LectureEvent le = new LectureEvent(2009,true,lecture.getId());
		le.save();
		
		test1 = new Exercise("Horst's exercise 1", "1 + 1 = 6?", "false", 8,1);
		test2 = new Exercise("Horst's exercise 2", "1 + 1 = 6?", "false", 8,1);
		test1.save();
		test2.save();
		
		testKeywords.add(new CKeyword( "Keyword1", test1.getId()));
		testKeywords.add(new CKeyword( "Keyword2", test1.getId()));
		testKeywords.add(new CKeyword( "Keyword2", test2.getId()));
		
		CKeyword.insertKey(testKeywords.get(0), CKeyword.EXERCISE);
		CKeyword.insertKey(testKeywords.get(1), CKeyword.EXERCISE);
		CKeyword.insertKey(testKeywords.get(2), CKeyword.EXERCISE);
		
		testSheet = new SheetGenerator(10, le, testKeywords, 5);
		
	}

	@Test
	public void testGetMaxComplexity() {
		assertEquals(10, testSheet.getMaxComplexity());
	}

	@Test
	public void testGetLectureEvent() {
		//assertEquals(1, testSheet.getLectureEvent().getId());
	}

	// Test impractical and unrealiable due to used random function
	
	/*
	@Test
	public void testGenerateExercises() {
		
		assertEquals(null , testSheet.generateExercises());
	}
	*/

}
