package de.ugoe.cs.swe.exercises.tests;

import static org.junit.Assert.*;
import org.junit.Test;
import de.ugoe.cs.swe.exercises.lecturer.Lecturer;
import de.ugoe.cs.swe.exercises.misc.Model;

public class LecturerTest extends BaseTest {

	Lecturer test = new Lecturer();
	Lecturer test2 = new Lecturer("Hans", "Wurst", "Master of Disaster");

	@Test
	public void testLecturerInt() {
		Lecturer testInt = new Lecturer();
		assertTrue(testInt instanceof Lecturer);
	}

	@Test
	public void testLecturerIntStringStringString() {
		Lecturer testInt2 = new Lecturer("Hans", "Wurst", "Master of Disaster");
		assertTrue(testInt2 instanceof Lecturer);
	}

	@Test
	public void testSetTitle() {
		test.setTitle("Dr");
		assertTrue(test.getTitle() == "Dr");
	}

	@Test
	public void testGetTitle() {
		assertTrue(test2.getTitle() == "Master of Disaster");
	}

	@Test
	public void testSetFirstName() {
		test.setFirstName("Peter");
		assertTrue(test.getFirstName() == "Peter");
	}

	@Test
	public void testGetFirstName() {
		assertTrue(test2.getFirstName() == "Hans");
	}

	@Test
	public void testSetLastName() {
		test.setLastName("Zwegat");
		assertTrue(test.getLastName() == "Zwegat");
	}

	@Test
	public void testGetLastName() {
		assertTrue(test2.getLastName() == "Wurst");
	}

	@Test
	public void testInsertAndUpdate() {
		Lecturer test1 = new Lecturer("Penner", "Sack", "Master of Puppets");
		Lecturer test3 = new Lecturer("sgfgfg", "gfdfg", "Dr. NO");
		
		assertEquals(test1.getId(), Model.UNDEFINED);
		assertEquals(test3.getId(), Model.UNDEFINED);
		assertEquals(Lecturer.all().size(), 0);
		test1.save();
		assertEquals(Lecturer.all().size(), 1);
		test3.save();
		assertEquals(Lecturer.all().size(), 2);
		
		assertEquals(Lecturer.all().get(0).getId(), test1.getId());
		assertEquals(Lecturer.all().get(1).getId(), test3.getId());
		
		assertEquals(Lecturer.all().get(0).getFirstName(), test1.getFirstName());
		assertEquals(Lecturer.all().get(1).getLastName(), test3.getLastName());
		test1.setFirstName("bla");
		test1.save();
		assertEquals(Lecturer.all().size(), 2);
		assertEquals(Lecturer.all().get(0).getId(), test1.getId());
		assertEquals(Lecturer.all().get(1).getId(), test3.getId());
		assertEquals(Lecturer.all().get(0).getLastName(), test1.getLastName());
		assertEquals(Lecturer.all().get(1).getFirstName(), test3.getFirstName());
		test1.setFirstName("OvO");
		test1.save();
		assertEquals(Lecturer.all().size(), 2);
	}

	@Test
	public void testDelete() {
		Lecturer test1 = new Lecturer("Penner", "Sack", "Master of Puppets");
		test1.save();
		assertEquals(Lecturer.all().size(), 1);
		test1.delete();
		assertEquals(Lecturer.all().size(), 0);
		assertEquals(Model.UNDEFINED, test1.getId());
	}

	@Test
	public void testAll() {
		Lecturer test1 = new Lecturer("Penner", "Sack", "Master of Puppets");
		Lecturer test3 = new Lecturer("sgfgfg", "gfdfg", "Dr. NO");
		test1.save();
		test3.save();
		// ArrayList<Lecturer> lecturers = new ArrayList<Lecturer>();
		// lecturers.add(test1);
		// lecturers.add(test3);
		assertEquals(Lecturer.all().get(0).getId(), test1.getId());
		assertEquals(Lecturer.all().get(1).getId(), test3.getId());
		assertEquals(Lecturer.all().get(0).getFirstName(), test1.getFirstName());
		assertEquals(Lecturer.all().get(1).getLastName(), test3.getLastName());
	}

}