package de.ugoe.cs.swe.exercises.lectureevent;


import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class LectureEventFilter extends ViewerFilter {

	private String searchString;

	public void setSearchText(String s) {
		// Search must be a substring of the existing value
		this.searchString = ".*" + s + ".*";
	}

	//Filters only for first and last name of the lecturer, not the title or ID.
	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (searchString == null || searchString.length() == 0) {
			return true;
		}
		LectureEvent searchelement = (LectureEvent) element;
		if (String.valueOf(searchelement.getSemester()).toLowerCase().matches(searchString.toLowerCase()) || searchelement.getLecture().getName().toLowerCase().matches(searchString.toLowerCase())) {
			return true;
		}
		return false;
	}
}
