package de.ugoe.cs.swe.exercises.lectureevent;

import java.util.ArrayList;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;
import de.ugoe.cs.swe.exercises.exercisesheet.ExerciseSheet;
import de.ugoe.cs.swe.exercises.lecture.GUITreeView;
import de.ugoe.cs.swe.exercises.lecturer.Lecturer;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Group;

public class LectureEventComposite extends Composite {
	private LectureEvent selected = null;
	private TableViewer listLecturersViewer;
	private CCombo lecturersCombo;
	private ArrayList<Lecturer> lecturers;
	private Text yearText;
	private Button btnSs, btnWs;

	public LectureEventComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));

		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false,
				1, 1));
		GridLayout gridLayout = new GridLayout(3, false);
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		composite.setLayout(gridLayout);

		Label lblYear = new Label(composite, SWT.NONE);
		lblYear.setText("Year:");

		yearText = new Text(composite, SWT.BORDER);
		yearText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false,
				1, 1));

		Group group = new Group(composite, SWT.NONE);
		group
				.setLayoutData(new GridData(SWT.LEFT, SWT.FILL, false, false,
						1, 1));
		GridLayout gridLayout_1 = new GridLayout(2, false);
		gridLayout_1.marginWidth = 0;
		gridLayout_1.marginHeight = 0;
		group.setLayout(gridLayout_1);
		btnWs = new Button(group, SWT.RADIO);
		btnWs.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1,
				1));
		btnWs.setText("WS");
		btnSs = new Button(group, SWT.RADIO);
		btnSs.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, true, false, 1,
				1));
		btnSs.setText("SS");
		new Label(this, SWT.NONE);

		final Table listLecturersTable = new Table(this, SWT.MULTI | SWT.BORDER);
		{
			GridData gridData = new GridData(SWT.FILL, SWT.FILL, true, true, 1,
					1);
			gridData.minimumHeight = 100;
			listLecturersTable.setLayoutData(gridData);
		}
		listLecturersTable.setHeaderVisible(true);
		TableColumn col = new TableColumn(listLecturersTable, SWT.LEFT, 0);
		col.setWidth(200);
		col.setText("Lecturers");

		listLecturersViewer = new TableViewer(listLecturersTable);

		Button btnRemoveLecturer = new Button(this, SWT.NONE);
		btnRemoveLecturer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				StructuredSelection sel = ((StructuredSelection) listLecturersViewer
						.getSelection());

				Object[] fuckdisshit = sel.toArray();

				for (int i = 0; i < fuckdisshit.length; i++) {

					selected.removeLecturer((Lecturer) fuckdisshit[i]);
				}
				listLecturersViewer.refresh();
			}
		});
		btnRemoveLecturer.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM,
				false, false, 1, 1));
		btnRemoveLecturer.setText("Remove lecturer");

		lecturersCombo = new CCombo(this, SWT.BORDER);
		lecturersCombo.setEditable(false);
		lecturersCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));

		Button btnAddLecturer = new Button(this, SWT.NONE);
		btnAddLecturer.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				if (lecturersCombo.getSelectionIndex() < 0)
					return;

				selected.addLecturer(lecturers.get(lecturersCombo
						.getSelectionIndex()));
				listLecturersViewer.refresh();
			}

		});
		btnAddLecturer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false,
				false, 1, 1));
		btnAddLecturer.setText("Add lecturer");
		new Label(this, SWT.NONE);

		Button newExerciseSheet = new Button(this, SWT.NONE);
		newExerciseSheet.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				ExerciseSheet exerciseSheet = new ExerciseSheet(selected);
				exerciseSheet.save();
				TreeItem item = new TreeItem(GUITreeView.getTree()
						.getSelection()[0], SWT.NONE);
				item.setData(exerciseSheet);
				item.setText("New Sheet");
				GUITreeView.getTree().setSelection(item);
				GUITreeView.switchComposite();
			}
		});
		newExerciseSheet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER,
				false, false, 1, 1));
		newExerciseSheet.setText("New Sheet");

		GridData gridData = new GridData(GridData.FILL_BOTH
				| GridData.VERTICAL_ALIGN_BEGINNING);
		gridData.horizontalSpan = 1;
		gridData.verticalSpan = 2;
		listLecturersViewer
				.setContentProvider(new LectureEventLecturerContentProvider());
		listLecturersViewer
				.setLabelProvider(new LectureEventLecturerLabelProvider());
		listLecturersViewer.setInput(new Object());
		listLecturersViewer.refresh();
	}

	public void load(LectureEvent lectureEvent) {
		this.selected = lectureEvent;

		yearText.setText(String.valueOf(selected.getSemester()));

		btnSs.setSelection(this.selected.getIsSummerSemester());
		btnWs.setSelection(!this.selected.getIsSummerSemester());

		listLecturersViewer
				.setContentProvider(new LectureEventLecturerContentProvider(
						selected));
		listLecturersViewer.refresh();
		lecturers = Lecturer.all();
		lecturersCombo.removeAll();
		for (Lecturer lecturer : lecturers) {
			lecturersCombo.add(lecturer.toString());
		}
	}

	public void save() {
		if (this.selected == null)
			return;

		int year = -1;
		try {
			year = Integer.parseInt(yearText.getText());
		} catch (Exception exception) {
		}

		if (year < 2000 || year > 10000) {
			MessageBox validationMessageBox = new MessageBox(getShell(), SWT.OK);
			validationMessageBox.setText("Invalid form data");
			validationMessageBox
					.setMessage("Please enter a valid year (a four-digit number like \"2009\").");
			validationMessageBox.open();
			return;
		}

		selected.setSemester(year);
		selected.setIsSummerSemester(btnSs.getSelection());
		selected.save();
		GUITreeView.getTree().getSelection()[0].setText(selected.getLecture()
				.getName()
				+ " " + selected.getSemesterString() + selected.getSemester());
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
}
