package de.ugoe.cs.swe.exercises.lecture;


import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Label;

import de.ugoe.cs.swe.exercises.misc.CKeyword;
import de.ugoe.cs.swe.exercises.misc.KeywordsCompositeExtender;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ModifyEvent;


public class LectureComposite extends Composite {
	Text textName;
	Lecture selected = null;
	KeywordsCompositeExtender keywordsExtender;

	/**
	 * Create the composite.
	 * 
	 * @param this
	 * @param style
	 */
	public LectureComposite(Composite parent, int style) {
		super(parent, style);
		setLayout(new GridLayout(2, false));

		Composite composite = new Composite(this, SWT.NONE);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false,
				1, 1));
		GridLayout gridLayout = new GridLayout(2, false);
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		composite.setLayout(gridLayout);

		Label label = new Label(composite, SWT.NONE);
		label.setText("Name:");
		label.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false,
				1, 1));
		new Label(this, SWT.NONE);

		textName = new Text(composite, SWT.SINGLE | SWT.BORDER);
		textName.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				GUITreeView.getTree().getSelection()[0].setText(textName.getText());
			}
		});
		textName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false,
				1, 1));

		keywordsExtender = new KeywordsCompositeExtender(this, CKeyword.LECTURE);
	}

	public void load(Lecture lecture) {
		this.selected = lecture;
		textName.setText(lecture.getName());
		keywordsExtender.load(lecture);
	}

	public void save() {
		if (this.selected == null)
			return;
		selected.setName(textName.getText());
		selected.save();
	}

	@Override
	protected void checkSubclass() {
		// Disable the check that prevents subclassing of SWT components
	}
}
