package de.ugoe.cs.swe.exercises.lecture;

import java.util.ArrayList;

import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.TreeItem;

import de.ugoe.cs.swe.exercises.exercisesheet.ExerciseSheet;
import de.ugoe.cs.swe.exercises.exercisesheet.ExerciseSheetComposite;
import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;
import de.ugoe.cs.swe.exercises.lectureevent.LectureEventComposite;
import de.ugoe.cs.swe.exercises.misc.Model;

import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.custom.SashForm;

public class GUITreeView extends ViewPart {

	private static Tree tree;
	private static Menu menu;

	public static Tree getTree() {
		return tree;
	}

	private static Group group;
	private static StackLayout layout = new StackLayout();
	final static Composite[] composites = new Composite[3];
	private Button btnSaveChanges;
	private SashForm sashForm;
	private Button addLectureButton;
	private Button deleteLectureButton;

	public GUITreeView() {
	}

	@Override
	public void createPartControl(Composite parent) {

		parent.setLayout(new GridLayout(3, false));

		tree = new Tree(parent, SWT.BORDER);
		tree.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				switchComposite();
			}
		});

		menu = new Menu(tree);
		tree.setMenu(menu);
		final MenuItem add = new MenuItem(menu, SWT.NONE);
		add.setText("Add");
		add.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Model model = (Model) tree.getSelection()[0].getData();
				if (model instanceof Lecture) {

					LectureEvent lectureEvent = new LectureEvent(2009, false,
							(Lecture) model);
					lectureEvent.save();
					TreeItem item = new TreeItem(tree.getSelection()[0],
							SWT.NONE);
					item.setData(lectureEvent);
					item.setText(lectureEvent.getLecture().getName()
							+ " WS2009");
					GUITreeView.getTree().setSelection(item);
					GUITreeView.switchComposite();

				} else {
					ExerciseSheet exerciseSheet;
					TreeItem item;
					if (model instanceof LectureEvent) {
						exerciseSheet = new ExerciseSheet((LectureEvent) model);
						exerciseSheet.save();
						item = new TreeItem(tree.getSelection()[0], SWT.NONE);
					} else {
						exerciseSheet = new ExerciseSheet(
								((ExerciseSheet) model).getLectureEvent());
						exerciseSheet.save();
						item = new TreeItem(GUITreeView.getTree()
								.getSelection()[0].getParentItem(), SWT.NONE);
					}
					item.setData(exerciseSheet);
					item.setText("New Sheet");
					GUITreeView.getTree().setSelection(item);
					GUITreeView.switchComposite();
				}

			}
		});

		MenuItem delete = new MenuItem(menu, SWT.NONE);
		delete.setText("Delete");
		delete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Model model = (Model) tree.getSelection()[0].getData();
				model.delete();
				tree.getSelection()[0].removeAll();
				tree.getSelection()[0].dispose();
			}
		});

		tree.setLinesVisible(true);
		{
			GridData gridData_1 = new GridData(SWT.FILL, SWT.FILL, false, true,
					2, 1);
			gridData_1.widthHint = 400;
			gridData_1.minimumWidth = 400;
			tree.setLayoutData(gridData_1);
		}

		group = new Group(parent, SWT.NONE);
		group.setLayout(layout);
		group.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

		/*
		 * GridLayout gridLayout = new GridLayout(1, false);
		 * gridLayout.marginHeight = 0; gridLayout.marginWidth = 0;
		 * group.setLayout(gridLayout);
		 */

		composites[0] = new LectureComposite(group, SWT.NONE);
		composites[1] = new LectureEventComposite(group, SWT.NONE);
		composites[2] = new ExerciseSheetComposite(group, SWT.NONE);

		refreshTree();
		if (tree.getItemCount() > 0)
			tree.setSelection(tree.getItem(0));

		sashForm = new SashForm(parent, SWT.NONE);
		sashForm.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM, false, false,
				2, 1));

		addLectureButton = new Button(sashForm, SWT.NONE);
		addLectureButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				Lecture lecture = new Lecture("New Lecture");
				lecture.save();
				TreeItem lectureItem = new TreeItem(GUITreeView.tree, SWT.NONE);
				lectureItem.setText("New lecture");
				lectureItem.setData(lecture);
				GUITreeView.tree.select(lectureItem);
				GUITreeView.switchComposite();
			}
		});
		addLectureButton.setText("Add lecture");

		deleteLectureButton = new Button(sashForm, SWT.NONE);
		deleteLectureButton.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				TreeItem itemIt = tree.getSelection()[0];
				while (itemIt.getParentItem() != null)
					itemIt = itemIt.getParentItem();
				itemIt.removeAll();
				Model model = (Model) itemIt.getData();
				model.delete();
				itemIt.dispose();
			}
		});
		deleteLectureButton.setText("Delete lecture");
		sashForm.setWeights(new int[] { 1, 1 });

		btnSaveChanges = new Button(parent, SWT.NONE);
		btnSaveChanges.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				save();
			}
		});
		btnSaveChanges.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false,
				false, 1, 1));
		btnSaveChanges.setText("Save changes");
		switchComposite();
	}

	public static void refreshTree() {
		tree.removeAll();

		ArrayList<Lecture> lectureList = Lecture.all();
		if (lectureList == null)
			return;
		ArrayList<LectureEvent> lectureEventList;
		ArrayList<ExerciseSheet> exerciseSheetList;

		TreeItem lectureTree;
		TreeItem lectureEventTree;
		TreeItem exerciseSheetTree;

		for (int i = 0; i < lectureList.size(); i++) {
			lectureTree = new TreeItem(tree, SWT.NONE);
			lectureTree.setData(lectureList.get(i));
			lectureTree.setText("" + lectureList.get(i).getName());

			lectureEventList = lectureList.get(i).getLectureEvents();
			if (lectureEventList == null)
				continue;
			for (int j = 0; j < lectureEventList.size(); j++) {
				lectureEventTree = new TreeItem(lectureTree, SWT.NONE);
				lectureEventTree.setData(lectureEventList.get(j));
				String sem;
				if (lectureEventList.get(j).getIsSummerSemester())
					sem = "SS";
				else
					sem = "WS";
				lectureEventTree.setText(""
						+ lectureEventList.get(j).getLecture().getName() + " "
						+ sem + "" + lectureEventList.get(j).getSemester());

				exerciseSheetList = lectureEventList.get(j).getExerciseSheets();
				if (exerciseSheetList == null)
					continue;
				for (int k = 0; k < exerciseSheetList.size(); k++) {
					exerciseSheetTree = new TreeItem(lectureEventTree, SWT.NONE);
					exerciseSheetTree.setData(exerciseSheetList.get(k));
					exerciseSheetTree.setText("Sheet "
							+ exerciseSheetList.get(k).getNumber());

				}
			}
		}
	}

	public static void switchComposite() {
		if (tree.getSelection().length == 0)
			return;
		
		Model model = (Model) tree.getSelection()[0].getData();
		
		if (model instanceof Lecture) {
			layout.topControl = composites[0];
			((LectureComposite) composites[0]).load((Lecture) model);
		} else if (model instanceof LectureEvent) {
			layout.topControl = composites[1];
			((LectureEventComposite) composites[1]).load((LectureEvent) model);
		} else if (model instanceof ExerciseSheet) {
			layout.topControl = composites[2];
			((ExerciseSheetComposite) composites[2])
					.load((ExerciseSheet) model);
		}
		for (int i = 0; i < 3; i++) {
			composites[i].setLayoutData(new GridData(SWT.FILL, SWT.FILL, true,
					true, 1, 1));
		}
		group.layout();
		
		
	}

	private void save() {
		if (layout.topControl instanceof LectureComposite) {
			// Lecture
			((LectureComposite) layout.topControl).save();
		} else if (layout.topControl instanceof LectureEventComposite) {
			// LectureEvent
			((LectureEventComposite) layout.topControl).save();
		} else if (layout.topControl instanceof ExerciseSheetComposite) {
			// TODO: ExerciseSheetComposite
			((ExerciseSheetComposite) layout.topControl).save();
		} else if (layout.topControl instanceof LectureComposite) {
			// TODO: ExerciseComposite
			((LectureComposite) layout.topControl).save();
		}

	}

	/*
	 * private int getId() { return
	 * (int)((Integer)(tree.getSelection()[0]).getData()); }
	 */

	@Override
	public void setFocus() {
	}
}
