package de.ugoe.cs.swe.exercises.exercisesheet;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.regex.Matcher;

import org.eclipse.jface.util.Util;
import org.eclipse.swt.widgets.Shell;

import de.ugoe.cs.swe.exercises.exercise.Exercise;
import de.ugoe.cs.swe.exercises.exercise.ExerciseSVN;
import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;
import de.ugoe.cs.swe.exercises.lecturer.Lecturer;
import de.ugoe.cs.swe.exercises.misc.FileUtils;
import de.ugoe.cs.swe.exercises.svn.SettingsDialog;

public class PdfGenerator {
	public static void generatePdf(ExerciseSheet exercisesheet, String path,
			boolean copyFile, boolean makeExerciseInsteadOfSolution) {
		ExerciseSVN.SVNCheckout(exercisesheet.returnMaxRevision());
		if (!path.endsWith(".pdf"))
			path += ".pdf";

		SettingsDialog settings = new SettingsDialog(new Shell());
		ArrayList<String> cmdList = new ArrayList<String>();

		String cmd = "\"" + settings.getmyPDFLatexPath() + "\""
				+ " -halt-on-error -output-directory=\"";
		try {
			File latexFile = File.createTempFile("exercise", ".tex");

			cmdList.add(settings.getmyPDFLatexPath());
			cmdList.add("-halt-on-error");
			cmdList.add("-output-directory=" + latexFile.getParent());
			cmdList.add(latexFile.getAbsolutePath());

			cmd += latexFile.getParent() + "\" \""
					+ latexFile.getAbsolutePath() + "\"";

			String filename = ExerciseSVN.SVNpath + "/template-";

			if (exercisesheet.isExamination()) {
				filename += "klausur";
			} else {
				filename += "uebung";
			}

			filename += ".tex";

			File templateFile = new File(filename);
			String template = "";
			FileInputStream fstream = new FileInputStream(templateFile);
			BufferedReader dstream = new BufferedReader(new InputStreamReader(
					fstream, "UTF8"));
			String line;
			while ((line = dstream.readLine()) != null) {
				template += line + "\n";
			}
			dstream.close();

			LectureEvent event = exercisesheet.getLectureEvent();
			ArrayList<Lecturer> lecturers = event.getLecturers();
			String lecturersString = "";
			boolean firstRun = true;
			for (Lecturer lecturer : lecturers) {
				if (!firstRun)
					lecturersString += ", ";
				lecturersString += lecturer.toString();
				firstRun = false;
			}
			if (lecturersString == "")
				lecturersString = "!NO LECTURERS FOUND!";

			ArrayList<Exercise> exercises = exercisesheet.getExercises();
			String exercisesString = "";
			for (Exercise exercise : exercises) {
				String text;
				if (makeExerciseInsteadOfSolution)
					text = exercise.getExerciseText(exercisesheet
							.returnMaxRevision());
				else
					text = exercise.getSolution(exercisesheet
							.returnMaxRevision());
				exercisesString += "\n\\section{" + exercise.getTitle() + "}\n"
						+ text;
			}

			String examorunit = "";

			if (exercisesheet.isExamination()) {
				examorunit = "Prüfung";
			} else {
				examorunit = "Übungszettel";
			}

			template = template.replaceAll("(\\W)LECTURE(\\W)", "$1"
					+ Matcher.quoteReplacement(event.toString()) + "$2");
			template = template.replaceAll("(\\W)LECTURERS(\\W)", "$1"
					+ Matcher.quoteReplacement(lecturersString) + "$2");
			template = template.replaceAll("(\\W)EXAMORUNIT(\\W)", "$1"
					+ Matcher.quoteReplacement(examorunit) + "$2");
			template = template.replaceAll("(\\W)SHEETNUMBER(\\W)", "$1"
					+ Matcher.quoteReplacement(String.valueOf(exercisesheet
							.getNumber())) + "$2");
			template = template.replaceAll("(\\W)EXERCISES(\\W)", "$1"
					+ Matcher.quoteReplacement(exercisesString) + "$2");

			FileOutputStream ofstream = new FileOutputStream(latexFile);
			BufferedWriter odstream = new BufferedWriter(
					new OutputStreamWriter(ofstream, "UTF8"));
			odstream.write(template);
			odstream.close();
			ProcessBuilder pb;
			if (Util.isLinux())
				pb = new ProcessBuilder(cmdList);
			else
				pb = new ProcessBuilder(cmd);

			// pb.directory(latexFile.getParentFile());

			Process p = pb.start();

			Scanner s = new Scanner(p.getInputStream()).useDelimiter("\n");
			while (s.hasNext()) {
				System.out.println(s.next());
			}

			// try {
			// p.waitFor();
			// } catch (InterruptedException e) {
			// // TODO Auto-generated catch block
			// e.printStackTrace();
			// }

			File f = new File(path);

			FileUtils.copyFile(new File(latexFile.getAbsolutePath().replaceAll(
					".tex$", ".pdf")), f);

			if (copyFile)
				FileUtils.copyFile(f, new File(ExerciseSVN.SVNpath
						+ "exercisesheets/" + f.getName()));

		} catch (IOException e) {
			e.printStackTrace();
			// } catch (InterruptedException e) {
			// // TODO Auto-generated catch block
			// e.printStackTrace();
		}
	}

}
