package de.ugoe.cs.swe.exercises.exercisesheet;


import java.awt.Desktop;
import java.io.File;
import java.io.IOException;


import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;


public class ExerciseSheetPDFDialog extends TitleAreaDialog {

	private String lectureName;
	private Shell shell;
	private static String fileName;

	public String getLecture() {
		return lectureName;
	}

	public ExerciseSheetPDFDialog(Shell parentShell, String file) {
		super(parentShell);
		super.setShellStyle(0);
		if(!file.endsWith(".pdf"))
			file += ".pdf";
		ExerciseSheetPDFDialog.fileName = file;
		this.shell = parentShell;
		shell.setEnabled(false);
	}

	@Override
	protected Control createContents(Composite parent) {
		Control contents = super.createContents(parent);
		setTitle("PDF created");
		File file = new File(fileName);
		setMessage("PDF " + file.getName() + " was successfully created.",
				IMessageProvider.INFORMATION);
		return contents;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		parent.getShell().setSize(500, 170);
		int x = shell.getLocation().x
				+ (shell.getSize().x - parent.getShell().getSize().x) / 2;
		int y = shell.getLocation().y
				+ (shell.getSize().y - parent.getShell().getSize().y) / 2;
		parent.getShell().setLocation(x, y);

		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		parent.setLayout(layout);
		Label label1 = new Label(parent, SWT.NONE);
		label1.setText("Do you want to open the PDF?");

		GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
		gd.horizontalSpan = 1;

		return parent;

	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		((GridLayout) parent.getLayout()).numColumns = 2;

		GridData buttonlayout = new GridData(SWT.LEFT, SWT.BEGINNING, false,
				false);
		buttonlayout.minimumWidth = 200;
		Button button = new Button(parent, SWT.PUSH);
		button.setText("OK");
		button.setFont(JFaceResources.getDialogFont());
		button.setLayoutData(buttonlayout);
		button.addSelectionListener(new SelectionAdapter() {
			

			@Override
			public void widgetSelected(SelectionEvent e) {

				try {
					Desktop d = Desktop.getDesktop();
					d.open(new File(ExerciseSheetPDFDialog.fileName));
				} catch (IOException e1) {
					// TODO Auto-generated catch block
					System.err.println(e1);
				}
				shell.setEnabled(true);
				close();

			}
		});
		Button cancel = new Button(parent, SWT.PUSH);
		cancel.setText("Cancel");
		cancel.setFont(JFaceResources.getDialogFont());
		cancel.setLayoutData(buttonlayout);
		cancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.setEnabled(true);
				close();
			}
		});
	}
}