package de.ugoe.cs.swe.exercises.exercisesheet;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;

public class ExerciseSheetAddDialog extends TitleAreaDialog {

	private Text editNumber;
	private Text editRevision;
	private Text editMaxComplexity;
	private int comboresultIsExam;
	private int comboresultLectureEvent;
	private int[] exerciseSheet = {-1, -1, -1, -1, -1};
	int[] lectureEventsListId;
	private ArrayList<LectureEvent> lectureEvents = new ArrayList<LectureEvent>();
	private Shell shell;
	public int[] getExerciseSheet() {
		return exerciseSheet;
	}

	public LectureEvent getComboResultLectureEvent() {
		return lectureEvents.get(comboresultLectureEvent);
	}
	
	public ExerciseSheetAddDialog(Shell parentShell) {
		super(parentShell);
		super.setShellStyle(0);
		this.shell = parentShell;
		shell.setEnabled(false);
	}

	@Override
	protected Control createContents(Composite parent) {
		parent.getShell().setSize(650, 350);
		int x = shell.getLocation().x + (shell.getSize().x - parent.getShell().getSize().x)/2;
		int y = shell.getLocation().y + (shell.getSize().y - parent.getShell().getSize().y)/2;
		parent.getShell().setLocation(x, y);
		
		Control contents = super.createContents(parent);
		setTitle("Add a new exercise sheet");
		setMessage("Please enter all the data for the new exercise sheet",
				IMessageProvider.INFORMATION);
		return contents;
	}

	@Override
	protected Control createDialogArea(Composite parent) {
		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		parent.setLayout(layout);
		Label labelNumber = new Label(parent, SWT.NONE);
		labelNumber.setText("Number");
		Text textboxNumber = new Text(parent, SWT.BORDER);
		textboxNumber.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
		textboxNumber.addListener(SWT.Verify, new Listener() {
		      public void handleEvent(Event e) {
		        String string = e.text;
		        char[] chars = new char[string.length()];
		        string.getChars(0, chars.length, chars, 0);
		        for (int i = 0; i < chars.length; i++) {
		          if (!('0' <= chars[i] && chars[i] <= '9')) {
		            e.doit = false;
		            return;
		          }
		        }
		      }
		    });
		editNumber = textboxNumber;
		
		Label labelRevision = new Label(parent, SWT.NONE);
		labelRevision.setText("Revision");
		Text textboxRevision = new Text(parent, SWT.BORDER);
		textboxRevision.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
		textboxRevision.addListener(SWT.Verify, new Listener() {
		      public void handleEvent(Event e) {
		        String string = e.text;
		        char[] chars = new char[string.length()];
		        string.getChars(0, chars.length, chars, 0);
		        for (int i = 0; i < chars.length; i++) {
		          if (!('0' <= chars[i] && chars[i] <= '9')) {
		            e.doit = false;
		            return;
		          }
		        }
		      }
		    });
		editRevision = textboxRevision;
		
		Label labelMaxComplexity = new Label(parent, SWT.NONE);
		labelMaxComplexity.setText("Desired Complexity:");
		Text textboxMaxComplexity = new Text(parent, SWT.BORDER);
		textboxMaxComplexity.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
		textboxMaxComplexity.addListener(SWT.Verify, new Listener() {
		      public void handleEvent(Event e) {
		        String string = e.text;
		        char[] chars = new char[string.length()];
		        string.getChars(0, chars.length, chars, 0);
		        for (int i = 0; i < chars.length; i++) {
		          if (!('0' <= chars[i] && chars[i] <= '9')) {
		            e.doit = false;
		            return;
		          }
		        }
		      }
		    });
		editMaxComplexity = textboxMaxComplexity;

		Label labelIsExam = new Label(parent, SWT.NONE);
		labelIsExam.setText("Is this an exam?");

		final Combo comboIsExam = new Combo(parent, SWT.READ_ONLY);
		comboIsExam.setItems(new String[] { "No", "Yes" });
		comboIsExam.setSize(200, 200);

		comboIsExam.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				comboresultIsExam = comboIsExam.getSelectionIndex();

			}

			public void widgetDefaultSelected(SelectionEvent e) {
				comboresultIsExam = -1;
			}
		});

		Label labelLecture = new Label(parent, SWT.NONE);
		labelLecture.setText("LectureEvent");
		lectureEvents = LectureEvent.all();
		String[] lecturesList = new String[lectureEvents.toArray().length];
		lectureEventsListId = new int[lectureEvents.toArray().length];

		for (int i = 0; i < lecturesList.length; i++) {
			lecturesList[i] = (lectureEvents.get(i).getLecture().getName() + ", " + lectureEvents.get(i).getIsSummerSemester() + " " + lectureEvents.get(i).getSemester() );
			lectureEventsListId[i] = lectureEvents.get(i).getId();
		}

		final Combo comboLecture = new Combo(parent, SWT.READ_ONLY);
		comboLecture.setItems(lecturesList);
		comboLecture.setSize(200, 200);
		comboLecture.addSelectionListener(new SelectionListener() {
			public void widgetSelected(SelectionEvent e) {
				comboresultLectureEvent = comboLecture.getSelectionIndex();
			}

			public void widgetDefaultSelected(SelectionEvent e) {
				comboresultLectureEvent = -1;
			}
		});

		return parent;

	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		((GridLayout) parent.getLayout()).numColumns = 2;

		GridData buttonlayout = new GridData(SWT.LEFT, SWT.BEGINNING, false,
				false);
		buttonlayout.minimumWidth = 200;
		Button buttonOk = new Button(parent, SWT.PUSH);
		buttonOk.setText("OK");
		buttonOk.setFont(JFaceResources.getDialogFont());
		buttonOk.setLayoutData(buttonlayout);
		buttonOk.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {

				if (editNumber.getText().length() != 0 ) {
					exerciseSheet[0] = Integer.parseInt(editNumber.getText());
					exerciseSheet[1] = Integer.parseInt(editRevision.getText());
					exerciseSheet[2] = Integer.parseInt(editMaxComplexity.getText());
					exerciseSheet[3] = comboresultIsExam;
					exerciseSheet[4] = lectureEventsListId[comboresultLectureEvent];

					shell.setEnabled(true);
					close();

				} else {
					setErrorMessage("Please fill out all the data");
				}
			}
		});
		Button buttonCancel = new Button(parent, SWT.PUSH);
		buttonCancel.setText("Cancel");
		buttonCancel.setFont(JFaceResources.getDialogFont());
		buttonCancel.setLayoutData(buttonlayout);
		buttonCancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.setEnabled(true);
				close();
			}
		});
	}

}