package de.ugoe.cs.swe.exercises.exercise;

import java.io.File;
import java.io.IOException;
import org.eclipse.swt.widgets.Shell;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

import de.ugoe.cs.swe.exercises.misc.FileUtils;
import de.ugoe.cs.swe.exercises.svn.*;

public class ExerciseSVN {
	private static SettingsDialog svnSettings = new SettingsDialog(new Shell());
	private static String url = svnSettings.getSVNLocation();
	private static String userName = svnSettings.getSVNUsername();
	private static String passWord = svnSettings.getSVNPassword();
	public static String SVNpathRev = System.getProperty("user.home") + "/"
			+ svnSettings.getWorkingDirectory() + "/REVISION";
	public static String SVNpath = System.getProperty("user.home") + "/"
			+ svnSettings.getWorkingDirectory() + "/";

	public static void SVNCheckout(int revnumber) {

//		System.out.println("Checked out old revision #" + revnumber);
		DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(false);
		DAVRepositoryFactory.setup();

		SVNClientManager ourClientManager = SVNClientManager.newInstance(
				options, userName, passWord);
		SVNUpdateClient updateClient = ourClientManager.getUpdateClient();

		File dstPath = new File(SVNpathRev);

		String tmp = Integer.toString(revnumber);

		try {

			updateClient.doCheckout(SVNURL.parseURIDecoded(url), dstPath,
					SVNRevision.parse(tmp), SVNRevision.parse(tmp),
					SVNDepth.INFINITY, true);
		} catch (SVNException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static void SVNCheckout() {

		DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(false);
		DAVRepositoryFactory.setup();

		SVNClientManager ourClientManager = SVNClientManager.newInstance(
				options, userName, passWord);
		SVNUpdateClient updateClient = ourClientManager.getUpdateClient();

		File dstPath = new File(SVNpath);

		try {

			updateClient
					.doCheckout(SVNURL.parseURIDecoded(url), dstPath,
							SVNRevision.HEAD, SVNRevision.HEAD,
							SVNDepth.INFINITY, true);
		} catch (SVNException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@SuppressWarnings("deprecation")
	public static long SVNcommit() {

		SVNCommitInfo commitInfo = null;

		DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(false);
		DAVRepositoryFactory.setup();

		SVNClientManager ourClientManager = SVNClientManager.newInstance(
				options, userName, passWord);

		SVNCommitClient commitClient = ourClientManager.getCommitClient();
		File[] fileArray = new File[1];
		fileArray[0] = new File(SVNpath);
		SVNCommitPacket commitPacket;
		try {
			commitPacket = commitClient.doCollectCommitItems(fileArray, true,
					true, true);

			// System.out.println(commitPacket);
			// System.out.println("-");
			commitInfo = (commitClient.doCommit(commitPacket, true,
					"added files"));
			System.out.println(commitInfo);
		} catch (SVNException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return commitInfo.getNewRevision();

	}

	public static long SVNAdd(File[] file) throws IOException, SVNException {

		DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(false);
		DAVRepositoryFactory.setup();

		SVNClientManager ourClientManager = SVNClientManager.newInstance(
				options, userName, passWord);

		SVNWCClient ourWCClient = new SVNWCClient(ourClientManager, options);
		ourWCClient.doAdd(file[0], true, false, true, SVNDepth.INFINITY, true,
				true);
		ourWCClient.doAdd(file[1], true, false, true, SVNDepth.INFINITY, true,
				true);
		ExerciseSVN.SVNUpdate();
		int revNumber = (int) ExerciseSVN.SVNcommit();

		return revNumber;

	}

	public static void SVNAdd(String oldName, String newName) {
		if (!oldName.endsWith(".pdf"))
			oldName += ".pdf";
		if (!newName.endsWith(".pdf"))
			newName += ".pdf";

		newName = newName.replaceAll(" ", "_");

		// String mv = "mv " + SVNpath + "exercisesheets/" + oldName + " "
		// + SVNpath + "exercisesheets/" + newName;

		FileUtils.renameFile(oldName, newName);

		// try {
		// Runtime.getRuntime().exec(mv);
		// } catch (IOException e1) {
		// System.err.println(e1);
		// }

		File file = new File(SVNpath + "exercisesheets/" + newName);

		DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(false);
		DAVRepositoryFactory.setup();

		SVNClientManager ourClientManager = SVNClientManager.newInstance(
				options, userName, passWord);

		SVNWCClient ourWCClient = new SVNWCClient(ourClientManager, options);
		try {
			ourWCClient.doAdd(file, true, false, true, SVNDepth.INFINITY, true,
					false);
		} catch (SVNException e) {
			// TODO Auto-generated catch block
			System.err.println(e);
		}

		ExerciseSVN.SVNUpdate();
		ExerciseSVN.SVNcommit();

	}

	public static void SVNUpdate() {
		DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(false);
		DAVRepositoryFactory.setup();

		SVNClientManager ourClientManager = SVNClientManager.newInstance(
				options, userName, passWord);
		SVNUpdateClient updateClient = ourClientManager.getUpdateClient();

		File dstPath = new File(SVNpath);

		try {
			updateClient.doUpdate(dstPath, SVNRevision.HEAD, SVNDepth.INFINITY,
					true, true);
		} catch (SVNException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@SuppressWarnings("deprecation")
	public static void SVNExport(File file, int revisionnumber) {
		DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(false);
		DAVRepositoryFactory.setup();

		SVNClientManager ourClientManager = SVNClientManager.newInstance(
				options, userName, passWord);
		SVNUpdateClient updateClient = ourClientManager.getUpdateClient();

		File dstPath = new File(SVNpath);

		SVNRevision svnrev = SVNRevision.create(revisionnumber);

		try {
			updateClient.doExport(file, dstPath, SVNRevision.HEAD, svnrev,
					"/n", true, true);
		} catch (SVNException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	public static void setPassWord(String passWord) {
		ExerciseSVN.passWord = passWord;
	}

	public static String getPassWord() {
		return passWord;
	}

	public static void setUserName(String userName) {
		ExerciseSVN.userName = userName;
	}

	public static String getUserName() {
		return userName;
	}

	public static void setUrl(String url) {
		ExerciseSVN.url = url;
	}

	public static String getUrl() {
		return url;
	}

	public static String getTextFromSVN(int revisionnumber) {
		// TODO Auto-generated method stub
		return "";
	}

	// public static void SVNInit() {
	//		
	// System.out.println("pre init");
	// ExerciseSVN.SVNCheckout();
	// System.out.println("checkout done");
	// ArrayList<Exercise > exercises = Exercise.all();
	// System.out.println("arrayklist done");
	// for (int i=0;i<exercises.size();i++){
	//			
	// System.out.println("id von: " + i + ": " +exercises.get(i).getId());
	// exercises.get(i).saveToDisk();
	// System.out.println("savetodisk");
	// exercises.get(i).readFromDisk();
	// System.out.println("readfromdisk");
	// }
	// System.out.println("init done");
	//		
	// }

}
