package de.ugoe.cs.swe.exercises.misc;

import de.ugoe.cs.swe.exercises.exercise.Exercise;

public class QuickSort {

	Integer[] arr;
	Exercise[] exercises;
	
	public Integer[] getArr() {
		return arr;
	}
	
	public Exercise[] getExercises() {
		return exercises;
	}
	
	private int partition(Integer arr[], int left, int right, Exercise[] exercises)	{
		int i = left, j = right;
		int tmp;
		int pivot = arr[(left + right) / 2];
		Exercise tmpE;

		while (i <= j) {
			while (arr[i] < pivot)
				i++;
			while (arr[j] > pivot)
				j--;
			if (i <= j) {
				tmpE = exercises[i];
				tmp = arr[i];
				exercises[i] = exercises[j];
				arr[i] = arr[j];
				exercises[j] = tmpE;
				arr[j] = tmp;
				i++;
				j--;
			}
		}
		return i;
	}

	public void quickSort(Integer[] arr1, int left, int right, Exercise[] exercises1) {
		if(arr1.length < 1 || exercises1.length < 1) {
			return;
		}
		arr = arr1;
		exercises = exercises1;
		int index = partition(arr, left, right, exercises);
		if (left < index - 1)
			quickSort(arr, left, index - 1, exercises);
		if (index < right)
			quickSort(arr, index, right, exercises);
	}
}