package de.ugoe.cs.swe.exercises.lecturer;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class LecturerFilter extends ViewerFilter {

	private String searchString;

	public void setSearchText(String s) {
		// Search must be a substring of the existing value
		if (s == null || s.equals("")) {
			this.searchString = s;
			return;
		}
		
		this.searchString = ".*" + s + ".*";
	}

	// Filters only for first and last name of the lecturer, not the title or
	// ID.
	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (searchString == null || searchString.length() == 0) {
			return true;
		}
		Lecturer filteredLecturers = (Lecturer) element;
		if (filteredLecturers.getFirstName().toLowerCase().matches(
				searchString.toLowerCase())) {
			return true;
		} else if (filteredLecturers.getLastName().toLowerCase().matches(
				searchString.toLowerCase())) {
			return true;
		}
		return false;
	}
}
