package de.ugoe.cs.swe.exercises.lecturer;

import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LecturerEditDialog extends TitleAreaDialog {

	private Text editTitle;
	private Text editFirstName;
	private Text editLastName;
	private String[] lecturer = new String[4];
	private Shell shell;

	public String[] getLecturer() {
		return lecturer;
	}

	public LecturerEditDialog(Shell parentShell) {
		super(parentShell);
		super.setShellStyle(0);
		this.shell = parentShell;
		shell.setEnabled(false);
	}

	@Override
	protected Control createContents(Composite parent) {
		Control contents = super.createContents(parent);
		setTitle("Edit a lecturer");
		setMessage("Edit the lecturers data", IMessageProvider.INFORMATION);
		return contents;
	}

	@Override
	protected Control createDialogArea(Composite parent) {

		GridLayout layout = new GridLayout();
		layout.numColumns = 2;
		parent.setLayout(layout);
		Label labelTitle = new Label(parent, SWT.NONE);
		labelTitle.setText("Title");
		Text textboxTitle = new Text(parent, SWT.BORDER);
		textboxTitle.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
	//	textboxTitle.setText(ViewLecturer.getEditTitle());
		editTitle = textboxTitle;
		Label labelFirstName = new Label(parent, SWT.NONE);
		labelFirstName.setText("First name");
		Text textboxFirstName = new Text(parent, SWT.BORDER);
		textboxFirstName.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
	//	textboxFirstName.setText(ViewLecturer.getEditFirstName());
		editFirstName = textboxFirstName;
		Label labelLastName = new Label(parent, SWT.NONE);
		labelLastName.setText("Last name");
		Text textboxLastName = new Text(parent, SWT.BORDER);
		textboxLastName.setLayoutData(new GridData(GridData.GRAB_HORIZONTAL
				| GridData.HORIZONTAL_ALIGN_FILL));
	//	textboxLastName.setText(ViewLecturer.getEditLastName());
		//TODO: 3 kommentare ausklammern
		editLastName = textboxLastName;

		GridData gd = new GridData(GridData.HORIZONTAL_ALIGN_END);
		gd.horizontalSpan = 1;

		return parent;

	}

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		((GridLayout) parent.getLayout()).numColumns = 2;

		GridData buttonlayout = new GridData(SWT.LEFT, SWT.BEGINNING, false,
				false);
		buttonlayout.minimumWidth = 200;

		Button buttonOk = new Button(parent, SWT.PUSH);
		buttonOk.setText("OK");
		buttonOk.setFont(JFaceResources.getDialogFont());
		buttonOk.setLayoutData(buttonlayout);
		buttonOk.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if (editTitle.getText().length() != 0
						&& editFirstName.getText().length() != 0
						&& editLastName.getText().length() != 0) {
					lecturer[0] = "1";
					lecturer[1] = editTitle.getText();
					lecturer[2] = editFirstName.getText();
					lecturer[3] = editLastName.getText();
					shell.setEnabled(true);
					close();

				} else {
					setErrorMessage("Field can't be empty");
				}
			}
		});
		Button buttonCancel = new Button(parent, SWT.PUSH);
		buttonCancel.setText("Cancel");
		buttonCancel.setFont(JFaceResources.getDialogFont());
		buttonCancel.setLayoutData(buttonlayout);
		buttonCancel.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				shell.setEnabled(true);
				close();
			}
		});
	}
}