package de.ugoe.cs.swe.exercises.lecturer;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;
import de.ugoe.cs.swe.exercises.misc.Model;

public class Lecturer extends Model {

	private String lastName;
	private String firstName;
	private String title;

	@Override
	protected String getTableName() {
		return "lecturer";
	}

	public Lecturer() {
		// DEFAULT CONSTRUCTOR
		// Needed to create temporary lecturers in different add/edit/delete
		// methods
	}

	public Lecturer(String firstName, String lastName, String title) {
		super();
		this.setFirstName(firstName);
		this.setLastName(lastName);
		this.setTitle(title);
	}

	public Lecturer(int id, String firstName, String lastName, String title) {
		super(id);
		this.setFirstName(firstName);
		this.setLastName(lastName);
		this.setTitle(title);
	}

	@Override
	protected void update() throws SQLException {
		PreparedStatement statement = prepareStatement("UPDATE lecturer SET lastname=?, firstname=?, title=? WHERE id=?");
		statement.setInt(4, this.getId());
		executeSaveStatement(statement);
	}

	protected void executeSaveStatement(PreparedStatement statement)
			throws SQLException {
		statement.setString(1, this.getLastName());
		statement.setString(2, this.getFirstName());
		statement.setString(3, this.getTitle());
		statement.executeUpdate();
	}

	@Override
	protected PreparedStatement insert() throws SQLException {

		PreparedStatement statement = prepareStatement("INSERT INTO lecturer SET lastname=?, firstname=?, title=?");
		executeSaveStatement(statement);
		return statement;
	}

	@Override
	public String toString() {
		return getTitle() + " " + getFirstName() + " " + getLastName();
	}
	
	public void setTitle(String title) {
		this.title = title;
	}

	public String getTitle() {
		return title;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getLastName() {
		return lastName;
	}

	public static ArrayList<Lecturer> all() {
		try {
			return fromStatement(Model
					.prepareStatement("SELECT * FROM lecturer"));
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

	public static ArrayList<Lecturer> fromStatement(PreparedStatement statement)
			throws SQLException {
		ResultSet resultset = statement.executeQuery();
		ArrayList<Lecturer> lecturers = new ArrayList<Lecturer>();
		while (resultset.next()) {
			lecturers.add(new Lecturer(resultset.getInt("id"), resultset
					.getString("firstname"), resultset.getString("lastname"),
					resultset.getString("title")));
		}
		return lecturers;
	}

	public ArrayList<LectureEvent> getLecturerEvents() {
		try {
			PreparedStatement statement = Model
					.prepareStatement("SELECT DISTINCT lectureevent.* FROM lecturer, lectureevent, lectureevent_lecturer WHERE lecturer.id = ? AND lectureevent.id = lectureevent_lecturer.lectureevent AND lectureevent_lecturer.lecturer = lecturer.id ORDER BY id");
			statement.setInt(1, this.getId());
			return LectureEvent.fromStatement(statement);
		} catch (SQLException e) {
			e.printStackTrace();
		}
		return null;
	}

}
