package de.ugoe.cs.swe.exercises.lecture;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import de.ugoe.cs.swe.exercises.misc.CKeyword;

class LectureKeywordContentProvider implements IStructuredContentProvider {

	private int lectureId = 0;
	
	public LectureKeywordContentProvider(int lectureId) {
		this.lectureId = Math.abs(lectureId);
	}
	public LectureKeywordContentProvider() {}
	
	public void setLectureId(int id) {
		this.lectureId = Math.abs(id);
	}
	
	public int getLectureId() {
		return this.lectureId;
	}
	
	public void inputChanged(Viewer v, Object oldInput, Object newInput) {
	}

	public void dispose() {
	}
	
	public Object[] getElements(Object parent) {
		return CKeyword.getKeywordsForModel(lectureId, CKeyword.LECTURE).toArray();
	}

}
