package de.ugoe.cs.swe.exercises.exercise;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class ExerciseFilter extends ViewerFilter {

	private String searchString = null;

	public void setSearchText(String s) {
		// Search must be a substring of the existing value
		if (s == null || s.length() == 0)
			this.searchString = null;
		else
			this.searchString = ".*" + s + ".*";
	}

	// Filters only for first and last name of the lecturer, not the title or
	// ID.
	@Override
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		if (searchString == null || searchString.length() == 0) {
			return true;
		}
		Exercise exercise = (Exercise) element;
		return (exercise.getTitle().toLowerCase() + " " + exercise
				.getComplexity()).matches(searchString.toLowerCase());
	}
}
