package de.ugoe.cs.swe.exercises;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchAdvisor extends WorkbenchAdvisor {

	private static final String PERSPECTIVE_ID = "de.ugoe.cs.swe.exercises.perspective";

	@Override
	public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(
			IWorkbenchWindowConfigurer configurer) {

		PreferenceManager pm = configurer.getWorkbenchConfigurer()
				.getWorkbench().getPreferenceManager();

		IPreferenceNode texlipse = pm.find("TexlipsePreferencePage");

		texlipse.remove("TexlipseBuilderPreferencePage");
		texlipse
				.remove("net.sourceforge.texlipse.properties.ProjectTemplatesPreferencePage");
		texlipse.remove("TexlipseViewerSettingsPreferencePage");
		texlipse.remove("BibtexPreferencePage");
		texlipse.remove("TexlipseSpellChecker");

		WorkbenchWindowAdvisor advisor = new ApplicationWorkbenchWindowAdvisor(
				configurer);

		return advisor;
	}

	@Override
	public String getInitialWindowPerspectiveId() {
		return PERSPECTIVE_ID;
	}

}
