package de.ugoe.cs.swe.exercises.tests;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.swe.exercises.lecture.Lecture;
import de.ugoe.cs.swe.exercises.misc.CKeyword;
import de.ugoe.cs.swe.exercises.misc.Model;

public class LectureTest extends BaseTest {

	@Test
	public void testInsertAndUpdate() {
		Lecture informatik = new Lecture("Informatik I");
		Lecture english = new Lecture("Business English");
		assertEquals(informatik.getId(), Model.UNDEFINED);
		assertEquals(english.getId(), Model.UNDEFINED);
		assertEquals(Lecture.all().size(), 0);
		informatik.save();
		assertEquals(Lecture.all().size(), 1);
		english.save();
		assertEquals(Lecture.all().size(), 2);
		assertEquals(Lecture.all().get(0).getId(), informatik.getId());
		assertEquals(Lecture.all().get(1).getId(), english.getId());
		assertEquals(Lecture.all().get(0).getName(), informatik.getName());
		assertEquals(Lecture.all().get(1).getName(), english.getName());
		informatik.setName("Informatik II");
		informatik.save();
		assertEquals(Lecture.all().size(), 2);
		assertEquals(Lecture.all().get(0).getId(), informatik.getId());
		assertEquals(Lecture.all().get(1).getId(), english.getId());
		assertEquals(Lecture.all().get(0).getName(), informatik.getName());
		assertEquals(Lecture.all().get(1).getName(), english.getName());
		informatik.setName("Informatik I");
		informatik.save();
		assertEquals(Lecture.all().size(), 2);
	}

	@Test
	public void testAll() {
		Lecture informatik = new Lecture("Informatik I");
		Lecture english = new Lecture("Business English");
		informatik.save();
		english.save();
		assertEquals(Lecture.all().get(0).getId(), informatik.getId());
		assertEquals(Lecture.all().get(1).getId(), english.getId());
		assertEquals(Lecture.all().get(0).getName(), informatik.getName());
		assertEquals(Lecture.all().get(1).getName(), english.getName());
	}

	@Test
	public void testDelete() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		assertEquals(Lecture.all().size(), 1);
		informatik.delete();
		assertEquals(Lecture.all().size(), 0);
		assertEquals(Model.UNDEFINED, informatik.getId());

	}

	@Test(expected = Model.DoesNotExistException.class)
	public void testDeleteException() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.delete();
	}

	@Test
	public void testInsertKeyword() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();

		CKeyword key1 = new CKeyword(0, "Schlüssel 1", informatik.getId());
		CKeyword key2 = new CKeyword(0, "Schlüssel** 2", informatik.getId());

		CKeyword.insertKey(key1, CKeyword.LECTURE);
		CKeyword.insertKey(key2, CKeyword.LECTURE);

		assertEquals(key1.getKey(), CKeyword.getKeywordsForModel(
				informatik.getId(), CKeyword.LECTURE).get(0).getKey());
		assertEquals(key1.getModelId(), CKeyword.getKeywordsForModel(
				informatik.getId(), CKeyword.LECTURE).get(0).getModelId());
	}

	@Test
	public void testDeleteKeyword() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();

		CKeyword key1 = new CKeyword(0, "Schlüssel 1", informatik.getId());
		CKeyword key2 = new CKeyword(0, "Schlüssel** 2", informatik.getId());

		CKeyword.insertKey(key1, CKeyword.LECTURE);
		CKeyword.insertKey(key2, CKeyword.LECTURE);

		CKeyword.deleteKey(CKeyword.getKeywordsForModel(informatik.getId(), CKeyword.LECTURE)
				.get(0).getKeyId(), CKeyword.LECTURE);
		assertEquals(1, CKeyword.getKeywordsForModel(informatik.getId(), CKeyword.LECTURE)
				.size());
		CKeyword.deleteKey(CKeyword.getKeywordsForModel(informatik.getId(), CKeyword.LECTURE)
				.get(0).getKeyId(), CKeyword.LECTURE);
		assertEquals(0, CKeyword.getKeywordsForModel(informatik.getId(), CKeyword.LECTURE)
				.size());
	}
}
