package de.ugoe.cs.swe.exercises.tests;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.swe.exercises.lecture.Lecture;
import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;
import de.ugoe.cs.swe.exercises.lecturer.Lecturer;
import de.ugoe.cs.swe.exercises.misc.Model;

public class LectureEventTest extends BaseTest {

	@Test(expected = Model.DoesNotExistException.class)
	public void testUnsavedLecture() {
		Lecture informatik = new Lecture("Informatik I");
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
	}

	@Test
	public void testAll() {
		Lecture informatik = new Lecture("Informatik I");
		Lecture english = new Lecture("Business English");
		informatik.save();
		english.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		LectureEvent englishEvent = new LectureEvent(2008, LectureEvent.WS,
				english);
		infoEvent.save();
		englishEvent.save();
		assertEquals(LectureEvent.all().get(0).getId(), infoEvent.getId());
		assertEquals(LectureEvent.all().get(1).getId(), englishEvent.getId());
		assertEquals(LectureEvent.all().get(0).getSemester(), infoEvent
				.getSemester());
		assertEquals(LectureEvent.all().get(1).getSemester(), englishEvent
				.getSemester());
		assertEquals(LectureEvent.all().get(0).getIsSummerSemester(), infoEvent.getIsSummerSemester());
		assertEquals(LectureEvent.all().get(1).getIsSummerSemester(), englishEvent
				.getIsSummerSemester());
		assertEquals(LectureEvent.all().get(0).getLecture().getId(), infoEvent
				.getLecture().getId());
		assertEquals(LectureEvent.all().get(1).getLecture().getId(),
				englishEvent.getLecture().getId());
	}

	@Test
	public void testGetLecturers() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		Lecturer waack = new Lecturer("Stefan", "Waack", "Prof. Dr.");
		Lecturer damm = new Lecturer("Carsten", "Damm", "Prof. Dr.");
		waack.save();
		damm.save();
		infoEvent.addLecturer(waack);
		infoEvent.addLecturer(damm);
		assertEquals(infoEvent.getLecturers().size(), 2);
		assertEquals(infoEvent.getLecturers().get(0).getId(), waack.getId());
		assertEquals(infoEvent.getLecturers().get(1).getId(), damm.getId());
		infoEvent.removeLecturer(waack);
		infoEvent.removeLecturer(damm);
		assertEquals(infoEvent.getLecturers().size(), 0);
	}

	@Test
	public void testUpdate() {
		Lecture informatik = new Lecture("Informatik I");
		Lecture informatik2 = new Lecture("Informatik II");
		informatik.save();
		informatik2.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		assertEquals(LectureEvent.all().get(0).getLecture().getId(), infoEvent
				.getLecture().getId());
		infoEvent.setLecture(informatik2);
		infoEvent.save();
		assertEquals(LectureEvent.all().size(), 1);
		assertEquals(LectureEvent.all().get(0).getId(), infoEvent.getId());
		assertEquals(LectureEvent.all().get(0).getSemester(), infoEvent
				.getSemester());
		assertEquals(LectureEvent.all().get(0).getIsSummerSemester(), infoEvent.getIsSummerSemester());
		assertEquals(LectureEvent.all().get(0).getLecture().getName(),
				infoEvent.getLecture().getName());
		assertEquals(LectureEvent.all().get(0).getLecture().getId(), infoEvent
				.getLecture().getId());
	}

	@Test
	public void testDelete() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		assertEquals(LectureEvent.all().size(), 1);
		infoEvent.delete();
		assertEquals(LectureEvent.all().size(), 0);
	}

	@Test
	public void testCascadedDelete() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		assertEquals(LectureEvent.all().size(), 1);
		informatik.delete();
		assertEquals(LectureEvent.all().size(), 0);
	}
}
