package de.ugoe.cs.swe.exercises.tests;

import static org.junit.Assert.*;
import org.junit.Test;
import de.ugoe.cs.swe.exercises.exercise.Exercise;
import de.ugoe.cs.swe.exercises.misc.Model;

public class ExerciseTest extends BaseTest {

	Exercise test = new Exercise("Horst's exercise 1", "1 + 1 = 6?", "false", 8,1);
	Exercise test2 = new Exercise("Horst's exercise 2", "1 + 1 = 6?", "false", 8,1);

	@Test
	public void testExerciseInt() {
		Exercise testInt = new Exercise();
		assertTrue(testInt instanceof Exercise);
	}

	@Test
	public void testExerciseIntStringStringString() {
		Exercise testInt2 = new Exercise("Hans theorem", "Hans", "Wurst", 6, 6);
		assertTrue(testInt2 instanceof Exercise);
	}

	@Test
	public void testSetSolution() {
		test.setSolution("Horst");
		test.save();
		assertEquals(test.getSolution(),"Horst\n");
	}

	@Test
	public void testGetSolution() {
		test2.save();
		assertEquals(test2.getSolution(),"false\n");
	}

	@Test
	public void testSetRevisionnumber() {
		test.setRevisionnumber(2);
		assertTrue(test.getRevisionnumber() == 2);
	}

	@Test
	public void testGetRevisionnumber() {
		assertTrue(test2.getRevisionnumber() == 8);
	}

	@Test
	public void testSetComplexity() {
		test.setComplexity(4);
		assertTrue(test.getComplexity() == 4);
	}

	@Test
	public void testGetComplexity() {
		assertTrue(test2.getComplexity() == 1);
	}

	@Test
	public void testInsertAndUpdate() {
		Exercise test1 = new Exercise("Penner's lemma", "Penner", "Sack", 6,1);
		Exercise test3 = new Exercise("sfasf solve", "sgfgfg", "gfdfg", 7,2);
		assertEquals(test1.getId(), Model.UNDEFINED);
		assertEquals(test3.getId(), Model.UNDEFINED);
		assertEquals(Exercise.all().size(), 0);
		test1.save();
		// assertEquals(Exercise.all().size(), 1);
		test3.save();
		assertEquals(Exercise.all().size(), 2);
		assertEquals(Exercise.all().get(0).getId(), test1.getId());
		assertEquals(Exercise.all().get(1).getId(), test3.getId());
		assertEquals(Exercise.all().get(0).getSolution(), test1.getSolution());
	
		test1.setSolution("bla");
		test1.save();
		assertEquals(Exercise.all().size(), 2);
		assertEquals(Exercise.all().get(0).getId(), test1.getId());
		assertEquals(Exercise.all().get(1).getId(), test3.getId());
		assertEquals(Exercise.all().get(0).getSolution(), test1.getSolution());
	
		test1.setSolution("OvO");
		test1.save();
		assertEquals(Exercise.all().size(), 2);
	}

	@Test
	public void testDelete() {
		Exercise test1 = new Exercise("Penner's lemma", "Penner", "Sack", 3);
		test1.save();
		assertEquals(Exercise.all().size(), 1);
		test1.delete();
		assertEquals(Exercise.all().size(), 0);
		assertEquals(Model.UNDEFINED, test1.getId());
	}

	@Test
	public void testAll() {
		Exercise test1 = new Exercise("Penner's lemma", "Penner", "Sack", 7);
		Exercise test3 = new Exercise("bumbum", "sgfgfg", "gfdfg", 10);
		test1.save();
		test3.save();
		// ArrayList<Exercise> lecturers = new ArrayList<Exercise>();
		// lecturers.add(test1);
		// lecturers.add(test3);
		assertEquals(Exercise.all().get(0).getId(), test1.getId());
		assertEquals(Exercise.all().get(1).getId(), test3.getId());
		assertEquals(Exercise.all().get(0).getSolution(), test1.getSolution());
		assertEquals(Exercise.all().get(1).getSolution(), test3.getSolution());
		assertEquals(Exercise.all().get(0).getComplexity(), test1
				.getComplexity());
		assertEquals(Exercise.all().get(1).getComplexity(), test3
				.getComplexity());
	}

	@Test
	public void testSaveToDisk() {
//		Exercise test5 = new Exercise("Lemma lemma", "solution", "egal", 5);
//		test5.save();
//		test5.saveToDisk();

	}

	// @Test
	// public void testGetTextFromSVN(String svnRef)
	// {
	// ExerciseSVN.getTextFromSVN("hallo");
	//		
	// }

}