package de.ugoe.cs.swe.exercises.tests;

import static org.junit.Assert.*;

import org.junit.Test;

import de.ugoe.cs.swe.exercises.exercise.Exercise;
import de.ugoe.cs.swe.exercises.exercisesheet.ExerciseSheet;
import de.ugoe.cs.swe.exercises.lecture.Lecture;
import de.ugoe.cs.swe.exercises.lectureevent.LectureEvent;

public class ExerciseSheetTest extends BaseTest {
	@Test
	public void testAll() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		
		ExerciseSheet sheet = new ExerciseSheet(1, 1, 5, false, infoEvent, 5);
		sheet.save();
		assertEquals(ExerciseSheet.all().size(), 1);
		assertEquals(ExerciseSheet.all().get(0).getId(), sheet.getId());
		assertEquals(ExerciseSheet.all().get(0).getNumber(), sheet
				.getNumber());
		assertEquals(ExerciseSheet.all().get(0).isExamination(), sheet
				.isExamination());

		assertEquals(ExerciseSheet.all().get(0).getComplexityValue(), sheet
				.getComplexityValue());
		assertEquals(ExerciseSheet.all().get(0).getLectureEvent().getId(), sheet
				.getLectureEvent().getId());
	}

	@Test
	public void testGetExercises() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		Exercise exercise = new Exercise("Penner Aufgabe", "Penner", "Sack", 6);
		exercise.save();
		ExerciseSheet sheet = new ExerciseSheet(1, 1, 5, false, infoEvent,5);
		sheet.save();
		sheet.addExercise(exercise);
		assertEquals(sheet.getExercises().size(), 1);
		assertEquals(sheet.getExercises().get(0).getId(), exercise.getId());
		sheet.removeExercise(exercise);
		assertEquals(sheet.getExercises().size(), 0);
	}
	
	@Test
	public void testUpdate() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		ExerciseSheet sheet = new ExerciseSheet(1, 1, 5, false, infoEvent,5);
		sheet.save();
		assertEquals(ExerciseSheet.all().size(), 1);
		sheet.setExamination(true);
		sheet.save();
		assertEquals(ExerciseSheet.all().size(), 1);
		assertEquals(ExerciseSheet.all().get(0).getId(), sheet.getId());
		assertEquals(ExerciseSheet.all().get(0).getNumber(), sheet
				.getNumber());
		assertEquals(ExerciseSheet.all().get(0).isExamination(), sheet
				.isExamination());
		assertEquals(ExerciseSheet.all().get(0).getComplexityValue(), sheet
				.getComplexityValue());
		assertEquals(ExerciseSheet.all().get(0).getLectureEvent().getId(), sheet
				.getLectureEvent().getId());
	}

	@Test
	public void testDelete() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		ExerciseSheet sheet = new ExerciseSheet(1, 1, 5, false, infoEvent,5);
		sheet.save();
		assertEquals(ExerciseSheet.all().size(), 1);
		sheet.delete();
		assertEquals(ExerciseSheet.all().size(), 0);
	}

	@Test
	public void testCacadedDelete() {
		Lecture informatik = new Lecture("Informatik I");
		informatik.save();
		LectureEvent infoEvent = new LectureEvent(2009, LectureEvent.SS,
				informatik);
		infoEvent.save();
		ExerciseSheet sheet = new ExerciseSheet(1, 1, 5, false, infoEvent,5);
		sheet.save();
		assertEquals(ExerciseSheet.all().size(), 1);
		informatik.delete();
		assertEquals(ExerciseSheet.all().size(), 0);
	}
}
