/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnIndexConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnUnique;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableCheck;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableForeignKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableIndexConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableUnique;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetTableDef
implements ISqlJetTableDef {
    private static String AUTOINDEX = "sqlite_autoindex_%s_%d";
    private final String name;
    private final String databaseName;
    private final boolean temporary;
    private final boolean ifNotExists;
    private final List<ISqlJetColumnDef> columns;
    private final List<ISqlJetTableConstraint> constraints;
    private int page;
    private long rowId;
    private boolean rowIdPrimaryKey;
    private boolean autoincremented;
    private String primaryKeyIndexName;
    private String rowIdPrimaryKeyColumnName;
    private int rowIdPrimaryKeyColumnIndex = -1;
    private final List<String> primaryKeyColumns = new ArrayList<String>();
    private final Map<String, SqlJetColumnIndexConstraint> columnConstraintsIndexCache = new HashMap<String, SqlJetColumnIndexConstraint>();
    private final Map<String, SqlJetTableIndexConstraint> tableConstrainsIndexCache = new HashMap<String, SqlJetTableIndexConstraint>();

    public SqlJetTableDef(CommonTree ast, int page) throws SqlJetException {
        CommonTree defNode;
        CommonTree optionsNode = (CommonTree)ast.getChild(0);
        this.temporary = this.hasOption(optionsNode, "temporary");
        this.ifNotExists = this.hasOption(optionsNode, "exists");
        CommonTree nameNode = (CommonTree)ast.getChild(1);
        this.name = nameNode.getText();
        this.databaseName = nameNode.getChildCount() > 0 ? nameNode.getChild(0).getText() : null;
        ArrayList<SqlJetColumnDef> columns = new ArrayList<SqlJetColumnDef>();
        ArrayList<SqlJetTableConstraint> constraints = new ArrayList<SqlJetTableConstraint>();
        if (ast.getChildCount() > 2 && "columns".equalsIgnoreCase((defNode = (CommonTree)ast.getChild(2)).getText())) {
            for (int i = 0; i < defNode.getChildCount(); ++i) {
                columns.add(new SqlJetColumnDef((CommonTree)defNode.getChild(i)));
            }
            if (ast.getChildCount() > 3) {
                CommonTree constraintsNode = (CommonTree)ast.getChild(3);
                assert ("constraints".equalsIgnoreCase(constraintsNode.getText()));
                for (int i = 0; i < constraintsNode.getChildCount(); ++i) {
                    String constraintName;
                    CommonTree constraintRootNode = (CommonTree)constraintsNode.getChild(i);
                    assert ("table_constraint".equalsIgnoreCase(constraintRootNode.getText()));
                    CommonTree constraintNode = (CommonTree)constraintRootNode.getChild(0);
                    String constraintType = constraintNode.getText();
                    String string = constraintName = constraintRootNode.getChildCount() > 1 ? constraintRootNode.getChild(1).getText() : null;
                    if ("primary".equalsIgnoreCase(constraintType)) {
                        constraints.add(new SqlJetTablePrimaryKey(constraintName, constraintNode));
                        continue;
                    }
                    if ("unique".equalsIgnoreCase(constraintType)) {
                        constraints.add(new SqlJetTableUnique(constraintName, constraintNode));
                        continue;
                    }
                    if ("check".equalsIgnoreCase(constraintType)) {
                        constraints.add(new SqlJetTableCheck(constraintName, constraintNode));
                        continue;
                    }
                    if ("foreign".equalsIgnoreCase(constraintType)) {
                        constraints.add(new SqlJetTableForeignKey(constraintName, constraintNode));
                        continue;
                    }
                    assert (false);
                }
            }
        }
        this.columns = Collections.unmodifiableList(columns);
        this.constraints = Collections.unmodifiableList(constraints);
        this.page = page;
        this.resolveConstraints();
    }

    private void resolveConstraints() throws SqlJetException {
        int columnIndex = 0;
        int autoindexNumber = 0;
        for (ISqlJetColumnDef column : this.columns) {
            for (ISqlJetColumnConstraint constraint : column.getConstraints()) {
                if (constraint instanceof ISqlJetColumnPrimaryKey) {
                    SqlJetColumnPrimaryKey pk = (SqlJetColumnPrimaryKey)constraint;
                    this.primaryKeyColumns.add(column.getName());
                    if (column.hasExactlyIntegerType()) {
                        this.rowIdPrimaryKeyColumnName = column.getName();
                        this.rowIdPrimaryKeyColumnIndex = columnIndex;
                        this.rowIdPrimaryKey = true;
                        this.autoincremented = pk.isAutoincremented();
                        continue;
                    }
                    this.primaryKeyIndexName = SqlJetTableDef.generateAutoIndexName(this.getName(), ++autoindexNumber);
                    pk.setIndexName(this.primaryKeyIndexName);
                    this.columnConstraintsIndexCache.put(pk.getIndexName(), pk);
                    continue;
                }
                if (!(constraint instanceof ISqlJetColumnUnique)) continue;
                SqlJetColumnUnique uc = (SqlJetColumnUnique)constraint;
                uc.setIndexName(SqlJetTableDef.generateAutoIndexName(this.getName(), ++autoindexNumber));
                this.columnConstraintsIndexCache.put(uc.getIndexName(), uc);
            }
            ++columnIndex;
        }
        for (ISqlJetTableConstraint constraint : this.constraints) {
            if (constraint instanceof ISqlJetTablePrimaryKey) {
                boolean b = false;
                SqlJetTablePrimaryKey pk = (SqlJetTablePrimaryKey)constraint;
                assert (this.primaryKeyColumns.isEmpty());
                this.primaryKeyColumns.addAll(pk.getColumns());
                if (pk.getColumns().size() == 1) {
                    String n = pk.getColumns().get(0);
                    ISqlJetColumnDef c = this.getColumn(n);
                    if (null == c) {
                        throw new SqlJetException(SqlJetErrorCode.ERROR, "Wrong column '" + n + "' in PRIMARY KEY");
                    }
                    if (c.hasExactlyIntegerType()) {
                        this.rowIdPrimaryKeyColumnName = n;
                        this.rowIdPrimaryKeyColumnIndex = this.getColumnNumber(n);
                        this.rowIdPrimaryKey = true;
                        b = true;
                    }
                }
                if (b) continue;
                this.primaryKeyIndexName = SqlJetTableDef.generateAutoIndexName(this.getName(), ++autoindexNumber);
                pk.setIndexName(this.primaryKeyIndexName);
                this.tableConstrainsIndexCache.put(pk.getIndexName(), pk);
                continue;
            }
            if (!(constraint instanceof ISqlJetTableUnique)) continue;
            SqlJetTableUnique uc = (SqlJetTableUnique)constraint;
            uc.setIndexName(SqlJetTableDef.generateAutoIndexName(this.getName(), ++autoindexNumber));
            this.tableConstrainsIndexCache.put(uc.getIndexName(), uc);
        }
    }

    private static String generateAutoIndexName(String tableName, int i) {
        return String.format(AUTOINDEX, tableName, i);
    }

    private boolean hasOption(CommonTree optionsNode, String name) {
        for (int i = 0; i < optionsNode.getChildCount(); ++i) {
            CommonTree optionNode = (CommonTree)optionsNode.getChild(i);
            if (!name.equalsIgnoreCase(optionNode.getText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isKeepExisting() {
        return this.ifNotExists;
    }

    @Override
    public List<ISqlJetColumnDef> getColumns() {
        return this.columns;
    }

    @Override
    public ISqlJetColumnDef getColumn(String name) {
        for (ISqlJetColumnDef column : this.getColumns()) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    @Override
    public int getColumnNumber(String name) {
        int i = 0;
        for (ISqlJetColumnDef column : this.getColumns()) {
            if (column.getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public List<ISqlJetTableConstraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean isRowIdPrimaryKey() {
        return this.rowIdPrimaryKey;
    }

    @Override
    public boolean isAutoincremented() {
        return this.autoincremented;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public long getRowId() {
        return this.rowId;
    }

    public void setRowId(long rowId) {
        this.rowId = rowId;
    }

    @Override
    public String getPrimaryKeyIndexName() {
        return this.primaryKeyIndexName;
    }

    public String getRowIdPrimaryKeyColumnName() {
        return this.rowIdPrimaryKeyColumnName;
    }

    public int getRowIdPrimaryKeyColumnIndex() {
        return this.rowIdPrimaryKeyColumnIndex;
    }

    public List<String> getPrimaryKeyColumnNames() {
        return this.primaryKeyColumns;
    }

    public SqlJetColumnIndexConstraint getColumnIndexConstraint(String indexName) {
        return this.columnConstraintsIndexCache.get(indexName);
    }

    public SqlJetTableIndexConstraint getTableIndexConstraint(String indexName) {
        return this.tableConstrainsIndexCache.get(indexName);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPage());
        buffer.append("/");
        buffer.append(this.getRowId());
        buffer.append(": ");
        buffer.append(this.toSQL());
        return buffer.toString();
    }

    @Override
    public String toSQL() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE ");
        if (this.isTemporary()) {
            buffer.append("TEMPORARY ");
        }
        buffer.append("TABLE ");
        if (this.isKeepExisting()) {
            buffer.append("IF NOT EXISTS ");
        }
        if (this.getDatabaseName() != null) {
            buffer.append(this.getDatabaseName());
            buffer.append('.');
        }
        buffer.append(this.getName());
        buffer.append(" (");
        List<ISqlJetColumnDef> columns = this.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(columns.get(i).toString());
        }
        List<ISqlJetTableConstraint> constraints = this.getConstraints();
        for (int i = 0; i < constraints.size(); ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(constraints.get(i).toString());
        }
        buffer.append(')');
        return buffer.toString();
    }
}

