/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.pager;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCache;
import org.tmatesoft.sqljet.core.internal.ISqlJetPageCallback;
import org.tmatesoft.sqljet.core.internal.SqlJetPageFlags;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.pager.SqlJetPage;

public class SqlJetPageCache
implements ISqlJetPageCache {
    public static final String SQLJET_PAGE_CACHE_SIZE = "SQLJET.PAGE_CACHE_SIZE";
    public static final int PAGE_CACHE_SIZE_DEFAULT = 2000;
    public static final int PAGE_CACHE_SIZE_MINIMUM = 10;
    private static final int N_SORT_BUCKET = 25;
    SqlJetPage pDirty;
    SqlJetPage pDirtyTail;
    SqlJetPage pSynced;
    int nRef;
    int nMax = 2000;
    int nMin = 10;
    int szPage;
    boolean bPurgeable;
    ISqlJetPageCallback xStress;
    PCache pCache = new PCache();
    ISqlJetPage pPage1;

    SqlJetPageCache() {
        int cacheSize = SqlJetUtility.getIntSysProp(SQLJET_PAGE_CACHE_SIZE, this.nMax);
        if (cacheSize >= this.nMin) {
            this.nMax = cacheSize;
        }
    }

    static void removeFromDirtyList(SqlJetPage pPage) {
        SqlJetPageCache p = pPage.pCache;
        assert (pPage.pDirtyNext != null || pPage == p.pDirtyTail);
        assert (pPage.pDirtyPrev != null || pPage == p.pDirty);
        if (p.pSynced == pPage) {
            SqlJetPage pSynced = pPage.pDirtyPrev;
            while (pSynced != null && pSynced.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
                pSynced = pSynced.pDirtyPrev;
            }
            p.pSynced = pSynced;
        }
        if (pPage.pDirtyNext != null) {
            pPage.pDirtyNext.pDirtyPrev = pPage.pDirtyPrev;
        } else {
            assert (pPage == p.pDirtyTail);
            p.pDirtyTail = pPage.pDirtyPrev;
        }
        if (pPage.pDirtyPrev != null) {
            pPage.pDirtyPrev.pDirtyNext = pPage.pDirtyNext;
        } else {
            assert (pPage == p.pDirty);
            p.pDirty = pPage.pDirtyNext;
        }
        pPage.pDirtyNext = null;
        pPage.pDirtyPrev = null;
    }

    static void addToDirtyList(SqlJetPage pPage) {
        SqlJetPageCache p = pPage.pCache;
        assert (pPage.pDirtyNext == null && pPage.pDirtyPrev == null && p.pDirty != pPage);
        pPage.pDirtyNext = p.pDirty;
        if (pPage.pDirtyNext != null) {
            assert (pPage.pDirtyNext.pDirtyPrev == null);
            pPage.pDirtyNext.pDirtyPrev = pPage;
        }
        p.pDirty = pPage;
        if (p.pDirtyTail == null) {
            p.pDirtyTail = pPage;
        }
        if (p.pSynced == null && !pPage.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
            p.pSynced = pPage;
        }
    }

    static void unpin(SqlJetPage p) {
        SqlJetPageCache pCache = p.pCache;
        if (pCache.bPurgeable) {
            if (p.pgno == 1) {
                pCache.pPage1 = null;
            }
            if (pCache.pCache != null) {
                pCache.pCache.unpin(p, false);
            }
        }
    }

    public void open(int szPage, boolean purgeable, ISqlJetPageCallback stress) {
        this.szPage = szPage;
        this.bPurgeable = purgeable;
        this.xStress = stress;
    }

    public void setPageSize(int pageSize) {
        assert (this.nRef == 0 && this.pDirty == null);
        if (this.pCache != null) {
            this.pCache.destroy();
            this.pCache = null;
        }
        this.szPage = pageSize;
    }

    public ISqlJetPage fetch(int pgno, boolean createFlag) throws SqlJetException {
        SqlJetPage pPage = null;
        assert (pgno > 0);
        if (this.pCache == null && createFlag) {
            this.pCache = new PCache();
        }
        if (this.pCache != null) {
            pPage = this.pCache.fetch(pgno, createFlag);
        }
        if (pPage == null && createFlag) {
            SqlJetPage pPg = this.pSynced;
            while (pPg != null && (pPg.nRef > 0 || pPg.flags.contains((Object)SqlJetPageFlags.NEED_SYNC))) {
                pPg = pPg.pDirtyPrev;
            }
            if (pPg == null) {
                pPg = this.pDirtyTail;
                while (pPg != null && pPg.nRef > 0) {
                    pPg = pPg.pDirtyPrev;
                }
            }
            if (pPg != null) {
                this.xStress.pageCallback(pPg);
            }
            this.pCache.cleanUnpinned();
            pPage = this.pCache.fetch(pgno, true);
        }
        if (pPage != null) {
            if (0 == pPage.nRef) {
                ++this.nRef;
            }
            ++pPage.nRef;
            if (null == pPage.pData) {
                pPage.pData = ByteBuffer.allocate(this.szPage);
            }
            pPage.pCache = this;
            pPage.pgno = pgno;
            if (pgno == 1) {
                this.pPage1 = pPage;
            }
        }
        return pPage;
    }

    public void release(ISqlJetPage page) {
        SqlJetPage p = (SqlJetPage)page;
        assert (p.nRef > 0);
        --p.nRef;
        if (p.nRef == 0) {
            SqlJetPageCache pCache = p.pCache;
            --pCache.nRef;
            if (!p.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
                SqlJetPageCache.unpin(p);
            } else {
                SqlJetPageCache.removeFromDirtyList(p);
                SqlJetPageCache.addToDirtyList(p);
            }
        }
    }

    public void drop(ISqlJetPage page) {
        SqlJetPage p = (SqlJetPage)page;
        assert (p.nRef >= 1);
        if (p.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            SqlJetPageCache.removeFromDirtyList(p);
        }
        --this.nRef;
        if (p.pgno == 1) {
            this.pPage1 = null;
        }
        this.pCache.unpin(p, true);
    }

    public void makeDirty(ISqlJetPage page) {
        SqlJetPage p = (SqlJetPage)page;
        p.flags.remove((Object)SqlJetPageFlags.DONT_WRITE);
        assert (p.nRef > 0);
        if (!p.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            p.flags.add(SqlJetPageFlags.DIRTY);
            SqlJetPageCache.addToDirtyList(p);
        }
    }

    public void makeClean(ISqlJetPage page) {
        SqlJetPage p = (SqlJetPage)page;
        if (p.flags.contains((Object)SqlJetPageFlags.DIRTY)) {
            SqlJetPageCache.removeFromDirtyList(p);
            p.flags.remove((Object)SqlJetPageFlags.DIRTY);
            p.flags.remove((Object)SqlJetPageFlags.NEED_SYNC);
            if (p.nRef == 0) {
                SqlJetPageCache.unpin(p);
            }
        }
    }

    public void cleanAll() {
        SqlJetPage p;
        while ((p = this.pDirty) != null) {
            this.makeClean(p);
        }
    }

    public void clearSyncFlags() {
        SqlJetPage p = this.pDirty;
        while (p != null) {
            p.flags.remove((Object)SqlJetPageFlags.NEED_SYNC);
            p = p.pDirtyNext;
        }
        this.pSynced = this.pDirtyTail;
    }

    public void move(ISqlJetPage page, int newPgno) {
        SqlJetPage p = (SqlJetPage)page;
        assert (p.nRef > 0);
        assert (newPgno > 0);
        this.pCache.rekey(p, p.pgno, newPgno);
        p.pgno = newPgno;
        if (p.flags.contains((Object)SqlJetPageFlags.DIRTY) && p.flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) {
            SqlJetPageCache.removeFromDirtyList(p);
            SqlJetPageCache.addToDirtyList(p);
        }
    }

    public void truncate(int pgno) {
        if (this.pCache != null) {
            SqlJetPage p = this.pDirty;
            while (p != null) {
                SqlJetPage pNext = p.pDirtyNext;
                if (p.pgno > pgno) {
                    assert (p.flags.contains((Object)SqlJetPageFlags.DIRTY));
                    this.makeClean(p);
                }
                p = pNext;
            }
            if (pgno == 0 && this.pPage1 != null) {
                SqlJetUtility.memset(this.pPage1.getData(), (byte)0, this.szPage);
                pgno = 1;
            }
            this.pCache.truncate(pgno + 1);
        }
    }

    public void close() {
        if (this.pCache != null) {
            this.pCache.destroy();
        }
    }

    public void clear() {
        this.truncate(0);
    }

    static SqlJetPage mergeDirtyList(SqlJetPage pA, SqlJetPage pB) {
        SqlJetPage result;
        SqlJetPage pTail = result = new SqlJetPage();
        while (pA != null && pB != null) {
            if (pA.pgno < pB.pgno) {
                pTail.pDirty = pA;
                pTail = pA;
                pA = pA.pDirty;
                continue;
            }
            pTail.pDirty = pB;
            pTail = pB;
            pB = pB.pDirty;
        }
        pTail.pDirty = pA != null ? pA : (pB != null ? pB : null);
        return result.pDirty;
    }

    static SqlJetPage sortDirtyList(SqlJetPage pIn) {
        int i;
        SqlJetPage p;
        SqlJetPage[] a = new SqlJetPage[25];
        while (pIn != null) {
            p = pIn;
            pIn = p.pDirty;
            p.pDirty = null;
            for (i = 0; i < 24; ++i) {
                if (a[i] == null) {
                    a[i] = p;
                    break;
                }
                p = SqlJetPageCache.mergeDirtyList(a[i], p);
                a[i] = null;
            }
            if (i != 24) continue;
            a[i] = SqlJetPageCache.mergeDirtyList(a[i], p);
        }
        p = a[0];
        for (i = 1; i < 25; ++i) {
            p = SqlJetPageCache.mergeDirtyList(p, a[i]);
        }
        return p;
    }

    public ISqlJetPage getDirtyList() {
        SqlJetPage p = this.pDirty;
        while (p != null) {
            p.pDirty = p.pDirtyNext;
            p = p.pDirtyNext;
        }
        return SqlJetPageCache.sortDirtyList(this.pDirty);
    }

    public int getRefCount() {
        return this.nRef;
    }

    public int getPageCount() {
        int nPage = 0;
        if (this.pCache != null) {
            nPage = this.pCache.getPageCount();
        }
        return nPage;
    }

    public int getCachesize() {
        return this.nMax;
    }

    public void setCacheSize(int mxPage) {
        this.nMax = mxPage;
    }

    public void iterate(ISqlJetPageCallback iter) throws SqlJetException {
        SqlJetPage pDirty = this.pDirty;
        while (pDirty != null) {
            iter.pageCallback(pDirty);
            pDirty = pDirty.pDirtyNext;
        }
    }

    class PCache {
        private Map<Integer, SqlJetPage> apHash = new LinkedHashMap<Integer, SqlJetPage>();
        private Set<Integer> unpinned = new LinkedHashSet<Integer>();
        private int iMaxKey;

        PCache() {
        }

        public synchronized int getPageCount() {
            return this.apHash.size();
        }

        public synchronized SqlJetPage fetch(final int key, boolean createFlag) {
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class FetchOut {
                FetchOut() {
                }

                SqlJetPage go_to(SqlJetPage pPage) {
                    if (pPage != null && key > PCache.this.iMaxKey) {
                        PCache.this.iMaxKey = key;
                    }
                    return pPage;
                }
            }
            FetchOut fetch_out = new FetchOut();
            SqlJetPage pPage = null;
            if (this.apHash.size() > 0) {
                pPage = this.apHash.get(key);
            }
            if (pPage != null || !createFlag) {
                return fetch_out.go_to(pPage);
            }
            if (SqlJetPageCache.this.bPurgeable && this.getPageCount() == SqlJetPageCache.this.nMax) {
                return null;
            }
            if (pPage == null) {
                pPage = new SqlJetPage(SqlJetPageCache.this.szPage);
            }
            if (pPage != null) {
                pPage.pgno = key;
                pPage.pCache = SqlJetPageCache.this;
                this.apHash.put(key, pPage);
            }
            return fetch_out.go_to(pPage);
        }

        public synchronized void unpin(ISqlJetPage page, boolean discard) {
            int pageNumber = page.getPageNumber();
            if (discard || SqlJetPageCache.this.bPurgeable && this.getPageCount() == SqlJetPageCache.this.nMax) {
                this.apHash.remove(pageNumber);
            } else if (!this.unpinned.contains(pageNumber)) {
                this.unpinned.add(pageNumber);
            }
        }

        public synchronized void rekey(ISqlJetPage page, int oldKey, int newKey) {
            SqlJetPage pPage = (SqlJetPage)page;
            assert (pPage.pgno == oldKey);
            this.apHash.remove(oldKey);
            this.apHash.put(newKey, pPage);
            pPage.pgno = newKey;
            if (newKey > this.iMaxKey) {
                this.iMaxKey = newKey;
            }
        }

        public synchronized void truncate(int iLimit) {
            if (iLimit <= this.iMaxKey) {
                LinkedList<Integer> l = new LinkedList<Integer>();
                for (Integer i : this.apHash.keySet()) {
                    if (i < iLimit) continue;
                    l.add(i);
                }
                for (Integer i : l) {
                    this.apHash.remove(i);
                }
                this.iMaxKey = iLimit - 1;
            }
        }

        public synchronized void destroy() {
            this.apHash.clear();
            this.unpinned.clear();
        }

        public void cleanUnpinned() {
            Iterator<Integer> i = this.unpinned.iterator();
            while (i.hasNext()) {
                Integer next = i.next();
                if (next == null) {
                    i.remove();
                    continue;
                }
                SqlJetPage p = this.apHash.get(next);
                if (p == null) {
                    i.remove();
                    continue;
                }
                Set<SqlJetPageFlags> flags = p.getFlags();
                if (flags.contains((Object)SqlJetPageFlags.DIRTY) || flags.contains((Object)SqlJetPageFlags.NEED_SYNC)) continue;
                this.apHash.remove(next);
                i.remove();
                return;
            }
        }
    }
}

