/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNFileFetcher;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNConflictVersion;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNTreeConflictUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNCleanupHandler;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNEntryHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNConflictAction;
import org.tmatesoft.svn.core.wc.SVNConflictDescription;
import org.tmatesoft.svn.core.wc.SVNConflictReason;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNOperation;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNTreeConflictDescription;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUpdateEditor
implements ISVNUpdateEditor,
ISVNCleanupHandler {
    private String mySwitchURL;
    private String myTarget;
    private String myTargetURL;
    private String myRootURL;
    private SVNAdminAreaInfo myAdminInfo;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private long myTargetRevision;
    private boolean myIsRootOpen;
    private boolean myIsTargetDeleted;
    private boolean myIsUnversionedObstructionsAllowed;
    private boolean myIsDepthSticky;
    private Collection mySkippedTrees;
    private Collection myDeletedTrees;
    private SVNWCAccess myWCAccess;
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNDepth myRequestedDepth;
    private String[] myExtensionPatterns;
    private ISVNFileFetcher myFileFetcher;
    private boolean myIsLockOnDemand;

    private SVNUpdateEditor(SVNAdminAreaInfo info, String switchURL, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExtensions, String targetURL, String rootURL, ISVNFileFetcher fileFetcher, boolean lockOnDemand) {
        this.myAdminInfo = info;
        this.myWCAccess = info.getWCAccess();
        this.myIsUnversionedObstructionsAllowed = allowUnversionedObstructions;
        this.myTarget = info.getTargetName();
        this.mySwitchURL = switchURL;
        this.myTargetRevision = -1L;
        this.myRequestedDepth = depth;
        this.myIsDepthSticky = depthIsSticky;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myExtensionPatterns = preservedExtensions;
        this.myFileFetcher = fileFetcher;
        this.myTargetURL = targetURL;
        this.myRootURL = rootURL;
        this.myIsLockOnDemand = lockOnDemand;
        if (this.myTarget != null) {
            this.myTargetURL = SVNPathUtil.append(this.myTargetURL, SVNEncodingUtil.uriEncode(this.myTarget));
        }
        if ("".equals(this.myTarget)) {
            this.myTarget = null;
        }
    }

    private Collection getSkippedTrees() {
        if (this.mySkippedTrees == null) {
            this.mySkippedTrees = new LinkedList();
        }
        return this.mySkippedTrees;
    }

    private Collection getDeletedTrees() {
        if (this.myDeletedTrees == null) {
            this.myDeletedTrees = new LinkedList();
        }
        return this.myDeletedTrees;
    }

    private void addSkippedTree(File path) {
        this.getSkippedTrees().add(path);
    }

    private void addDeletedTree(File path) {
        this.getDeletedTrees().add(path);
    }

    private boolean inSkippedTree(File path) {
        while (path != null && !path.equals(this.myAdminInfo.getAnchor().getRoot())) {
            if (this.getSkippedTrees().contains(path)) {
                return true;
            }
            path = path.getParentFile();
        }
        return false;
    }

    private boolean inDeletedTree(File path, boolean includeRoot) {
        if (!includeRoot) {
            path = path.getParentFile();
        }
        while (path != null && !path.equals(this.myAdminInfo.getAnchor().getRoot())) {
            if (this.getDeletedTrees().contains(path)) {
                return true;
            }
            path = path.getParentFile();
        }
        return false;
    }

    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
        this.myWCAccess.registerCleanupHandler(this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory);
        if (this.myTarget == null) {
            SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
            SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), false);
            if (entry != null) {
                this.myCurrentDirectory.myAmbientDepth = entry.getDepth();
                this.myCurrentDirectory.wasIncomplete = entry.isIncomplete();
                this.myCurrentDirectory.myPreviousRevision = entry.getRevision();
            }
            SVNHashMap attributes = new SVNHashMap();
            attributes.put("svn:entry:revision", Long.toString(this.myTargetRevision));
            attributes.put("svn:entry:url", this.myCurrentDirectory.URL);
            attributes.put("svn:entry:incomplete", Boolean.TRUE.toString());
            if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
                attributes.put("svn:entry:repos", this.myRootURL);
            }
            adminArea.modifyEntry(adminArea.getThisDirName(), attributes, true, false);
            if (this.mySwitchURL != null) {
                this.clearWCProperty(this.myCurrentDirectory.getAdminArea(), null);
            }
        } else if (this.mySwitchURL != null) {
            if (this.myAdminInfo.getTarget() == this.myAdminInfo.getAnchor()) {
                this.clearWCProperty(this.myAdminInfo.getTarget(), this.myTarget);
            } else {
                this.clearWCProperty(this.myAdminInfo.getTarget(), null);
            }
        }
    }

    private void doDeleteEntry(String path, SVNAdminArea parentArea, SVNDirectoryInfo parent, SVNURL theirURL) throws SVNException {
        SVNAdminArea childArea;
        SVNErrorMessage err;
        File fullPath = this.myAdminInfo.getAnchor().getFile(path);
        String name = SVNPathUtil.tail(path);
        SVNEntry entry = this.myWCAccess.getVersionedEntry(fullPath, true);
        if (entry.getDepth() == SVNDepth.EXCLUDE) {
            parentArea.deleteEntry(name);
            parentArea.saveEntries(true);
            if (path.equals(this.myTarget)) {
                this.myIsTargetDeleted = true;
            }
            return;
        }
        SVNNodeKind kind = entry.getKind();
        long previousRevision = entry.getRevision();
        SVNURL url = entry.getSVNURL();
        if (this.inSkippedTree(fullPath) && !this.inDeletedTree(fullPath, true)) {
            return;
        }
        File victim = this.alreadyInTreeConflict(fullPath);
        if (victim != null) {
            this.addSkippedTree(fullPath);
            SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, entry.getKind(), null, this.myTargetRevision, SVNEventAction.SKIP, SVNEventAction.UPDATE_DELETE, null, null);
            event.setPreviousRevision(previousRevision);
            event.setPreviousURL(url);
            this.myWCAccess.handleEvent(event);
            return;
        }
        SVNLog log = parent == null ? parentArea.getLog() : parent.getLog();
        SVNTreeConflictDescription treeConflict = kind == SVNNodeKind.DIR && this.myWCAccess.isMissing(fullPath) && (entry.isScheduledForDeletion() || entry.isScheduledForReplacement()) ? null : this.checkTreeConflict(fullPath, entry, parentArea, log, SVNConflictAction.DELETE, SVNNodeKind.NONE, theirURL);
        if (treeConflict != null) {
            this.addSkippedTree(fullPath);
            SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, entry.getKind(), null, this.myTargetRevision, SVNEventAction.TREE_CONFLICT, SVNEventAction.UPDATE_DELETE, null, null);
            event.setPreviousRevision(entry.getRevision());
            event.setPreviousURL(entry.getSVNURL());
            this.myWCAccess.handleEvent(event);
            if (treeConflict.getConflictReason() == SVNConflictReason.EDITED) {
                if (parent != null) {
                    parent.flushLog();
                    parent.runLogs();
                } else if (log != null) {
                    log.save();
                    parentArea.runLogs();
                }
                this.scheduleExistingEntryForReAdd(entry, fullPath, theirURL);
                return;
            }
            if (treeConflict.getConflictReason() != SVNConflictReason.DELETED) {
                SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Unexpected tree conflict reason");
                SVNErrorManager.error(error, SVNLogType.WC);
            }
        }
        log = parent == null ? parentArea.getLog() : parent.getLog();
        SVNProperties attributes = new SVNProperties();
        attributes.put("name", name);
        log.addCommand("delete-entry", attributes, false);
        attributes.clear();
        if (path.equals(this.myTarget)) {
            attributes.put("name", name);
            attributes.put("name", name);
            attributes.put(SVNProperty.shortPropertyName("svn:entry:kind"), kind == SVNNodeKind.DIR ? "dir" : "file");
            attributes.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(this.myTargetRevision));
            attributes.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.TRUE.toString());
            log.addCommand("modify-entry", attributes, false);
            this.myIsTargetDeleted = true;
        }
        try {
            if (parent != null) {
                parent.flushLog();
            } else if (log != null) {
                log.save();
            }
        }
        catch (SVNException svne) {
            err = svne.getErrorMessage().wrap("Error writing log file for ''{0}''", parent.getPath());
            SVNErrorManager.error(err, svne, SVNLogType.WC);
        }
        if (this.myIsLockOnDemand && kind == SVNNodeKind.DIR && (childArea = this.myWCAccess.getAdminArea(parentArea.getFile(name))) != null && !childArea.isLocked()) {
            childArea.lock(false);
        }
        if (this.mySwitchURL != null && kind == SVNNodeKind.DIR && (childArea = this.myWCAccess.retrieve(parentArea.getFile(name))) != null) {
            try {
                childArea.removeFromRevisionControl(childArea.getThisDirName(), true, false);
            }
            catch (SVNException svne) {
                this.handleLeftLocalModificationsError(svne);
            }
        }
        try {
            if (parent != null) {
                parent.runLogs();
            } else {
                parentArea.runLogs();
            }
        }
        catch (SVNException svne) {
            err = svne.getErrorMessage().wrap("Error running log file for ''{0}''", parentArea.getRoot());
            SVNErrorManager.error(err, svne, SVNLogType.WC);
        }
        if (treeConflict == null && !this.inDeletedTree(fullPath, true)) {
            SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, kind, null, this.myTargetRevision, SVNEventAction.UPDATE_DELETE, null, null, null);
            event.setPreviousRevision(previousRevision);
            event.setPreviousURL(url);
            this.myWCAccess.handleEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File alreadyInTreeConflict(File path) throws SVNException {
        File ancestor = path;
        ArrayList<File> ancestors = new ArrayList<File>();
        SVNWCAccess access = SVNWCAccess.newInstance(this.myWCAccess);
        try {
            access.probeOpen(ancestor, false, 0);
            SVNEntry entry = access.getEntry(path, true);
            if (entry != null) {
                ancestors.add(ancestor);
            }
        }
        finally {
            access.close();
        }
        access = SVNWCAccess.newInstance(this.myWCAccess);
        try {
            for (ancestor = ancestor.getParentFile(); ancestor != null; ancestor = ancestor.getParentFile()) {
                SVNAdminArea adminArea = access.probeOpen(ancestor, false, 0);
                if (adminArea == null) {
                    break;
                }
                boolean isWCRoot = access.isWCRoot(ancestor);
                if (isWCRoot) {
                    break;
                }
                ancestors.add(ancestor);
            }
        }
        finally {
            access.close();
        }
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            ancestor = (File)ancestors.get(i);
            SVNTreeConflictDescription treeConflict = access.getTreeConflict(ancestor);
            if (treeConflict == null) continue;
            return ancestor;
        }
        return null;
    }

    private SVNTreeConflictDescription checkTreeConflict(File path, SVNEntry entry, SVNAdminArea parentArea, SVNLog log, SVNConflictAction action, SVNNodeKind theirKind, SVNURL theirURL) throws SVNException {
        boolean allModsAreDeletes = false;
        boolean isSubtreeOfLocallyDeleted = this.inDeletedTree(path, false);
        SVNConflictReason reason = null;
        if (action == SVNConflictAction.EDIT) {
            if ((entry.isScheduledForDeletion() || entry.isScheduledForReplacement()) && !isSubtreeOfLocallyDeleted) {
                reason = SVNConflictReason.DELETED;
            }
        } else if (action == SVNConflictAction.ADD) {
            if (entry != null && entry.getExternalFilePath() == null) {
                reason = SVNConflictReason.ADDED;
            }
        } else if (action == SVNConflictAction.DELETE) {
            if (entry.isScheduledForDeletion() || entry.isScheduledForReplacement()) {
                if (!isSubtreeOfLocallyDeleted) {
                    reason = SVNConflictReason.DELETED;
                }
            } else {
                SVNAdminArea adminArea;
                boolean modified = false;
                if (entry.isFile()) {
                    modified = this.entryHasLocalModifications(parentArea, path, SVNNodeKind.FILE, entry.getSchedule());
                    if (entry.isScheduledForDeletion()) {
                        allModsAreDeletes = true;
                    }
                } else if (entry.isDirectory() && (adminArea = this.myWCAccess.probeRetrieve(path)).getRoot().equals(path)) {
                    boolean[] allEditsAreDeletes = new boolean[1];
                    modified = this.treeHasLocalModifications(adminArea, allEditsAreDeletes);
                    allModsAreDeletes = allEditsAreDeletes[0];
                }
                if (modified) {
                    reason = allModsAreDeletes ? SVNConflictReason.DELETED : SVNConflictReason.EDITED;
                }
            }
        }
        if (reason != null) {
            SVNNodeKind leftKind = entry.isScheduledForAddition() ? SVNNodeKind.NONE : (entry.isScheduledForDeletion() ? SVNNodeKind.UNKNOWN : entry.getKind());
            SVNURL repoRoot = entry.getRepositoryRootURL();
            String repoPath = SVNPathUtil.getPathAsChild(repoRoot.getPath(), entry.getSVNURL().getPath());
            repoPath = repoPath != null ? repoPath : "/";
            SVNConflictVersion srcLeftVersion = new SVNConflictVersion(repoRoot, repoPath, entry.getRevision(), leftKind);
            if (this.mySwitchURL != null) {
                if (theirURL != null) {
                    repoPath = SVNPathUtil.getPathAsChild(repoRoot.getPath(), theirURL.getPath());
                } else {
                    SVNURL switchURL = SVNURL.parseURIEncoded(this.mySwitchURL);
                    repoPath = SVNPathUtil.getPathAsChild(repoRoot.getPath(), switchURL.getPath());
                }
            }
            SVNConflictVersion srcRightVersion = new SVNConflictVersion(repoRoot, repoPath, this.myTargetRevision, theirKind);
            SVNTreeConflictDescription treeConflict = new SVNTreeConflictDescription(path, entry.getKind(), action, reason, this.mySwitchURL != null ? SVNOperation.SWITCH : SVNOperation.UPDATE, srcLeftVersion, srcRightVersion);
            SVNHashMap conflicts = new SVNHashMap();
            conflicts.put(treeConflict.getPath(), treeConflict);
            String conflictData = SVNTreeConflictUtil.getTreeConflictData(conflicts);
            SVNProperties command = new SVNProperties();
            command.put("name", parentArea.getThisDirName());
            command.put("data", conflictData);
            log.addCommand("add-tree-conflict", command, false);
            return treeConflict;
        }
        return null;
    }

    public boolean treeHasLocalModifications(SVNAdminArea adminArea, final boolean[] allModsAreDeletes) throws SVNException {
        final boolean[] modified = new boolean[]{false};
        if (allModsAreDeletes != null) {
            allModsAreDeletes[0] = true;
        }
        ISVNEntryHandler entryHandler = new ISVNEntryHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEntry(File path, SVNEntry entry) throws SVNException {
                SVNAdminArea entryArea;
                try {
                    entryArea = SVNUpdateEditor.this.myWCAccess.probeRetrieve(path);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED) {
                        ISVNEventHandler eventHandler = SVNUpdateEditor.this.myWCAccess.getEventHandler();
                        SVNUpdateEditor.this.myWCAccess.setEventHandler(null);
                        try {
                            entryArea = SVNUpdateEditor.this.myWCAccess.open(path, false, -1);
                        }
                        finally {
                            SVNUpdateEditor.this.myWCAccess.setEventHandler(eventHandler);
                        }
                    }
                    throw e;
                }
                boolean hasModifications = SVNUpdateEditor.this.entryHasLocalModifications(entryArea, path, entry.getKind(), entry.getSchedule());
                if (hasModifications) {
                    modified[0] = true;
                    if (!entry.isScheduledForDeletion()) {
                        allModsAreDeletes[0] = false;
                    }
                }
            }

            public void handleError(File path, SVNErrorMessage error) throws SVNException {
                SVNErrorManager.error(error, SVNLogType.WC);
            }
        };
        adminArea.walkThisDirectory(entryHandler, false, SVNDepth.INFINITY);
        return modified[0];
    }

    private boolean entryHasLocalModifications(SVNAdminArea adminArea, File path, SVNNodeKind kind, String schedule) throws SVNException {
        boolean modified;
        if (schedule != null) {
            modified = true;
        } else {
            SVNAdminArea tmpArea;
            boolean textModified = false;
            if (kind == SVNNodeKind.FILE) {
                textModified = adminArea.hasTextModifications(path.getName(), false);
            }
            boolean propsModified = kind == SVNNodeKind.FILE ? adminArea.hasPropModifications(path.getName()) : (path.equals(adminArea.getRoot()) ? adminArea.hasPropModifications(adminArea.getThisDirName()) : ((tmpArea = this.myWCAccess.probeRetrieve(path)).getRoot().equals(path) ? tmpArea.hasPropModifications(tmpArea.getThisDirName()) : tmpArea.hasPropConflict(path.getName())));
            modified = textModified || propsModified;
        }
        return modified;
    }

    private void scheduleExistingEntryForReAdd(SVNEntry entry, final File path, SVNURL theirURL) throws SVNException {
        SVNAdminArea area;
        File parentPath = path.getParentFile();
        String entryName = path.getName();
        SVNHashMap attributes = new SVNHashMap();
        attributes.put("svn:entry:url", theirURL.toString());
        attributes.put("svn:entry:schedule", "add");
        attributes.put("svn:entry:copyfrom-url", entry.getURL());
        attributes.put("svn:entry:copyfrom-rev", String.valueOf(entry.getRevision()));
        attributes.put("svn:entry:copied", Boolean.TRUE.toString());
        if (this.myIsLockOnDemand && entry.isDirectory() && (area = this.myWCAccess.getAdminArea(path)) != null && !area.isLocked()) {
            area.lock(false);
        }
        final SVNAdminArea adminArea = this.myWCAccess.retrieve(entry.isDirectory() ? path : parentPath);
        adminArea.modifyEntry(entry.isDirectory() ? adminArea.getThisDirName() : entryName, attributes, true, true);
        if (entry.isDirectory()) {
            ISVNEntryHandler entryHandler = new ISVNEntryHandler(){

                public void handleEntry(File ePath, SVNEntry e) throws SVNException {
                    if (!path.equals(ePath)) {
                        SVNAdminArea childArea;
                        if (SVNUpdateEditor.this.myIsLockOnDemand && e.isDirectory() && !adminArea.getThisDirName().equals(e.getName()) && (childArea = SVNUpdateEditor.this.myWCAccess.getAdminArea(ePath)) != null && !childArea.isLocked()) {
                            childArea.lock(false);
                        }
                        SVNAdminArea eArea = adminArea.getThisDirName().equals(e.getName()) ? SVNUpdateEditor.this.myWCAccess.retrieve(ePath) : SVNUpdateEditor.this.myWCAccess.retrieve(ePath.getParentFile());
                        if (e.getSchedule() == null) {
                            SVNHashMap eAttrs = new SVNHashMap();
                            eAttrs.put("svn:entry:copied", Boolean.TRUE.toString());
                            eArea.modifyEntry(e.getName(), eAttrs, true, false);
                        }
                    }
                }

                public void handleError(File path2, SVNErrorMessage error) throws SVNException {
                    SVNErrorManager.error(error, SVNLogType.WC);
                }
            };
            adminArea.walkThisDirectory(entryHandler, false, SVNDepth.INFINITY);
            SVNAdminArea parentArea = this.myWCAccess.retrieve(parentPath);
            parentArea.getVersionedEntry(parentArea.getThisDirName(), true);
            parentArea.modifyEntry(entryName, attributes, true, true);
        }
    }

    public void deleteEntry(String path, long revision) throws SVNException {
        this.checkIfPathIsUnderRoot(path);
        String name = SVNPathUtil.tail(path);
        SVNURL url = SVNURL.parseURIEncoded(this.myCurrentDirectory.URL);
        SVNURL theirURL = url.appendPath(name, false);
        this.checkIfPathIsUnderRoot(path);
        this.doDeleteEntry(path, this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory, theirURL);
    }

    private void handleLeftLocalModificationsError(SVNException originalError) throws SVNException {
        SVNException error = null;
        error = originalError;
        while (error != null && error.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            error = error.getCause() instanceof SVNException ? (SVNException)error.getCause() : null;
        }
        if (error != null) {
            return;
        }
        throw originalError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNAdminArea childArea;
        SVNHashMap attributes;
        SVNEntry entry;
        SVNAdminArea parentArea;
        boolean isLocallyDeleted;
        String name;
        File fullPath;
        block40: {
            SVNErrorMessage err;
            block39: {
                SVNFileType kind;
                fullPath = this.myAdminInfo.getAnchor().getFile(path);
                name = SVNPathUtil.tail(path);
                isLocallyDeleted = this.inDeletedTree(fullPath, true);
                parentArea = this.myCurrentDirectory.getAdminArea();
                SVNDirectoryInfo parentDirectory = this.myCurrentDirectory;
                this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, path, true);
                this.myCurrentDirectory.myPreviousRevision = -1L;
                this.myCurrentDirectory.myAmbientDepth = path.equals(this.myTarget) ? (this.myRequestedDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : this.myRequestedDepth) : (this.myRequestedDepth == SVNDepth.IMMEDIATES || this.myRequestedDepth == SVNDepth.UNKNOWN && parentDirectory.myAmbientDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : SVNDepth.INFINITY);
                parentDirectory.flushLog();
                this.checkIfPathIsUnderRoot(path);
                if (this.inSkippedTree(fullPath) && !isLocallyDeleted) {
                    return;
                }
                File victim = this.alreadyInTreeConflict(fullPath);
                if (victim != null) {
                    this.addSkippedTree(fullPath);
                    SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.DIR, null, this.myTargetRevision, SVNEventAction.SKIP, SVNEventAction.UPDATE_ADD, null, null);
                    this.myWCAccess.handleEvent(event);
                }
                if ((kind = SVNFileType.getType(fullPath)) == SVNFileType.FILE || kind == SVNFileType.UNKNOWN) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': a non-directory object of the same name already exists", path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (kind == SVNFileType.DIRECTORY) {
                    SVNAdminArea adminArea = null;
                    try {
                        adminArea = SVNWCAccess.newInstance(null).open(fullPath, false, 0);
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                            throw svne;
                        }
                        if (this.myIsUnversionedObstructionsAllowed) {
                            this.myCurrentDirectory.isExisted = true;
                        }
                        SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': an unversioned directory of the same name already exists", this.myCurrentDirectory.getPath());
                        SVNErrorManager.error(err2, SVNLogType.WC);
                    }
                    if (adminArea != null) {
                        try {
                            SVNErrorMessage err3;
                            SVNEntry entry2 = adminArea.getEntry(adminArea.getThisDirName(), false);
                            SVNEntry parentEntry = parentArea.getEntry(parentArea.getThisDirName(), false);
                            SVNEntry entryInParent = (SVNEntry)parentArea.getEntries().get(name);
                            if (entry2 != null && parentEntry != null && entry2.getUUID() != null && parentEntry.getUUID() != null && !entry2.getUUID().equals(parentEntry.getUUID())) {
                                err3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "UUID mismatch: existing directory ''{0}'' was checked out from a different repository", this.myCurrentDirectory.getPath());
                                SVNErrorManager.error(err3, SVNLogType.WC);
                            }
                            if (entry2 != null && this.mySwitchURL == null && this.myCurrentDirectory.URL != null && !this.myCurrentDirectory.URL.equals(entry2.getURL())) {
                                err3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL ''{0}'' of existing directory ''{1}'' does not match expected URL ''{2}''", new Object[]{entry2.getURL(), this.myCurrentDirectory.getPath(), this.myCurrentDirectory.URL});
                                SVNErrorManager.error(err3, SVNLogType.WC);
                            }
                            if (entryInParent == null) {
                                err3 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': a versioned directory of the same name already exists", this.myCurrentDirectory.getPath());
                                SVNErrorManager.error(err3, SVNLogType.WC);
                            }
                            if (entry2 != null && (entry2.isScheduledForAddition() || entry2.isScheduledForReplacement()) && !entry2.isCopied()) {
                                this.myCurrentDirectory.isAddExisted = true;
                                break block39;
                            }
                            SVNURL theirURL = SVNURL.parseURIEncoded(this.myCurrentDirectory.URL);
                            SVNTreeConflictDescription treeConflict = this.checkTreeConflict(fullPath, entry2, parentArea, parentDirectory.getLog(), SVNConflictAction.ADD, SVNNodeKind.DIR, theirURL);
                            try {
                                parentDirectory.flushLog();
                            }
                            catch (SVNException svne) {
                                SVNErrorMessage err4 = svne.getErrorMessage().wrap("Error writing log file for ''{0}''", parentDirectory.getPath());
                                SVNErrorManager.error(err4, svne, SVNLogType.WC);
                            }
                            if (treeConflict != null) {
                                this.addSkippedTree(fullPath);
                                SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.DIR, null, this.myTargetRevision, SVNEventAction.TREE_CONFLICT, SVNEventAction.UPDATE_ADD, null, null);
                                if (entry2 != null) {
                                    event.setPreviousRevision(entry2.getRevision());
                                    event.setPreviousURL(entry2.getSVNURL());
                                }
                                this.myWCAccess.handleEvent(event);
                                return;
                            }
                        }
                        finally {
                            adminArea.getWCAccess().close();
                        }
                    }
                }
            }
            if (SVNFileUtil.getAdminDirectoryName().equals(name)) {
                err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'':  object of the same name as the administrative directory", path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (copyFromPath != null || SVNRevision.isValidRevisionNumber(copyFromRevision)) {
                err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Failed to add directory ''{0}'': copyfrom arguments not yet supported", path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            entry = parentArea.getEntry(name, false);
            attributes = new SVNHashMap();
            attributes.put("svn:entry:kind", "dir");
            attributes.put("svn:entry:absent", null);
            attributes.put("svn:entry:deleted", null);
            boolean force = false;
            if (this.myCurrentDirectory.isAddExisted) {
                attributes.put("svn:entry:schedule", null);
                force = true;
            }
            entry = parentArea.modifyEntry(name, attributes, true, force);
            if (this.myCurrentDirectory.isAddExisted) {
                attributes.put("svn:entry:revision", Long.toString(this.myTargetRevision));
                if (this.mySwitchURL != null) {
                    attributes.put("svn:entry:url", this.myCurrentDirectory.URL);
                }
                SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
                adminArea.modifyEntry(adminArea.getThisDirName(), attributes, true, true);
            }
            String rootURL = null;
            if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
                rootURL = this.myRootURL;
            }
            SVNWCManager.ensureAdminAreaExists(fullPath, this.myCurrentDirectory.URL, rootURL, null, this.myTargetRevision, this.myCurrentDirectory.myAmbientDepth);
            childArea = null;
            if (!this.myAdminInfo.getAnchor().getRoot().equals(fullPath)) {
                ISVNEventHandler eventHandler = this.myWCAccess.getEventHandler();
                try {
                    this.myWCAccess.setEventHandler(null);
                    childArea = this.myWCAccess.open(fullPath, true, 0);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                        childArea = this.myWCAccess.retrieve(fullPath);
                        break block40;
                    }
                    throw e;
                }
                finally {
                    this.myWCAccess.setEventHandler(eventHandler);
                }
            }
        }
        if (isLocallyDeleted) {
            attributes.clear();
            attributes.put("svn:entry:schedule", "delete");
            parentArea.modifyEntry(name, attributes, true, false);
            childArea = this.myWCAccess.retrieve(fullPath);
            childArea.modifyEntry(childArea.getThisDirName(), attributes, true, false);
        }
        try {
            childArea = this.myWCAccess.open(fullPath, true, 0);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_LOCKED) {
                childArea = this.myWCAccess.retrieve(fullPath);
            }
            throw e;
        }
        if (childArea != null) {
            this.myWCAccess.registerCleanupHandler(childArea, this.myCurrentDirectory);
        }
        if (!this.myCurrentDirectory.isAddExisted && !isLocallyDeleted) {
            SVNEvent event = SVNEventFactory.createSVNEvent(parentArea.getFile(entry.getName()), SVNNodeKind.DIR, null, this.myTargetRevision, this.myCurrentDirectory.isExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_ADD, null, null, null);
            event.setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
            event.setPreviousURL(entry.getSVNURL());
            event.setURL(this.myCurrentDirectory.URL != null ? SVNURL.parseURIEncoded(this.myCurrentDirectory.URL) : null);
            this.myWCAccess.handleEvent(event);
        }
    }

    public void openDir(String path, long revision) throws SVNException {
        SVNConflictDescription treeConflict;
        this.myCurrentDirectory.flushLog();
        this.checkIfPathIsUnderRoot(path);
        SVNDirectoryInfo parentInfo = this.myCurrentDirectory;
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, path, false);
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        this.myWCAccess.registerCleanupHandler(adminArea, this.myCurrentDirectory);
        SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), true);
        if (entry != null) {
            this.myCurrentDirectory.myPreviousRevision = entry.getRevision();
            this.myCurrentDirectory.myAmbientDepth = entry.getDepth();
            this.myCurrentDirectory.wasIncomplete = entry.isIncomplete();
        } else {
            this.myCurrentDirectory.myPreviousRevision = -1L;
        }
        File fullPath = this.myAdminInfo.getAnchor().getFile(path);
        if (this.inSkippedTree(fullPath) && !this.inDeletedTree(fullPath, true)) {
            this.myCurrentDirectory.isSkipped = true;
            return;
        }
        File victim = this.alreadyInTreeConflict(fullPath);
        if (victim != null) {
            treeConflict = null;
        } else {
            SVNURL theirURL = SVNURL.parseURIEncoded(this.myCurrentDirectory.URL);
            treeConflict = this.checkTreeConflict(fullPath, entry, parentInfo.getAdminArea(), parentInfo.getLog(), SVNConflictAction.EDIT, SVNNodeKind.DIR, theirURL);
        }
        if (treeConflict != null && treeConflict.getConflictReason() == SVNConflictReason.DELETED && !this.inDeletedTree(fullPath, true)) {
            this.addDeletedTree(fullPath);
        }
        boolean hasPropConflicts = adminArea.hasPropConflict(adminArea.getThisDirName());
        if (victim != null || treeConflict != null || hasPropConflicts) {
            if (!this.inDeletedTree(fullPath, true)) {
                this.myCurrentDirectory.isSkipped = true;
            }
            this.addSkippedTree(fullPath);
            if (!this.inDeletedTree(fullPath, false)) {
                SVNEventAction eventAction = hasPropConflicts ? SVNEventAction.SKIP : SVNEventAction.TREE_CONFLICT;
                SVNStatusType propStatus = hasPropConflicts ? SVNStatusType.CONFLICTED : null;
                SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.DIR, null, this.myTargetRevision, null, propStatus, null, eventAction, SVNEventAction.UPDATE_UPDATE, null, null);
                event.setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
                if (this.myCurrentDirectory.URL != null) {
                    event.setURL(SVNURL.parseURIEncoded(this.myCurrentDirectory.URL));
                }
                if (entry != null) {
                    event.setPreviousURL(entry.getSVNURL());
                }
                this.myWCAccess.handleEvent(event);
            }
            if (hasPropConflicts || treeConflict != null && treeConflict.getConflictReason() != SVNConflictReason.DELETED) {
                return;
            }
        }
        SVNHashMap attributes = new SVNHashMap();
        attributes.put("svn:entry:revision", Long.toString(this.myTargetRevision));
        attributes.put("svn:entry:url", this.myCurrentDirectory.URL);
        attributes.put("svn:entry:incomplete", Boolean.TRUE.toString());
        if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
            attributes.put("svn:entry:repos", this.myRootURL);
        }
        entry = adminArea.modifyEntry(adminArea.getThisDirName(), attributes, true, false);
    }

    public void absentDir(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.DIR);
    }

    public void absentFile(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.FILE);
    }

    private void absentEntry(String path, SVNNodeKind kind) throws SVNException {
        String name = SVNPathUtil.tail(path);
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry entry = adminArea.getEntry(name, false);
        if (entry != null && entry.isScheduledForAddition()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to mark ''{0}'' absent: item of the same name is already scheduled for addition", path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNHashMap attributes = new SVNHashMap();
        attributes.put("svn:entry:revision", Long.toString(this.myTargetRevision));
        attributes.put("svn:entry:kind", kind.toString());
        attributes.put("svn:entry:deleted", null);
        attributes.put("svn:entry:absent", Boolean.TRUE.toString());
        entry = adminArea.modifyEntry(name, attributes, true, false);
    }

    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!this.myCurrentDirectory.isSkipped) {
            this.myCurrentDirectory.propertyChanged(name, value);
        }
    }

    private void clearWCProperty(SVNAdminArea adminArea, String target) throws SVNException {
        if (adminArea == null) {
            return;
        }
        Iterator ents = adminArea.entries(false);
        while (ents.hasNext()) {
            SVNVersionedProperties props;
            SVNEntry entry = (SVNEntry)ents.next();
            if (target != null) {
                if (!entry.isFile() || !target.equals(entry.getName())) continue;
                props = adminArea.getWCProperties(entry.getName());
                props.setPropertyValue("svn:wc:ra_dav:version-url", null);
                adminArea.saveWCProperties(false);
                continue;
            }
            if (entry.isFile() || adminArea.getThisDirName().equals(entry.getName())) {
                props = adminArea.getWCProperties(entry.getName());
                props.setPropertyValue("svn:wc:ra_dav:version-url", null);
                adminArea.saveWCProperties(false);
                continue;
            }
            SVNAdminArea childArea = this.myAdminInfo.getWCAccess().getAdminArea(adminArea.getFile(entry.getName()));
            this.clearWCProperty(childArea, null);
        }
    }

    public void closeDir() throws SVNException {
        File fullPath = this.myAdminInfo.getAnchor().getFile(this.myCurrentDirectory.getPath());
        if (this.inSkippedTree(fullPath) && !this.inDeletedTree(fullPath, true)) {
            this.maybeBumpDirInfo(this.myCurrentDirectory);
            this.myCurrentDirectory = this.myCurrentDirectory.Parent;
            return;
        }
        SVNProperties modifiedWCProps = this.myCurrentDirectory.getChangedWCProperties();
        SVNProperties modifiedEntryProps = this.myCurrentDirectory.getChangedEntryProperties();
        SVNProperties modifiedProps = this.myCurrentDirectory.getChangedProperties();
        SVNStatusType propStatus = SVNStatusType.UNKNOWN;
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        if (this.myCurrentDirectory.wasIncomplete) {
            SVNVersionedProperties oldBaseProps = adminArea.getBaseProperties(adminArea.getThisDirName());
            SVNProperties baseMap = oldBaseProps.asMap();
            if (modifiedProps == null) {
                modifiedProps = new SVNProperties();
            }
            Iterator names = baseMap.nameSet().iterator();
            while (names.hasNext()) {
                String name = (String)names.next();
                if (modifiedProps.containsName(name)) continue;
                modifiedProps.put(name, SVNPropertyValue.create(null));
            }
        }
        if (modifiedWCProps != null || modifiedEntryProps != null || modifiedProps != null) {
            SVNLog log = this.myCurrentDirectory.getLog();
            if (modifiedProps != null && !modifiedProps.isEmpty()) {
                if (modifiedProps.containsName("svn:externals")) {
                    String oldExternal = adminArea.getProperties(adminArea.getThisDirName()).getStringPropertyValue("svn:externals");
                    String newExternal = modifiedProps.getStringValue("svn:externals");
                    String path = this.myCurrentDirectory.getPath();
                    if (oldExternal == null && newExternal != null) {
                        this.myAdminInfo.addExternal(path, oldExternal, newExternal);
                        this.myAdminInfo.addDepth(path, this.myCurrentDirectory.myAmbientDepth);
                    } else if (oldExternal != null && newExternal == null) {
                        this.myAdminInfo.addExternal(path, oldExternal, newExternal);
                        this.myAdminInfo.addDepth(path, this.myCurrentDirectory.myAmbientDepth);
                    } else if (oldExternal != null && !oldExternal.equals(newExternal)) {
                        this.myAdminInfo.addExternal(path, oldExternal, newExternal);
                        this.myAdminInfo.addDepth(path, this.myCurrentDirectory.myAmbientDepth);
                    }
                }
                SVNVersionedProperties oldBaseProps = adminArea.getBaseProperties(adminArea.getThisDirName());
                try {
                    propStatus = adminArea.mergeProperties(adminArea.getThisDirName(), oldBaseProps.asMap(), modifiedProps, null, null, true, false, log);
                }
                catch (SVNException svne) {
                    SVNErrorMessage err = svne.getErrorMessage().wrap("Couldn't do property merge");
                    SVNErrorManager.error(err, svne, SVNLogType.WC);
                }
            }
            log.logChangedEntryProperties(adminArea.getThisDirName(), modifiedEntryProps);
            log.logChangedWCProperties(adminArea.getThisDirName(), modifiedWCProps);
        }
        this.myCurrentDirectory.flushLog();
        this.myCurrentDirectory.runLogs();
        this.maybeBumpDirInfo(this.myCurrentDirectory);
        if (!(this.myCurrentDirectory.isSkipped || !this.myCurrentDirectory.isAddExisted && this.myCurrentDirectory.IsAdded || this.inDeletedTree(fullPath, true) || adminArea == this.myAdminInfo.getAnchor() && !"".equals(this.myAdminInfo.getTargetName()))) {
            SVNEventAction action;
            SVNEventAction sVNEventAction = action = this.myCurrentDirectory.isAddExisted || this.myCurrentDirectory.isExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_UPDATE;
            if (propStatus == SVNStatusType.UNKNOWN && action != SVNEventAction.UPDATE_EXISTS) {
                action = SVNEventAction.UPDATE_NONE;
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(adminArea.getRoot(), SVNNodeKind.DIR, null, this.myTargetRevision, SVNStatusType.UNKNOWN, propStatus, null, action, null, null, null);
            event.setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
            event.setURL(this.myCurrentDirectory.URL != null ? SVNURL.parseURIEncoded(this.myCurrentDirectory.URL) : null);
            this.myWCAccess.handleEvent(event);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.Parent;
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myTarget != null && this.myWCAccess.isMissing(this.myAdminInfo.getAnchor().getFile(this.myTarget))) {
            this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            this.myWCAccess.registerCleanupHandler(this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory);
            this.doDeleteEntry(this.myTarget, this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory, null);
        }
        if (!this.myIsRootOpen) {
            if (this.myCurrentDirectory == null) {
                this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            }
            this.completeDirectory(this.myCurrentDirectory);
        }
        if (!this.myIsTargetDeleted) {
            File targetFile = this.myTarget != null ? this.myAdminInfo.getAnchor().getFile(this.myTarget) : this.myAdminInfo.getAnchor().getRoot();
            this.getSkippedTrees().removeAll(this.getDeletedTrees());
            SVNWCManager.updateCleanup(targetFile, this.myWCAccess, this.mySwitchURL, this.myRootURL, this.myTargetRevision, true, this.getSkippedTrees(), this.myRequestedDepth, this.myIsLockOnDemand);
        }
        return null;
    }

    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = this.addFile(this.myCurrentDirectory, path, copyFromPath, copyFromRevision);
    }

    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = this.openFile(path, this.myCurrentDirectory);
    }

    public void changeFileProperty(String commitPath, String name, SVNPropertyValue value) throws SVNException {
        this.changeFileProperty(name, value, this.myCurrentFile);
    }

    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        String checksum;
        if (this.myCurrentFile.isSkipped) {
            return;
        }
        this.myCurrentFile.receivedTextDelta = true;
        SVNAdminArea adminArea = this.myCurrentFile.getAdminArea();
        SVNEntry entry = adminArea.getEntry(this.myCurrentFile.name, false);
        boolean replaced = entry != null && entry.isScheduledForReplacement();
        boolean useRevertBase = replaced;
        if (useRevertBase) {
            this.myCurrentFile.baseFile = adminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.name, false));
            this.myCurrentFile.newBaseFile = adminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.name, true));
        } else {
            this.myCurrentFile.baseFile = adminArea.getBaseFile(this.myCurrentFile.name, false);
            this.myCurrentFile.newBaseFile = adminArea.getBaseFile(this.myCurrentFile.name, true);
        }
        String string = checksum = entry != null ? entry.getChecksum() : null;
        if (!replaced && baseChecksum != null && checksum != null && !baseChecksum.equals(checksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; expected: ''{1}'', recorded: ''{2}''", new Object[]{this.myCurrentFile.baseFile, baseChecksum, checksum});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File baseSrcFile = null;
        if (!this.myCurrentFile.IsAdded) {
            baseSrcFile = this.myCurrentFile.baseFile;
        } else if (this.myCurrentFile.copiedBaseText != null) {
            baseSrcFile = this.myCurrentFile.copiedBaseText;
        }
        if (replaced || checksum == null) {
            checksum = baseChecksum;
        }
        File baseTmpFile = this.myCurrentFile.newBaseFile;
        if (checksum != null) {
            this.myCurrentFile.expectedSrcChecksum = checksum;
            InputStream baseIS = baseSrcFile != null && baseSrcFile.exists() ? SVNFileUtil.openFileForReading(baseSrcFile) : SVNFileUtil.DUMMY_IN;
            this.myCurrentFile.sourceChecksumStream = baseIS != SVNFileUtil.DUMMY_IN ? new SVNChecksumInputStream(baseIS, "MD5") : null;
            this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.sourceChecksumStream != null ? this.myCurrentFile.sourceChecksumStream : baseIS, baseTmpFile, true);
        } else {
            this.myDeltaProcessor.applyTextDelta(baseSrcFile, baseTmpFile, true);
        }
    }

    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        if (!this.myCurrentFile.isSkipped) {
            try {
                this.myDeltaProcessor.textDeltaChunk(diffWindow);
            }
            catch (SVNException svne) {
                this.myDeltaProcessor.textDeltaEnd();
                SVNFileUtil.deleteFile(this.myCurrentFile.newBaseFile);
                this.myCurrentFile.newBaseFile = null;
                throw svne;
            }
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    public void textDeltaEnd(String commitPath) throws SVNException {
        if (!this.myCurrentFile.isSkipped) {
            this.myCurrentFile.checksum = this.myDeltaProcessor.textDeltaEnd();
        }
        if (this.myCurrentFile.expectedSrcChecksum != null) {
            String actualSourceChecksum;
            String string = actualSourceChecksum = this.myCurrentFile.sourceChecksumStream != null ? this.myCurrentFile.sourceChecksumStream.getDigest() : null;
            if (!this.myCurrentFile.expectedSrcChecksum.equals(actualSourceChecksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch while updating ''{0}''; expected: ''{1}'', actual: ''{2}''", new Object[]{this.myCurrentFile.baseFile, this.myCurrentFile.expectedSrcChecksum, actualSourceChecksum});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        this.closeFile(textChecksum, this.myCurrentFile, this.myCurrentDirectory);
        this.myCurrentFile = null;
    }

    public void abortEdit() throws SVNException {
    }

    private void checkIfPathIsUnderRoot(String path) throws SVNException {
        if (SVNFileUtil.isWindows && path != null) {
            String testPath = path.replace(File.separatorChar, '/');
            int ind = -1;
            while (testPath.length() > 0 && (ind = testPath.indexOf("..")) != -1) {
                if (ind == 0 || testPath.charAt(ind - 1) == '/') {
                    SVNErrorMessage err;
                    int i;
                    for (i = ind + 2; i < testPath.length(); ++i) {
                        if (testPath.charAt(i) == '.') continue;
                        if (testPath.charAt(i) != '/') break;
                        err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' is not in the working copy", path);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if (i == testPath.length()) {
                        err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' is not in the working copy", path);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    testPath = testPath.substring(i);
                    continue;
                }
                testPath = testPath.substring(ind + 2);
            }
        }
    }

    private void maybeBumpDirInfo(SVNDirectoryInfo dirInfo) throws SVNException {
        while (dirInfo != null) {
            --dirInfo.RefCount;
            if (dirInfo.RefCount > 0) {
                return;
            }
            if (!dirInfo.isSkipped) {
                this.completeDirectory(dirInfo);
            }
            dirInfo = dirInfo.Parent;
        }
    }

    private void completeDirectory(SVNDirectoryInfo dirInfo) throws SVNException {
        File file = this.myAdminInfo.getAnchor().getFile(dirInfo.getPath());
        if (this.inSkippedTree(file) && !this.inDeletedTree(file, true)) {
            return;
        }
        if (dirInfo.Parent == null && this.myTarget != null) {
            SVNAdminArea adminArea;
            SVNEntry entry;
            if ((this.myIsDepthSticky || this.myTarget != null) && (entry = (adminArea = dirInfo.getAdminArea()).getEntry(this.myTarget, true)) != null && entry.getDepth() == SVNDepth.EXCLUDE) {
                File target = this.myAdminInfo.getAnchor().getFile(this.myTarget);
                SVNAdminArea targetArea = this.myWCAccess.getAdminArea(target);
                if (targetArea == null && entry.isDirectory()) {
                    this.doDeleteEntry(this.myTarget, this.myAdminInfo.getAnchor(), null, null);
                } else {
                    entry.setDepth(SVNDepth.INFINITY);
                    adminArea.saveEntries(false);
                }
            }
            return;
        }
        SVNAdminArea adminArea = dirInfo.getAdminArea();
        SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No ''.'' entry found in ''{0}''", adminArea.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        entry.setIncomplete(false);
        File target = this.myAdminInfo.getTarget().getRoot();
        if (this.myIsDepthSticky && (this.myRequestedDepth == SVNDepth.INFINITY || adminArea.getRoot().equals(target) && this.myRequestedDepth.compareTo(entry.getDepth()) > 0)) {
            entry.setDepth(this.myRequestedDepth);
            this.myAdminInfo.addDepth(dirInfo.getPath(), this.myRequestedDepth);
        }
        Iterator ents = adminArea.entries(true);
        while (ents.hasNext()) {
            SVNEntry currentEntry = (SVNEntry)ents.next();
            if (currentEntry.isDeleted()) {
                if (!currentEntry.isScheduledForAddition()) {
                    adminArea.deleteEntry(currentEntry.getName());
                    continue;
                }
                SVNHashMap attributes = new SVNHashMap();
                attributes.put("svn:entry:deleted", null);
                adminArea.modifyEntry(currentEntry.getName(), attributes, false, false);
                continue;
            }
            if (currentEntry.isAbsent() && currentEntry.getRevision() != this.myTargetRevision) {
                adminArea.deleteEntry(currentEntry.getName());
                continue;
            }
            if (currentEntry.getKind() != SVNNodeKind.DIR) continue;
            if (currentEntry.getDepth() == SVNDepth.EXCLUDE) {
                if (!this.myIsDepthSticky || this.myRequestedDepth.compareTo(SVNDepth.IMMEDIATES) < 0) continue;
                currentEntry.setDepth(SVNDepth.INFINITY);
                continue;
            }
            if (!this.myWCAccess.isMissing(adminArea.getFile(currentEntry.getName())) || currentEntry.isAbsent() || currentEntry.isScheduledForAddition()) continue;
            adminArea.deleteEntry(currentEntry.getName());
            this.myWCAccess.handleEvent(SVNEventFactory.createSVNEvent(adminArea.getFile(currentEntry.getName()), currentEntry.getKind(), null, currentEntry.getRevision(), SVNEventAction.UPDATE_DELETE, null, null, null));
        }
        adminArea.saveEntries(true);
    }

    private SVNFileInfo addFile(SVNDirectoryInfo parent, String path, String copyFromPath, long copyFromRevision) throws SVNException {
        File fullPath = this.myAdminInfo.getAnchor().getFile(path);
        boolean isLocallyDeleted = this.inDeletedTree(fullPath, true);
        if (!(copyFromPath == null && !SVNRevision.isValidRevisionNumber(copyFromRevision) || copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision))) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Bad copyfrom arguments received.");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        SVNFileInfo info = this.createFileInfo(this.myCurrentDirectory, path, true);
        if (this.inSkippedTree(fullPath) && !isLocallyDeleted) {
            info.isSkipped = true;
            return info;
        }
        info.isDeleted = isLocallyDeleted;
        this.checkIfPathIsUnderRoot(path);
        SVNAdminArea adminArea = parent.getAdminArea();
        SVNFileType fileType = SVNFileType.getType(adminArea.getFile(info.name));
        SVNEntry entry = adminArea.getEntry(info.name, false);
        File victim = this.alreadyInTreeConflict(fullPath);
        if (victim != null) {
            info.isSkipped = true;
            this.addSkippedTree(fullPath);
            SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.FILE, null, this.myTargetRevision, SVNEventAction.SKIP, SVNEventAction.UPDATE_ADD, null, null);
            if (entry != null) {
                event.setPreviousRevision(entry.getRevision());
                event.setPreviousURL(entry.getSVNURL());
            }
            this.myWCAccess.handleEvent(event);
            return info;
        }
        if (fileType == SVNFileType.DIRECTORY || fileType == SVNFileType.UNKNOWN) {
            SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': a non-file object of the same name already exists", path);
            SVNErrorManager.error(error, SVNLogType.WC);
        }
        if (entry == null && (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK)) {
            if (this.myIsUnversionedObstructionsAllowed) {
                info.isExisted = true;
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': an unversioned file of the same name already exists", path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        if (entry != null) {
            SVNErrorMessage error;
            SVNEntry parentEntry = adminArea.getEntry(adminArea.getThisDirName(), false);
            if (entry.getUUID() != null && !entry.getUUID().equals(parentEntry.getUUID())) {
                error = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "UUID mismatch: existing file ''{0}'' was checked out from a different repository", fullPath);
                SVNErrorManager.error(error, SVNLogType.WC);
            }
            if (this.mySwitchURL == null && !info.URL.equals(entry.getURL())) {
                error = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "URL ''{0}'' of existing file ''{1}'' does not match expected URL ''{2}''", new Object[]{entry.getURL(), fullPath, info.URL});
                SVNErrorManager.error(error, SVNLogType.WC);
            }
        }
        if (entry != null && (fileType == SVNFileType.FILE || fileType == SVNFileType.SYMLINK)) {
            if ((entry.isScheduledForAddition() || entry.isScheduledForReplacement()) && !entry.isCopied()) {
                info.isAddExisted = true;
            } else {
                SVNURL theirURL;
                SVNLog log = parent.getLog();
                SVNTreeConflictDescription treeConflict = this.checkTreeConflict(fullPath, entry, adminArea, log, SVNConflictAction.ADD, SVNNodeKind.FILE, theirURL = SVNURL.parseURIEncoded(info.URL));
                if (treeConflict != null) {
                    this.addSkippedTree(fullPath);
                    info.isSkipped = true;
                    SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.FILE, null, this.myTargetRevision, SVNEventAction.TREE_CONFLICT, SVNEventAction.UPDATE_ADD, null, null);
                    event.setPreviousRevision(entry.getRevision());
                    event.setPreviousURL(entry.getSVNURL());
                    this.myWCAccess.handleEvent(event);
                    return info;
                }
            }
        }
        if (copyFromPath != null && !info.isSkipped) {
            return this.addFileWithHistory(parent, info, copyFromPath, copyFromRevision);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNFileInfo addFileWithHistory(SVNDirectoryInfo parent, SVNFileInfo info, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNProperties workingProperties;
        SVNProperties baseProperties;
        block14: {
            block13: {
                SVNEntry srcEntry;
                SVNAdminArea adminArea;
                block11: {
                    info.addedWithHistory = true;
                    adminArea = parent.getAdminArea();
                    SVNEntry pathEntry = adminArea.getEntry(adminArea.getThisDirName(), false);
                    srcEntry = null;
                    try {
                        srcEntry = this.locateCopyFrom(copyFromPath, copyFromRevision, adminArea.getRoot(), pathEntry);
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND) break block11;
                        throw svne;
                    }
                }
                info.copiedBaseText = SVNAdminUtil.createTmpFile(adminArea);
                baseProperties = null;
                workingProperties = null;
                if (srcEntry == null) break block13;
                SVNAdminArea srcArea = srcEntry.getAdminArea();
                String srcTextBasePath = null;
                if (srcEntry.isScheduledForReplacement() && srcEntry.getCopyFromURL() != null) {
                    srcTextBasePath = SVNAdminUtil.getTextRevertPath(srcEntry.getName(), false);
                    workingProperties = baseProperties = srcArea.getRevertProperties(srcEntry.getName()).asMap();
                } else {
                    srcTextBasePath = SVNAdminUtil.getTextBasePath(srcEntry.getName(), false);
                    baseProperties = srcArea.getBaseProperties(srcEntry.getName()).asMap();
                    workingProperties = srcArea.getProperties(srcEntry.getName()).asMap();
                }
                InputStream srcIS = null;
                OutputStream copiedBaseOS = null;
                try {
                    srcIS = SVNFileUtil.openFileForReading(srcArea.getFile(srcTextBasePath));
                    copiedBaseOS = SVNFileUtil.openFileForWriting(info.copiedBaseText);
                    SVNChecksumOutputStream checksumOS = new SVNChecksumOutputStream(copiedBaseOS, "MD5", true);
                    copiedBaseOS = checksumOS;
                    FSRepositoryUtil.copy(srcIS, copiedBaseOS, this.myWCAccess);
                    info.copiedBaseChecksum = checksumOS.getDigest();
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(srcIS);
                    SVNFileUtil.closeFile(copiedBaseOS);
                    throw throwable;
                }
                SVNFileUtil.closeFile(srcIS);
                SVNFileUtil.closeFile(copiedBaseOS);
                if (srcArea.hasTextModifications(srcEntry.getName(), false, true, false)) {
                    info.copiedWorkingText = SVNAdminUtil.createTmpFile(adminArea);
                    SVNFileUtil.copyFile(srcArea.getFile(srcEntry.getName()), info.copiedWorkingText, true);
                }
                break block14;
            }
            if (this.myFileFetcher == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "No fetch_func supplied to update_editor.");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            baseProperties = new SVNProperties();
            OutputStream baseTextOS = null;
            try {
                baseTextOS = SVNFileUtil.openFileForWriting(info.copiedBaseText);
                SVNChecksumOutputStream checksumBaseTextOS = new SVNChecksumOutputStream(baseTextOS, "MD5", true);
                baseTextOS = checksumBaseTextOS;
                this.myFileFetcher.fetchFile(copyFromPath, copyFromRevision, baseTextOS, baseProperties);
                info.copiedBaseChecksum = checksumBaseTextOS.getDigest();
            }
            finally {
                SVNFileUtil.closeFile(baseTextOS);
            }
            workingProperties = baseProperties;
        }
        info.copiedBaseProperties = baseProperties.getRegularProperties();
        info.copiedWorkingProperties = workingProperties.getRegularProperties();
        return info;
    }

    private SVNEntry locateCopyFrom(String copyFromPath, long copyFromRevision, File dstDir, SVNEntry dstEntry) throws SVNException {
        String copyFromParent;
        if (dstEntry.getRepositoryRoot() == null || dstEntry.getURL() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Destination directory of add-with-history is missing a URL");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        dstDir = new File(SVNPathUtil.validateFilePath(dstDir.getAbsolutePath())).getAbsoluteFile();
        String dstReposPath = SVNPathUtil.getPathAsChild(dstEntry.getRepositoryRootURL().toDecodedString(), dstEntry.getSVNURL().toDecodedString());
        if (dstReposPath == null) {
            if (dstEntry.getURL().equals(dstEntry.getRepositoryRoot())) {
                dstReposPath = "";
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Destination URLs are broken");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        dstReposPath = "/" + dstReposPath;
        String ancestorPath = SVNPathUtil.getCommonPathAncestor(dstReposPath = SVNPathUtil.canonicalizePath(dstReposPath), copyFromParent = SVNPathUtil.removeTail(copyFromPath));
        if ("".equals(ancestorPath)) {
            return null;
        }
        int levelsUP = SVNPathUtil.getSegmentsCount(dstReposPath) - SVNPathUtil.getSegmentsCount(ancestorPath);
        File currentWD = dstDir;
        for (int i = 0; i < levelsUP && currentWD != null; currentWD = currentWD.getParentFile(), ++i) {
        }
        if (currentWD == null) {
            return null;
        }
        SVNFileType kind = SVNFileType.getType(currentWD);
        if (kind != SVNFileType.DIRECTORY) {
            return null;
        }
        SVNWCAccess ancestorAccess = SVNWCAccess.newInstance(null);
        SVNAdminArea ancestorArea = null;
        try {
            ancestorArea = ancestorAccess.open(currentWD, false, 0);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                ancestorAccess.close();
                return null;
            }
            throw svne;
        }
        SVNEntry ancestorEntry = ancestorArea.getEntry(ancestorArea.getThisDirName(), false);
        if (dstEntry.getUUID() != null && ancestorEntry.getUUID() != null && !dstEntry.getUUID().equals(ancestorEntry.getUUID())) {
            ancestorAccess.close();
            return null;
        }
        SVNURL ancestorURL = dstEntry.getRepositoryRootURL().appendPath(ancestorPath, false);
        if (!ancestorURL.equals(ancestorEntry.getSVNURL())) {
            ancestorAccess.close();
            return null;
        }
        String extraComponents = SVNPathUtil.getPathAsChild(ancestorPath, copyFromPath);
        currentWD = new File(currentWD, extraComponents);
        File currentWDParent = currentWD.getParentFile();
        kind = SVNFileType.getType(currentWD);
        if (kind != SVNFileType.FILE) {
            ancestorAccess.close();
            return null;
        }
        try {
            ancestorAccess.close();
            ancestorArea = ancestorAccess.open(currentWDParent, false, 0);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                ancestorAccess.close();
                return null;
            }
            throw svne;
        }
        SVNEntry fileEntry = ancestorArea.getEntry(currentWD.getName(), false);
        if (fileEntry == null) {
            ancestorAccess.close();
            return null;
        }
        if (fileEntry.getUUID() != null && dstEntry.getUUID() != null && !fileEntry.getUUID().equals(dstEntry.getUUID())) {
            ancestorAccess.close();
            return null;
        }
        SVNURL fileURL = fileEntry.getRepositoryRootURL().appendPath(copyFromPath, false);
        if (!fileURL.equals(fileEntry.getSVNURL())) {
            ancestorAccess.close();
            return null;
        }
        if (!SVNRevision.isValidRevisionNumber(fileEntry.getCommittedRevision()) || !SVNRevision.isValidRevisionNumber(fileEntry.getRevision())) {
            ancestorAccess.close();
            return null;
        }
        if (fileEntry.getCommittedRevision() > copyFromRevision || copyFromRevision > fileEntry.getRevision()) {
            ancestorAccess.close();
            return null;
        }
        return fileEntry;
    }

    private void changeFileProperty(String name, SVNPropertyValue value, SVNFileInfo fileInfo) {
        if (!fileInfo.isSkipped) {
            fileInfo.propertyChanged(name, value);
            if (this.myWCAccess.getOptions().isUseCommitTimes() && "svn:entry:committed-date".equals(name)) {
                fileInfo.commitTime = value.getString();
                if (fileInfo.commitTime != null) {
                    fileInfo.commitTime = fileInfo.commitTime.trim();
                }
            }
        }
    }

    public SVNFileInfo openFile(String path, SVNDirectoryInfo parent) throws SVNException {
        this.checkIfPathIsUnderRoot(path);
        File fullPath = this.myAdminInfo.getAnchor().getFile(path);
        SVNFileInfo info = this.createFileInfo(parent, path, false);
        SVNAdminArea adminArea = parent.getAdminArea();
        SVNEntry entry = adminArea.getEntry(info.name, true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "File ''{0}'' in directory ''{1}'' is not a versioned resource", new Object[]{info.name, adminArea.getRoot()});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean isLocallyDeleted = this.inDeletedTree(fullPath, true);
        if (this.inSkippedTree(fullPath) && !isLocallyDeleted) {
            info.isSkipped = true;
            return info;
        }
        File victim = this.alreadyInTreeConflict(fullPath);
        SVNConflictDescription treeConflict = null;
        if (victim == null) {
            SVNLog log = parent.getLog();
            SVNURL theirURL = SVNURL.parseURIEncoded(info.URL);
            treeConflict = this.checkTreeConflict(fullPath, entry, adminArea, log, SVNConflictAction.EDIT, SVNNodeKind.FILE, theirURL);
        }
        String name = SVNPathUtil.tail(path);
        boolean hasTextConflicts = adminArea.hasTextConflict(name);
        boolean hasPropConflicts = adminArea.hasPropConflict(name);
        if (treeConflict != null && treeConflict.getConflictReason() == SVNConflictReason.DELETED && !isLocallyDeleted) {
            this.addDeletedTree(fullPath);
            isLocallyDeleted = true;
        }
        info.isDeleted = isLocallyDeleted;
        if (victim != null || treeConflict != null || hasTextConflicts || hasPropConflicts) {
            if (!isLocallyDeleted) {
                info.isSkipped = true;
            }
            this.addSkippedTree(fullPath);
            if (!this.inDeletedTree(fullPath, false)) {
                SVNEventAction eventAction = treeConflict != null ? SVNEventAction.TREE_CONFLICT : SVNEventAction.SKIP;
                SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.FILE, null, this.myTargetRevision, hasTextConflicts ? SVNStatusType.CONFLICTED : SVNStatusType.UNKNOWN, hasPropConflicts ? SVNStatusType.CONFLICTED : SVNStatusType.UNKNOWN, SVNStatusType.LOCK_INAPPLICABLE, eventAction, SVNEventAction.UPDATE_UPDATE, null, null);
                event.setPreviousRevision(entry.getRevision());
                event.setURL(entry.getSVNURL());
                this.myWCAccess.handleEvent(event);
            }
        }
        return info;
    }

    private void closeFile(String textChecksum, SVNFileInfo fileInfo, SVNDirectoryInfo dirInfo) throws SVNException {
        String absTmpBasePath;
        String absBasePath;
        boolean isTextUpdated;
        if (fileInfo.isSkipped) {
            this.maybeBumpDirInfo(dirInfo);
            return;
        }
        File fullPath = this.myAdminInfo.getAnchor().getFile(fileInfo.getPath());
        if (fileInfo.addedWithHistory && !fileInfo.receivedTextDelta) {
            boolean useRevertBase;
            SVNAdminArea adminArea;
            SVNEntry entry;
            if (fileInfo.baseFile != null || fileInfo.newBaseFile != null || fileInfo.copiedBaseText == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "assertion failure in SVNUpdateEditor.closeFile(): fileInfo.baseFile = {0}, fileInfo.newBaseFile = {1}, fileInfo.copiedBaseText = {2}", new Object[]{fileInfo.baseFile, fileInfo.newBaseFile, fileInfo.copiedBaseText});
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            boolean replaced = (entry = (adminArea = fileInfo.getAdminArea()).getEntry(fileInfo.name, false)) != null && entry.isScheduledForReplacement();
            boolean bl = useRevertBase = replaced && entry.getCopyFromURL() != null;
            if (useRevertBase) {
                fileInfo.baseFile = adminArea.getFile(SVNAdminUtil.getTextRevertPath(fileInfo.name, false));
                fileInfo.newBaseFile = adminArea.getFile(SVNAdminUtil.getTextRevertPath(fileInfo.name, true));
            } else {
                fileInfo.baseFile = adminArea.getBaseFile(fileInfo.name, false);
                fileInfo.newBaseFile = adminArea.getBaseFile(fileInfo.name, true);
            }
            SVNFileUtil.copyFile(fileInfo.copiedBaseText, fileInfo.newBaseFile, true);
            fileInfo.checksum = fileInfo.copiedBaseChecksum;
        }
        String checksum = null;
        boolean bl = isTextUpdated = fileInfo.newBaseFile != null;
        if (textChecksum != null && isTextUpdated) {
            if (fileInfo.checksum != null && !textChecksum.equals(fileInfo.checksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", new Object[]{fileInfo.getPath(), textChecksum, fileInfo.checksum});
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            checksum = textChecksum;
        }
        SVNAdminArea adminArea = fileInfo.getAdminArea();
        SVNLog log = dirInfo.getLog();
        String name = fileInfo.name;
        SVNEntry fileEntry = adminArea.getEntry(name, false);
        if (fileEntry == null && !fileInfo.IsAdded) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", fileInfo.getPath());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        long previousRevision = fileEntry != null ? fileEntry.getRevision() : -1L;
        SVNURL previousURL = fileEntry != null ? fileEntry.getSVNURL() : null;
        SVNProperties modifiedWCProps = fileInfo.getChangedWCProperties();
        SVNProperties modifiedEntryProps = fileInfo.getChangedEntryProperties();
        SVNProperties modifiedProps = fileInfo.getChangedProperties();
        String commitTime = fileInfo.commitTime;
        SVNProperties command = new SVNProperties();
        SVNStatusType textStatus = SVNStatusType.UNCHANGED;
        SVNStatusType lockStatus = SVNStatusType.LOCK_UNCHANGED;
        if (this.myAdminInfo.isIncomplete(fileInfo.getPath()) && fileEntry != null) {
            SVNVersionedProperties oldBaseProps = adminArea.getBaseProperties(fileEntry.getName());
            SVNProperties baseMap = oldBaseProps.asMap();
            if (modifiedProps == null) {
                modifiedProps = new SVNProperties();
            }
            Iterator names = baseMap.nameSet().iterator();
            while (names.hasNext()) {
                String propName = (String)names.next();
                if (modifiedProps.containsName(propName)) continue;
                modifiedProps.put(propName, SVNPropertyValue.create(null));
            }
        }
        boolean magicPropsChanged = false;
        if (modifiedProps != null && !modifiedProps.isEmpty()) {
            magicPropsChanged = modifiedProps.containsName("svn:executable") || modifiedProps.containsName("svn:needs-lock") || modifiedProps.containsName("svn:keywords") || modifiedProps.containsName("svn:eol-style") || modifiedProps.containsName("svnkit:charset") || modifiedProps.containsName("svn:special");
        }
        SVNStatusType propStatus = adminArea.mergeProperties(name, null, fileInfo.copiedBaseProperties, fileInfo.copiedWorkingProperties, modifiedProps, null, null, true, false, log);
        if (modifiedEntryProps != null) {
            lockStatus = log.logChangedEntryProperties(name, modifiedEntryProps);
        }
        if (modifiedWCProps != null) {
            log.logChangedWCProperties(name, modifiedWCProps);
        }
        boolean isLocallyModified = false;
        if (fileInfo.copiedWorkingText != null) {
            isLocallyModified = true;
        } else if (!fileInfo.isExisted) {
            isLocallyModified = adminArea.hasTextModifications(name, false, false, false);
        } else if (isTextUpdated) {
            isLocallyModified = adminArea.hasVersionedFileTextChanges(adminArea.getFile(name), fileInfo.newBaseFile, false);
        }
        boolean isReplaced = fileEntry != null && fileEntry.isScheduledForReplacement();
        SVNProperties logAttributes = new SVNProperties();
        if (fileInfo.isAddExisted) {
            logAttributes.put("force", "true");
            logAttributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "");
        }
        log.logTweakEntry(name, fileInfo.URL, this.myTargetRevision);
        String absDirPath = adminArea.getRoot().getAbsolutePath().replace(File.separatorChar, '/');
        String basePath = null;
        if (fileInfo.baseFile != null && (basePath = (absBasePath = fileInfo.baseFile.getAbsolutePath().replace(File.separatorChar, '/')).substring(absDirPath.length())).startsWith("/")) {
            basePath = basePath.substring(1);
        }
        String tmpBasePath = null;
        if (fileInfo.newBaseFile != null && (tmpBasePath = (absTmpBasePath = fileInfo.newBaseFile.getAbsolutePath().replace(File.separatorChar, '/')).substring(absDirPath.length())).startsWith("/")) {
            tmpBasePath = tmpBasePath.substring(1);
        }
        SVNStatusType mergeOutcome = SVNStatusType.UNCHANGED;
        File workingFile = adminArea.getFile(name);
        boolean deletedCopiedBaseText = false;
        if (tmpBasePath != null) {
            textStatus = SVNStatusType.CHANGED;
            if (!isReplaced) {
                if (!isLocallyModified) {
                    if (!fileInfo.isDeleted) {
                        command.put("name", tmpBasePath);
                        command.put("dest", name);
                        log.addCommand("cp-and-translate", command, false);
                        command.clear();
                    }
                } else {
                    SVNFileType kind = SVNFileType.getType(workingFile);
                    if (kind == SVNFileType.NONE && !fileInfo.addedWithHistory) {
                        command.put("name", tmpBasePath);
                        command.put("dest", name);
                        log.addCommand("cp-and-translate", command, false);
                        command.clear();
                    } else if (!fileInfo.isExisted) {
                        String pathExt = null;
                        if (this.myExtensionPatterns != null && this.myExtensionPatterns.length > 0) {
                            int dotInd = name.lastIndexOf(46);
                            if (dotInd != -1 && dotInd != 0 && dotInd != name.length() - 1) {
                                pathExt = name.substring(dotInd + 1);
                            }
                            if (pathExt != null && !"".equals(pathExt)) {
                                String extPattern;
                                boolean matches = false;
                                for (int i = 0; i < this.myExtensionPatterns.length && !(matches = DefaultSVNOptions.matches(extPattern = this.myExtensionPatterns[i], pathExt)); ++i) {
                                }
                                if (!matches) {
                                    pathExt = null;
                                }
                            }
                        }
                        boolean deleteLeftMergeFile = false;
                        boolean deleteCopiedBaseText = false;
                        File mergeLeftFile = fileInfo.baseFile;
                        if (fileInfo.isAddExisted && !isReplaced) {
                            deleteLeftMergeFile = true;
                            mergeLeftFile = SVNAdminUtil.createTmpFile(adminArea);
                        } else if (fileInfo.copiedBaseText != null) {
                            deleteCopiedBaseText = true;
                            deleteLeftMergeFile = true;
                            mergeLeftFile = fileInfo.copiedBaseText;
                        }
                        String absMergeLeftFilePath = mergeLeftFile.getAbsolutePath().replace(File.separatorChar, '/');
                        String mergeLeftFilePath = absMergeLeftFilePath.substring(absDirPath.length());
                        if (mergeLeftFilePath.startsWith("/")) {
                            mergeLeftFilePath = mergeLeftFilePath.substring(1);
                        }
                        String leftLabel = null;
                        leftLabel = fileInfo.addedWithHistory ? ".copied" + (pathExt != null ? "." + pathExt : "") : ".r" + fileEntry.getRevision() + (pathExt != null ? "." + pathExt : "");
                        String rightLabel = ".r" + this.myTargetRevision + (pathExt != null ? "." + pathExt : "");
                        String mineLabel = ".mine" + (pathExt != null ? "." + pathExt : "");
                        mergeOutcome = adminArea.mergeText(name, mergeLeftFile, adminArea.getFile(tmpBasePath), fileInfo.copiedWorkingText, mineLabel, leftLabel, rightLabel, modifiedProps, false, null, log);
                        if (mergeOutcome == SVNStatusType.UNCHANGED) {
                            textStatus = SVNStatusType.MERGED;
                        }
                        if (deleteLeftMergeFile) {
                            command.put("name", mergeLeftFilePath);
                            log.addCommand("rm", command, false);
                            command.clear();
                            if (deleteCopiedBaseText) {
                                deletedCopiedBaseText = true;
                            }
                        }
                        if (fileInfo.copiedWorkingText != null) {
                            String absCopiedWorkingTextPath = fileInfo.copiedWorkingText.getAbsolutePath().replace(File.separatorChar, '/');
                            String copiedWorkingTextPath = absCopiedWorkingTextPath.substring(absDirPath.length());
                            if (copiedWorkingTextPath.startsWith("/")) {
                                copiedWorkingTextPath = copiedWorkingTextPath.substring(1);
                            }
                            command.put("name", copiedWorkingTextPath);
                            log.addCommand("rm", command, false);
                            command.clear();
                        }
                    }
                }
            }
        } else {
            if (magicPropsChanged && (workingFile.exists() || SVNFileType.getType(workingFile) == SVNFileType.SYMLINK)) {
                String tmpPath = SVNAdminUtil.getTextBasePath(name, true);
                command.put("name", name);
                command.put("dest", tmpPath);
                log.addCommand("cp-and-detranslate", command, false);
                command.clear();
                command.put("name", tmpPath);
                command.put("dest", name);
                log.addCommand("cp-and-translate", command, false);
                command.clear();
            }
            if (lockStatus == SVNStatusType.LOCK_UNLOCKED) {
                command.put("name", name);
                log.addCommand("maybe-readonly", command, false);
                command.clear();
            }
        }
        if (tmpBasePath != null) {
            command.put("name", tmpBasePath);
            command.put("dest", basePath);
            log.addCommand("mv", command, false);
            command.clear();
            command.put("name", basePath);
            log.addCommand("readonly", command, false);
            command.clear();
            logAttributes.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
        }
        if (fileInfo.isDeleted && !isReplaced) {
            logAttributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "delete");
        }
        if (logAttributes.size() > 0) {
            logAttributes.put("name", name);
            log.addCommand("modify-entry", logAttributes, false);
        }
        if (!isLocallyModified && (fileInfo.IsAdded || fileEntry.getSchedule() == null)) {
            if (commitTime != null && !fileInfo.isExisted) {
                command.put("name", name);
                command.put("timestamp", commitTime);
                log.addCommand("set-timestamp", command, false);
                command.clear();
            }
            if ((tmpBasePath != null || magicPropsChanged) && !fileInfo.isDeleted) {
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                log.addCommand("modify-entry", command, false);
                command.clear();
            }
            command.put("name", name);
            command.put(SVNProperty.shortPropertyName("svn:entry:working-size"), "working");
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (fileInfo.copiedBaseText != null && !deletedCopiedBaseText) {
            String absCopiedBaseTextPath = fileInfo.copiedBaseText.getAbsolutePath().replace(File.separatorChar, '/');
            String copiedBaseTextPath = absCopiedBaseTextPath.substring(absDirPath.length());
            if (copiedBaseTextPath.startsWith("/")) {
                copiedBaseTextPath = copiedBaseTextPath.substring(1);
            }
            command.put("name", copiedBaseTextPath);
            log.addCommand("rm", command, false);
            command.clear();
        }
        this.maybeBumpDirInfo(dirInfo);
        if (mergeOutcome == SVNStatusType.CONFLICTED_UNRESOLVED) {
            textStatus = SVNStatusType.CONFLICTED_UNRESOLVED;
        } else if (mergeOutcome == SVNStatusType.CONFLICTED) {
            textStatus = SVNStatusType.CONFLICTED;
        } else if (fileInfo.newBaseFile != null) {
            textStatus = isLocallyModified ? SVNStatusType.MERGED : SVNStatusType.CHANGED;
        }
        if ((textStatus != SVNStatusType.UNCHANGED || propStatus != SVNStatusType.UNCHANGED || lockStatus != SVNStatusType.LOCK_UNCHANGED || fileInfo.treeConficted) && !this.inDeletedTree(fullPath, true)) {
            SVNEventAction action;
            SVNEventAction expectedAction = action = SVNEventAction.UPDATE_UPDATE;
            if (fileInfo.treeConficted) {
                action = SVNEventAction.TREE_CONFLICT;
            } else if (fileInfo.isExisted || fileInfo.isAddExisted) {
                if (textStatus != SVNStatusType.CONFLICTED_UNRESOLVED && textStatus != SVNStatusType.CONFLICTED) {
                    expectedAction = action = SVNEventAction.UPDATE_EXISTS;
                }
            } else if (fileInfo.IsAdded) {
                expectedAction = action = SVNEventAction.UPDATE_ADD;
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(fullPath, SVNNodeKind.FILE, null, this.myTargetRevision, textStatus, propStatus, lockStatus, action, expectedAction, null, null);
            event.setPreviousRevision(previousRevision);
            event.setPreviousURL(previousURL);
            event.setURL(fileInfo.URL != null ? SVNURL.parseURIEncoded(fileInfo.URL) : null);
            this.myWCAccess.handleEvent(event);
        }
    }

    private SVNFileInfo createFileInfo(SVNDirectoryInfo parent, String path, boolean added) throws SVNException {
        SVNFileInfo info = new SVNFileInfo(parent, path);
        info.IsAdded = added;
        info.name = SVNPathUtil.tail(path);
        info.isExisted = false;
        info.isAddExisted = false;
        info.isSkipped = false;
        info.treeConficted = false;
        info.isDeleted = false;
        info.baseFile = null;
        info.newBaseFile = null;
        SVNAdminArea adminArea = parent.getAdminArea();
        SVNEntry entry = adminArea.getEntry(info.name, true);
        info.URL = this.mySwitchURL != null || entry == null ? SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(info.name)) : entry.getURL();
        ++parent.RefCount;
        return info;
    }

    private SVNDirectoryInfo createDirectoryInfo(SVNDirectoryInfo parent, String path, boolean added) {
        String name;
        SVNDirectoryInfo info = new SVNDirectoryInfo(path);
        info.Parent = parent;
        info.IsAdded = added;
        String string = name = path != null ? SVNPathUtil.tail(path) : "";
        if (this.mySwitchURL == null) {
            SVNAdminArea area = null;
            SVNEntry dirEntry = null;
            File areaPath = new File(this.myAdminInfo.getAnchor().getRoot(), info.getPath());
            try {
                area = this.myWCAccess.getAdminArea(areaPath);
                if (area != null) {
                    dirEntry = area.getEntry(area.getThisDirName(), false);
                }
            }
            catch (SVNException svne) {
                // empty catch block
            }
            if (area != null && dirEntry != null) {
                info.URL = dirEntry.getURL();
            }
            if (info.URL == null && parent != null) {
                info.URL = SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(name));
            } else if (info.URL == null && parent == null) {
                info.URL = this.myTargetURL;
            }
        } else {
            info.URL = parent == null ? (this.myTarget == null ? this.mySwitchURL : SVNPathUtil.removeTail(this.mySwitchURL)) : (this.myTarget != null && parent.Parent == null ? this.mySwitchURL : SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(name)));
        }
        info.RefCount = 1;
        info.isSkipped = false;
        if (info.Parent != null) {
            ++info.Parent.RefCount;
        }
        info.isExisted = false;
        info.isAddExisted = false;
        info.log = null;
        info.myAmbientDepth = SVNDepth.UNKNOWN;
        info.wasIncomplete = false;
        return info;
    }

    public static SVNUpdateEditor createUpdateEditor(SVNAdminAreaInfo info, String switchURL, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExtensions, ISVNFileFetcher fileFetcher, boolean lockOnDemand) throws SVNException {
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        SVNEntry entry = info.getAnchor().getEntry(info.getAnchor().getThisDirName(), false);
        if (switchURL != null && entry != null && entry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(entry.getRepositoryRoot(), switchURL)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", new Object[]{switchURL, entry.getRepositoryRoot()});
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNUpdateEditor editor = new SVNUpdateEditor(info, switchURL, allowUnversionedObstructions, depthIsSticky, depth, preservedExtensions, entry != null ? entry.getURL() : null, entry != null ? entry.getRepositoryRoot() : null, fileFetcher, lockOnDemand);
        info.getTarget().closeEntries();
        return editor;
    }

    public void cleanup(SVNAdminArea area) throws SVNException {
        area.runLogs();
    }

    private class SVNDirectoryInfo
    extends SVNEntryInfo
    implements ISVNCleanupHandler {
        public int RefCount;
        private SVNLog log;
        public int LogCount;
        public SVNDepth myAmbientDepth;
        public boolean wasIncomplete;

        public SVNDirectoryInfo(String path) {
            super(path);
        }

        public SVNAdminArea getAdminArea() throws SVNException {
            String path = this.getPath();
            File file = new File(SVNUpdateEditor.this.myAdminInfo.getAnchor().getRoot(), path);
            SVNAdminArea area = SVNUpdateEditor.this.myAdminInfo.getWCAccess().retrieve(file);
            if (SVNUpdateEditor.this.myIsLockOnDemand && area != null && !area.isLocked()) {
                area.lock(false);
                area = SVNUpdateEditor.this.myAdminInfo.getWCAccess().upgrade(file);
            }
            return area;
        }

        public SVNLog getLog() throws SVNException {
            if (this.log == null) {
                this.log = this.getAdminArea().getLog();
                ++this.LogCount;
            }
            return this.log;
        }

        public void flushLog() throws SVNException {
            if (this.log != null) {
                this.log.save();
                this.log = null;
            }
        }

        public void runLogs() throws SVNException {
            this.LogCount = 0;
            this.getAdminArea().runLogs();
        }

        public void cleanup(SVNAdminArea area) throws SVNException {
            if (area != null && this.LogCount > 0) {
                this.LogCount = 0;
                area.runLogs();
            }
        }
    }

    private class SVNFileInfo
    extends SVNEntryInfo {
        public String name;
        public String commitTime;
        public String checksum;
        public String expectedSrcChecksum;
        public String copiedBaseChecksum;
        public File baseFile;
        public File newBaseFile;
        public boolean addedWithHistory;
        public boolean receivedTextDelta;
        private SVNProperties copiedBaseProperties;
        private SVNProperties copiedWorkingProperties;
        private File copiedBaseText;
        private File copiedWorkingText;
        private SVNChecksumInputStream sourceChecksumStream;
        private boolean treeConficted;
        private boolean isDeleted;

        public SVNFileInfo(SVNDirectoryInfo parent, String path) {
            super(path);
            this.Parent = parent;
            this.isDeleted = false;
        }

        public SVNAdminArea getAdminArea() throws SVNException {
            return this.Parent.getAdminArea();
        }
    }

    private class SVNEntryInfo {
        public String URL;
        public boolean IsAdded;
        public boolean isExisted;
        public boolean isAddExisted;
        public SVNDirectoryInfo Parent;
        public boolean isSkipped;
        public long myPreviousRevision;
        private String myPath;
        private SVNProperties myChangedProperties;
        private SVNProperties myChangedEntryProperties;
        private SVNProperties myChangedWCProperties;

        protected SVNEntryInfo(String path) {
            this.myPath = path;
        }

        protected String getPath() {
            return this.myPath;
        }

        public void propertyChanged(String name, SVNPropertyValue value) {
            if (name.startsWith("svn:entry:")) {
                String strValue;
                SVNProperties sVNProperties = this.myChangedEntryProperties = this.myChangedEntryProperties == null ? new SVNProperties() : this.myChangedEntryProperties;
                if (value != null && (strValue = value.getString()) != null) {
                    strValue = strValue.trim();
                    value = SVNPropertyValue.create(strValue);
                }
                this.myChangedEntryProperties.put(name.substring("svn:entry:".length()), value);
            } else if (name.startsWith("svn:wc:")) {
                this.myChangedWCProperties = this.myChangedWCProperties == null ? new SVNProperties() : this.myChangedWCProperties;
                this.myChangedWCProperties.put(name, value);
            } else {
                this.myChangedProperties = this.myChangedProperties == null ? new SVNProperties() : this.myChangedProperties;
                this.myChangedProperties.put(name, value);
            }
        }

        public SVNProperties getChangedWCProperties() {
            return this.myChangedWCProperties;
        }

        public SVNProperties getChangedEntryProperties() {
            return this.myChangedEntryProperties;
        }

        public SVNProperties getChangedProperties() {
            return this.myChangedProperties;
        }
    }
}

