/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.File;
import java.io.InputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNSSLAuthentication;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public final class HTTPSSLKeyManager
implements X509KeyManager {
    private final ISVNAuthenticationManager authenticationManager;
    private final String realm;
    private final SVNURL url;
    private KeyManager[] myKeyManagers;
    private SVNSSLAuthentication myAuthentication;
    private Exception myException;

    public static KeyManager[] loadClientCertificate(File clientCertFile, String clientCertPassword) throws SVNException {
        char[] passphrase = null;
        if (clientCertPassword != null) {
            passphrase = clientCertPassword.toCharArray();
        }
        KeyStore keyStore = null;
        InputStream is = SVNFileUtil.openFileForReading(clientCertFile, SVNLogType.NETWORK);
        try {
            keyStore = KeyStore.getInstance("PKCS12");
            if (keyStore != null) {
                keyStore.load(is, passphrase);
            }
        }
        catch (Throwable th) {
            SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
            throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, th.getMessage(), null, 0, th), th);
        }
        finally {
            SVNFileUtil.closeFile(is);
        }
        KeyManagerFactory kmf = null;
        KeyManager[] result = null;
        if (keyStore != null) {
            try {
                kmf = KeyManagerFactory.getInstance("SunX509");
                if (kmf != null) {
                    kmf.init(keyStore, passphrase);
                    result = kmf.getKeyManagers();
                }
            }
            catch (Throwable th) {
                SVNDebugLog.getDefaultLog().logFine(SVNLogType.NETWORK, th);
                throw new SVNException(SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, th.getMessage()), th);
            }
        }
        return result;
    }

    public HTTPSSLKeyManager(ISVNAuthenticationManager authenticationManager, String realm, SVNURL url) {
        this.authenticationManager = authenticationManager;
        this.realm = realm;
        this.url = url;
    }

    public String[] getClientAliases(String location, Principal[] principals) {
        if (!this.initializeNoException()) {
            return null;
        }
        Iterator it = HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers).iterator();
        while (it.hasNext()) {
            X509KeyManager keyManager = (X509KeyManager)it.next();
            String[] clientAliases = keyManager.getClientAliases(location, principals);
            if (clientAliases == null) continue;
            return clientAliases;
        }
        return null;
    }

    public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
        if (!this.initializeNoException()) {
            return null;
        }
        Iterator it = HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers).iterator();
        while (it.hasNext()) {
            X509KeyManager keyManager = (X509KeyManager)it.next();
            String clientAlias = keyManager.chooseClientAlias(strings, principals, socket);
            if (clientAlias == null) continue;
            return clientAlias;
        }
        return null;
    }

    public String[] getServerAliases(String location, Principal[] principals) {
        if (!this.initializeNoException()) {
            return null;
        }
        Iterator it = HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers).iterator();
        while (it.hasNext()) {
            X509KeyManager keyManager = (X509KeyManager)it.next();
            String[] serverAliases = keyManager.getServerAliases(location, principals);
            if (serverAliases == null) continue;
            return serverAliases;
        }
        return null;
    }

    public String chooseServerAlias(String location, Principal[] principals, Socket socket) {
        if (!this.initializeNoException()) {
            return null;
        }
        Iterator it = HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers).iterator();
        while (it.hasNext()) {
            X509KeyManager keyManager = (X509KeyManager)it.next();
            String serverAlias = keyManager.chooseServerAlias(location, principals, socket);
            if (serverAlias == null) continue;
            return serverAlias;
        }
        return null;
    }

    public X509Certificate[] getCertificateChain(String location) {
        if (!this.initializeNoException()) {
            return null;
        }
        Iterator it = HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers).iterator();
        while (it.hasNext()) {
            X509KeyManager keyManager = (X509KeyManager)it.next();
            X509Certificate[] certificateChain = keyManager.getCertificateChain(location);
            if (certificateChain == null) continue;
            return certificateChain;
        }
        return null;
    }

    public PrivateKey getPrivateKey(String string) {
        if (!this.initializeNoException()) {
            return null;
        }
        Iterator it = HTTPSSLKeyManager.getX509KeyManagers(this.myKeyManagers).iterator();
        while (it.hasNext()) {
            X509KeyManager keyManager = (X509KeyManager)it.next();
            PrivateKey privateKey = keyManager.getPrivateKey(string);
            if (privateKey == null) continue;
            return privateKey;
        }
        return null;
    }

    public Exception getException() {
        return this.myException;
    }

    public void acknowledgeAndClearAuthentication(SVNErrorMessage errorMessage) throws SVNException {
        if (this.myAuthentication != null) {
            this.authenticationManager.acknowledgeAuthentication(errorMessage == null, "svn.ssl.client-passphrase", this.realm, errorMessage, this.myAuthentication);
        }
        this.myAuthentication = null;
        if (errorMessage != null) {
            this.myKeyManagers = null;
        }
        Exception exception = this.myException;
        this.myException = null;
        if (exception instanceof SVNException) {
            throw (SVNException)exception;
        }
        if (exception != null) {
            throw new SVNException(SVNErrorMessage.UNKNOWN_ERROR_MESSAGE, (Throwable)exception);
        }
    }

    private boolean initializeNoException() {
        try {
            boolean result = this.initialize();
            this.myException = null;
            return result;
        }
        catch (Exception exception) {
            this.myException = exception;
            return false;
        }
    }

    private boolean initialize() throws SVNException {
        KeyManager[] keyManagers;
        if (this.myKeyManagers != null) {
            return true;
        }
        boolean isFirstAuthentication = true;
        while (true) {
            if (isFirstAuthentication) {
                this.myAuthentication = (SVNSSLAuthentication)this.authenticationManager.getFirstAuthentication("svn.ssl.client-passphrase", this.realm, this.url);
                isFirstAuthentication = false;
            } else {
                this.myAuthentication = (SVNSSLAuthentication)this.authenticationManager.getNextAuthentication("svn.ssl.client-passphrase", this.realm, this.url);
            }
            if (this.myAuthentication == null) {
                SVNErrorManager.cancel("SSL authentication with client certificate cancelled", SVNLogType.NETWORK);
            }
            try {
                keyManagers = HTTPSSLKeyManager.loadClientCertificate(this.myAuthentication.getCertificateFile(), this.myAuthentication.getPassword());
            }
            catch (SVNException ex) {
                SVNErrorMessage sslErr = SVNErrorMessage.create(SVNErrorCode.RA_NOT_AUTHORIZED, "SSL handshake failed: ''{0}''", new Object[]{ex.getMessage()}, 0, ex.getCause());
                this.authenticationManager.acknowledgeAuthentication(false, "svn.ssl.client-passphrase", this.realm, sslErr, this.myAuthentication);
                continue;
            }
            break;
        }
        this.myKeyManagers = keyManagers;
        return true;
    }

    private static List getX509KeyManagers(KeyManager[] keyManagers) {
        ArrayList<KeyManager> x509KeyManagers = new ArrayList<KeyManager>();
        for (int index = 0; index < keyManagers.length; ++index) {
            KeyManager keyManager = keyManagers[index];
            if (!(keyManager instanceof X509KeyManager)) continue;
            x509KeyManagers.add(keyManager);
        }
        return x509KeyManagers;
    }
}

